/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.text.Segment;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ReadTextBuffer;

class InputReadTextBuffer
implements ReadTextBuffer {
    public static long readTime = 0L;
    public static int totalLineCount = 0;
    public static int averageLineCount = 0;
    private static int bufferCount = 0;
    private char[] buffer;

    private static int countLines(char[] cArray) {
        int n = cArray.length > 0 ? 1 : 0;
        int n2 = 0;
        while (n2 < cArray.length - 1) {
            if (cArray[n2] == '\n') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    static char[] resizeCharBuf(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length < n ? cArray.length : n);
        return cArray2;
    }

    static InputReadTextBuffer init(URL uRL) {
        try {
            long l = NativeHandler.getHiPerfTick();
            InputStream inputStream = URLFileSystem.openInputStream((URL)uRL);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            InputReadTextBuffer inputReadTextBuffer = new InputReadTextBuffer();
            inputReadTextBuffer.buffer = new char[16384];
            int n = 0;
            while (true) {
                int n2;
                if ((n2 = inputStreamReader.read(inputReadTextBuffer.buffer, n, 16384)) < 16384) {
                    if (n2 <= 0) break;
                    inputReadTextBuffer.buffer = InputReadTextBuffer.resizeCharBuf(inputReadTextBuffer.buffer, n + n2);
                    break;
                }
                inputReadTextBuffer.buffer = InputReadTextBuffer.resizeCharBuf(inputReadTextBuffer.buffer, (n += n2) + 16384);
            }
            readTime += NativeHandler.getHiPerfTick() - l;
            averageLineCount = (totalLineCount += InputReadTextBuffer.countLines(inputReadTextBuffer.buffer)) / ++bufferCount;
            InputReadTextBuffer inputReadTextBuffer2 = inputReadTextBuffer;
            return inputReadTextBuffer2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getLength() {
        return this.buffer.length;
    }

    public char getChar(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[n];
    }

    public char[] getChars(int n, int n2) throws IndexOutOfBoundsException {
        if (n + n2 < 0 || n + n2 > this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.buffer, n, cArray, 0, n2);
        return cArray;
    }

    public String getString(int n, int n2) throws IndexOutOfBoundsException {
        if (n + n2 < 0 || n + n2 > this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.buffer, n, n2);
    }

    public void getText(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        segment.array = this.buffer;
        segment.offset = n;
        segment.count = n2;
    }

    public void readLock() {
    }

    public boolean tryReadLock() {
        return true;
    }

    public int getLockStatus() {
        return -1;
    }

    public void readUnlock() {
    }

    InputReadTextBuffer() {
    }
}

