/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.compiler.CopyListener;
import oracle.ide.compiler.PostBuilder;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.panels.Navigable;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerPage;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.compiler.OjcConfigurationPanel;
import oracle.jdeveloper.compiler.OutputStreamLogPage;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.ojc.interfaces.Storage;

public final class JCompiler
extends Compiler
implements ShutdownHook,
Addin {
    private static final String pkgName = "oracle.jdeveloper.compiler.";
    public static final String DISABLE_FILE_NOT_IN_PROJECT_WARNING = "disableFileNotInProjectWarning";
    public static final int MAKE_SELECTED_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_SELECTED_CMD_ID");
    public static final String MAKE_SELECTED_CMD = "oracle.jdeveloper.compiler.MakeSelectedCommand";
    public static final int BUILD_SELECTED_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_SELECTED_CMD_ID");
    public static final String BUILD_SELECTED_CMD = "oracle.jdeveloper.compiler.BuildSelectedCommand";
    public static final int MAKE_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_WORKINGSET_CMD_ID");
    public static final String MAKE_WORKINGSET_CMD = "oracle.jdeveloper.compiler.MakeWorkingSetCommand";
    public static final int BUILD_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_WORKINGSET_CMD_ID");
    public static final String BUILD_WORKINGSET_CMD = "oracle.jdeveloper.compiler.BuildWorkingSetCommand";
    public static final int MAKE_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_PROJECT_CMD_ID");
    public static final String MAKE_PROJECT_CMD = "oracle.jdeveloper.compiler.MakeProjectCommand";
    public static final int BUILD_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_PROJECT_CMD_ID");
    public static final String BUILD_PROJECT_CMD = "oracle.jdeveloper.compiler.BuildProjectCommand";
    public static final int MAKE_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_WORKSPACE_CMD_ID");
    public static final String MAKE_WORKSPACE_CMD = "oracle.jdeveloper.compiler.MakeWorkspaceCommand";
    public static final int BUILD_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.BUILD_WORKSPACE_CMD_ID");
    public static final String BUILD_WORKSPACE_CMD = "oracle.jdeveloper.compiler.BuildWorkspaceCommand";
    public static final int MAKE_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.MAKE_FOLDER_CMD_ID");
    public static final String MAKE_FOLDER_CMD = "oracle.jdeveloper.compiler.MakeFolderCommand";
    public static final int CANCEL_BUILD_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.CANCEL_BUILD_CMD_ID");
    public static final String CANCEL_BUILD_CMD = "oracle.jdeveloper.compiler.CancelBuildCommand";
    public static final int CLEANALL_CMD_ID = Ide.findOrCreateCmdID((String)"JCompiler.CLEANALL_CMD_ID");
    public static final String CLEANALL_CMD = "oracle.jdeveloper.compiler.CleanAllCommand";
    private static final String msgStart = CompArb.getString(42);
    private static final String cleanCompleted = CompArb.getString(35);
    private static final String cleanCancelled = CompArb.getString(36);
    private static final String msgSuccess = CompArb.getString(43);
    private static final String msgNothingToBuild = CompArb.getString(44);
    private static JCompiler instance;
    private LogPage outputLog;
    private LogPage errorLog;
    private Navigable compilerNavigable;
    private ArrayList buildListeners;
    private HashMap cachedProjects;
    ArrayList copyListeners;
    private boolean disableProjectUpdates;
    private final ProjectChangeListener projectChangeListener;

    void $init$() {
        this.buildListeners = new ArrayList();
        this.cachedProjects = new HashMap();
        this.copyListeners = new ArrayList();
        this.disableProjectUpdates = false;
        this.projectChangeListener = new 8();
    }

    public static JCompiler getInstance() {
        if (instance == null) {
            instance = new JCompiler();
        }
        return instance;
    }

    JCompiler() {
        this.$init$();
        instance = this;
    }

    static void invokeAsap(Runnable runnable) {
        if (!Ide.getIdeArgs().getCreateUI() || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void projectPropertiesChangedImpl(ProjectChangeEvent projectChangeEvent) {
        ChangeInfo[] changeInfoArray = projectChangeEvent.getChangeDetails();
        if (changeInfoArray != null) {
            int n = 0;
            while (n < changeInfoArray.length) {
                if (changeInfoArray[n].getChangeType() == 0 || changeInfoArray[n].getChangeType() == 1) {
                    Project project = projectChangeEvent.getProject();
                    if (project == null || this.disableProjectUpdates) break;
                    if (project.isDirty()) {
                        this.cachedProjects.put(project, Boolean.TRUE);
                        Project.addNodeListenerForType(Project.class, (NodeListener)new 7());
                        break;
                    }
                    this.cachedProjects.remove(project);
                    break;
                }
                ++n;
            }
        }
    }

    public boolean forceRebuildOnProject(Project project) {
        if ((Boolean)this.cachedProjects.get(project) == null) {
            return false;
        }
        this.cachedProjects.remove(project);
        return true;
    }

    public void initialize() {
        Compiler.setCompiler((Compiler)this);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdeveloper/compiler/accelerators.xml");
        this.compilerNavigable = new Navigable(CompArb.getString(39), OjcConfigurationPanel.class);
        ProjectPropertiesDialog.addPanel((Navigable)this.compilerNavigable);
        Project.addProjectChangeListener((String)OjcConfiguration.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries", (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)JProjectPaths.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)PathsConfiguration.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        if (!this.isBusy(null)) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), CompArb.getString(88), CompArb.getString(87), 0, 3);
        if (n == 0) {
            this.stopBuild(null);
            return true;
        }
        return false;
    }

    public boolean isBusy(Context context) {
        return UnifiedBuildSystem.getInstance().isAlive() || UnifiedBuildSystem.getInstance().isLocked(context);
    }

    public void stopBuild(Context context) {
        UnifiedBuildSystem.getInstance().stopBuildSystem();
    }

    void cleanAll(Context context) {
        if (!this.isBusy(context)) {
            UnifiedBuildSystem.getInstance().initCleanAll(context);
        }
    }

    private void saveAll(boolean bl) {
        if (bl || Ide.getEnvironOptions().getSaveBeforeCompile()) {
            IdeUtil.runNow((Runnable)new 6());
        }
    }

    public boolean compile(Context context, boolean bl, boolean bl2) {
        return this.compile(context, bl, bl2, false);
    }

    public boolean compile(Context context, boolean bl, boolean bl2, boolean bl3) {
        UnifiedBuildSystem unifiedBuildSystem = UnifiedBuildSystem.getInstance();
        boolean bl4 = true;
        try {
            if (!this.isBusy(context)) {
                this.saveAll(bl3);
                bl4 = bl2 && SwingUtilities.isEventDispatchThread() ? unifiedBuildSystem.buildOnUIThread(context, bl) : unifiedBuildSystem.init(context, bl);
            }
            if (bl2 && bl4) {
                unifiedBuildSystem.join(0L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (bl4) {
            bl4 = unifiedBuildSystem.getLastErrorCount() == 0;
        }
        return bl4;
    }

    public void compile(Context context, boolean bl, PostBuilder postBuilder, boolean bl2) {
        5 var5_5 = new 5(this, context, bl, bl2, postBuilder);
        var5_5.start();
    }

    public boolean compile(Context context, boolean bl, boolean bl2, OutputStream outputStream, OutputStream outputStream2) {
        this.errorLog = new OutputStreamLogPage(outputStream2);
        this.outputLog = new OutputStreamLogPage(outputStream);
        return this.compile(context, bl, true);
    }

    public boolean internalJavaCompile(Context context, ArrayList arrayList) throws Exception {
        if (this.isBusy(context)) {
            throw new IllegalStateException();
        }
        boolean[] blArray = new boolean[]{false};
        boolean bl = UnifiedBuildSystem.showCompileProgress;
        UnifiedBuildSystem.showCompileProgress = false;
        try {
            try {
                Element[] elementArray = context.getSelection();
                ArrayList<IdeStorage> arrayList2 = new ArrayList<IdeStorage>();
                Element[] elementArray2 = elementArray;
                int n = 0;
                while (n < elementArray2.length) {
                    Element element = elementArray2[n];
                    if (!element.getLongLabel().endsWith(".java")) {
                        throw new IllegalArgumentException();
                    }
                    arrayList2.add(new IdeStorage((Node)element));
                    ++n;
                }
                Translator translator = UnifiedBuildSystem.getInstance().getJavaTranslator();
                if (translator == null) {
                    throw new ClassNotFoundException();
                }
                4 var9_11 = new 4(this, blArray, arrayList);
                Project project = context.getProject();
                if (project == null) {
                    project = Ide.getActiveProject();
                }
                translator.setLog(var9_11);
                translator.translate(project, true, arrayList2, new ArrayList());
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
        }
        finally {
            UnifiedBuildSystem.showCompileProgress = bl;
        }
        return blArray[0];
    }

    public int compileInThread(Thread thread, Project project, ArrayList arrayList, boolean bl) {
        UnifiedBuildSystem unifiedBuildSystem = UnifiedBuildSystem.getInstance();
        return unifiedBuildSystem.compileInThread(thread, project, arrayList, bl);
    }

    public URL getURLFromClassName(Context context, String string) {
        URL uRL = null;
        if (!this.isBusy(context)) {
            uRL = UnifiedBuildSystem.getInstance().getURLFromClassName(context, string);
        }
        return uRL;
    }

    private static OjcConfiguration getOjcConfig(Project project) {
        return OjcConfiguration.getInstance((PropertyStorage)project);
    }

    static boolean getReverseCopyRes(Project project) {
        OjcConfiguration ojcConfiguration = JCompiler.getOjcConfig(project);
        if (ojcConfiguration != null) {
            return ojcConfiguration.getReverseCopyRes();
        }
        return false;
    }

    static String[] getCopyRes(Project project) {
        OjcConfiguration ojcConfiguration = JCompiler.getOjcConfig(project);
        if (ojcConfiguration != null) {
            return ojcConfiguration.getCopyRes();
        }
        return null;
    }

    static boolean isCopyable(String string, String[] stringArray, boolean bl) {
        if (string != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.endsWith(stringArray[n])) {
                    return bl ^ true;
                }
                ++n;
            }
        }
        return bl;
    }

    static boolean isCopyable(Element element, String[] stringArray, boolean bl) {
        if (element != null) {
            URL uRL;
            String string = element instanceof Node ? ((uRL = ((Node)element).getURL()) != null ? uRL.getPath() : element.getShortLabel()) : element.getShortLabel();
            return JCompiler.isCopyable(string, stringArray, bl);
        }
        return false;
    }

    static boolean isCopyable(Element element, Project project) {
        return JCompiler.isCopyable(element, JCompiler.getCopyRes(project), JCompiler.getReverseCopyRes(project));
    }

    public synchronized boolean addCopyListener(CopyListener copyListener) {
        int n = 0;
        while (n < this.copyListeners.size()) {
            if ((CopyListener)this.copyListeners.get(n) == copyListener) {
                return false;
            }
            ++n;
        }
        this.copyListeners.add(copyListener);
        return true;
    }

    public synchronized boolean removeCopyListener(CopyListener copyListener) {
        int n = 0;
        while (n < this.copyListeners.size()) {
            if ((CopyListener)this.copyListeners.get(n) == copyListener) {
                this.copyListeners.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean addBuildSystemListener(BuildSystemListener buildSystemListener) {
        int n = 0;
        while (n < this.buildListeners.size()) {
            if ((BuildSystemListener)this.buildListeners.get(n) == buildSystemListener) {
                return false;
            }
            ++n;
        }
        this.buildListeners.add(buildSystemListener);
        return true;
    }

    public synchronized boolean removeBuildSystemListener(BuildSystemListener buildSystemListener) {
        int n = 0;
        while (n < this.buildListeners.size()) {
            if ((BuildSystemListener)this.buildListeners.get(n) == buildSystemListener) {
                this.buildListeners.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    void invokeListenersBegin(Context context) throws BuildSystemVetoException {
        BuildSystemListener[] buildSystemListenerArray = this.getBuildSystemListenersArray();
        if (buildSystemListenerArray == null) {
            return;
        }
        int n = 0;
        while (n < buildSystemListenerArray.length) {
            buildSystemListenerArray[n].buildWillStart(context);
            ++n;
        }
    }

    void invokeListenersFinish(IdeLog ideLog) throws BuildSystemVetoException {
        BuildSystemListener[] buildSystemListenerArray = this.getBuildSystemListenersArray();
        if (buildSystemListenerArray == null) {
            return;
        }
        int n = 0;
        while (n < buildSystemListenerArray.length) {
            buildSystemListenerArray[n].buildFinished(ideLog.nerrors(), ideLog.nwarnings(), 0);
            ++n;
        }
    }

    private synchronized BuildSystemListener[] getBuildSystemListenersArray() {
        if (this.buildListeners == null || this.buildListeners.size() == 0) {
            return null;
        }
        BuildSystemListener[] buildSystemListenerArray = new BuildSystemListener[this.buildListeners.size()];
        int n = 0;
        Iterator iterator = this.buildListeners.iterator();
        while (iterator.hasNext()) {
            buildSystemListenerArray[n++] = (BuildSystemListener)iterator.next();
        }
        return buildSystemListenerArray;
    }

    public boolean lock(Context context, boolean bl) {
        if (this.isBusy(context)) {
            if (!bl) {
                return false;
            }
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return UnifiedBuildSystem.getInstance().lock(context);
    }

    public boolean unlock(Context context) {
        return UnifiedBuildSystem.getInstance().unlock();
    }

    public LogPage getOutputLog() {
        if (this.outputLog == null) {
            IdeArgs ideArgs = Ide.getIdeArgs();
            this.outputLog = !ideArgs.getCreateUI() || ideArgs.hasArg("-make") || ideArgs.hasArg("-rebuild") ? new OutputStreamLogPage(System.out) : LogManager.getLogManager().getMsgPage();
        }
        return this.outputLog;
    }

    public void logOutMsg(String string) {
        try {
            JCompiler.invokeAsap(new 3(this, string));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void logOutStartBuild() {
        JCompiler.invokeAsap(new 2());
    }

    private void _logOutEndBuild(int n, int n2) {
        IdeLog ideLog = UnifiedBuildSystem.ideLog;
        if (ideLog == null) {
            return;
        }
        DateFormat dateFormat = DateFormat.getTimeInstance(2);
        String string = "[" + dateFormat.format(new Date()) + "] ";
        if (n2 > 0) {
            String string2 = string + (n2 == 1 ? cleanCompleted : cleanCancelled);
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(string2 + "\n");
            }
            this.setStatusBarText(string2);
        } else if (ideLog.nerrors() + ideLog.nwarnings() > 0) {
            String string3 = string + CompArb.format(69, Integer.toString(ideLog.nerrors()), Integer.toString(ideLog.nwarnings()));
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(string3 + "\n");
            }
            this.setStatusBarText(string3);
            ideLog.unregisterAsynchronousLogPage(this.getErrorLog());
        } else {
            String string4 = string + (n == 0 ? msgNothingToBuild : msgSuccess);
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(string4 + "\n");
            }
            this.setStatusBarText(string4);
            ideLog.unregisterAsynchronousLogPage(this.getErrorLog());
        }
    }

    private void setStatusBarText(String string) {
        if (Ide.getIdeArgs().getCreateUI()) {
            Ide.getStatusBar().setText(string);
        }
    }

    void logOutEndBuild(int n, int n2) {
        JCompiler.invokeAsap(new 1(this, n, n2));
    }

    public LogPage getErrorLog() {
        if (this.errorLog == null) {
            IdeArgs ideArgs = Ide.getIdeArgs();
            this.errorLog = ideArgs.hasArg("-make") || ideArgs.hasArg("-rebuild") ? new OutputStreamLogPage(System.err) : new CompilerPage();
        }
        return this.errorLog;
    }

    public void registerTranslator(Translator translator) {
        UnifiedBuildSystem.getInstance().registerTranslator(translator);
    }

    public void unregisterTranslator(Translator translator) {
        UnifiedBuildSystem.getInstance().unregisterTranslator(translator);
    }

    public void registerNavigable(Navigable navigable) {
        this.compilerNavigable.addChildNavigable(navigable);
    }

    static void mav$projectPropertiesChangedImpl(JCompiler jCompiler, ProjectChangeEvent projectChangeEvent) {
        jCompiler.projectPropertiesChangedImpl(projectChangeEvent);
    }

    static HashMap ra$cachedProjects(JCompiler jCompiler) {
        return jCompiler.cachedProjects;
    }

    static boolean ra$disableProjectUpdates(JCompiler jCompiler) {
        return jCompiler.disableProjectUpdates;
    }

    static void wa$disableProjectUpdates(JCompiler jCompiler, boolean bl) {
        jCompiler.disableProjectUpdates = bl;
    }

    static String ra$msgStart() {
        return msgStart;
    }

    static void mav$setStatusBarText(JCompiler jCompiler, String string) {
        jCompiler.setStatusBarText(string);
    }

    static void mav$_logOutEndBuild(JCompiler jCompiler, int n, int n2) {
        jCompiler._logOutEndBuild(n, n2);
    }

    public final class 8
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            JCompiler.mav$projectPropertiesChangedImpl(JCompiler.this, projectChangeEvent);
        }
    }

    public final class 7
    extends NodeListener {
        public void nodeClosed(NodeEvent nodeEvent) {
            JCompiler.ra$cachedProjects(JCompiler.this).remove(nodeEvent.getNode());
        }
    }

    public final class 6
    implements Runnable {
        public void run() {
            boolean bl = JCompiler.ra$disableProjectUpdates(JCompiler.this);
            JCompiler.wa$disableProjectUpdates(JCompiler.this, true);
            try {
                try {
                    SaveAllCommand.saveAll();
                }
                catch (Exception exception) {}
            }
            finally {
                JCompiler.wa$disableProjectUpdates(JCompiler.this, bl);
            }
        }
    }

    public final class 5
    extends Thread {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ boolean v$rebuild;
        private final /* synthetic */ boolean v$save;
        private final /* synthetic */ PostBuilder v$postBuild;
        final /* synthetic */ JCompiler this$0;

        public void run() {
            boolean bl = this.this$0.compile(this.v$context, this.v$rebuild, true, this.v$save);
            if (this.v$postBuild != null) {
                this.v$postBuild.postBuild(bl);
            }
        }

        public 5(JCompiler jCompiler, Context context, boolean bl, boolean bl2, PostBuilder postBuilder) {
            this.v$postBuild = postBuilder;
            this.v$save = bl2;
            this.v$rebuild = bl;
            this.v$context = context;
            this.this$0 = jCompiler;
        }
    }

    public final class 4
    implements Translator.Log {
        int errCnt;
        int warningCnt;
        private final /* synthetic */ boolean[] v$areThereErrors;
        private final /* synthetic */ ArrayList v$messages;
        final /* synthetic */ JCompiler this$0;

        void $init$() {
            this.errCnt = 0;
            this.warningCnt = 0;
        }

        public void error(Storage storage, int n, int n2, int n3, String string) {
            this.v$areThereErrors[0] = true;
            this.v$messages.add(storage.getPath() + '(' + n + ',' + n2 + "):" + n3 + ':' + string);
            ++this.errCnt;
        }

        public void warning(Storage storage, int n, int n2, int n3, String string) {
            this.v$messages.add(storage.getPath() + '(' + n + ',' + n2 + "):" + n3 + ':' + string);
            ++this.warningCnt;
        }

        public void clear(Storage storage) {
        }

        public int nerrors() {
            return this.errCnt;
        }

        public int nwarnings() {
            return this.warningCnt;
        }

        public 4(JCompiler jCompiler, boolean[] blArray, ArrayList arrayList) {
            this.v$messages = arrayList;
            this.v$areThereErrors = blArray;
            this.this$0 = jCompiler;
            this.$init$();
        }
    }

    public final class 3
    implements Runnable {
        private final /* synthetic */ String v$msg;
        final /* synthetic */ JCompiler this$0;

        public void run() {
            this.this$0.getOutputLog().log((Object)this.v$msg);
        }

        public 3(JCompiler jCompiler, String string) {
            this.v$msg = string;
            this.this$0 = jCompiler;
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            if (UnifiedBuildSystem.showCompileProgress) {
                JCompiler.this.logOutMsg(JCompiler.ra$msgStart() + "\n");
            }
            JCompiler.mav$setStatusBarText(JCompiler.this, JCompiler.ra$msgStart());
            LogPage logPage = JCompiler.this.getErrorLog();
            UnifiedBuildSystem.ideLog.registerAsynchronousLogPage(logPage);
            if (Ide.getEnvironOptions().getClearCompilerLogBeforeCompile()) {
                logPage.clearAll();
            }
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ int v$filesBuilt;
        private final /* synthetic */ int v$cleanAll;
        final /* synthetic */ JCompiler this$0;

        public void run() {
            JCompiler.mav$_logOutEndBuild(this.this$0, this.v$filesBuilt, this.v$cleanAll);
        }

        public 1(JCompiler jCompiler, int n, int n2) {
            this.v$cleanAll = n2;
            this.v$filesBuilt = n;
            this.this$0 = jCompiler;
        }
    }
}

