/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdevimpl.runner.codecoach.CCResultPage;

final class JCompilerMenuItems
implements ContextMenuListener,
Controller,
Addin {
    private JCompiler jcompiler;
    private JMenuItem compileSelected;
    private JMenuItem rebuildSelected;
    private JMenuItem makeWorkingSet;
    private JMenuItem buildWorkingSet;
    private JMenuItem makeProject;
    private JMenuItem buildProject;
    private JMenuItem makeWorkspace;
    private JMenuItem buildWorkspace;
    private JMenuItem cancelBuild;
    private JMenuItem cleanAll;
    private static final String CompileS = CompArb.getString(4);
    private static final String RebuildS = CompArb.getString(8);
    private static final String SelectedS = CompArb.getString(1);
    private static final String CleanS = CompArb.getString(32);
    private static final String CompileDB = CompArb.getString(90);
    private static JCompilerMenuItems instance;
    private HashMap popupCachedMenuItems;

    JCompilerMenuItems() {
        instance = this;
    }

    static JCompilerMenuItems getInstance() {
        return instance;
    }

    public void initialize() {
        this.jcompiler = JCompiler.getInstance();
        if (this.jcompiler != null && this.jcompiler == Compiler.getCompiler()) {
            this.initializeMenuItems();
            NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)this, null);
            ContextMenu contextMenu = EditorManager.getEditorManager().getContextMenu();
            if (contextMenu != null) {
                contextMenu.addContextMenuListener((ContextMenuListener)this);
            }
            if ((contextMenu = LogManager.getLogManager().getContextMenu()) != null) {
                contextMenu.addContextMenuListener((ContextMenuListener)this);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (context == null) {
            return false;
        }
        int n = ideAction.getCommandId();
        if (this.jcompiler.isBusy(null) && n == JCompiler.CANCEL_BUILD_CMD_ID) {
            this.jcompiler.stopBuild(context);
            return true;
        }
        CompilerContext.setCompileAction(context, ideAction);
        if (n == JCompiler.MAKE_SELECTED_CMD_ID || n == JCompiler.MAKE_FOLDER_CMD_ID || n == JCompiler.MAKE_PROJECT_CMD_ID || n == JCompiler.MAKE_WORKINGSET_CMD_ID || n == JCompiler.MAKE_WORKSPACE_CMD_ID) {
            return this.jcompiler.compile(context, false, false, true);
        }
        if (n == JCompiler.BUILD_SELECTED_CMD_ID || n == JCompiler.BUILD_WORKINGSET_CMD_ID || n == JCompiler.BUILD_PROJECT_CMD_ID || n == JCompiler.BUILD_WORKSPACE_CMD_ID) {
            return this.jcompiler.compile(context, true, false, true);
        }
        if (n == JCompiler.CANCEL_BUILD_CMD_ID) {
            return true;
        }
        if (n == JCompiler.CLEANALL_CMD_ID) {
            this.jcompiler.cleanAll(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (context == null || ideAction == null) {
            return false;
        }
        int n = ideAction.getCommandId();
        if (n == JCompiler.MAKE_SELECTED_CMD_ID) {
            return this.setMenuItem(context, this.compileSelected, ideAction, false, false);
        }
        if (n == JCompiler.BUILD_SELECTED_CMD_ID) {
            return this.setMenuItem(context, this.rebuildSelected, ideAction, true, false);
        }
        if (n == JCompiler.MAKE_WORKINGSET_CMD_ID) {
            return this.setWSMenuItem(ideAction, !this.jcompiler.isBusy(context), this.makeWorkingSet, this.getWorkingSet(Ide.getActiveProject()));
        }
        if (n == JCompiler.BUILD_WORKINGSET_CMD_ID) {
            return this.setWSMenuItem(ideAction, !this.jcompiler.isBusy(context), this.buildWorkingSet, this.getWorkingSet(Ide.getActiveProject()));
        }
        if (n == JCompiler.MAKE_PROJECT_CMD_ID) {
            return this.setWPMenuItem(context, (Element)Ide.getActiveProject(), this.makeProject, ideAction, false);
        }
        if (n == JCompiler.BUILD_PROJECT_CMD_ID) {
            return this.setWPMenuItem(context, (Element)Ide.getActiveProject(), this.buildProject, ideAction, true);
        }
        if (n == JCompiler.MAKE_WORKSPACE_CMD_ID) {
            return this.setWPMenuItem(context, (Element)Ide.getActiveWorkspace(), this.makeWorkspace, ideAction, false);
        }
        if (n == JCompiler.BUILD_WORKSPACE_CMD_ID) {
            return this.setWPMenuItem(context, (Element)Ide.getActiveWorkspace(), this.buildWorkspace, ideAction, true);
        }
        if (n == JCompiler.MAKE_FOLDER_CMD_ID) {
            return this.setMenuItem(context, null, ideAction, false, false);
        }
        if (n == JCompiler.CANCEL_BUILD_CMD_ID) {
            boolean bl = UnifiedBuildSystem.getInstance().isAlive();
            return this.setMenuItem(ideAction, bl, this.cancelBuild);
        }
        if (n == JCompiler.CLEANALL_CMD_ID) {
            return this.setMenuItem(context, this.cleanAll, ideAction, false, true);
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Element element;
        boolean bl;
        IdeAction ideAction;
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view instanceof MessagePage && this.jcompiler.isBusy(context)) {
            IdeAction ideAction2 = IdeAction.find((int)JCompiler.CANCEL_BUILD_CMD_ID);
            ideAction2.setEnabled(true);
            contextMenu.add((Component)this.getMenuItem(contextMenu, ideAction2), JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        if (view instanceof CCResultPage) {
            return;
        }
        boolean bl2 = true;
        Element[] elementArray = this.getElementsFromContext(context, false);
        if (elementArray == null || elementArray.length == 0 || elementArray[0] == null || elementArray[0] instanceof AntNode || !elementArray[0].getAttributes().isSet(ElementAttributes.BUILDABLE) && !JCompiler.isCopyable(elementArray[0], context.getProject())) {
            return;
        }
        boolean bl3 = false;
        if (view instanceof NavigatorWindow) {
            NavigatorManager navigatorManager = ((NavigatorWindow)view).getManager();
            boolean bl4 = bl3 = navigatorManager != null && navigatorManager == NavigatorManager.getWorkspaceNavigatorManager();
        }
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            context = codeEditor.getContext();
            bl2 = false;
        }
        if ((ideAction = IdeAction.find((int)((bl = (element = elementArray.length >= 1 ? elementArray[0] : null) instanceof Project) ? JCompiler.MAKE_PROJECT_CMD_ID : JCompiler.MAKE_SELECTED_CMD_ID))) != null) {
            this.update(ideAction, context);
            contextMenu.add((Component)this.getMenuItem(contextMenu, ideAction), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        if (bl && bl3 && (ideAction = IdeAction.find((int)JCompiler.MAKE_WORKINGSET_CMD_ID)) != null) {
            this.update(ideAction, context);
            JMenuItem jMenuItem = this.getMenuItem(contextMenu, ideAction);
            this.setWSMenuItem(ideAction, true, jMenuItem, this.getWorkingSet(Ide.getActiveProject()));
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        if ((ideAction = IdeAction.find((int)(bl ? JCompiler.BUILD_PROJECT_CMD_ID : JCompiler.BUILD_SELECTED_CMD_ID))) != null && this.getPrefix(element, false, false) != CompileDB) {
            this.update(ideAction, context);
            contextMenu.add((Component)this.getMenuItem(contextMenu, ideAction), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        if (bl && bl3 && (ideAction = IdeAction.find((int)JCompiler.BUILD_WORKINGSET_CMD_ID)) != null) {
            this.update(ideAction, context);
            JMenuItem jMenuItem = this.getMenuItem(contextMenu, ideAction);
            this.setWSMenuItem(ideAction, true, jMenuItem, this.getWorkingSet(Ide.getActiveProject()));
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void initializeMenuItems() {
        Menubar menubar = Ide.getMenubar();
        AddinManager addinManager = AddinManager.getAddinManager();
        JMenu jMenu = MenuManager.getJMenu((String)"Run");
        String string = addinManager.getCommand(JCompiler.MAKE_WORKSPACE_CMD_ID, "oracle.jdeveloper.compiler.MakeWorkspaceCommand");
        IdeAction ideAction = IdeAction.get((int)JCompiler.MAKE_WORKSPACE_CMD_ID, (String)string, (String)CompArb.getString(23), (String)jMenu.getText(), (Integer)CompArb.getInteger(24), (ArrayResourceBundle)CompArb.getInstance(), (int)25, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(23));
        ideAction.addController((Controller)this);
        this.makeWorkspace = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_WORKSPACE);
        menubar.add((Component)this.makeWorkspace, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
        string = addinManager.getCommand(JCompiler.MAKE_PROJECT_CMD_ID, "oracle.jdeveloper.compiler.MakeProjectCommand");
        ideAction = IdeAction.get((int)JCompiler.MAKE_PROJECT_CMD_ID, (String)string, (String)CompArb.getString(17), (String)jMenu.getText(), (Integer)CompArb.getInteger(18), (ArrayResourceBundle)CompArb.getInstance(), (int)19, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(17));
        ideAction.addController((Controller)this);
        this.makeProject = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_PROJECT);
        menubar.add((Component)this.makeProject, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
        string = addinManager.getCommand(JCompiler.MAKE_WORKINGSET_CMD_ID, "oracle.jdeveloper.compiler.MakeWorkingSetCommand");
        ideAction = IdeAction.get((int)JCompiler.MAKE_WORKINGSET_CMD_ID, (String)string, (String)CompArb.getString(11), (String)jMenu.getText(), (Integer)CompArb.getInteger(12), (ArrayResourceBundle)CompArb.getInstance(), (int)13, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(11));
        ideAction.addController((Controller)this);
        this.makeWorkingSet = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_WORKSET);
        menubar.add((Component)this.makeWorkingSet, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
        string = addinManager.getCommand(JCompiler.BUILD_WORKINGSET_CMD_ID, "oracle.jdeveloper.compiler.BuildWorkingSetCommand");
        ideAction = IdeAction.get((int)JCompiler.BUILD_WORKINGSET_CMD_ID, (String)string, (String)CompArb.getString(14), (String)jMenu.getText(), (Integer)CompArb.getInteger(15), (ArrayResourceBundle)CompArb.getInstance(), (int)16, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(14));
        ideAction.addController((Controller)this);
        this.buildWorkingSet = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_WORKSET);
        menubar.add((Component)this.buildWorkingSet, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
        string = addinManager.getCommand(JCompiler.MAKE_FOLDER_CMD_ID, "oracle.jdeveloper.compiler.MakeFolderCommand");
        ideAction = IdeAction.get((int)JCompiler.MAKE_FOLDER_CMD_ID, (String)string, (String)CompArb.getString(2), (String)jMenu.getText(), (Integer)CompArb.getInteger(18), (ArrayResourceBundle)CompArb.getInstance(), (int)25, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(2));
        ideAction.addController((Controller)this);
        string = addinManager.getCommand(JCompiler.BUILD_WORKSPACE_CMD_ID, "oracle.jdeveloper.compiler.BuildWorkspaceCommand");
        ideAction = IdeAction.get((int)JCompiler.BUILD_WORKSPACE_CMD_ID, (String)string, (String)CompArb.getString(26), (String)jMenu.getText(), (Integer)CompArb.getInteger(27), (ArrayResourceBundle)CompArb.getInstance(), (int)28, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(26));
        ideAction.addController((Controller)this);
        this.buildWorkspace = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_WORKSPACE);
        menubar.add((Component)this.buildWorkspace, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
        string = addinManager.getCommand(JCompiler.BUILD_PROJECT_CMD_ID, "oracle.jdeveloper.compiler.BuildProjectCommand");
        ideAction = IdeAction.get((int)JCompiler.BUILD_PROJECT_CMD_ID, (String)string, (String)CompArb.getString(20), (String)jMenu.getText(), (Integer)CompArb.getInteger(21), (ArrayResourceBundle)CompArb.getInstance(), (int)22, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(20));
        ideAction.addController((Controller)this);
        this.buildProject = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_PROJECT);
        menubar.add((Component)this.buildProject, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
        string = addinManager.getCommand(JCompiler.MAKE_SELECTED_CMD_ID, "oracle.jdeveloper.compiler.MakeSelectedCommand");
        ideAction = IdeAction.get((int)JCompiler.MAKE_SELECTED_CMD_ID, (String)string, (String)CompileS, (String)jMenu.getText(), (Integer)CompArb.getInteger(5), (ArrayResourceBundle)CompArb.getInstance(), (int)6, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(3));
        ideAction.addController((Controller)this);
        this.compileSelected = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_MAKE_FILE);
        string = addinManager.getCommand(JCompiler.BUILD_SELECTED_CMD_ID, "oracle.jdeveloper.compiler.BuildSelectedCommand");
        ideAction = IdeAction.get((int)JCompiler.BUILD_SELECTED_CMD_ID, (String)string, (String)RebuildS, (String)jMenu.getText(), (Integer)CompArb.getInteger(9), (ArrayResourceBundle)CompArb.getInstance(), (int)10, null, (boolean)false);
        ideAction.putValue("NoCtxName", (Object)CompArb.getString(7));
        ideAction.addController((Controller)this);
        this.rebuildSelected = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_REBUILD_FILE);
        string = addinManager.getCommand(JCompiler.CANCEL_BUILD_CMD_ID, "oracle.jdeveloper.compiler.CancelBuildCommand");
        ideAction = IdeAction.get((int)JCompiler.CANCEL_BUILD_CMD_ID, (String)string, (String)CompArb.getString(29), (String)jMenu.getText(), (Integer)CompArb.getInteger(30), (ArrayResourceBundle)CompArb.getInstance(), (int)31, null, (boolean)false);
        ideAction.putValue("ShortDescription", (Object)CompArb.getString(29));
        ideAction.addController((Controller)this);
        this.cancelBuild = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_CANCEL_BUILD);
        menubar.add((Component)this.cancelBuild, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
        string = addinManager.getCommand(JCompiler.CLEANALL_CMD_ID, "oracle.jdeveloper.compiler.CleanAllCommand");
        ideAction = IdeAction.get((int)JCompiler.CLEANALL_CMD_ID, (String)string, (String)CleanS, (String)jMenu.getText(), (Integer)CompArb.getInteger(33), (ArrayResourceBundle)CompArb.getInstance(), (int)34, null, (boolean)false);
        ideAction.putValue("ShortDescription", (Object)CleanS);
        ideAction.addController((Controller)this);
        this.cleanAll = menubar.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_CLEANALL);
        menubar.add((Component)this.cleanAll, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
    }

    private JMenuItem getMenuItem(ContextMenu contextMenu, IdeAction ideAction) {
        JMenuItem jMenuItem;
        if (this.popupCachedMenuItems == null) {
            this.popupCachedMenuItems = new HashMap();
        }
        if ((jMenuItem = (JMenuItem)this.popupCachedMenuItems.get(ideAction)) == null) {
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
            this.popupCachedMenuItems.put(ideAction, jMenuItem);
        }
        return jMenuItem;
    }

    private boolean setMenuItem(IdeAction ideAction, boolean bl, JMenuItem jMenuItem) {
        ideAction.setEnabled(bl);
        jMenuItem.setEnabled(bl);
        jMenuItem.setVisible(true);
        return true;
    }

    private boolean setWPMenuItem(Context context, Element element, JMenuItem jMenuItem, IdeAction ideAction, boolean bl) {
        String string = "";
        Element[] elementArray = this.getElementsFromContext(context, true);
        if (elementArray != null && elementArray.length > 1 && (element == null || elementArray[0].getClass() == element.getClass())) {
            string = this.getPrefix(elementArray[0], bl, false) + SelectedS;
        } else if (element != null) {
            string = this.getPrefix(element, bl, false) + (this.inPopup(context) ? "" : element.getShortLabel());
        }
        if (string.length() > 0) {
            boolean bl2 = this.jcompiler.isBusy(null);
            jMenuItem.setText(string);
            jMenuItem.setEnabled(bl2 ^ true);
            ideAction.setEnabled(bl2 ^ true);
            ideAction.putValue("Name", (Object)string);
        } else {
            ideAction.setEnabled(false);
        }
        return true;
    }

    private boolean setWSMenuItem(IdeAction ideAction, boolean bl, JMenuItem jMenuItem, WorkingSet workingSet) {
        if (workingSet != null) {
            ideAction.setEnabled(bl);
            jMenuItem.setEnabled(bl);
            jMenuItem.setVisible(true);
            String string = CompArb.getString(ideAction.getCommandId() == JCompiler.MAKE_WORKINGSET_CMD_ID ? 11 : 14);
            jMenuItem.setText(string);
        }
        return true;
    }

    private WorkingSet getWorkingSet(Project project) {
        if (project == null) {
            return null;
        }
        WorkingSets workingSets = WorkingSets.getInstance((Project)project);
        WorkingSet workingSet = workingSets.getCurrentWorkingSet();
        if (workingSet == null) {
            workingSet = workingSets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
        }
        return workingSet;
    }

    private boolean setMenuItem(Context context, JMenuItem jMenuItem, IdeAction ideAction, boolean bl, boolean bl2) {
        Element[] elementArray = this.getElementsFromContext(context, true);
        if (elementArray == null || elementArray.length == 0 || elementArray[0] == null) {
            ideAction.setEnabled(false);
            return true;
        }
        Element element = elementArray[0];
        boolean bl3 = true;
        if (bl2) {
            if (element instanceof Workspace || element instanceof Workspaces) {
                ideAction.setEnabled(Ide.getActiveProject() != null);
                return true;
            }
            if (!(element instanceof Project)) {
                element = context.getProject();
                if (element == null) {
                    element = Ide.getActiveProject();
                }
                if (element == null) {
                    ideAction.setEnabled(false);
                    return true;
                }
                bl3 = false;
            }
        }
        String string = this.getPrefix(element, bl, bl2);
        String string2 = element.getShortLabel();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string + (elementArray.length > 1 && bl3 ? SelectedS : (this.inPopup(context) ? "" : string2));
        if (jMenuItem != null) {
            jMenuItem.setText(string3);
            jMenuItem.setVisible(true);
        }
        ideAction.putValue("Name", (Object)string3);
        if ((element instanceof Locatable || element != null && element.mayHaveChildren()) && !(element instanceof AntNode) && (element.getAttributes().isSet(ElementAttributes.BUILDABLE) || JCompiler.isCopyable(element, context.getProject())) || element instanceof Workspaces) {
            ideAction.setEnabled(this.jcompiler.isBusy(null) ^ true);
        } else {
            ideAction.setEnabled(false);
        }
        return true;
    }

    private String getPrefix(Element element, boolean bl, boolean bl2) {
        if (element instanceof Locatable && CmJavaUtil.isCMUrl(((Locatable)element).getURL())) {
            return CompileDB;
        }
        return bl ? RebuildS : (bl2 ? CleanS : CompileS);
    }

    private boolean inPopup(Context context) {
        EventObject eventObject = context.getEvent();
        return eventObject == null || eventObject instanceof MouseEvent;
    }

    private Element[] getElementsFromContext(Context context, boolean bl) {
        Element[] elementArray = context.getSelection();
        if (!(elementArray != null && elementArray.length != 0 && (elementArray[0] == null || elementArray[0].getAttributes().isSet(ElementAttributes.BUILDABLE)) || bl && context.getNode() == null)) {
            elementArray = new Element[]{context.getNode()};
        }
        return elementArray;
    }

    void enableCancelBuild(boolean bl) {
        if (Ide.getIdeArgs().getCreateUI()) {
            JCompiler.invokeAsap(new 1(this, bl));
        }
    }

    static JMenuItem ra$cancelBuild(JCompilerMenuItems jCompilerMenuItems) {
        return jCompilerMenuItems.cancelBuild;
    }

    static boolean mav$setMenuItem(JCompilerMenuItems jCompilerMenuItems, IdeAction ideAction, boolean bl, JMenuItem jMenuItem) {
        return jCompilerMenuItems.setMenuItem(ideAction, bl, jMenuItem);
    }

    static JMenuItem ra$makeProject(JCompilerMenuItems jCompilerMenuItems) {
        return jCompilerMenuItems.makeProject;
    }

    static JMenuItem ra$buildProject(JCompilerMenuItems jCompilerMenuItems) {
        return jCompilerMenuItems.buildProject;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$enable;
        final /* synthetic */ JCompilerMenuItems this$0;

        public void run() {
            JCompilerMenuItems.mav$setMenuItem(this.this$0, IdeAction.find((int)JCompiler.CANCEL_BUILD_CMD_ID), this.v$enable, JCompilerMenuItems.ra$cancelBuild(this.this$0));
            JCompilerMenuItems.mav$setMenuItem(this.this$0, IdeAction.find((int)JCompiler.MAKE_PROJECT_CMD_ID), this.v$enable ^ true, JCompilerMenuItems.ra$makeProject(this.this$0));
            JCompilerMenuItems.mav$setMenuItem(this.this$0, IdeAction.find((int)JCompiler.BUILD_PROJECT_CMD_ID), this.v$enable ^ true, JCompilerMenuItems.ra$buildProject(this.this$0));
        }

        public 1(JCompilerMenuItems jCompilerMenuItems, boolean bl) {
            this.v$enable = bl;
            this.this$0 = jCompilerMenuItems;
        }
    }
}

