/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.compiler.CompArb;
import oracle.ojc.interfaces.Storage;

public class JarStorage
implements Storage {
    private final URL _jarURL;
    private final JarIndex _jarIndex;
    private final String _jarEntry;
    private final int _jarEntryIndex;
    private final File _jarFile;
    private String _canonicalPath;
    private HashMap properties;
    static final /* synthetic */ boolean $assertionsDisabled;

    void $init$() {
        this.properties = null;
    }

    public JarStorage(URL uRL) {
        LogManager logManager;
        this.$init$();
        this._jarURL = uRL;
        URL uRL2 = JarUtil.getJarFileURL((URL)uRL);
        this._jarFile = new File(uRL2.getPath());
        JarIndex jarIndex = null;
        try {
            jarIndex = JarUtil.getJarIndex((URL)this._jarURL);
        }
        catch (IOException iOException) {
            jarIndex = null;
        }
        this._jarIndex = jarIndex;
        if ((this._jarIndex == null || this._jarIndex.getNumEntries() == 0 && this._jarIndex.getTimestamp() > 0L) && (logManager = LogManager.getLogManager()) != null) {
            LogPage logPage = logManager.getMsgPage();
            1 var7_7 = new 1(this, logPage);
            if (logPage instanceof MessagePage) {
                var7_7.run();
            } else {
                SwingUtilities.invokeLater(var7_7);
            }
        }
        this._jarEntry = JarUtil.getJarEntry((URL)this._jarURL);
        this._jarEntryIndex = -1;
    }

    private JarStorage(JarStorage jarStorage, String string, int n) {
        this.$init$();
        this._jarURL = jarStorage._jarURL;
        this._jarIndex = jarStorage._jarIndex;
        this._jarEntry = string;
        this._jarEntryIndex = n;
        this._jarFile = jarStorage._jarFile;
        if (!ModelUtil.hasLength((String)jarStorage._jarEntry)) {
            this._canonicalPath = jarStorage.getCanonicalPath() + File.separator + string.replace('/', File.separatorChar);
        } else {
            this._canonicalPath = jarStorage.getCanonicalPath();
            if (!this._canonicalPath.endsWith(File.separator)) {
                this._canonicalPath = this._canonicalPath + File.separator;
            }
            this._canonicalPath = this._canonicalPath + this.getName().replace('/', File.separatorChar);
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        JarStorage jarStorage = (JarStorage)object;
        return ModelUtil.areEqual((Object)this._jarEntry, (Object)jarStorage._jarEntry) && ModelUtil.areEqual((Object)this._jarFile, (Object)jarStorage._jarFile);
    }

    public int hashCode() {
        return this._jarURL != null ? this._jarURL.hashCode() : 0;
    }

    public String toString() {
        return this.getCanonicalPath();
    }

    public long modDate() {
        if (this._jarIndex != null && this._jarEntryIndex >= 0) {
            return this._jarIndex.getTimestamp(this._jarEntryIndex);
        }
        return this._jarFile.lastModified();
    }

    public URL getURL() {
        return URLFactory.newJarURL((URL)this._jarURL, (String)this._jarEntry);
    }

    public String getName() {
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            int n = this._jarEntry.lastIndexOf("/");
            if (this._jarEntry.endsWith("/") && n > 0) {
                n = this._jarEntry.lastIndexOf("/", n - 1);
            }
            return this._jarEntry.substring(n + 1);
        }
        return this._jarFile.getName();
    }

    public String getPath() {
        String string = this._jarFile.getPath();
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            return string + "/" + this._jarEntry;
        }
        return string;
    }

    public String getCanonicalPath() {
        if (this._canonicalPath == null) {
            try {
                this._canonicalPath = this._jarFile.getCanonicalPath() + "!";
            }
            catch (IOException iOException) {
                this._canonicalPath = this._jarFile.getAbsolutePath();
            }
            if (ModelUtil.hasLength((String)this._jarEntry)) {
                this._canonicalPath = this._canonicalPath + File.separator + this._jarEntry.replace('/', File.separatorChar);
            }
        }
        return this._canonicalPath;
    }

    public String getParent() {
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            return this._jarFile.getPath();
        }
        return this._jarFile.getParent();
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public boolean isDirectory() {
        return !ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/");
    }

    public boolean isInJar() {
        return true;
    }

    public void close() {
    }

    static {
        $assertionsDisabled = JarStorage.class.desiredAssertionStatus() ^ true;
    }

    public int size() throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public ArrayList listStorage() {
        String[] stringArray = this.list();
        if (stringArray != null) {
            ArrayList<Storage> arrayList = new ArrayList<Storage>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(this.open(stringArray[n]));
                ++n;
            }
            return arrayList;
        }
        return null;
    }

    public String[] list() {
        if (this._jarIndex != null && (this._jarEntry.length() == 0 || this._jarEntry.endsWith("/"))) {
            return this._jarIndex.list(this._jarEntry);
        }
        return new String[0];
    }

    public void open() throws IOException {
    }

    public Storage open(String string) {
        if ((string = string.replace(File.separatorChar, '/')).endsWith("/")) {
            return this.openDir(string);
        }
        string = this._jarEntry + string;
        int n = this._jarIndex != null ? this._jarIndex.entryIndex(string) : -1;
        return n >= 0 ? new JarStorage(this, string, n) : null;
    }

    public Storage openDir(String string) {
        if (!(string = string.replace(File.separatorChar, '/')).endsWith("/")) {
            string = string + "/";
        }
        string = this._jarEntry + string;
        int n = this._jarIndex != null ? this._jarIndex.dirEntryIndex(string) : -1;
        return n >= 0 ? new JarStorage(this, string, n) : null;
    }

    public byte[] read() throws IOException {
        if (!ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/")) {
            throw new UnsupportedOperationException();
        }
        return this._jarIndex.getBytes(this._jarEntry);
    }

    public int read(byte[] byArray) throws IOException {
        if (!ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/")) {
            throw new UnsupportedOperationException();
        }
        byte[] byArray2 = this._jarIndex.getBytes(this._jarEntry);
        int n = byArray2.length;
        if (n > byArray.length) {
            return n;
        }
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return n;
    }

    public Storage setContext(Storage storage) {
        throw new UnsupportedOperationException();
    }

    public void setPackage(String string) {
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Storage create(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Storage createDir(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    static File ra$_jarFile(JarStorage jarStorage) {
        return jarStorage._jarFile;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ LogPage v$page;
        final /* synthetic */ JarStorage this$0;

        public void run() {
            this.v$page.log((Object)CompArb.format(70, JarStorage.ra$_jarFile(this.this$0).getPath()));
            this.v$page.log((Object)"\n");
        }

        public 1(JarStorage jarStorage, LogPage logPage) {
            this.v$page = logPage;
            this.this$0 = jarStorage;
        }
    }
}

