/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.runner.SimpleProcess;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.DependencyProvider;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorageMap;
import oracle.jdeveloper.compiler.IdeStorageWrapper;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.compiler.PatchClassFile;
import oracle.jdeveloper.compiler.RedefineMap;
import oracle.jdeveloper.compiler.SourceFinder;
import oracle.jdeveloper.compiler.SourceMap;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Warning;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.FileStorage;

public class Ojc
implements Addin,
Translator {
    private Translator.Log _log;
    private static File tmpJavacFile = null;
    private static File tmpOjcFile = null;
    static Context currentContext = null;

    void $init$() {
        this._log = null;
    }

    public Ojc() {
        this.$init$();
    }

    public String getName() {
        return "Ojc";
    }

    public ArrayList getInputTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(".java");
        return arrayList;
    }

    public ArrayList getOutputTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(".class");
        return arrayList;
    }

    public boolean canBuild(Storage storage) {
        return storage.getName().endsWith(".java");
    }

    public boolean needToBuild(Storage storage) {
        return false;
    }

    public void setLog(Translator.Log log) {
        this._log = log;
    }

    public void setParameter(String string, String string2) {
        throw new Error();
    }

    public void setProject(Project project) {
    }

    public void updateProject(Project project) {
    }

    private static String replaceExt(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            n = string.length();
        }
        if (string.indexOf(File.separatorChar, n) < 0) {
            string = string.substring(0, n);
        }
        return string + string2;
    }

    private static File getCdiFile(Project project) {
        URL uRL = project.getURL();
        URL uRL2 = JavaProject.getInstance(project).getOutputDirectory();
        if (uRL2 != null) {
            String string = new File(uRL2.getPath()).getPath();
            String string2 = URLFileSystem.getFileName((URL)uRL);
            return new File(string, Ojc.replaceExt(string2, ".cdi"));
        }
        String string = URLFileSystem.getPlatformPathName((URL)uRL);
        return new File(Ojc.replaceExt(string, ".cdi"));
    }

    private static File processOutputDirectory(Project project, ArrayList arrayList) {
        File file;
        URL uRL = JavaProject.getInstance(project).getOutputDirectory();
        File file2 = file = uRL != null ? new File(uRL.getPath()) : new File(project.getURL().getPath()).getParentFile();
        if (arrayList != null) {
            arrayList.add("-d");
            arrayList.add(Ojc.stringize(file.getPath()));
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static URL getURLFromClassName(Project project, String string) {
        FileStorage fileStorage = new FileStorage(Ojc.getCdiFile(project));
        return SourceFinder.getFromCDI((Storage)fileStorage, string);
    }

    private static String stringize(String string) {
        if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
            return "\"" + string + "\"";
        }
        return string;
    }

    private String buildString(String string, Storage[] storageArray, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (storageArray != null) {
            int n = 0;
            while (n < storageArray.length) {
                stringBuffer.append(string == null ? Ojc.stringize(storageArray[n].getPath()) : storageArray[n].getPath());
                stringBuffer.append(string == null ? " " : File.pathSeparator);
                ++n;
            }
        }
        if (arrayList != null) {
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                arrayList2.add(arrayList.get(n));
                ++n;
            }
            ArrayList arrayList3 = Helpers.listOfUniqueClassPathElement(arrayList2);
            if (arrayList3 != null) {
                int n2 = 0;
                while (n2 < arrayList3.size()) {
                    URL uRL = (URL)arrayList3.get(n2);
                    String string2 = new File(uRL.getPath()).getPath();
                    stringBuffer.append(string == null ? Ojc.stringize(string2) : string2);
                    stringBuffer.append(string == null ? " " : File.pathSeparator);
                    ++n2;
                }
            }
        }
        if (stringBuffer != null && stringBuffer.length() > 0) {
            if (string != null) {
                stringBuffer.setLength(stringBuffer.length() - 1);
                return string + " " + Ojc.stringize(stringBuffer.toString()) + " ";
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, ' ');
            return stringBuffer.toString();
        }
        return "";
    }

    private void addSMAPs(ArrayList arrayList, String string) {
        int n = 0;
        while (n < arrayList.size()) {
            Storage storage = (Storage)arrayList.get(n);
            SourceMap sourceMap = (SourceMap)storage.getProperty("sourceMap");
            if (sourceMap != null) {
                try {
                    String string2;
                    String string3 = sourceMap.getQualifiedClassName().replace('.', File.separatorChar) + ".class";
                    File file = new File(string + File.separatorChar + string3);
                    if (file.exists()) {
                        PatchClassFile.addSMAP(file, sourceMap.getSMAP());
                    }
                    if ((string2 = (String)storage.getProperty("outputDirectory")) != null && !string2.equals(string)) {
                        File file2 = new File(string2 + File.separatorChar + string3);
                        if (file2.exists()) {
                            file2.delete();
                        }
                        file.renameTo(file2);
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassFormatError classFormatError) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    private void logMessage(Translator.Log log, Storage storage, int n, int n2, String string, boolean bl) {
        SourceMap sourceMap;
        int n3 = Scanner.positionToLine((int)n);
        int n4 = Scanner.positionToColumn((int)n);
        if (storage != null && (sourceMap = (SourceMap)storage.getProperty("sourceMap")) != null) {
            int[] nArray = new int[]{n3, n4};
            Storage[] storageArray = new Storage[]{null};
            sourceMap.translateLocation(nArray, storageArray);
            n3 = nArray[0];
            n4 = nArray[1];
            storage = storageArray[0];
            if (storage != null && J2eeSettings.isCompilableJsp(storage.getName()) && log instanceof IdeLog) {
                String string2;
                URL uRL;
                URL uRL2;
                String string3;
                File file;
                if (n2 == IdeLog.getUnusedImportCode() || n2 == IdeLog.getPartialUsedStarImportCode()) {
                    return;
                }
                Project project = ((IdeLog)log).getProject();
                if (project != null && (file = new File(string3 = URLFileSystem.getPlatformPathName((URL)(uRL2 = URLFactory.newURL((URL)(uRL = J2eeSettings.getInstance(project).getHtmlRootDirectory()), (String)(string2 = storage.getPath())))))).exists()) {
                    storage = Helpers.createFileStorage(file);
                }
            }
        }
        if (bl) {
            log.error(storage, n3, n4, n2, string);
        } else {
            log.warning(storage, n3, n4, n2, string);
        }
    }

    private String buildOjcCmdLine(Project project, Options options, ArrayList arrayList, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = new File(JProjectLibraries.getInstance((PropertyStorage)project).getJDK().getJavaExecutable().getPath()).getPath();
        if (string == null) {
            string = "<path to java executable>";
        }
        stringBuffer.append(string);
        stringBuffer.append(" -jar ");
        File file = new File(Ide.getLibDirectory(), "ojc.jar");
        if (file.exists()) {
            stringBuffer.append(file.getPath());
        } else {
            file = new File(Ide.getBinDirectory() + "/../lib/ojc.jar");
            if (file.exists()) {
                stringBuffer.append(file.getPath());
            } else {
                stringBuffer.append("<ojc.jar location>");
            }
        }
        stringBuffer.append(options.noquiet ? " -noquiet " : " ");
        if (Warning.isEmpty()) {
            stringBuffer.append("-nowarn ");
        } else {
            stringBuffer.append("-warn ");
            if (!Warning.isEnabled((int)Message.warningStaticAccessWithObject.getNumber())) {
                stringBuffer.append("-nowarn:" + Message.warningStaticAccessWithObject.getNumber() + " ");
            }
            if (!Warning.isEnabled((int)Message.warningUnusedImport.getNumber())) {
                stringBuffer.append("-nowarn:" + Message.warningUnusedImport.getNumber() + " ");
            }
            if (!Warning.isEnabled((int)Message.warningPartialUsedStarImport.getNumber())) {
                stringBuffer.append("-nowarn:" + Message.warningPartialUsedStarImport.getNumber() + " ");
            }
            if (!Warning.isEnabled((int)Message.warningIsDeprecated.getNumber())) {
                stringBuffer.append("-nowarn:" + Message.warningIsDeprecated.getNumber() + " ");
            } else {
                stringBuffer.append("-deprecation");
                if (options.selfDeprecation) {
                    stringBuffer.append(":self ");
                } else {
                    stringBuffer.append(" ");
                }
            }
            stringBuffer.append("-nowarn:" + Message.warningCatchVarNeverUsed.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningDirectoryDoesntExist.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningDuplicateImport.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningEmptyCatchStatement.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningEmptySource.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningEmptyStatement.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningFallThrough.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningMethodNeverCalled.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningNoSerialVersionUID.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningOverridesDeprecated.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningParameterNeverUsed.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningSelfAssignment.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningSwitchWithoutCase.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningUncheckedConversion.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningUnnecessaryCast.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningUnterminatedFinally.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningVarAssignmentNeverUsed.getNumber() + " ");
            stringBuffer.append("-nowarn:" + Message.warningVariableNeverUsed.getNumber() + " ");
        }
        switch (options.sourceJDKVersion) {
            case 110: {
                stringBuffer.append("-source 1.1 ");
                break;
            }
            case 120: {
                stringBuffer.append("-source 1.2 ");
                break;
            }
            case 130: {
                stringBuffer.append("-source 1.3 ");
                break;
            }
            case 140: {
                stringBuffer.append("-source 1.4 ");
                break;
            }
            case 150: {
                stringBuffer.append("-source 1.5 ");
            }
        }
        switch (options.targetJDKVersion) {
            case 110: {
                stringBuffer.append("-target 1.1 ");
                break;
            }
            case 120: {
                stringBuffer.append("-target 1.2 ");
                break;
            }
            case 130: {
                stringBuffer.append("-target 1.3 ");
                break;
            }
            case 140: {
                stringBuffer.append("-target 1.4 ");
                break;
            }
            case 150: {
                stringBuffer.append("-target 1.5 ");
            }
        }
        if (options.excludeClasses != null && options.excludeClasses.size() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer("-exclude ");
            int n = 0;
            while (n < options.excludeClasses.size()) {
                stringBuffer2.append((String)options.excludeClasses.get(n));
                stringBuffer2.append(File.pathSeparator);
                ++n;
            }
            stringBuffer2.setCharAt(stringBuffer2.length() - 1, ' ');
            stringBuffer.append(stringBuffer2.toString());
        }
        stringBuffer.append("-encoding ");
        stringBuffer.append(options.encoding == null ? "null" : options.encoding);
        stringBuffer.append(" ");
        if (options.localVariables) {
            stringBuffer.append("-g ");
        }
        if (options.destinationDir != null) {
            stringBuffer.append("-d ");
            stringBuffer.append(Ojc.stringize(options.destinationDir));
            stringBuffer.append(" ");
        }
        if (options.makeFile != null) {
            stringBuffer.append("-make ");
            stringBuffer.append(Ojc.stringize(options.makeFile.getPath()));
            stringBuffer.append(" ");
            if (bl) {
                stringBuffer.append("-rebuild ");
            }
        }
        stringBuffer.append(this.buildString("-classpath ", options.classpathStorage, arrayList));
        stringBuffer.append(this.buildString("-sourcepath ", options.sourcepathStorage, null));
        Storage[] storageArray = new Storage[arrayList.size()];
        arrayList.toArray(storageArray);
        stringBuffer.append(this.buildString(null, storageArray, null));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runJavacProcess(Project project, OjcConfiguration ojcConfiguration, boolean bl, ArrayList arrayList, ArrayList arrayList2, Translator.Log log) {
        String string;
        RedefineMap redefineMap = new RedefineMap();
        HashMap<String, Storage> hashMap = new HashMap<String, Storage>();
        ArrayList<String> arrayList3 = new ArrayList<String>(15 + arrayList.size());
        try {
            String string2 = JProjectLibraries.getInstance((PropertyStorage)project).getJDK().getJavaExecutable().getPath();
            if (string2.endsWith("jre/bin/java.exe")) {
                string2 = string2.substring(0, string2.length() - 16) + "bin/javac.exe";
            } else if (string2.endsWith("java.exe")) {
                string2 = string2.substring(0, string2.length() - 4) + "c.exe";
            } else if (string2.endsWith("jre/bin/java")) {
                string2 = string2.substring(0, string2.length() - 12) + "bin/javac";
            } else if (string2.endsWith("java")) {
                string2 = string2 + "c";
            } else {
                throw new Throwable();
            }
            File file = new File(string2);
            if (!file.exists()) {
                throw new Throwable();
            }
            string2 = file.getPath();
            arrayList3.add(Ojc.stringize(string2));
        }
        catch (Throwable throwable) {
            System.out.println("error: unable to determine javac path");
            int n = 1;
            return n;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("compiler.vmargs", ""), " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList3.add("-J" + stringTokenizer.nextToken());
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            arrayList3.add("-verbose");
        }
        if (ojcConfiguration.isShowWarnings() && ojcConfiguration.isShowDeprecations()) {
            arrayList3.add("-deprecation");
        }
        if (!(string = ojcConfiguration.getSource()).equals("Default")) {
            arrayList3.add("-source");
            arrayList3.add(string);
        }
        arrayList3.add("-Xlint:all");
        String string3 = ojcConfiguration.getTarget();
        if (!string3.equals("Default")) {
            arrayList3.add("-target");
            arrayList3.add(string3);
        }
        arrayList3.add("-encoding");
        arrayList3.add(ojcConfiguration.getCurrentEncoding());
        if (ojcConfiguration.isDebugInformation()) {
            arrayList3.add("-g");
        }
        arrayList3.add("-classpath");
        arrayList3.add(Ojc.stringize(Helpers.urlPathAndDependantPathToString(PathsConfiguration.getInstance(project).getClassPath(), arrayList, File.pathSeparator)));
        arrayList3.add("-sourcepath");
        arrayList3.add(Ojc.stringize(Helpers.urlPathToString(PathsConfiguration.getInstance(project).getProjectSourcePath(), File.pathSeparator)));
        String string4 = Ojc.processOutputDirectory(project, arrayList3).getPath();
        try {
            if (tmpJavacFile == null) {
                tmpJavacFile = File.createTempFile("javac", null, null);
                tmpJavacFile.deleteOnExit();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tmpJavacFile), 16384);
            int n = 0;
            while (n < arrayList.size()) {
                Storage storage = (Storage)arrayList.get(n);
                String string5 = storage.getPath();
                bufferedWriter.write(Ojc.stringize(string5).replace('\\', '/'));
                bufferedWriter.write("\n");
                if (storage.getProperty("sourceMap") != null) {
                    hashMap.put(string5, storage);
                }
                ++n;
            }
            bufferedWriter.close();
            arrayList3.add(Ojc.stringize("@" + tmpJavacFile.getPath()));
        }
        catch (Throwable throwable) {
            System.out.println("error: unable to run javac as an external process: " + throwable);
            int n = 1;
            return n;
        }
        SimpleProcess simpleProcess = new SimpleProcess(arrayList3.toArray(new String[arrayList3.size()]));
        simpleProcess.setAddToProcessesFolder(false);
        simpleProcess.setAddToTerminateMenu(false);
        simpleProcess.setLogPage((LogPage)new 1JavacLogInfo(this, string4, simpleProcess, hashMap, log, redefineMap));
        int n = simpleProcess.execAndWait();
        SimpleProcess simpleProcess2 = simpleProcess;
        SimpleProcess simpleProcess3 = simpleProcess;
        synchronized (simpleProcess3) {
            simpleProcess2 = null;
        }
        if (n < 0) {
            log.error(null, 0, 0, 0, CompArb.getString(83));
        }
        redefineMap.redefineClassMap(project);
        this.addSMAPs(arrayList, string4);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runOjc2Process(String string, Project project, OjcConfiguration ojcConfiguration, boolean bl, ArrayList arrayList, ArrayList arrayList2, Translator.Log log) {
        String string2;
        String string3;
        RedefineMap redefineMap = new RedefineMap();
        HashMap<String, Storage> hashMap = new HashMap<String, Storage>();
        ArrayList<String> arrayList3 = new ArrayList<String>(15 + arrayList.size());
        try {
            String string4 = System.getProperty("java.home");
            if (string4 != null) {
                if (!(string4 = string4.replace('\\', '/')).endsWith("/")) {
                    string4 = string4 + '/';
                }
                string4 = new File(string4 + "bin/java.exe").exists() ? string4 + "bin/java.exe" : (new File(string4 + "bin/java").exists() ? string4 + "bin/java" : null);
            }
            if (string4 == null) {
                throw new Throwable("error: unable to determine java path");
            }
            arrayList3.add(Ojc.stringize(string4.replace('/', File.separatorChar)));
            StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("compiler.vmargs", ""), " ");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList3.add(stringTokenizer.nextToken());
            }
            arrayList3.add("-classpath");
            if (!new File(string).exists()) {
                throw new Throwable("error: " + string + " is not a jar file, or the file is not found");
            }
            arrayList3.add(Ojc.stringize(string));
            arrayList3.add("oracle.ojc.compiler.IdeMain");
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
            int n = 1;
            return n;
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            arrayList3.add("-verbose");
        }
        if (!(string3 = ojcConfiguration.getSource()).equals("Default")) {
            arrayList3.add("-source");
            arrayList3.add(string3);
        }
        if (!(string2 = ojcConfiguration.getTarget()).equals("Default")) {
            arrayList3.add("-target");
            arrayList3.add(string2);
        }
        arrayList3.add("-encoding");
        arrayList3.add(ojcConfiguration.getCurrentEncoding());
        if (ojcConfiguration.isDebugInformation()) {
            arrayList3.add("-g");
        }
        arrayList3.add("-classpath");
        arrayList3.add(Ojc.stringize(Helpers.urlPathAndDependantPathToString(PathsConfiguration.getInstance(project).getClassPath(), arrayList, File.pathSeparator)));
        arrayList3.add("-sourcepath");
        arrayList3.add(Ojc.stringize(Helpers.urlPathToString(PathsConfiguration.getInstance(project).getProjectSourcePath(), File.pathSeparator)));
        String string5 = Ojc.processOutputDirectory(project, arrayList3).getPath();
        try {
            if (tmpOjcFile == null) {
                tmpOjcFile = File.createTempFile("ojc2", null, null);
                tmpOjcFile.deleteOnExit();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tmpOjcFile), 16384);
            int n = 0;
            while (n < arrayList.size()) {
                Storage storage = (Storage)arrayList.get(n);
                String string6 = storage.getPath();
                bufferedWriter.write(Ojc.stringize(string6));
                bufferedWriter.write("\n");
                if (storage.getProperty("sourceMap") != null) {
                    hashMap.put(string6, storage);
                }
                arrayList3.add(Ojc.stringize(string6));
                ++n;
            }
            bufferedWriter.close();
        }
        catch (Throwable throwable) {
            System.out.println("error: unable to run ojc2 as an external process: " + throwable);
            int n = 1;
            return n;
        }
        SimpleProcess simpleProcess = new SimpleProcess(arrayList3.toArray(new String[arrayList3.size()]));
        simpleProcess.setAddToProcessesFolder(false);
        simpleProcess.setAddToTerminateMenu(false);
        simpleProcess.setLogPage((LogPage)new 1Ojc2LogInfo(this, string5, simpleProcess, hashMap, log, redefineMap));
        int n = simpleProcess.execAndWait();
        SimpleProcess simpleProcess2 = simpleProcess;
        SimpleProcess simpleProcess3 = simpleProcess;
        synchronized (simpleProcess3) {
            simpleProcess2 = null;
        }
        if (n < 0) {
            System.out.println("runOjc2Process: return code --> " + n);
            log.error(null, 0, 0, 0, CompArb.getString(83));
        }
        redefineMap.redefineClassMap(project);
        this.addSMAPs(arrayList, string5);
        return 0;
    }

    private ArrayList checkDependencies(DependencyProvider dependencyProvider, File file, Project project, ArrayList arrayList, boolean bl) {
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                dependencyProvider.load(fileInputStream, false);
            }
            catch (IOException iOException) {
                dependencyProvider.reinit();
            }
        }
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = project.findChildren(JavaSourceNode.class);
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            URL uRL = node.getURL();
            if (!uRL.getPath().endsWith(".java")) continue;
            arrayList2.add(uRL);
        }
        int n = 0;
        while (n < arrayList.size()) {
            URL uRL;
            Storage storage = (Storage)arrayList.get(n);
            String string = storage.getPath();
            if (string.endsWith(".java") && storage.getProperty("preprocessor_generated_file") == Boolean.TRUE && !arrayList2.contains(uRL = URLFactory.newFileURL((String)string))) {
                arrayList2.add(uRL);
            }
            ++n;
        }
        try {
            arrayList2 = dependencyProvider.updateData(arrayList2, bl, true);
        }
        catch (IOException iOException) {
            new Exception("dependency provider error").printStackTrace();
        }
        arrayList.clear();
        Collection collection = dependencyProvider.getDependants(arrayList2, true);
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new FileStorage(new File(((URL)iterator.next()).getPath())));
        }
        return arrayList;
    }

    public int translate(Project project, boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        int n;
        int n2;
        int n3;
        int n4;
        File file;
        IdeStorageMap ideStorageMap;
        Options options;
        RedefineMap redefineMap;
        Project project2;
        Translator.Log log;
        block33: {
            Boolean bl2;
            String string;
            String string2;
            UnifiedBuildSystem.getInstance().beginMarking();
            log = this._log;
            project2 = project;
            OjcConfiguration ojcConfiguration = OjcConfiguration.getInstance((PropertyStorage)project2);
            redefineMap = new RedefineMap();
            if (ojcConfiguration.isUseJavac()) {
                DependencyProvider dependencyProvider = new DependencyProvider();
                File file2 = new File(Ide.getSystemDirectory() + File.separator + "cache" + File.separator + project2.getLongLabel().replace(File.separatorChar, '_').replace(':', '_').replace('.', '_') + ".deps");
                arrayList = this.checkDependencies(dependencyProvider, file2, project2, arrayList, bl);
                if (arrayList.size() <= 0) {
                    return 0;
                }
                int n5 = log.nerrors();
                if (this.runJavacProcess(project2, ojcConfiguration, bl, arrayList, arrayList2, log) == 0) {
                    if (n5 == log.nerrors()) {
                        try {
                            File file3 = file2.getParentFile();
                            if (!file3.exists()) {
                                file3.mkdirs();
                            }
                            dependencyProvider.save(new FileOutputStream(file2), false);
                        }
                        catch (IOException iOException) {
                            new Exception("Dependency provider error, " + file2.getPath() + " may be readonly").printStackTrace();
                        }
                    }
                    return 0;
                }
            }
            if ((string2 = System.getProperty("useOjc2")) != null && this.runOjc2Process(string2, project2, ojcConfiguration, bl, arrayList, arrayList2, log) == 0) {
                return 0;
            }
            options = new Options(null);
            options.ideEnv = new 2(this, log, redefineMap);
            1 var16_16 = new 1(this, options, log);
            options.log = var16_16;
            Message.initializeMessages((Log)options.log);
            if (Thread.currentThread().isInterrupted()) {
                return 0;
            }
            options.noquiet = UnifiedBuildSystem.showCompileProgress;
            Warning.disableAllWarnings();
            if (ojcConfiguration.isShowWarnings()) {
                Warning.defaultAllWarnings();
                if (ojcConfiguration.isShowObjectDotStaticWarnings()) {
                    Warning.enableWarning((int)Message.warningStaticAccessWithObject.getNumber());
                }
                if (ojcConfiguration.isShowUnusedImportWarnings()) {
                    Warning.enableWarning((int)Message.warningUnusedImport.getNumber());
                }
                if (ojcConfiguration.isShowPartialImportWarnings()) {
                    Warning.enableWarning((int)Message.warningPartialUsedStarImport.getNumber());
                }
                if (ojcConfiguration.isShowDeprecations()) {
                    Warning.enableWarning((int)Message.warningIsDeprecated.getNumber());
                    if (ojcConfiguration.isShowSelfDeprecations()) {
                        options.selfDeprecation = true;
                    }
                }
                Warning.disableWarning((int)Message.warningCatchVarNeverUsed.getNumber());
                Warning.disableWarning((int)Message.warningDirectoryDoesntExist.getNumber());
                Warning.disableWarning((int)Message.warningDuplicateImport.getNumber());
                Warning.disableWarning((int)Message.warningEmptyCatchStatement.getNumber());
                Warning.disableWarning((int)Message.warningEmptySource.getNumber());
                Warning.disableWarning((int)Message.warningEmptyStatement.getNumber());
                Warning.disableWarning((int)Message.warningFallThrough.getNumber());
                Warning.disableWarning((int)Message.warningMethodNeverCalled.getNumber());
                Warning.disableWarning((int)Message.warningNoSerialVersionUID.getNumber());
                Warning.disableWarning((int)Message.warningOverridesDeprecated.getNumber());
                Warning.disableWarning((int)Message.warningParameterNeverUsed.getNumber());
                Warning.disableWarning((int)Message.warningSelfAssignment.getNumber());
                Warning.disableWarning((int)Message.warningSwitchWithoutCase.getNumber());
                Warning.disableWarning((int)Message.warningUncheckedConversion.getNumber());
                Warning.disableWarning((int)Message.warningUnnecessaryCast.getNumber());
                Warning.disableWarning((int)Message.warningUnterminatedFinally.getNumber());
                Warning.disableWarning((int)Message.warningVarAssignmentNeverUsed.getNumber());
                Warning.disableWarning((int)Message.warningVariableNeverUsed.getNumber());
            }
            options.targetJDKVersion = (string = ojcConfiguration.getTarget()).equals("1.1") ? 110 : (string.equals("1.2") ? 120 : (string.equals("1.3") ? 130 : (string.equals("1.4") ? 140 : 150)));
            String string3 = ojcConfiguration.getSource();
            options.sourceJDKVersion = string3.equals("1.1") ? 110 : (string3.equals("1.2") ? 120 : (string3.equals("1.3") ? 130 : (string3.equals("1.4") ? 140 : 150)));
            String[] stringArray = ojcConfiguration.getExcludedClasses();
            if (stringArray != null && stringArray.length > 0) {
                options.excludeClasses = new ArrayList(stringArray.length);
                int n6 = 0;
                while (n6 < stringArray.length) {
                    options.excludeClasses.add(stringArray[n6]);
                    ++n6;
                }
            }
            if (currentContext != null && currentContext.getProperty("CompilerGenerateClassesDespiteErrors") == Boolean.TRUE) {
                try {
                    Field field = Options.class.getField("generateClassesDespiteErrors");
                    field.setBoolean(options, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            options.encoding = ojcConfiguration.getCurrentEncoding();
            if (ojcConfiguration.isDebugInformation()) {
                options.localVariables = true;
                options.codecoach = true;
            }
            options.classpathStorage = Helpers.urlPathAndDependantPathToStorageArray(PathsConfiguration.getInstance(project2).getClassPath(), arrayList);
            URLPath uRLPath = PathsConfiguration.getInstance(project2).getSourcePath();
            Storage[] storageArray = Helpers.urlPathToStorageArray(uRLPath);
            ideStorageMap = IdeStorageMap.create(uRLPath);
            int n7 = 0;
            while (n7 < storageArray.length) {
                if (storageArray[n7] instanceof FileStorage) {
                    storageArray[n7] = new IdeStorageWrapper(storageArray[n7], ideStorageMap);
                }
                ++n7;
            }
            options.sourcepathStorage = storageArray;
            options.bootClasspathStr = "";
            file = Ojc.processOutputDirectory(project2, null);
            options.destinationDir = file.getPath();
            File file4 = Ojc.getCdiFile(project);
            options.rebuild = bl;
            if (bl && (bl2 = (Boolean)project.getTransientProperties().get("rebuild")) != null && bl2.booleanValue() && file4.exists()) {
                file4.delete();
            }
            options.makeFile = new FileStorage(file4);
            n4 = arrayList.size();
            try {
                String string4 = Integer.toString(n4);
                String string5 = Ide.getProperty((String)"OJC.BuildFragmentSize", (String)string4);
                n3 = Integer.parseInt(string5);
                if (n3 <= 0 || n3 > n4) {
                    n3 = n4;
                }
            }
            catch (Throwable throwable) {
                n3 = n4;
            }
            n2 = 0;
            n = 0;
            if (n3 == n4) break block33;
        }
        while (n4 > 0) {
            int n8;
            int n9 = n4 < n3 ? n4 : n3;
            ArrayList<Storage> arrayList3 = new ArrayList<Storage>(n9);
            int n10 = 0;
            while (n10 < n9) {
                arrayList3.add((Storage)arrayList.get(n2 + n10));
                ++n10;
            }
            n2 += n9;
            n4 -= n9;
            if (options.noquiet) {
                String string = this.buildOjcCmdLine(project2, options, arrayList3, bl);
                oracle.ide.compiler.Compiler.getCompiler().logOutMsg(string + "\n");
            }
            if ((n8 = Compiler.main(arrayList3, (Options)options)) == 4) {
                if (n > 3 || n3 < 2) {
                    log.error(null, 0, 0, 0, CompArb.getString(89));
                    continue;
                }
                n2 -= n9;
                n4 += n9;
                project.setProperty("OJC.BuildFragmentSize", Integer.toString(n3 /= 2));
                ++n;
                continue;
            }
            if (n8 < 2) continue;
            log.error(null, 0, 0, 0, n8 == 3 ? CompArb.getString(83) : CompArb.getString(45));
        }
        if (ideStorageMap != null) {
            ideStorageMap.destroy();
        }
        redefineMap.redefineClassMap(project);
        this.addSMAPs(arrayList, file.getPath());
        return 0;
    }

    public void initialize() {
        JCompiler.getInstance().registerTranslator(this);
    }

    static void mav$logMessage(Ojc ojc, Translator.Log log, Storage storage, int n, int n2, String string, boolean bl) {
        ojc.logMessage(log, storage, n, n2, string, bl);
    }

    static Translator.Log ra$_log(Ojc ojc) {
        return ojc._log;
    }

    public class 1JavacLogInfo
    extends AbstractLogPage {
        final StringBuffer sb;
        final String outPath;
        final SimpleProcess javacProcess;
        int logLine;
        private final Pattern javacErrorPattern;
        private final Pattern javacOutFilePattern;
        private final Pattern javacParsingFilePattern;
        private final /* synthetic */ HashMap v$sourceMapFiles;
        private final /* synthetic */ Translator.Log v$log;
        private final /* synthetic */ RedefineMap v$rm;
        final /* synthetic */ Ojc this$0;

        1JavacLogInfo(Ojc ojc, String string, SimpleProcess simpleProcess, HashMap hashMap, Translator.Log log, RedefineMap redefineMap) {
            this.v$rm = redefineMap;
            this.v$log = log;
            this.v$sourceMapFiles = hashMap;
            this.this$0 = ojc;
            super(new ViewId("BuildSystemJavacBufferPage", "BuildSystemJavacBufferPage"), null, false);
            this.$init$();
            this.sb = new StringBuffer(1024);
            this.logLine = 0;
            this.outPath = string;
            this.javacProcess = simpleProcess;
        }

        void $init$() {
            this.javacErrorPattern = Pattern.compile("^(.*):([0-9]+):(.*)$");
            this.javacOutFilePattern = Pattern.compile("^\\[wrote (.*\\.class)\\]$");
            this.javacParsingFilePattern = Pattern.compile("^\\[parsing started (.*\\.java)\\]$");
        }

        private Storage getSourceFile(String string) {
            Storage storage = (Storage)this.v$sourceMapFiles.get(string);
            if (storage == null) {
                storage = new FileStorage(new File(string));
            }
            return storage;
        }

        public void log(Object object) {
            String string;
            this.sb.append(object.toString());
            while ((string = this.getLine(this.sb)) != null) {
                Matcher matcher;
                String string2;
                this.checkForTermination();
                if (++this.logLine == 1) {
                    if (!Ide.getEnvironOptions().getSaveBeforeCompile()) {
                        this.v$log.error(null, 0, 0, 0, CompArb.getString(82));
                    }
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)(string + "\n"));
                    continue;
                }
                if (string.endsWith(" cannot find symbol") && (string2 = this.getLine(this.sb)) != null && string2.startsWith("symbol  : ")) {
                    string = string.substring(0, string.lastIndexOf("symbol")) + string2.substring(10);
                }
                if ((matcher = this.javacErrorPattern.matcher(string)).matches()) {
                    int n;
                    try {
                        n = Integer.parseInt(matcher.group(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                    String string3 = matcher.group(3);
                    boolean bl = string3.startsWith(" warning:") ^ true;
                    Ojc.mav$logMessage(this.this$0, this.v$log, this.getSourceFile(matcher.group(1)), Scanner.lineColumnToPosition((int)n, (int)0), 0, bl ? string3 : string3.substring(9), bl);
                    continue;
                }
                matcher = this.javacOutFilePattern.matcher(string);
                if (matcher.matches()) {
                    String string4 = matcher.group(1);
                    this.v$rm.redefineClass(string4, this.outPath, this.v$log);
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)("  writing " + string4 + "\n"));
                    continue;
                }
                matcher = this.javacParsingFilePattern.matcher(string);
                if (matcher.matches()) {
                    String string5 = matcher.group(1);
                    Storage storage = this.getSourceFile(string5);
                    UnifiedBuildSystem.getInstance().markTranslated(storage);
                    this.v$log.clear(storage);
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    if (string5 != null) {
                        string5 = string5.replace('/', File.separatorChar);
                    }
                    JCompiler.getInstance().getOutputLog().log((Object)("  compiling " + string5 + "\n"));
                    continue;
                }
                if (!string.startsWith("javac:")) continue;
                this.v$log.error(null, 0, 0, 0, string);
            }
            this.checkForTermination();
        }

        private String getLine(StringBuffer stringBuffer) {
            int n = stringBuffer.indexOf("\n");
            if (n >= 0) {
                int n2 = n;
                char c = stringBuffer.charAt(n2);
                while (n2 >= 0 && (c == '\r' || c == '\n')) {
                    if (--n2 < 0) continue;
                    c = stringBuffer.charAt(n2);
                }
                String string = stringBuffer.substring(0, n2 + 1);
                stringBuffer.delete(0, n + 1);
                return string;
            }
            return null;
        }

        private void checkForTermination() {
            if (Thread.currentThread().isInterrupted()) {
                new 1().start();
            }
        }

        public Component getGUI() {
            return null;
        }

        protected void requestShow() {
        }

        public void show() {
        }

        public boolean isVisible() {
            return true;
        }

        public final class 1
        extends Thread {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SimpleProcess simpleProcess = 1JavacLogInfo.this.javacProcess;
                synchronized (simpleProcess) {
                    if (1JavacLogInfo.this.javacProcess != null) {
                        1JavacLogInfo.this.javacProcess.getRunProcess().terminate();
                    }
                }
            }
        }
    }

    public class 1Ojc2LogInfo
    extends AbstractLogPage {
        final SimpleProcess ojc2Process;
        final String outPath;
        final StringBuffer sb;
        int logLine;
        private final Pattern ojc2ErrorPattern;
        private final Pattern ojc2ErrorTagPattern;
        private final Pattern ojc2OutFilePattern;
        private final Pattern ojc2ParsingFilePattern;
        private final /* synthetic */ HashMap v$sourceMapFiles;
        private final /* synthetic */ Translator.Log v$log;
        private final /* synthetic */ RedefineMap v$rm;
        final /* synthetic */ Ojc this$0;

        1Ojc2LogInfo(Ojc ojc, String string, SimpleProcess simpleProcess, HashMap hashMap, Translator.Log log, RedefineMap redefineMap) {
            this.v$rm = redefineMap;
            this.v$log = log;
            this.v$sourceMapFiles = hashMap;
            this.this$0 = ojc;
            super(new ViewId("BuildSystemOjc2BufferPage", "BuildSystemOjc2BufferPage"), null, false);
            this.$init$();
            this.sb = new StringBuffer(1024);
            this.logLine = 0;
            this.outPath = string;
            this.ojc2Process = simpleProcess;
        }

        void $init$() {
            this.ojc2ErrorPattern = Pattern.compile("^(.*):([0-9]+):(.*)$");
            this.ojc2ErrorTagPattern = Pattern.compile("^ (\\Qerror\\E|\\Qwarning\\E) #[0-9]+:(.*)$");
            this.ojc2OutFilePattern = Pattern.compile("^\\[writing (.*\\.class) [0-9]+ms \\]$");
            this.ojc2ParsingFilePattern = Pattern.compile("^\\[parsing (.*\\.java) [0-9]+ms \\]$");
        }

        private Storage getSourceFile(String string) {
            Storage storage = (Storage)this.v$sourceMapFiles.get(string);
            if (storage == null) {
                storage = new FileStorage(new File(string));
            }
            return storage;
        }

        public void log(Object object) {
            String string;
            this.sb.append(object.toString());
            while ((string = this.getLine(this.sb)) != null) {
                this.checkForTermination();
                if (++this.logLine == 1) {
                    if (!Ide.getEnvironOptions().getSaveBeforeCompile()) {
                        this.v$log.error(null, 0, 0, 0, CompArb.getString(82));
                    }
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)(string + "\n"));
                    continue;
                }
                Matcher matcher = this.ojc2ErrorPattern.matcher(string);
                if (matcher.matches()) {
                    String string2;
                    int n;
                    Storage storage = this.getSourceFile(matcher.group(1));
                    try {
                        n = Integer.parseInt(matcher.group(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                    String string3 = matcher.group(3);
                    matcher = this.ojc2ErrorTagPattern.matcher(string3);
                    boolean bl = false;
                    if (matcher.matches()) {
                        string2 = matcher.group(2);
                        bl = matcher.group(1).charAt(0) != 'w';
                    } else {
                        string2 = "unrecognized ojc2 error/warning message <" + string3 + ">";
                    }
                    Ojc.mav$logMessage(this.this$0, this.v$log, storage, Scanner.lineColumnToPosition((int)n, (int)0), 0, string2, bl);
                    continue;
                }
                matcher = this.ojc2OutFilePattern.matcher(string);
                if (matcher.matches()) {
                    String string4 = matcher.group(1);
                    this.v$rm.redefineClass(string4, this.outPath, this.v$log);
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)("  writing " + string4 + "\n"));
                    continue;
                }
                matcher = this.ojc2ParsingFilePattern.matcher(string);
                if (matcher.matches()) {
                    Storage storage = this.getSourceFile(matcher.group(1));
                    UnifiedBuildSystem.getInstance().markTranslated(storage);
                    this.v$log.clear(storage);
                    if (!UnifiedBuildSystem.showCompileProgress) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)("  compiling " + matcher.group(1) + "\n"));
                    continue;
                }
                System.out.println("ojc2 output: " + string);
            }
            this.checkForTermination();
        }

        private String getLine(StringBuffer stringBuffer) {
            int n = stringBuffer.indexOf("\n");
            if (n >= 0) {
                int n2 = n;
                char c = stringBuffer.charAt(n2);
                while (n2 >= 0 && (c == '\r' || c == '\n')) {
                    if (--n2 < 0) continue;
                    c = stringBuffer.charAt(n2);
                }
                String string = stringBuffer.substring(0, n2 + 1);
                stringBuffer.delete(0, n + 1);
                return string;
            }
            return null;
        }

        private void checkForTermination() {
            if (Thread.currentThread().isInterrupted()) {
                new 1().start();
            }
        }

        public Component getGUI() {
            return null;
        }

        protected void requestShow() {
        }

        public void show() {
        }

        public boolean isVisible() {
            return true;
        }

        public final class 1
        extends Thread {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SimpleProcess simpleProcess = 1Ojc2LogInfo.this.ojc2Process;
                synchronized (simpleProcess) {
                    if (1Ojc2LogInfo.this.ojc2Process != null) {
                        1Ojc2LogInfo.this.ojc2Process.getRunProcess().terminate();
                    }
                }
            }
        }
    }

    public final class 2
    implements IdeEnv {
        private final /* synthetic */ Translator.Log v$log;
        private final /* synthetic */ RedefineMap v$rm;
        final /* synthetic */ Ojc this$0;

        public boolean authorizeParsing(Storage storage, String string) {
            this.v$log.clear(storage);
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            UnifiedBuildSystem.getInstance().markTranslated(storage);
            return true;
        }

        public boolean authorizeChecking(Storage storage, String string) {
            return !Thread.currentThread().isInterrupted();
        }

        public boolean authorizeWriting(Storage storage, String string, byte[] byArray, int n, int n2) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            this.v$rm.redefineClass(storage, string, byArray, n2, Ojc.ra$_log(this.this$0));
            return true;
        }

        public 2(Ojc ojc, Translator.Log log, RedefineMap redefineMap) {
            this.v$rm = redefineMap;
            this.v$log = log;
            this.this$0 = ojc;
        }
    }

    public final class 1
    implements Log {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final /* synthetic */ Options v$options;
        private final /* synthetic */ Translator.Log v$log;
        final /* synthetic */ Ojc this$0;

        static {
            $assertionsDisabled = 1.class.desiredAssertionStatus() ^ true;
        }

        public void redirect(String string) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void print(String string) {
            if (this.v$options.noquiet) {
                oracle.ide.compiler.Compiler.getCompiler().logOutMsg(string);
            }
        }

        public void println(String string) {
            if (this.v$options.noquiet) {
                if (string.startsWith("[compiling ") && string.endsWith("]")) {
                    string = "  " + string.substring(1, string.length() - 1);
                }
                oracle.ide.compiler.Compiler.getCompiler().logOutMsg(string + "\n");
            }
        }

        public void printError(Storage storage, int n, ErrorInfo errorInfo) {
            Ojc.mav$logMessage(this.this$0, this.v$log, storage, n + 1, errorInfo.getNumber(), errorInfo.getMessage(), true);
        }

        public void printWarning(Storage storage, int n, ErrorInfo errorInfo) {
            Ojc.mav$logMessage(this.this$0, this.v$log, storage, n + 1, errorInfo.getNumber(), errorInfo.getMessage(), false);
        }

        public int nerrors() {
            return this.v$log.nerrors();
        }

        public int nwarnings() {
            return this.v$log.nwarnings();
        }

        public 1(Ojc ojc, Options options, Translator.Log log) {
            this.v$log = log;
            this.v$options = options;
            this.this$0 = ojc;
        }
    }
}

