/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.model.Project;
import oracle.ide.util.Encodings;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.compiler.OjcConfigurationConstants;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;

public class OjcConfiguration
extends HashStructureAdapter
implements OjcConfigurationConstants {
    public static final String DATA_KEY = OjcConfiguration.class.getName();
    public static final String DEFAULT_TARGET = "Default";
    private static final String[] DEFAULT_TARGETS = new String[]{"Default", "1.1", "1.2", "1.3", "1.4", "1.5"};
    public static final String DEFAULT_SOURCE = "Default";
    private static final String JDK15_SOURCE = "1.5";
    private static final String[] DEFAULT_SOURCES = new String[]{"Default", "1.2", "1.3", "1.4", "1.5"};
    public static final String DEFAULT_ENCODING = "Default";
    private PropertyStorage project;

    private OjcConfiguration(HashStructure hashStructure, PropertyStorage propertyStorage) {
        super(hashStructure);
        this.project = propertyStorage;
    }

    public static OjcConfiguration getInstance(PropertyStorage propertyStorage) {
        return new OjcConfiguration(OjcConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY), propertyStorage);
    }

    public static OjcConfiguration getOjcConfiguration(Project project, String string) {
        return OjcConfiguration.getInstance((PropertyStorage)project);
    }

    public boolean isDebugInformation() {
        return this._hash.getBoolean("debugInformation", true);
    }

    public void setDebugInformation(boolean bl) {
        this._hash.putBoolean("debugInformation", bl);
    }

    private String getJdkVersion() {
        JDK jDK;
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance(this.project);
        if (jProjectLibraries != null && (jDK = jProjectLibraries.getJDK()) != null) {
            return jDK.getJavaVersion().toString();
        }
        return "";
    }

    public boolean isJDK15() {
        return this.getJdkVersion().compareTo(JDK15_SOURCE) >= 0;
    }

    public boolean isUseJavac() {
        return this._hash.getBoolean("useJavac", false);
    }

    public void setUseJavac(boolean bl) {
        this._hash.putBoolean("useJavac", bl);
    }

    public boolean isShowWarnings() {
        return this._hash.getBoolean("showWarnings", true);
    }

    public void setShowWarnings(boolean bl) {
        this._hash.putBoolean("showWarnings", bl);
    }

    public boolean isShowUnusedImportWarnings() {
        return this._hash.getBoolean("showUnusedImportWarnings", false);
    }

    public void setShowUnusedImportWarnings(boolean bl) {
        this._hash.putBoolean("showUnusedImportWarnings", bl);
    }

    public boolean isShowPartialImportWarnings() {
        return this._hash.getBoolean("showPartialImportWarnings", false);
    }

    public void setShowPartialImportWarnings(boolean bl) {
        this._hash.putBoolean("showPartialImportWarnings", bl);
    }

    public boolean isShowObjectDotStaticWarnings() {
        return this._hash.getBoolean("showObjectDotStaticWarnings", false);
    }

    public void setShowObjectDotStaticWarnings(boolean bl) {
        this._hash.putBoolean("showObjectDotStaticWarnings", bl);
    }

    public boolean isShowDeprecations() {
        return this._hash.getBoolean("showDeprecations", true);
    }

    public void setShowDeprecations(boolean bl) {
        this._hash.putBoolean("showDeprecations", bl);
    }

    public boolean isShowSelfDeprecations() {
        return this._hash.getBoolean("showSelfDeprecations", true);
    }

    public void setShowSelfDeprecations(boolean bl) {
        this._hash.putBoolean("showSelfDeprecations", bl);
    }

    public String[] getExcludedClasses() {
        ListStructure listStructure = this._hash.getListStructure("excludedClasses");
        return listStructure != null ? (String[])listStructure.toArray((Object[])new String[listStructure.size()]) : null;
    }

    public void setExcludedClasses(String[] stringArray) {
        if (stringArray == null) {
            this._hash.remove("excludedClasses");
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure("excludedClasses");
            listStructure.mirror(Arrays.asList(stringArray));
        }
    }

    public String[] getTargets() {
        String string = this.getJdkVersion();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DEFAULT_TARGETS[0]);
        int n = 1;
        while (n < DEFAULT_TARGETS.length) {
            if (DEFAULT_TARGETS[n].compareTo(string) <= 0) {
                arrayList.add(DEFAULT_TARGETS[n]);
            }
            ++n;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public String getTargetString() {
        String string = "Default";
        return this._hash.getString("target", "Default");
    }

    public String getTarget() {
        String string = this.getTargetString();
        String string2 = this.getJdkVersion().substring(0, 3);
        if (string.equals("Default")) {
            string = string2.compareTo(JDK15_SOURCE) >= 0 ? string2 : (string2.compareTo("1.2") >= 0 ? "1.2" : "1.1");
        } else if (string.substring(0, 3).compareTo(string2) > 0) {
            string = string2;
        }
        return string;
    }

    public void setTarget(String string) {
        if (string != null) {
            this._hash.putString("target", string);
        }
    }

    public String[] getSources() {
        String string = this.getJdkVersion();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DEFAULT_SOURCES[0]);
        int n = 1;
        while (n < DEFAULT_SOURCES.length) {
            if (DEFAULT_SOURCES[n].compareTo(string) <= 0) {
                arrayList.add(DEFAULT_SOURCES[n]);
            }
            ++n;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public String getSourceString() {
        String string = "Default";
        return this._hash.getString("source", "Default");
    }

    public String getSource() {
        String string = this.getSourceString();
        String string2 = this.getJdkVersion().substring(0, 3);
        if (string.equals("Default")) {
            string = string2.compareTo(JDK15_SOURCE) >= 0 ? string2 : (string2.compareTo("1.4") == 0 ? "1.3" : string2);
        } else if (string.substring(0, 3).compareTo(string2) > 0) {
            string = string2;
        }
        return string;
    }

    public void setSource(String string) {
        if (string != null) {
            this._hash.putString("source", string);
        }
    }

    public String[] getCopyRes() {
        ListStructure listStructure = this._hash.getListStructure("copyRes");
        if (listStructure == null) {
            listStructure = this._hash.getOrCreateListStructure("copyRes");
            this.initDefaultCopyRes(listStructure);
        }
        return (String[])listStructure.toArray((Object[])new String[listStructure.size()]);
    }

    public void setCopyRes(String[] stringArray) {
        if (stringArray == null) {
            this._hash.remove("copyRes");
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure("copyRes");
            listStructure.mirror(Arrays.asList(stringArray));
        }
    }

    private void initDefaultCopyRes(ListStructure listStructure) {
        String[] stringArray = GraphicsUtils.getImageExtensions();
        int n = 0;
        while (n < stringArray.length) {
            listStructure.addPlaceholder((Object)stringArray[n]);
            ++n;
        }
        listStructure.addPlaceholder((Object)".properties");
        listStructure.addPlaceholder((Object)".xml");
        listStructure.addPlaceholder((Object)"-apf.xml");
        listStructure.addPlaceholder((Object)".ejx");
        listStructure.addPlaceholder((Object)".xcfg");
        listStructure.addPlaceholder((Object)".cpx");
        listStructure.addPlaceholder((Object)".dcx");
        listStructure.addPlaceholder((Object)".wsdl");
        listStructure.addPlaceholder((Object)".ini");
        listStructure.addPlaceholder((Object)".tld");
        listStructure.addPlaceholder((Object)".tag");
    }

    public boolean getReverseCopyRes() {
        return this._hash.getBoolean("reverseCopyRes", false);
    }

    public void setReverseCopyRes(boolean bl) {
        this._hash.putBoolean("reverseCopyRes", bl);
    }

    public String getCurrentEncoding() throws TransientMarker {
        String string = this.getInternalEncoding();
        return string == null || "Default".equals(string) ? Encodings.getDefaultEncoding() : string;
    }

    public void setCurrentEncoding(String string) {
        if (string == null) {
            string = "Default";
        }
        this.setInternalEncoding(string);
    }

    String getInternalEncoding() {
        return this._hash.getString("internalEncoding", "Default");
    }

    void setInternalEncoding(String string) {
        this._hash.putString("internalEncoding", string);
    }
}

