/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Encodings;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.OjcConfiguration;

public class OjcConfigurationPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    JCheckBox debugInfoCheckBox;
    JCheckBox showWarningsCheckBox;
    JCheckBox showUnusedImportWarningsCheckBox;
    JCheckBox showPartialImportWarningsCheckBox;
    JCheckBox showObjectDotStaticWarningsCheckBox;
    JCheckBox showDeprecationsCheckBox;
    JCheckBox showSelfDeprecationsCheckBox;
    JCheckBox useJavacCheckBox;
    JLabel excludeClassesLabel;
    JTextField excludedClassesTextField;
    JLabel copyResLabel;
    JTextField copyResTextField;
    JCheckBox reverseCopyResCheckBox;
    JLabel encodingLabel;
    JComboBox encodingComboBox;
    JLabel targetLabel;
    JComboBox targetComboBox;
    JLabel sourceLabel;
    JComboBox sourceComboBox;
    GridBagLayout gridBagLayout1;
    JPanel jPanel1;
    GridBagLayout gridBagLayout2;
    ItemSelectableTracker deprecationTracker;
    ItemSelectableTracker warningTracker;
    private String previousEncoding;
    private static final String[] PROPERTY_KEYS = new String[]{"showWarnings", "showUnusedImportWarnings", "showPartialImportWarnings", "showObjectDotStaticWarnings", "showDeprecations", "showSelfDeprecations", "debugInformation", "useJavac", "source", "target", "internalEncoding", "excludedClasses", "copyRes", "reverseCopyRes"};

    void $init$() {
        this.debugInfoCheckBox = new JCheckBox();
        this.showWarningsCheckBox = new JCheckBox();
        this.showUnusedImportWarningsCheckBox = new JCheckBox();
        this.showPartialImportWarningsCheckBox = new JCheckBox();
        this.showObjectDotStaticWarningsCheckBox = new JCheckBox();
        this.showDeprecationsCheckBox = new JCheckBox();
        this.showSelfDeprecationsCheckBox = new JCheckBox();
        this.useJavacCheckBox = new JCheckBox();
        this.excludeClassesLabel = new JLabel();
        this.excludedClassesTextField = new JTextField();
        this.copyResLabel = new JLabel();
        this.copyResTextField = new JTextField();
        this.reverseCopyResCheckBox = new JCheckBox();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox<String>(new String[0]);
        this.targetLabel = new JLabel();
        this.targetComboBox = new JComboBox<String>(new String[0]);
        this.sourceLabel = new JLabel();
        this.sourceComboBox = new JComboBox<String>(new String[0]);
        this.gridBagLayout1 = new GridBagLayout();
        this.jPanel1 = new JPanel();
        this.gridBagLayout2 = new GridBagLayout();
        this.deprecationTracker = new ItemSelectableTracker((ItemSelectable)this.showDeprecationsCheckBox, new Component[]{this.showSelfDeprecationsCheckBox});
        this.warningTracker = new ItemSelectableTracker((ItemSelectable)this.showWarningsCheckBox, new Component[]{this.showUnusedImportWarningsCheckBox, this.showPartialImportWarningsCheckBox, this.showObjectDotStaticWarningsCheckBox}, new ItemSelectableTracker[]{this.deprecationTracker});
        this.previousEncoding = null;
    }

    public OjcConfigurationPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getDataKey() {
        return OjcConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        if (traversableContext != null && OjcConfigurationPanel.isDefaultProject((Namespace)traversableContext)) {
            this.setHelpID("f1_com_proset_compilerdpp_html");
        } else {
            this.setHelpID("f1_com_proset_compiler_html");
        }
        OjcConfiguration ojcConfiguration = OjcConfigurationPanel.getOjcConfiguration(traversableContext);
        this.loadFrom(ojcConfiguration);
    }

    public void onExit(TraversableContext traversableContext) {
        OjcConfiguration ojcConfiguration = OjcConfigurationPanel.getOjcConfiguration(traversableContext);
        this.commitTo(ojcConfiguration);
    }

    private static OjcConfiguration getOjcConfiguration(TraversableContext traversableContext) {
        PropertyStorage propertyStorage = OjcConfigurationPanel.getPropertyData((Namespace)traversableContext);
        return OjcConfiguration.getInstance(propertyStorage);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.showDeprecationsCheckBox || object == this.showWarningsCheckBox) {
            if (this.useJavacCheckBox.isSelected()) {
                this.showUnusedImportWarningsCheckBox.setEnabled(false);
                this.showPartialImportWarningsCheckBox.setEnabled(false);
                this.showObjectDotStaticWarningsCheckBox.setEnabled(false);
                this.showSelfDeprecationsCheckBox.setEnabled(false);
            }
        } else if (object == this.targetComboBox) {
            String string;
            String string2 = (String)this.targetComboBox.getSelectedItem();
            if (string2 != null && (string = (String)this.sourceComboBox.getSelectedItem()) != null && (string2.equals("Default") || !string.equals("Default") && string.compareTo(string2) > 0 && string.compareTo("1.4") >= 0)) {
                string2 = string;
                this.targetComboBox.setSelectedItem(string2);
            }
        } else if (object == this.sourceComboBox) {
            String string;
            String string3 = (String)this.sourceComboBox.getSelectedItem();
            if (string3 != null && (string = (String)this.targetComboBox.getSelectedItem()) != null && (string.equals("Default") || !string3.equals("Default") && string3.compareTo(string) > 0 && string3.compareTo("1.4") >= 0)) {
                string = string3;
                this.targetComboBox.setSelectedItem(string);
            }
        } else if (object == this.useJavacCheckBox) {
            this.actionPerformed_useJavacCheckBox();
        }
    }

    private String toStringList(String[] stringArray) {
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]).append(";");
                ++n;
            }
            if (stringArray.length > 0) {
                int n2 = stringBuffer.length() - 1;
                stringBuffer.deleteCharAt(n2);
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private void populateComboBox(JComboBox jComboBox, String[] stringArray, String string) {
        jComboBox.removeAllItems();
        int n = 0;
        while (n < stringArray.length) {
            jComboBox.addItem(stringArray[n]);
            ++n;
        }
        jComboBox.setSelectedItem(string);
    }

    private void loadFrom(OjcConfiguration ojcConfiguration) {
        this.populateComboBox(this.targetComboBox, ojcConfiguration.getTargets(), ojcConfiguration.getTargetString());
        this.populateComboBox(this.sourceComboBox, ojcConfiguration.getSources(), ojcConfiguration.getSourceString());
        this.debugInfoCheckBox.setSelected(ojcConfiguration.isDebugInformation());
        this.showWarningsCheckBox.setSelected(ojcConfiguration.isShowWarnings());
        this.showUnusedImportWarningsCheckBox.setSelected(ojcConfiguration.isShowUnusedImportWarnings());
        this.showPartialImportWarningsCheckBox.setSelected(ojcConfiguration.isShowPartialImportWarnings());
        this.showObjectDotStaticWarningsCheckBox.setSelected(ojcConfiguration.isShowObjectDotStaticWarnings());
        this.showDeprecationsCheckBox.setSelected(ojcConfiguration.isShowDeprecations());
        this.showSelfDeprecationsCheckBox.setSelected(ojcConfiguration.isShowSelfDeprecations());
        this.showSelfDeprecationsCheckBox.setEnabled(ojcConfiguration.isShowWarnings() && ojcConfiguration.isShowDeprecations());
        this.useJavacCheckBox.setSelected(ojcConfiguration.isUseJavac());
        this.excludedClassesTextField.setText(this.toStringList(ojcConfiguration.getExcludedClasses()));
        this.copyResTextField.setText(this.toStringList(ojcConfiguration.getCopyRes()));
        this.reverseCopyResCheckBox.setSelected(ojcConfiguration.getReverseCopyRes());
        String string = ojcConfiguration.getInternalEncoding();
        Encodings.initComboBox((JComboBox)this.encodingComboBox, (boolean)true, (String)string);
        this.actionPerformed_useJavacCheckBox();
    }

    private String[] toStringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private void commitTo(OjcConfiguration ojcConfiguration) {
        ojcConfiguration.setTarget((String)this.targetComboBox.getSelectedItem());
        ojcConfiguration.setSource((String)this.sourceComboBox.getSelectedItem());
        ojcConfiguration.setDebugInformation(this.debugInfoCheckBox.isSelected());
        ojcConfiguration.setShowWarnings(this.showWarningsCheckBox.isSelected());
        ojcConfiguration.setShowUnusedImportWarnings(this.showUnusedImportWarningsCheckBox.isSelected());
        ojcConfiguration.setShowPartialImportWarnings(this.showPartialImportWarningsCheckBox.isSelected());
        ojcConfiguration.setShowObjectDotStaticWarnings(this.showObjectDotStaticWarningsCheckBox.isSelected());
        ojcConfiguration.setShowDeprecations(this.showDeprecationsCheckBox.isSelected());
        ojcConfiguration.setShowSelfDeprecations(this.showSelfDeprecationsCheckBox.isSelected());
        ojcConfiguration.setUseJavac(this.useJavacCheckBox.isSelected());
        ojcConfiguration.setExcludedClasses(this.toStringArray(this.excludedClassesTextField.getText()));
        ojcConfiguration.setCopyRes(this.toStringArray(this.copyResTextField.getText()));
        ojcConfiguration.setReverseCopyRes(this.reverseCopyResCheckBox.isSelected());
        if (Boolean.TRUE.equals(this.encodingComboBox.getClientProperty("encodings-loaded"))) {
            String string = (String)this.encodingComboBox.getSelectedItem();
            ojcConfiguration.setInternalEncoding("Default".equals(string) ? "Default" : string);
        }
    }

    private void actionPerformed_useJavacCheckBox() {
        this.showUnusedImportWarningsCheckBox.setEnabled(this.useJavacCheckBox.isSelected() ^ true);
        this.showPartialImportWarningsCheckBox.setEnabled(this.useJavacCheckBox.isSelected() ^ true);
        this.showObjectDotStaticWarningsCheckBox.setEnabled(this.useJavacCheckBox.isSelected() ^ true);
        this.showSelfDeprecationsCheckBox.setEnabled(this.useJavacCheckBox.isSelected() ^ true);
        this.excludeClassesLabel.setEnabled(this.useJavacCheckBox.isSelected() ^ true);
        this.excludedClassesTextField.setEnabled(this.useJavacCheckBox.isSelected() ^ true);
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.debugInfoCheckBox, (String)CompArb.getString(47));
        ResourceUtils.resButton((AbstractButton)this.showWarningsCheckBox, (String)CompArb.getString(48));
        ResourceUtils.resButton((AbstractButton)this.showUnusedImportWarningsCheckBox, (String)CompArb.getString(49));
        ResourceUtils.resButton((AbstractButton)this.showPartialImportWarningsCheckBox, (String)CompArb.getString(50));
        ResourceUtils.resButton((AbstractButton)this.showObjectDotStaticWarningsCheckBox, (String)CompArb.getString(53));
        ResourceUtils.resButton((AbstractButton)this.showDeprecationsCheckBox, (String)CompArb.getString(51));
        ResourceUtils.resButton((AbstractButton)this.showSelfDeprecationsCheckBox, (String)CompArb.getString(52));
        ResourceUtils.resButton((AbstractButton)this.useJavacCheckBox, (String)CompArb.getString(55));
        ResourceUtils.resLabel((JLabel)this.excludeClassesLabel, (Component)this.excludedClassesTextField, (String)CompArb.getString(56));
        ResourceUtils.resLabel((JLabel)this.copyResLabel, (Component)this.copyResTextField, (String)CompArb.getString(60));
        ResourceUtils.resButton((AbstractButton)this.reverseCopyResCheckBox, (String)CompArb.getString(61));
        ResourceUtils.resLabel((JLabel)this.encodingLabel, (Component)this.encodingComboBox, (String)CompArb.getString(57));
        ResourceUtils.resLabel((JLabel)this.targetLabel, (Component)this.targetComboBox, (String)CompArb.getString(62));
        ResourceUtils.resLabel((JLabel)this.sourceLabel, (Component)this.sourceComboBox, (String)CompArb.getString(63));
        int n = -1;
        int n2 = 18;
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel1.add((Component)this.showWarningsCheckBox, new GridBagConstraints2(0, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 1, 0));
        this.jPanel1.add((Component)this.showUnusedImportWarningsCheckBox, new GridBagConstraints2(0, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, n2, 0, 20), 1, 0));
        this.jPanel1.add((Component)this.showPartialImportWarningsCheckBox, new GridBagConstraints2(0, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, n2, 0, 20), 1, 0));
        this.jPanel1.add((Component)this.showObjectDotStaticWarningsCheckBox, new GridBagConstraints2(0, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, n2, 0, 20), 1, 0));
        this.jPanel1.add((Component)this.debugInfoCheckBox, new GridBagConstraints2(2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 1, 0));
        this.jPanel1.add((Component)this.useJavacCheckBox, new GridBagConstraints2(2, n, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 1, 0));
        this.jPanel1.add((Component)this.showDeprecationsCheckBox, new GridBagConstraints2(0, n, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, n2, 0, 20), 1, 0));
        this.jPanel1.add((Component)this.showSelfDeprecationsCheckBox, new GridBagConstraints2(0, n, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, n2 * 2, 0, 20), 1, 0));
        this.jPanel1.add((Component)this.sourceLabel, new GridBagConstraints2(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.sourceComboBox, new GridBagConstraints2(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 5, 0, 0), 10, 0));
        this.jPanel1.add((Component)this.targetLabel, new GridBagConstraints2(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.targetComboBox, new GridBagConstraints2(3, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 5, 0, 0), 10, 0));
        this.setLayout(this.gridBagLayout1);
        this.add(this.jPanel1, new GridBagConstraints2(0, n, 5, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 8, 0), 0, 0));
        this.add(this.encodingLabel, new GridBagConstraints2(0, n, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.encodingComboBox, new GridBagConstraints2(0, n, 4, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 8, 0), 0, 0));
        this.add(this.excludeClassesLabel, new GridBagConstraints2(0, n, 5, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.excludedClassesTextField, new GridBagConstraints2(0, n, 5, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 6, 0), 0, 0));
        this.add(this.copyResLabel, new GridBagConstraints2(0, n, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.reverseCopyResCheckBox, new GridBagConstraints2(3, n, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.copyResTextField, new GridBagConstraints2(0, n, 5, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.targetComboBox.addActionListener(this);
        this.sourceComboBox.addActionListener(this);
        this.useJavacCheckBox.addActionListener(this);
        this.showDeprecationsCheckBox.addActionListener(this);
        this.showWarningsCheckBox.addActionListener(this);
    }
}

