/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PatchClassFile {
    public static void addSMAP(File file, String string) throws IOException, ClassFormatError {
        if (!file.getName().endsWith(".class")) {
            throw new ClassFormatError();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        try {
            byArray = PatchClassFile.patchClass(byArray, string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ClassFormatError();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    private static byte[] patchClass(byte[] byArray, String string) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + string.length() + 1 + 2 + 20 + 2 + 4];
        int n2 = 0;
        int n3 = 0;
        System.arraycopy(byArray, n2, byArray2, n3, 8);
        int n4 = PatchClassFile.getChar(byArray, n2 += 8);
        int n5 = n3 += 8;
        byArray2[n3++] = byArray[n2++];
        byArray2[n3++] = byArray[n2++];
        int n6 = 0;
        int n7 = 1;
        while (n7 < n4) {
            byArray2[n3++] = byArray[n2];
            switch (byArray[n2++]) {
                case 1: 
                case 2: {
                    char c = PatchClassFile.getChar(byArray, n2);
                    System.arraycopy(byArray, n2, byArray2, n3, 2 + c);
                    n2 += 2;
                    if (c == '\u0014' && n6 == 0) {
                        boolean bl = true;
                        int n8 = 0;
                        while (n8 < 20) {
                            if (byArray[n2 + n8] != "SourceDebugExtension".charAt(n8)) {
                                bl = false;
                                break;
                            }
                            ++n8;
                        }
                        if (bl) {
                            n6 = n7;
                        }
                    }
                    n2 += c;
                    n3 += c + 2;
                    break;
                }
                case 5: 
                case 6: {
                    ++n7;
                    int n9 = 0;
                    while (n9 < 4) {
                        byArray2[n3++] = byArray[n2++];
                        ++n9;
                    }
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    byArray2[n3++] = byArray[n2++];
                    byArray2[n3++] = byArray[n2++];
                }
                case 7: 
                case 8: {
                    byArray2[n3++] = byArray[n2++];
                    byArray2[n3++] = byArray[n2++];
                    break;
                }
                default: {
                    throw new ClassFormatError();
                }
            }
            ++n7;
        }
        if (n6 == 0) {
            byArray2[n3++] = 1;
            n3 = PatchClassFile.writeChar(20, byArray2, n3);
            int n10 = 0;
            while (n10 < 20) {
                byArray2[n3++] = (byte)"SourceDebugExtension".charAt(n10);
                ++n10;
            }
            n6 = n4++;
            PatchClassFile.writeChar(n4, byArray2, n5);
        }
        System.arraycopy(byArray, n2, byArray2, n3, 6);
        n3 += 6;
        int n11 = n2 += 6;
        n4 = PatchClassFile.getChar(byArray, n2);
        n2 += 2 + n4 * 2;
        int n12 = 0;
        while (n12 < 2) {
            n4 = PatchClassFile.getChar(byArray, n2);
            n2 += 2;
            int n13 = 0;
            while (n13 < n4) {
                int n14 = PatchClassFile.getChar(byArray, n2 += 6);
                n2 += 2;
                int n15 = 0;
                while (n15 < n14) {
                    int n16 = PatchClassFile.getInt(byArray, n2 += 2);
                    n2 += 4 + n16;
                    ++n15;
                }
                ++n13;
            }
            ++n12;
        }
        System.arraycopy(byArray, n11, byArray2, n3, n2 - n11);
        int n17 = n3 += n2 - n11;
        n4 = PatchClassFile.getChar(byArray, n2);
        byArray2[n3++] = byArray[n2++];
        byArray2[n3++] = byArray[n2++];
        boolean bl = false;
        int n18 = 0;
        while (n18 < n4) {
            char c = PatchClassFile.getChar(byArray, n2);
            if (c == n6) {
                int n19 = PatchClassFile.getInt(byArray, n2 += 2);
                n2 += 4 + n19;
            } else {
                int n20 = PatchClassFile.getInt(byArray, n2 + 2);
                System.arraycopy(byArray, n2, byArray2, n3, 6 + n20);
                n2 += 6 + n20;
                n3 += 6 + n20;
            }
            ++n18;
        }
        PatchClassFile.writeChar(n4 + 1, byArray2, n17);
        n3 = PatchClassFile.writeChar(n6, byArray2, n3);
        n3 = PatchClassFile.writeInt(string.length(), byArray2, n3);
        int n21 = 0;
        while (n21 < string.length()) {
            byArray2[n3++] = (byte)string.charAt(n21);
            ++n21;
        }
        if (n3 < byArray2.length) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    private static char getChar(byte[] byArray, int n) {
        return (char)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
    }

    private static int getInt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    private static int writeChar(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        return n2;
    }

    private static int writeInt(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >> 24 & 0xFF);
        byArray[n2++] = (byte)(n >> 16 & 0xFF);
        byArray[n2++] = (byte)(n >> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        return n2;
    }

    private PatchClassFile() {
    }
}

