/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.runner.Debugger;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

class RedefineMap {
    final HashMap redefineMap;

    void $init$() {
        this.redefineMap = new HashMap();
    }

    private byte[] fileToBuffer(String string, Translator.Log log) {
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            if (n <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray);
            fileInputStream.close();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            log.error(null, 0, 0, 0, "can't redefine " + string);
            return null;
        }
    }

    void redefineClass(Storage storage, String string, byte[] byArray, int n, Translator.Log log) {
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null && debugger.isDebugging()) {
            byte[] byArray2;
            if (byArray == null) {
                byArray2 = this.fileToBuffer(storage.getPath(), log);
            } else {
                byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
            }
            if (byArray2 != null) {
                this.redefineMap.put(string, byArray2);
            }
        }
    }

    void redefineClass(String string, String string2, Translator.Log log) {
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null && debugger.isDebugging()) {
            byte[] byArray = this.fileToBuffer(string, log);
            String string3 = string;
            if (string3.startsWith(string2)) {
                string3 = string3.substring(string2.length());
            }
            if (string3.length() > 0 && string3.charAt(0) == File.separatorChar) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith(".class")) {
                string3 = string3.substring(0, string3.length() - 6);
            }
            string3 = string3.replace(File.separatorChar, '.');
            if (byArray != null) {
                this.redefineMap.put(string3, byArray);
            }
        }
    }

    void redefineClassMap(Project project) {
        if (this.redefineMap != null && this.redefineMap.size() > 0) {
            Debugger.getDebugger().redefineClasses(project, (Map)this.redefineMap);
            this.redefineMap.clear();
        }
    }

    RedefineMap() {
        this.$init$();
    }
}

