/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Attributes;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.model.XMLDataNode;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Log;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.compiler.BuildGraph;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.JCompilerMenuItems;
import oracle.jdeveloper.compiler.Ojc;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.deploy.common.ProfileDep;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.deploy.BuildSystemFacade;
import oracle.ojc.interfaces.Storage;

public class UnifiedBuildSystem {
    public static IdeLog ideLog;
    public static boolean showCompileProgress;
    private static final String PREPROCESSOR_GENERATED_PROPERTY = "preprocessor_generated_file";
    HashMap registeredTranslators;
    ArrayList registeredTranslatorsList;
    BuildGraph buildGraph;
    CompileThread compileThread;
    boolean locked;
    boolean buildingOnUIThread;
    private static UnifiedBuildSystem instance;
    private Set translatedSources;
    private Set suppressedSources;
    private Set translateableSources;
    private boolean marking;
    private static final Log LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = UnifiedBuildSystem.class.desiredAssertionStatus() ^ true;
        ideLog = new IdeLog();
        showCompileProgress = false;
        LOG = new Log("translator");
    }

    void $init$() {
        this.registeredTranslators = new HashMap(19);
        this.registeredTranslatorsList = new ArrayList(19);
        this.buildGraph = new BuildGraph();
        this.compileThread = null;
        this.locked = false;
        this.buildingOnUIThread = false;
    }

    private synchronized void initThread(Context context, boolean bl, boolean bl2) {
        this.compileThread = new CompileThread(bl, context, this.buildGraph, bl2, null);
        if (this.compileThread.getPriority() > 1) {
            this.compileThread.setPriority(this.compileThread.getPriority() - 1);
        }
        this.compileThread.start();
    }

    public synchronized boolean init(Context context, boolean bl) {
        if (!this.isAlive()) {
            this.initThread(context, bl, false);
            return true;
        }
        return false;
    }

    public synchronized boolean buildOnUIThread(Context context, boolean bl) {
        if (!this.isAlive()) {
            try {
                this.compileThread = new CompileThread(bl, context, this.buildGraph, false, null);
                this.buildingOnUIThread = true;
                this.compileThread.run();
            }
            finally {
                this.compileThread = null;
                this.buildingOnUIThread = false;
                return true;
            }
        }
        return false;
    }

    public synchronized void initCleanAll(Context context) {
        if (!this.isAlive()) {
            this.initThread(context, false, true);
        }
    }

    public URL getURLFromClassName(Context context, String string) {
        URL uRL = null;
        if (this.lock(context)) {
            Project project = context.getProject();
            if (project == null) {
                project = Ide.getActiveProject();
            }
            if (project == null) {
                project = Ide.getDefaultProject();
            }
            uRL = Ojc.getURLFromClassName(project, string);
        }
        this.unlock();
        return uRL;
    }

    public synchronized boolean isAlive() {
        return this.compileThread != null && this.compileThread.isAlive();
    }

    public void join(long l) throws InterruptedException {
        if (this.compileThread != null) {
            this.compileThread.join(0L);
        }
    }

    public synchronized void stopBuildSystem() {
        if (this.compileThread != null) {
            this.compileThread.interrupt();
        }
    }

    public synchronized boolean isLocked(Context context) {
        return this.locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean lock(Context context) {
        if (this.isAlive()) return false;
        this.locked = true;
        if (!true) return false;
        return true;
    }

    public synchronized boolean unlock() {
        if (this.locked) {
            this.locked = false;
            return false ^ true;
        }
        return false;
    }

    public synchronized int compileInThread(Thread thread, Project project, ArrayList arrayList, boolean bl) throws IllegalArgumentException {
        if (!(thread instanceof CompileThread || this.buildingOnUIThread && SwingUtilities.isEventDispatchThread())) {
            throw new IllegalArgumentException("thread");
        }
        int n = arrayList.size();
        if (arrayList == null) {
            throw new IllegalArgumentException("files");
        }
        int n2 = 0;
        while (n2 < n) {
            if (!(arrayList.get(n2) instanceof Storage)) {
                throw new IllegalArgumentException("files[" + n2 + "]");
            }
            ++n2;
        }
        return this.compileThread.buildFilesInThread(project, arrayList, bl);
    }

    public synchronized int getLastErrorCount() {
        return ideLog != null ? ideLog.nerrors() : 0;
    }

    private boolean isTranslatorCompatible(ArrayList arrayList, Translator translator, String string) {
        int n = BuildGraph.isPreprocessor(translator) ? 0 : 1;
        int n2 = 0;
        while (n2 < arrayList.size()) {
            if (!BuildGraph.isPreprocessor((Translator)arrayList.get(n2))) {
                ++n;
            }
            ++n2;
        }
        return n <= 1;
    }

    public void registerTranslator(Translator translator) {
        ArrayList arrayList = translator.getInputTypes();
        int n = 0;
        while (n < arrayList.size()) {
            String string = (String)arrayList.get(n);
            ArrayList<Translator> arrayList2 = (ArrayList<Translator>)this.registeredTranslators.get(string);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Translator>(1);
                arrayList2.add(translator);
                this.registeredTranslators.put(string, arrayList2);
            } else if (!arrayList2.contains(translator)) {
                if (this.isTranslatorCompatible(arrayList2, translator, string)) {
                    arrayList2.add(translator);
                    this.registeredTranslators.put(string, arrayList2);
                } else {
                    System.out.println("Addin: Translator " + translator.getName() + " is trying to register a input type (" + string + ")" + " which conflicts with translator " + translator.getName() + " who already using this input type");
                }
            }
            ++n;
        }
        if (!this.buildGraph.rebuild(this.registeredTranslators)) {
            System.out.println("Addin error: unable to register translator " + translator.getName());
            this.unregisterTranslator(translator);
        } else if (!this.registeredTranslatorsList.contains(translator)) {
            this.registeredTranslatorsList.add(translator);
        }
    }

    public void unregisterTranslator(Translator translator) {
        ArrayList arrayList = translator.getInputTypes();
        int n = 0;
        while (n < arrayList.size()) {
            String string = (String)arrayList.get(n);
            ArrayList arrayList2 = (ArrayList)this.registeredTranslators.get(string);
            if (arrayList2 != null) {
                arrayList2.remove(translator);
            }
            if (arrayList2 == null || arrayList2.size() == 0) {
                this.registeredTranslators.remove(string);
            }
            ++n;
        }
        this.registeredTranslatorsList.remove(translator);
    }

    Translator getJavaTranslator() {
        for (Translator translator : this.registeredTranslatorsList) {
            if (!"Ojc".equals(translator.getName())) continue;
            return translator;
        }
        return null;
    }

    public static UnifiedBuildSystem getInstance() {
        if (instance == null) {
            instance = new UnifiedBuildSystem();
        }
        return instance;
    }

    private void beginTranslator(Translator translator) {
        if (!$assertionsDisabled && !LOG.trace("begin translator {0}", (Object)translator)) {
            throw new AssertionError();
        }
        this.translateableSources = new HashSet();
        this.marking = false;
    }

    private void markTranslateable(Storage storage) {
        if (this.suppressedSources.contains(storage)) {
            return;
        }
        if (Boolean.TRUE.equals(storage.getProperty(PREPROCESSOR_GENERATED_PROPERTY))) {
            return;
        }
        this.translateableSources.add(storage);
    }

    public void beginMarking() {
        if (!$assertionsDisabled && !LOG.trace("begin marking")) {
            throw new AssertionError();
        }
        this.marking = true;
    }

    public void markTranslated(Storage storage) {
        boolean bl;
        if (!this.marking) {
            throw new IllegalStateException("marking translator failed to call beginMarking");
        }
        boolean bl2 = bl = this.suppressedSources.contains(storage) || Boolean.TRUE.equals(storage.getProperty(PREPROCESSOR_GENERATED_PROPERTY));
        if (!$assertionsDisabled && !LOG.trace("mark {1} translated, suppressed {0}", bl, (Object)storage)) {
            throw new AssertionError();
        }
        if (!bl) {
            this.translatedSources.add(storage);
        }
        this.translateableSources.remove(storage);
    }

    private void endTranslator() {
        if (this.marking) {
            if (!$assertionsDisabled && !LOG.trace("end translator, suppressed {0}", (Object)this.translateableSources)) {
                throw new AssertionError();
            }
            this.suppressedSources.addAll(this.translateableSources);
            this.translatedSources.removeAll(this.translateableSources);
        } else {
            if (!$assertionsDisabled && !LOG.trace("end translator, translated {0}", (Object)this.translateableSources)) {
                throw new AssertionError();
            }
            if (this.translateableSources != null) {
                this.translatedSources.addAll(this.translateableSources);
            }
        }
        this.translateableSources = null;
    }

    public Set getTranslatedSources() {
        return this.translatedSources;
    }

    public UnifiedBuildSystem() {
        this.$init$();
    }

    static void wa$translatedSources(UnifiedBuildSystem unifiedBuildSystem, Set set) {
        unifiedBuildSystem.translatedSources = set;
    }

    static void wa$suppressedSources(UnifiedBuildSystem unifiedBuildSystem, Set set) {
        unifiedBuildSystem.suppressedSources = set;
    }

    static void mav$beginTranslator(UnifiedBuildSystem unifiedBuildSystem, Translator translator) {
        unifiedBuildSystem.beginTranslator(translator);
    }

    static void mav$endTranslator(UnifiedBuildSystem unifiedBuildSystem) {
        unifiedBuildSystem.endTranslator();
    }

    static void mav$markTranslateable(UnifiedBuildSystem unifiedBuildSystem, Storage storage) {
        unifiedBuildSystem.markTranslateable(storage);
    }

    static Log ra$LOG() {
        return LOG;
    }

    private class CompileThread
    extends Thread {
        boolean rebuild;
        boolean cleanAll;
        BuildGraph buildGraph;
        Context context;
        long startTime;
        String[] copyResSpec;
        boolean reverseCopy;
        HashMap deploymentProfileBuilt;
        HashSet projectsBuilt;
        int filesBuilt;
        boolean warnOnSourceNotInProject;
        boolean saveBeforeCompile;
        private PrintWriter bsfPrintWriter;
        public static final String THREAD_NAME = "CompileThread";
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = CompileThread.class.desiredAssertionStatus() ^ true;
        }

        private CompileThread(boolean bl, Context context, BuildGraph buildGraph, boolean bl2) {
            super(THREAD_NAME);
            this.rebuild = bl;
            this.cleanAll = bl2;
            this.context = context;
            this.buildGraph = buildGraph;
            this.deploymentProfileBuilt = new HashMap();
            this.copyResSpec = null;
            this.reverseCopy = false;
            this.filesBuilt = 0;
            this.warnOnSourceNotInProject = false;
            EnvironOptions environOptions = Ide.getEnvironOptions();
            showCompileProgress = environOptions.getShowCompileProgress();
            this.saveBeforeCompile = environOptions.getSaveBeforeCompile();
            this.projectsBuilt = new HashSet();
            this.startTime = System.currentTimeMillis();
        }

        private Storage getStorageForNode(URL uRL) {
            Storage storage;
            Node node;
            if (uRL.getRef() != null) {
                return null;
            }
            Node node2 = node = this.saveBeforeCompile ? null : NodeFactory.find((URL)uRL);
            if (node != null && node.isDirty() || !"file".equals(uRL.getProtocol())) {
                if (node == null) {
                    try {
                        node = NodeFactory.findOrCreate((URL)uRL);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                storage = new IdeStorage(node);
            } else {
                storage = Helpers.createFileStorage(uRL.getPath());
            }
            if (node != null) {
                storage.setProperty("nodeClassObject", (Object)node.getClass());
            }
            return storage;
        }

        private void processElement(URL uRL, ArrayList arrayList, HashMap hashMap) {
            String string;
            Storage storage = this.getStorageForNode(uRL);
            if (storage != null && hashMap.get(string = storage.getPath()) == null) {
                arrayList.add(storage);
                hashMap.put(string, storage);
            }
        }

        private void getProjectFileList(Project project, ArrayList arrayList, HashMap hashMap) {
            Iterator iterator = ProjectContent.getInstance((PropertyStorage)project).getAllContents().urlIterator(null);
            while (iterator.hasNext()) {
                this.processElement((URL)iterator.next(), arrayList, hashMap);
            }
        }

        private boolean makeSureResultsAreStorageInstances(ArrayList arrayList) {
            if (arrayList == null) {
                return true;
            }
            int n = 0;
            while (n < arrayList.size()) {
                if (!(arrayList.get(n) instanceof Storage)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private void recursivelyDeleteDir(File file) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                if (file2.isDirectory()) {
                    this.recursivelyDeleteDir(file2);
                }
                boolean bl = file2.delete();
                ++n;
            }
        }

        private boolean cleanProject(Project project) {
            String string = CompArb.format(77, project.getShortLabel());
            URL uRL = JavaProject.getInstance(project).getOutputDirectory();
            if (uRL == null) {
                MessageDialog.error(null, (Object)CompArb.getString(78), (String)string, (String)"");
                return false;
            }
            File file = new File(uRL.getPath());
            if (!file.exists()) {
                return true;
            }
            if (!file.isDirectory()) {
                MessageDialog.error(null, (Object)CompArb.getString(81), (String)string, (String)"");
                return false;
            }
            if (!MessageDialog.confirm(null, (Object)CompArb.format(80, file.getPath()), (String)string, (String)"", (boolean)true)) {
                return false;
            }
            if (file.getParentFile() == null && !MessageDialog.confirm(null, (Object)CompArb.getString(79), (String)string, (String)"", (boolean)true)) {
                return false;
            }
            this.recursivelyDeleteDir(file);
            return true;
        }

        private void buildGraph(ArrayList arrayList, Project project, boolean bl) {
            if (arrayList == null || arrayList.size() <= 0 || project == null) {
                return;
            }
            ArrayList arrayList2 = this.buildGraph.getOrderedTranslatorList();
            int n = 0;
            while (n < UnifiedBuildSystem.this.registeredTranslatorsList.size()) {
                Translator translator = (Translator)UnifiedBuildSystem.this.registeredTranslatorsList.get(n);
                if (arrayList2.indexOf(translator) == -1) {
                    arrayList2.add(translator);
                }
                ++n;
            }
            HashMap<Storage, Storage> hashMap = new HashMap<Storage, Storage>();
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                Translator translator = (Translator)arrayList2.get(n2);
                try {
                    UnifiedBuildSystem.mav$beginTranslator(UnifiedBuildSystem.this, translator);
                    translator.setProject(project);
                    translator.setLog(ideLog);
                    if (this.isInterrupted()) {
                        translator.setProject(null);
                        translator.setLog(null);
                        UnifiedBuildSystem.mav$endTranslator(UnifiedBuildSystem.this);
                        return;
                    }
                    ArrayList<Storage> arrayList3 = new ArrayList<Storage>();
                    int n3 = 0;
                    while (n3 < arrayList.size()) {
                        Storage storage = (Storage)arrayList.get(n3);
                        if (translator.canBuild(storage)) {
                            arrayList3.add(storage);
                            UnifiedBuildSystem.mav$markTranslateable(UnifiedBuildSystem.this, storage);
                        } else if (translator.needToBuild(storage)) {
                            arrayList3.add(storage);
                        }
                        ++n3;
                    }
                    if (arrayList3.size() > 0) {
                        int n4 = ideLog.nerrors();
                        ArrayList arrayList4 = new ArrayList();
                        translator.translate(project, bl, arrayList3, arrayList4);
                        int n5 = ideLog.nerrors() - n4;
                        if (n5 <= 0 && arrayList4.size() > 0) {
                            if (BuildGraph.isPreprocessor(translator)) {
                                int n6 = 0;
                                while (n6 < arrayList3.size()) {
                                    Storage storage = (Storage)arrayList3.get(n6);
                                    if (translator.canBuild(storage)) {
                                        if (arrayList4.contains(storage)) {
                                            arrayList4.remove(storage);
                                        } else {
                                            arrayList.remove(storage);
                                        }
                                    }
                                    ++n6;
                                }
                            }
                            int n7 = 0;
                            while (n7 < arrayList4.size()) {
                                Storage storage = (Storage)arrayList4.get(n7);
                                if (!$assertionsDisabled && !UnifiedBuildSystem.ra$LOG().trace("preprocess created {0}", (Object)storage)) {
                                    throw new AssertionError();
                                }
                                storage.setProperty(UnifiedBuildSystem.PREPROCESSOR_GENERATED_PROPERTY, (Object)Boolean.TRUE);
                                arrayList.add(storage);
                                hashMap.put(storage, storage);
                                ++n7;
                            }
                        }
                        if (n5 > 0) {
                            int n8 = 0;
                            while (n8 < arrayList3.size()) {
                                Storage storage = (Storage)arrayList3.get(n8);
                                if (hashMap.get(storage) == storage) {
                                    File file = new File(storage.getPath());
                                    file.delete();
                                    hashMap.remove(storage);
                                }
                                ++n8;
                            }
                            int n9 = 0;
                            while (n9 < arrayList4.size()) {
                                new File(((Storage)arrayList4.get(n9)).getPath()).delete();
                                ++n9;
                            }
                        }
                    }
                }
                finally {
                    translator.setProject(null);
                    translator.setLog(null);
                    UnifiedBuildSystem.mav$endTranslator(UnifiedBuildSystem.this);
                }
                ++n2;
            }
        }

        int buildFilesInThread(Project project, ArrayList arrayList, boolean bl) {
            int n = ideLog.nerrors();
            this.buildGraph(arrayList, project, bl);
            return ideLog.nerrors() - n;
        }

        private void buildProjectFiles(Workspace workspace, Project project, Element[] elementArray) {
            if (this.projectsBuilt.contains(project)) {
                return;
            }
            if (elementArray == null) {
                this.projectsBuilt.add(project);
            }
            project.getTransientProperties().put("rebuild", this.rebuild && elementArray == null);
            boolean bl = this.rebuild | JCompiler.getInstance().forceRebuildOnProject(project);
            Workspace workspace2 = ideLog.getWorkspace();
            Project project2 = ideLog.getProject();
            try {
                Object object;
                ideLog.setWorkspace(workspace);
                ideLog.setProject(project);
                this.copyResSpec = JCompiler.getCopyRes(project);
                this.reverseCopy = JCompiler.getReverseCopyRes(project);
                ArrayList arrayList = new ArrayList(64);
                HashMap hashMap = new HashMap();
                if (elementArray != null) {
                    int n = 0;
                    while (n < elementArray.length) {
                        Element element = elementArray[n];
                        if (element instanceof RelativeDirectoryContextFolder) {
                            RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)elementArray[n];
                            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
                            Iterator iterator = contentSet.urlIterator(relativeDirectoryContextFolder.getRelativePath());
                            while (iterator.hasNext()) {
                                this.processElement((URL)iterator.next(), arrayList, hashMap);
                            }
                        } else {
                            this.processElement(((Node)elementArray[n]).getURL(), arrayList, hashMap);
                        }
                        ++n;
                    }
                } else {
                    this.getProjectFileList(project, arrayList, hashMap);
                }
                hashMap.clear();
                this.filesBuilt += arrayList.size();
                if (arrayList.size() <= 0) {
                    ideLog.setWorkspace(workspace2);
                    ideLog.setProject(project2);
                    return;
                }
                if (elementArray == null) {
                    ideLog.clear(null);
                } else {
                    int n = 0;
                    while (n < this.filesBuilt) {
                        Storage storage = (Storage)arrayList.get(n);
                        if (!storage.getPath().endsWith(".java")) {
                            ideLog.clear((Storage)arrayList.get(n));
                        }
                        ++n;
                    }
                }
                if (JavaProject.getInstance(project).getOutputDirectory() == null) {
                    ideLog.error(null, 0, 0, 0, CompArb.getString(68));
                    ideLog.setWorkspace(workspace2);
                    ideLog.setProject(project2);
                    return;
                }
                if (this.warnOnSourceNotInProject && arrayList.size() == 1 && ((object = this.context.getProperty("disableFileNotInProjectWarning")) == null || object == Boolean.FALSE)) {
                    ideLog.warning(null, 0, 0, 0, CompArb.format(86, ((Storage)arrayList.get(0)).getPath(), project.getShortLabel()));
                }
                if (this.buildGraph == null || this.buildGraph.buildRoots == null || this.buildGraph.buildRoots.size() == 0) {
                    throw new Error("no compiler addins installed");
                }
                ArrayList<Storage> arrayList2 = new ArrayList<Storage>(64);
                ArrayList<Storage> arrayList3 = new ArrayList<Storage>(64);
                int n = arrayList.size() - 1;
                while (n >= 0) {
                    Storage storage = (Storage)arrayList.get(n);
                    String string = storage.getName();
                    if (J2eeSettings.isCompilableJsp(string)) {
                        arrayList2.add(storage);
                        arrayList.remove(n);
                    } else if (string.endsWith(".uix") || string.endsWith(".uit")) {
                        arrayList3.add(storage);
                        arrayList.remove(n);
                    }
                    --n;
                }
                this.buildGraph(arrayList, project, bl);
                this.buildGraph(arrayList2, project, bl);
                this.buildGraph(arrayList3, project, bl);
            }
            finally {
                ideLog.setWorkspace(workspace2);
                ideLog.setProject(project2);
            }
        }

        private PrintWriter getBsfPrintWriter() {
            if (this.bsfPrintWriter == null) {
                this.bsfPrintWriter = Deployment.getLogPrintWriter();
            }
            return this.bsfPrintWriter;
        }

        private void buildDepProfile(Project project, Node node) {
            if (this.deploymentProfileBuilt.get(node) == project) {
                return;
            }
            this.deploymentProfileBuilt.put(node, project);
            BuildSystemFacade buildSystemFacade = new BuildSystemFacade(project, node);
            int n = ideLog.nerrors();
            ProfileDep[] profileDepArray = buildSystemFacade.getProfileDependencies();
            int n2 = 0;
            while (profileDepArray != null && n2 < profileDepArray.length) {
                Node node2 = NodeFactory.find((URL)profileDepArray[n2].getProjectURL());
                Node node3 = NodeFactory.find((URL)profileDepArray[n2].getProfileURL());
                if (node2 != null && node2 instanceof Project && node3 != null && node3 instanceof XMLDataNode) {
                    this.buildDepProfile((Project)node2, node3);
                }
                ++n2;
            }
            this.buildProjectFiles(null, project, null);
            if (ideLog.nerrors() <= n) {
                boolean bl = Boolean.TRUE.equals(this.context.getProperty("is-j2ee-application-assembly"));
                PrintWriter printWriter = (PrintWriter)this.context.getProperty("deploy-context-log");
                buildSystemFacade.deploy(bl, printWriter != null ? printWriter : this.getBsfPrintWriter());
            }
        }

        private void buildProject(Workspace workspace, Project project) {
            for (Dependable dependable : DependencyConfiguration.getInstance((Project)project).getAllDependenciesList()) {
                Element element = dependable.getSource();
                Folder folder = dependable.getSourceOwner();
                if (element instanceof Project) {
                    Workspace workspace2 = folder instanceof Workspace ? (Workspace)folder : null;
                    this.buildProjectFiles(workspace2, (Project)element, null);
                    continue;
                }
                if (!(element instanceof XMLDataNode) || !(folder instanceof Project)) continue;
                this.buildDepProfile((Project)folder, (Node)element);
            }
            this.buildProjectFiles(workspace, project, null);
        }

        private void buildWorkspace(Workspace workspace) {
            ideLog.setWorkspace(workspace);
            Iterator iterator = workspace.getChildren();
            while (iterator.hasNext()) {
                Project project = (Project)iterator.next();
                this.buildProject(workspace, project);
            }
        }

        private void buildAll(Element[] elementArray) {
            if (elementArray[0] instanceof Workspaces) {
                Iterator iterator = ((Folder)elementArray[0]).getChildren();
                while (iterator.hasNext()) {
                    Workspace workspace = (Workspace)iterator.next();
                    this.buildWorkspace(workspace);
                }
            } else if (elementArray[0] instanceof Workspace) {
                int n = 0;
                while (n < elementArray.length) {
                    Element element = elementArray[n];
                    this.buildWorkspace((Workspace)element);
                    ++n;
                }
            } else if (elementArray[0] instanceof Project) {
                int n = 0;
                while (n < elementArray.length) {
                    Element element = elementArray[n];
                    this.buildProject(this.context.getWorkspace(), (Project)element);
                    ++n;
                }
            } else {
                Context context;
                if (elementArray.length == 1 && elementArray[0] instanceof Locatable && !elementArray[0].mayHaveChildren() && !CmJavaUtil.isCMUrl(((Locatable)elementArray[0]).getURL()) && !(this.warnOnSourceNotInProject = (context = EditorUtil.findNodeInContext((Element)elementArray[0], (Context)this.context)) == null)) {
                    this.context = context;
                }
                Project project = this.context.getProject();
                Workspace workspace = this.context.getWorkspace();
                if (project == null) {
                    project = Ide.getActiveProject();
                    workspace = Ide.getActiveWorkspace();
                }
                if (project == null) {
                    project = Ide.getDefaultProject();
                    workspace = Ide.getDefaultWorkspace();
                }
                this.buildProjectFiles(workspace, project, elementArray);
                this.warnOnSourceNotInProject = false;
            }
        }

        private boolean cleanAll(Element[] elementArray) {
            boolean bl = true;
            if (elementArray[0] instanceof Workspaces) {
                Iterator iterator = elementArray[0].getChildren();
                while (iterator.hasNext()) {
                    bl &= this.cleanAll(new Element[]{(Element)iterator.next()});
                }
            } else if (elementArray[0] instanceof Workspace) {
                int n = 0;
                while (n < elementArray.length) {
                    Iterator iterator = ((Workspace)elementArray[n]).getChildren();
                    while (iterator.hasNext()) {
                        bl &= this.cleanProject((Project)iterator.next());
                    }
                    ++n;
                }
            } else if (elementArray[0] instanceof Project) {
                int n = 0;
                while (n < elementArray.length) {
                    Element element = elementArray[n];
                    bl &= this.cleanProject((Project)element);
                    ++n;
                }
            } else {
                Project project = this.context.getProject();
                if (project == null) {
                    project = Ide.getActiveProject();
                }
                if (project != null) {
                    bl &= this.cleanProject(project);
                }
            }
            return bl;
        }

        private Element[] getWorkingSetFileList(Project project) {
            WorkingSets workingSets = WorkingSets.getInstance((Project)project);
            WorkingSet workingSet = workingSets.getCurrentWorkingSet();
            if (workingSet == null) {
                workingSet = workingSets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
            }
            if (workingSet == null) {
                return new Element[0];
            }
            PatternFilters patternFilters = workingSet.getPatternFilters();
            IntersectedFilters intersectedFilters = new IntersectedFilters(patternFilters);
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            Iterator iterator = contentSet.nodeIterator("", intersectedFilters);
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            Element[] elementArray = arrayList.toArray(new Element[arrayList.size()]);
            return elementArray;
        }

        private Element[] getElementsToBuild() {
            IdeAction ideAction;
            Element[] elementArray = this.context.getSelection();
            boolean bl = elementArray == null || elementArray.length == 0;
            int n = 0;
            while (!bl && n < elementArray.length) {
                Element element = elementArray[n];
                Attributes attributes = element.getAttributes();
                if (!attributes.isSet(ElementAttributes.BUILDABLE)) {
                    bl = true;
                }
                ++n;
            }
            if (bl && this.context.getNode() != null) {
                elementArray = new Element[]{this.context.getNode()};
            }
            if ((ideAction = CompilerContext.getCompileAction(this.context)) != null) {
                int n2 = ideAction.getCommandId();
                Workspace workspace = Ide.getActiveWorkspace();
                Project project = Ide.getActiveProject();
                if (workspace != null && (n2 == JCompiler.MAKE_WORKSPACE_CMD_ID || n2 == JCompiler.BUILD_WORKSPACE_CMD_ID)) {
                    elementArray = new Element[]{workspace};
                } else if (project != null && (n2 == JCompiler.MAKE_PROJECT_CMD_ID || n2 == JCompiler.BUILD_PROJECT_CMD_ID)) {
                    elementArray = new Element[]{project};
                } else if (project != null && (n2 == JCompiler.MAKE_WORKINGSET_CMD_ID || n2 == JCompiler.BUILD_WORKINGSET_CMD_ID)) {
                    elementArray = this.getWorkingSetFileList(project);
                }
            }
            return elementArray;
        }

        public void run() {
            block12: {
                JCompiler jCompiler = JCompiler.getInstance();
                boolean bl = false;
                try {
                    block13: {
                        Ojc.currentContext = this.context;
                        UnifiedBuildSystem.wa$translatedSources(UnifiedBuildSystem.this, new HashSet());
                        UnifiedBuildSystem.wa$suppressedSources(UnifiedBuildSystem.this, new HashSet());
                        Element[] elementArray = this.getElementsToBuild();
                        if (elementArray == null || elementArray.length == 0) break block12;
                        ideLog.reinit();
                        JCompilerMenuItems.getInstance().enableCancelBuild(true);
                        if (!this.cleanAll) {
                            jCompiler.logOutStartBuild();
                        }
                        try {
                            try {
                                if (this.cleanAll) {
                                    bl = this.cleanAll(elementArray);
                                    break block13;
                                }
                                jCompiler.invokeListenersBegin(this.context);
                                this.buildAll(elementArray);
                            }
                            catch (BuildSystemVetoException buildSystemVetoException) {
                                ideLog.error(null, 0, 0, 0, buildSystemVetoException.getMessage());
                            }
                        }
                        finally {
                            this.deploymentProfileBuilt.clear();
                            this.projectsBuilt.clear();
                        }
                    }
                    try {
                        if (!this.cleanAll) {
                            jCompiler.invokeListenersFinish(ideLog);
                        }
                    }
                    catch (BuildSystemVetoException buildSystemVetoException) {
                        ideLog.error(null, 0, 0, 0, buildSystemVetoException.getMessage());
                    }
                    UnifiedBuildSystem.wa$translatedSources(UnifiedBuildSystem.this, null);
                    UnifiedBuildSystem.wa$suppressedSources(UnifiedBuildSystem.this, null);
                    ideLog.completed();
                    jCompiler.logOutEndBuild(this.filesBuilt, this.cleanAll ? (bl ? 1 : 2) : 0);
                }
                catch (Throwable throwable) {
                    jCompiler.logOutMsg(CompArb.getString(45) + "\n");
                    ideLog = new IdeLog();
                    ideLog.completed();
                }
            }
            JCompilerMenuItems.getInstance().enableCancelBuild(false);
            this.context = null;
            this.copyResSpec = null;
            this.reverseCopy = false;
        }

        CompileThread(boolean bl, Context context, BuildGraph buildGraph, boolean bl2, 1 var6_6) {
            this(bl, context, buildGraph, bl2);
        }

        public final class 1 {
        }
    }
}

