/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler.ant;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class AntConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = AntConfiguration.class.getName();
    public static final String PROJECT_BUILDFILE = "projectBuildfile";
    public static final String MAKE_TARGET = "makeTarget";
    public static final String REBUILD_TARGET = "rebuildTarget";
    public static final String ARGUMENTS = "arguments";
    public static final String SHOW_OUTPUT = "showOutput";
    public static final String TARGET_LIST = "targetList";

    private AntConfiguration(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static AntConfiguration getAntConfiguration(PropertyStorage propertyStorage) {
        HashStructure hashStructure = propertyStorage.getProperties();
        HashStructure hashStructure2 = hashStructure.getOrCreateHashStructure(DATA_KEY);
        return new AntConfiguration(hashStructure2);
    }

    public URL getProjectBuildfile() {
        return this._hash.getURL(PROJECT_BUILDFILE);
    }

    public void setProjectBuildfile(URL uRL) {
        this._hash.putURL(PROJECT_BUILDFILE, uRL, true);
    }

    public String getMakeTarget() {
        return this._hash.getString(MAKE_TARGET);
    }

    public void setMakeTarget(String string) {
        this._hash.putString(MAKE_TARGET, string, true);
    }

    public String getRebuildTarget() {
        return this._hash.getString(REBUILD_TARGET);
    }

    public void setRebuildTarget(String string) {
        this._hash.putString(REBUILD_TARGET, string, true);
    }

    public String getArguments() {
        return this._hash.getString(ARGUMENTS);
    }

    public void setArguments(String string) {
        this._hash.putString(ARGUMENTS, string, true);
    }

    public boolean isShowOutput() {
        return this._hash.getBoolean(SHOW_OUTPUT, true);
    }

    public void setShowOutput(boolean bl) {
        this._hash.putBoolean(SHOW_OUTPUT, bl);
    }

    public List getTargetList() {
        ListStructure listStructure = this._hash.getListStructure(TARGET_LIST);
        ArrayList arrayList = new ArrayList();
        if (listStructure != null) {
            arrayList.addAll(listStructure);
        }
        return arrayList;
    }

    public void setTargetList(List list) {
        if (list == null) {
            this._hash.remove(TARGET_LIST);
        } else {
            ListStructure listStructure = this._hash.getOrCreateListStructure(TARGET_LIST);
            listStructure.mirror(list);
        }
    }

    public static boolean hasBuildfile(Project project) {
        boolean bl = false;
        if (project != null && project instanceof Project) {
            AntConfiguration antConfiguration = AntConfiguration.getAntConfiguration((PropertyStorage)project);
            bl = antConfiguration != null && antConfiguration.getProjectBuildfile() != null;
        }
        return bl;
    }
}

