/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.controller.NodeActionDelegate;
import oracle.jdeveloper.java.JavaManager;

public abstract class JavaSourceNodeActionDelegate
extends NodeActionDelegate {
    private boolean redo;
    private UndoableEdit edit;
    private int[] selection;

    public boolean isEnabled(IdeAction ideAction, Context context, Element[] elementArray, int[] nArray) {
        return context.getProject() != null;
    }

    public int[] doAction(Context context, Element[] elementArray, int[] nArray, IdeAction ideAction) {
        if (this.redo) {
            if (this.edit != null) {
                this.edit.redo();
            }
        } else {
            this.redo = true;
            JavaManager javaManager = JavaManager.getJavaManager(context.getProject());
            SourceFile sourceFile = javaManager.getSourceFile(context.getNode().getURL());
            sourceFile.compile();
            SourceTransaction sourceTransaction = sourceFile.beginTransaction();
            try {
                HashSet<SourceImport> hashSet = new HashSet<SourceImport>();
                for (SourceImport sourceImport : sourceFile.getSourceImports()) {
                    if (sourceImport.isUsed()) continue;
                    hashSet.add(sourceImport);
                }
                this.selection = this.doAction(sourceFile, context, elementArray, nArray, ideAction);
                sourceTransaction.savepoint();
                sourceFile.compile();
                List list = sourceFile.getSourceImports();
                ArrayList<SourceImport> arrayList = new ArrayList<SourceImport>();
                for (SourceImport sourceImport : list) {
                    if (sourceImport.isUsed() || hashSet.contains(sourceImport)) continue;
                    arrayList.add(sourceImport);
                }
                list.removeAll(arrayList);
                this.edit = sourceTransaction.commit();
                sourceTransaction = null;
            }
            finally {
                if (sourceTransaction != null) {
                    sourceTransaction.abort();
                }
            }
        }
        return this.selection;
    }

    protected abstract int[] doAction(SourceFile var1, Context var2, Element[] var3, int[] var4, IdeAction var5);

    public void undoAction(Context context, Element[] elementArray, int[] nArray, IdeAction ideAction) {
        if (this.edit != null) {
            this.edit.undo();
        }
    }
}

