/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controller;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.CanceledException;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.controller.NodeActionControllerBundle;
import oracle.jdeveloper.controller.NodeActionDelegate;
import oracle.jdevimpl.audit.swing.DialogFactory;
import oracle.jdevimpl.audit.util.ChangeSupport;
import oracle.jdevimpl.audit.util.FormatBundle;
import oracle.jdevimpl.audit.util.Strings;
import oracle.jdevimpl.audit.util.TypeMap;

public class NodeActionController
implements Controller {
    public static final String SINGLE_SELECTION_TEMPLATE_TEXT = "single-selection-template-text";
    public static final String MULTIPLE_SELECTION_TEXT = "multiple-selection-text";
    private TypeMap delegates;
    private static final Log LOG = new Log("controller");
    private static final FormatBundle bundle = new FormatBundle(NodeActionControllerBundle.class);

    void $init$() {
        this.delegates = new TypeMap();
    }

    public void addDelegate(Class clazz, Class clazz2) {
        if (!Node.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " not instanceof Node");
        }
        if (!NodeActionDelegate.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException(clazz2 + " not instanceof NodeActionDelegate");
        }
        if (this.delegates.get(clazz) != null) {
            throw new IllegalArgumentException("delegate for " + clazz + " already added");
        }
        this.delegates.put(clazz, (Object)clazz2);
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl;
        boolean bl2;
        LOG.trace("updating {0} for {1}", (Object)this, (Object)context);
        String string = (String)ideAction.getValue("NoCtxName");
        if (string == null) {
            string = (String)ideAction.getValue("Name");
            ideAction.putValue("NoCtxName", (Object)string);
        }
        Node node = context.getNode();
        Element[] elementArray = context.getSelection();
        if (context.getView() instanceof CodeEditor) {
            String string2 = (String)ideAction.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
            if (string2 != null) {
                string = Strings.toString((String)string2, (Object[])new Object[]{node.getShortLabel()});
            }
            CodeEditor codeEditor = (CodeEditor)context.getView();
            int[] nArray = new int[]{codeEditor.getSelectionStart(), codeEditor.getSelectionEnd()};
            bl2 = this.isHandled(context);
            bl = this.isEnabled(context, null, nArray, ideAction);
        } else if (elementArray.length >= 1) {
            if (elementArray.length > 1) {
                String string3 = (String)ideAction.getValue(MULTIPLE_SELECTION_TEXT);
                if (string3 != null) {
                    string = string3;
                }
            } else {
                String string4 = (String)ideAction.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
                if (string4 != null) {
                    string = Strings.toString((String)string4, (Object[])new Object[]{elementArray[0].getShortLabel()});
                }
            }
            if (this.isContainer(elementArray[0]) || elementArray[0] instanceof Node) {
                bl2 = true;
                bl = true;
                Context context2 = new Context(context);
                int n = 0;
                while (n < elementArray.length) {
                    if (!this.isContainer(elementArray[n])) {
                        if (elementArray[n] instanceof Node) {
                            context2.setNode((Node)elementArray[n]);
                            bl2 = this.isHandled(context2);
                            bl = bl && this.isEnabled(context2, null, null, ideAction);
                        } else {
                            LOG.trace("element {0} not a container or node", n);
                            bl2 = false;
                            bl = false;
                        }
                    }
                    if (bl2) {
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                bl2 = node != null;
                int n = 0;
                while (bl2 && n < elementArray.length) {
                    if (this.isContainer(elementArray[n]) || elementArray[n] instanceof Node) {
                        bl2 = false;
                        LOG.trace("element {0} is a container or node", n);
                    }
                    ++n;
                }
                if (bl2) {
                    bl2 = this.isHandled(context);
                    bl = this.isEnabled(context, elementArray, null, ideAction);
                } else {
                    bl = false;
                }
            }
        } else if (node != null) {
            String string5 = (String)ideAction.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
            if (string5 != null) {
                string = Strings.toString((String)string5, (Object[])new Object[]{node.getShortLabel()});
            }
            bl2 = this.isHandled(context);
            bl = this.isEnabled(context, null, null, ideAction);
        } else {
            bl2 = false;
            bl = false;
        }
        LOG.trace("action enabled {0}, label {1}", bl, (Object)string);
        ideAction.setEnabled(bl);
        ideAction.putValue("Name", (Object)string);
        return bl2;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        LOG.trace("handling event for {0} on {1}", (Object)ideAction, (Object)context);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        Element[] elementArray = context.getSelection();
        if (context.getView() instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)context.getView();
            int[] nArray = new int[]{codeEditor.getSelectionStart(), codeEditor.getSelectionEnd()};
            this.queueNode(context, null, nArray, ideAction, linkedHashMap);
        } else if (elementArray.length >= 1) {
            if (this.isContainer(elementArray[0]) || elementArray[0] instanceof Node) {
                int n = 0;
                while (n < elementArray.length) {
                    if (this.isContainer(elementArray[n])) {
                        this.queueContainer(elementArray[n], project, workspace, ideAction, linkedHashMap);
                    } else if (elementArray[n] instanceof Node) {
                        Context context2 = new Context(context);
                        context2.setNode((Node)elementArray[n]);
                        this.queueNode(context2, null, null, ideAction, linkedHashMap);
                    }
                    ++n;
                }
            } else {
                this.queueNode(context, elementArray, null, ideAction, linkedHashMap);
            }
        } else if (context.getNode() != null) {
            this.queueNode(context, elementArray, null, ideAction, linkedHashMap);
        }
        if (linkedHashMap.isEmpty()) {
            this.showMessageDialog("no-files", null, false);
            return true;
        }
        LinkedHashMap<URL, NodeHandler> linkedHashMap2 = new LinkedHashMap<URL, NodeHandler>();
        LinkedHashMap<URL, NodeHandler> linkedHashMap3 = new LinkedHashMap<URL, NodeHandler>();
        Iterator iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            NodeHandler nodeHandler = (NodeHandler)entry.getValue();
            URL uRL = NodeHandler.ra$url(nodeHandler);
            if (URLFileSystem.isReadOnly((URL)uRL)) {
                VCSManager vCSManager = VCSManager.getVCSManager();
                if (vCSManager == null || !vCSManager.isVersioned(uRL)) {
                    linkedHashMap2.put(uRL, nodeHandler);
                    iterator.remove();
                } else {
                    linkedHashMap3.put(uRL, nodeHandler);
                }
            }
            NodeHandler.wa$dirty(nodeHandler, NodeHandler.ra$context(nodeHandler).getNode().isDirty());
        }
        LOG.trace("{0} read-only unversioned, {1} read-only versioned, {2} writable", linkedHashMap2.size(), linkedHashMap3.size(), linkedHashMap.size());
        if (linkedHashMap3.isEmpty() && linkedHashMap.isEmpty()) {
            this.showFileListDialog(linkedHashMap2, "no-mutable", false);
            return true;
        }
        if (!linkedHashMap2.isEmpty() && !this.showFileListDialog(linkedHashMap2, "skip-immutable", true)) {
            return true;
        }
        if (!linkedHashMap3.isEmpty() && !this.showFileListDialog(linkedHashMap3, "make-writable", true)) {
            return true;
        }
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null) {
            List list = editorManager.getAllEditors();
            int n = 0;
            while (n < list.size()) {
                CodeEditor codeEditor;
                Context context3;
                URL uRL;
                NodeHandler nodeHandler;
                Editor editor = (Editor)list.get(n);
                if (editor instanceof CodeEditor && (nodeHandler = (NodeHandler)linkedHashMap.get(uRL = (context3 = (codeEditor = (CodeEditor)editor).getContext()).getNode().getURL())) != null) {
                    NodeHandler.wa$open(nodeHandler, true);
                    NodeHandler.wa$initialSelection(nodeHandler, new int[]{codeEditor.getSelectionStart(), codeEditor.getSelectionEnd()});
                }
                ++n;
            }
        }
        if (!linkedHashMap3.isEmpty()) {
            VCSManager vCSManager = VCSManager.getVCSManager();
            String string = vCSManager.getCheckOutCommand();
            for (NodeHandler nodeHandler : linkedHashMap3.values()) {
                NodeHandler.wa$checkoutCommand(nodeHandler, CommandProcessor.createCommand((String)string, (Context)NodeHandler.ra$context(nodeHandler)));
            }
        }
        NodeActionCommand nodeActionCommand = new NodeActionCommand((String)ideAction.getValue("NoCtxName"), (String)ideAction.getValue("Name"), context, linkedHashMap, linkedHashMap3);
        try {
            CommandProcessor.getInstance().invoke((Command)nodeActionCommand);
        }
        catch (Throwable throwable) {
            throw new UnexpectedExceptionError(throwable);
        }
        return true;
    }

    private boolean showFileListDialog(Map map, String string, boolean bl) {
        if (map.size() == 1) {
            URL uRL = (URL)map.keySet().iterator().next();
            String string2 = URLFileSystem.getFileName((URL)uRL);
            String string3 = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)uRL));
            return this.showMessageDialog(string, new Object[]{string2, string3}, bl);
        }
        DialogFactory dialogFactory = new DialogFactory();
        JButton jButton = dialogFactory.addOkButton(null);
        if (bl) {
            dialogFactory.addCancelButton(null);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        dialogFactory.setContent((Component)jPanel);
        dialogFactory.setTitle(bundle.get(string + ".dialog.title"));
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        String string4 = bundle.get(string + ".dialog.n.message", (Object)new Integer(map.size()));
        JComponent jComponent = NodeActionController.createTextArea(string4);
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets.top = 5;
        Object[] objectArray = map.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = URLFileSystem.getPlatformPathName((URL)((URL)objectArray[n]));
            ++n;
        }
        JList<Object> jList = new JList<Object>(objectArray);
        jList.setVisibleRowCount(8);
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 31);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return jButton == dialogFactory.show();
    }

    private boolean showMessageDialog(String string, Object[] objectArray, boolean bl) {
        DialogFactory dialogFactory = new DialogFactory();
        JButton jButton = dialogFactory.addOkButton(null);
        if (bl) {
            dialogFactory.addCancelButton(null);
        }
        dialogFactory.setTitle(bundle.get(string + ".dialog.title"));
        String string2 = bundle.get(string + ".dialog.message", objectArray);
        JComponent jComponent = NodeActionController.createTextArea(string2);
        jComponent.setAlignmentX(0.0f);
        jComponent.setAlignmentY(0.0f);
        dialogFactory.setContent((Component)jComponent);
        dialogFactory.setInitialFocus((Component)jButton);
        return jButton == dialogFactory.show();
    }

    private static int showAbortDialog(String string, URL uRL, Throwable throwable, String[] stringArray) {
        String string2 = null;
        String string3 = null;
        if (uRL != null) {
            string2 = URLFileSystem.getFileName((URL)uRL);
            string3 = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)uRL));
        }
        DialogFactory dialogFactory = new DialogFactory();
        dialogFactory.setDefaultCloseButtonIgnored(true);
        JButton jButton = dialogFactory.addOkButton(null);
        jButton.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        dialogFactory.setContent((Component)jPanel);
        dialogFactory.setTitle(bundle.get(string + ".dialog.title"));
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        JComponent jComponent = NodeActionController.createTextArea(bundle.get(string + ".dialog.message", (Object)string2, (Object)string3, (Object)throwable));
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 2;
        JRadioButton[] jRadioButtonArray = new JRadioButton[stringArray.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        1 var13_13 = new 1(jRadioButtonArray, jButton, dialogFactory);
        int n = 0;
        while (n < jRadioButtonArray.length) {
            jRadioButtonArray[n] = new JRadioButton(bundle.get(stringArray[n], (Object)string2));
            ++gridBagConstraints.gridy;
            jPanel.add((Component)jRadioButtonArray[n], gridBagConstraints);
            buttonGroup.add(jRadioButtonArray[n]);
            jRadioButtonArray[n].addActionListener(var13_13);
            ++n;
        }
        ++gridBagConstraints.gridy;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        dialogFactory.show();
        int n2 = 0;
        while (n2 < jRadioButtonArray.length) {
            if (jRadioButtonArray[n2].isSelected()) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static JComponent createTextArea(String string) {
        JEditorPane jEditorPane = new JEditorPane("text/html", "<html><body>" + string + "</body></html>");
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.setForeground(UIManager.getColor("Label.foreground"));
        jEditorPane.setBackground(UIManager.getColor("Label.background"));
        Font font = jEditorPane.getFont();
        int n = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        StyleSheet styleSheet = ((HTMLDocument)jEditorPane.getDocument()).getStyleSheet();
        styleSheet.addRule("body {font-size: " + font.getSize() + "pt;" + "font-family: " + font.getFamily() + ";" + "font-weight: " + (font.isBold() ? "bold" : "normal") + ";" + "font-style: " + (font.isItalic() ? "italic" : "normal") + ";" + "color: #" + Integer.toHexString(jEditorPane.getForeground().getRGB() & 0xFFFFFF) + "width: " + n + "px;" + "max-width: " + n + "px;" + "}");
        jEditorPane.setBorder(null);
        jEditorPane.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        return jEditorPane;
    }

    private boolean isContainer(Element element) {
        if (element instanceof Workspaces) {
            return true;
        }
        if (element instanceof Workspace) {
            return true;
        }
        if (element instanceof Project) {
            return true;
        }
        return element instanceof RelativeDirectoryContextFolder;
    }

    protected NodeActionDelegate getDelegate(Node node) {
        Class clazz = node.getClass();
        Class clazz2 = (Class)this.delegates.get(clazz);
        if (clazz2 == null) {
            LOG.trace("getting no delegate for {0}", (Object)clazz);
            return null;
        }
        try {
            LOG.trace("getting delegate {0} for {1}", (Object)clazz2, (Object)clazz);
            NodeActionDelegate nodeActionDelegate = (NodeActionDelegate)clazz2.newInstance();
            return nodeActionDelegate;
        }
        catch (InstantiationException instantiationException) {
            throw new UnexpectedExceptionError((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnexpectedExceptionError((Throwable)illegalAccessException);
        }
    }

    private boolean isHandled(Context context) {
        return this.delegates.get(context.getNode().getClass()) != null;
    }

    private boolean isEnabled(Context context, Element[] elementArray, int[] nArray, IdeAction ideAction) {
        boolean bl;
        Node node = context.getNode();
        NodeActionDelegate nodeActionDelegate = this.getDelegate(node);
        if (nodeActionDelegate != null) {
            if (nodeActionDelegate.isEnabled(ideAction, context, elementArray, nArray)) {
                URL uRL = node.getURL();
                bl = URLFileSystem.isReadOnly((URL)uRL) ^ true;
                if (!bl) {
                    VCSManager vCSManager = VCSManager.getVCSManager();
                    bl = vCSManager != null && vCSManager.isVersioned(uRL);
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected void queueContainer(Element element, Project project, Workspace workspace, IdeAction ideAction, Map map) {
        if (element instanceof Workspaces) {
            Iterator iterator = element.getChildren();
            while (iterator.hasNext()) {
                this.queueContainer((Element)iterator.next(), null, null, ideAction, map);
            }
        } else if (element instanceof Workspace) {
            Iterator iterator = element.getChildren();
            while (iterator.hasNext()) {
                this.queueContainer((Element)iterator.next(), null, (Workspace)element, ideAction, map);
            }
        } else if (element instanceof Project) {
            project = (Project)element;
            WorkingSets workingSets = WorkingSets.getInstance((Project)project);
            WorkingSet workingSet = workingSets.getCurrentWorkingSet();
            if (workingSet == workingSets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL)) {
                workingSet = null;
            }
            Iterator iterator = workingSet != null ? ProjectContent.getInstance((PropertyStorage)project).getAllContents().nodeIterator("", new IntersectedFilters(workingSet.getPatternFilters())) : project.getChildren();
            while (iterator.hasNext()) {
                this.queueContainer((Element)iterator.next(), project, workspace, ideAction, map);
            }
        } else if (element instanceof RelativeDirectoryContextFolder) {
            Iterator iterator = element.getChildren();
            while (iterator.hasNext()) {
                this.queueContainer((Element)iterator.next(), project, workspace, ideAction, map);
            }
        } else if (element instanceof Node) {
            Node node = (Node)element;
            Context context = new Context(null, workspace, project, node);
            this.queueNode(context, null, null, ideAction, map);
        }
    }

    private void queueNode(Context context, Element[] elementArray, int[] nArray, IdeAction ideAction, Map map) {
        NodeActionDelegate nodeActionDelegate;
        Node node = context.getNode();
        URL uRL = node.getURL();
        if (!map.containsKey(uRL) && (nodeActionDelegate = this.getDelegate(node)) != null && nodeActionDelegate.isEnabled(ideAction, context, elementArray, nArray)) {
            LOG.trace("queueing {0} delegating to {1}", (Object)uRL, (Object)nodeActionDelegate);
            NodeHandler nodeHandler = new NodeHandler(null);
            NodeHandler.wa$action(nodeHandler, ideAction);
            NodeHandler.wa$elementSelection(nodeHandler, elementArray);
            NodeHandler.wa$textSelection(nodeHandler, nArray);
            NodeHandler.wa$context(nodeHandler, context);
            NodeHandler.wa$url(nodeHandler, uRL);
            NodeHandler.wa$delegate(nodeHandler, nodeActionDelegate);
            map.put(uRL, nodeHandler);
        }
    }

    private void changeSelection(Workspace workspace, Project project, URL uRL, int n, int n2) {
        Ide.setActiveWorkspace((Workspace)workspace);
        Ide.setActiveProject((Project)project);
        Node node = NodeFactory.find((URL)uRL);
        Context context = new Context(null, workspace, project, node);
        OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(context, n, n2);
        try {
            NavigationManager navigationManager = NavigationManager.getNavigationManager();
            if (navigationManager != null) {
                navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint);
            }
        }
        catch (Exception exception) {
            Log.error((String)"opening {0} failed: {1}", (Object)context, (Object)exception);
        }
    }

    private void fireStructureChanged(Context context) {
        Node node = context.getNode();
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, (Object)node);
        node.notifyObservers((Object)node, updateMessage);
    }

    public NodeActionController() {
        this.$init$();
    }

    static FormatBundle ra$bundle() {
        return bundle;
    }

    static Log ra$LOG() {
        return LOG;
    }

    static int maS$showAbortDialog(String string, URL uRL, Throwable throwable, String[] stringArray) {
        return NodeActionController.showAbortDialog(string, uRL, throwable, stringArray);
    }

    private static class NodeActionCommand
    extends Command {
        private String label;
        private Map handlersToCheckout;
        private Map handlersToDo;
        private Map handlersToUncheckout;
        private Map handlersToUndo;
        private Set handlersSkipped;
        private Node[] nodes;
        private ProgressMonitor progress;
        private ProgressModel model;
        private boolean reverting;
        private boolean vcsPhase;

        void $init$() {
            this.handlersToUncheckout = new LinkedHashMap();
            this.handlersToUndo = new LinkedHashMap();
            this.handlersSkipped = new LinkedHashSet();
        }

        public NodeActionCommand(String string, String string2, Context context, Map map, Map map2) {
            super(Ide.findOrCreateCmdID((String)string), 3, string);
            this.$init$();
            this.setContext(context);
            this.label = string2;
            this.handlersToCheckout = map2;
            this.handlersToDo = map;
        }

        public Node[] getAffectedNodes() {
            if (this.nodes == null) {
                this.nodes = new Node[this.handlersToDo.size()];
                int n = 0;
                Iterator iterator = this.handlersToDo.values().iterator();
                while (iterator.hasNext()) {
                    this.nodes[n++] = NodeHandler.ra$context((NodeHandler)iterator.next()).getNode();
                }
            }
            return this.nodes;
        }

        private void advance(String string, String string2) {
            if (this.model.isCanceled()) {
                this.reverting = true;
                throw new CanceledException();
            }
            this.model.set(string, this.model.getProgress() + 1, string2);
        }

        private void revert(String string, String string2) {
            this.model.set(string, this.model.getProgress() - 1, string2);
        }

        private void log(String string) {
            LogManager.getLogManager().getMsgPage().log((Object)(string + '\n'));
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public int doit() throws Exception {
            int n;
            void var1_2;
            this.getAffectedNodes();
            this.log(NodeActionController.ra$bundle().get("status.doing", (Object)this.label));
            this.reverting = false;
            this.handlersSkipped.clear();
            this.model = new ProgressModel();
            this.progress = new ProgressMonitor(this.label);
            this.progress.setSynchronous(this.handlersToCheckout.isEmpty() && this.handlersToDo.size() <= 1);
            Do do_ = new Do(null);
            block14: while (true) {
                NodeActionController.ra$LOG().trace("starting execution using {0}", (Object)var1_2);
                this.model.setCanceled(false);
                this.model.setMaximum(this.handlersToCheckout.size() + this.handlersToDo.size());
                Throwable throwable = this.progress.execute((Runnable)var1_2, 0, this.model);
                if (throwable == null) {
                    throwable = var1_2.getException();
                }
                NodeActionController.ra$LOG().trace("completed execution, exception {0}", (Object)throwable);
                if (throwable == null) {
                    n = this.reverting ? 1 : 0;
                    break;
                }
                this.reverting = false;
                if (throwable instanceof CanceledException) {
                    String[] stringArray = new String[]{"cancel.cancel.button.label", "cancel.stop.button.label", "cancel.continue.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("cancel", null, null, stringArray)) {
                        case 0: {
                            this.reverting = true;
                            Undo undo = new Undo(null);
                            break;
                        }
                        case 1: {
                            n = 0;
                            break block14;
                        }
                    }
                } else if (this.vcsPhase) {
                    Iterator iterator = this.handlersToCheckout.keySet().iterator();
                    URL uRL = (URL)iterator.next();
                    String[] stringArray = new String[]{"checkout-failed.cancel.button.label", "checkout-failed.stop.button.label", "checkout-failed.skip.button.label", "checkout-failed.retry.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("checkout-failed", uRL, throwable, stringArray)) {
                        case 0: {
                            this.reverting = true;
                            Undo undo = new Undo(null);
                            break;
                        }
                        case 1: {
                            n = 0;
                            break block14;
                        }
                        case 2: {
                            iterator.remove();
                            this.handlersSkipped.add(uRL);
                            break;
                        }
                    }
                } else {
                    Iterator iterator = this.handlersToDo.keySet().iterator();
                    URL uRL = (URL)iterator.next();
                    String[] stringArray = new String[]{"modification-failed.cancel.button.label", "modification-failed.stop.button.label", "modification-failed.skip.button.label", "modification-failed.retry.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("modification-failed", uRL, throwable, stringArray)) {
                        case 0: {
                            this.reverting = true;
                            Undo undo = new Undo(null);
                            break;
                        }
                        case 1: {
                            n = 0;
                            break block14;
                        }
                        case 2: {
                            iterator.remove();
                            this.handlersSkipped.add(uRL);
                        }
                    }
                }
                if (var1_2 instanceof Do) {
                    this.log(NodeActionController.ra$bundle().get("status.continuing", (Object)this.label));
                    continue;
                }
                this.log(NodeActionController.ra$bundle().get("status.cancelling", (Object)this.label));
            }
            if (var1_2 instanceof Do) {
                this.log(NodeActionController.ra$bundle().get("status.completed", (Object)this.label));
                return n;
            }
            this.log(NodeActionController.ra$bundle().get("status.cancelled", (Object)this.label));
            return n;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public int undo() throws Exception {
            int n;
            void var1_2;
            this.log(NodeActionController.ra$bundle().get("status.undoing", (Object)this.label));
            this.reverting = false;
            this.handlersSkipped.clear();
            this.model = new ProgressModel();
            this.progress = new ProgressMonitor(this.label);
            this.progress.setSynchronous(this.handlersToUncheckout.isEmpty() && this.handlersToUndo.size() <= 1);
            Undo undo = new Undo(null);
            block14: while (true) {
                NodeActionController.ra$LOG().trace("starting execution using {0}", (Object)var1_2);
                this.model.setCanceled(false);
                this.model.setMaximum(this.handlersToUncheckout.size() + this.handlersToUndo.size());
                Throwable throwable = this.progress.execute((Runnable)var1_2, 0, this.model);
                if (throwable == null) {
                    throwable = var1_2.getException();
                }
                NodeActionController.ra$LOG().trace("completed execution, exception {0}", (Object)throwable);
                if (throwable == null) {
                    n = this.reverting ? 1 : 0;
                    break;
                }
                this.reverting = false;
                if (throwable instanceof CanceledException) {
                    String[] stringArray = new String[]{"cancel-undo.cancel.button.label", "cancel-undo.stop.button.label", "cancel-undo.continue.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("cancel-undo", null, null, stringArray)) {
                        case 0: {
                            this.reverting = true;
                            Do do_ = new Do(null);
                            break;
                        }
                        case 1: {
                            n = 0;
                            break block14;
                        }
                    }
                } else if (this.vcsPhase) {
                    Iterator iterator = this.handlersToUncheckout.keySet().iterator();
                    URL uRL = (URL)iterator.next();
                    String[] stringArray = new String[]{"uncheckout-failed.cancel.button.label", "uncheckout-failed.stop.button.label", "uncheckout-failed.skip.button.label", "uncheckout-failed.retry.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("uncheckout-failed", uRL, throwable, stringArray)) {
                        case 0: {
                            this.reverting = true;
                            Do do_ = new Do(null);
                            break;
                        }
                        case 1: {
                            n = 0;
                            break block14;
                        }
                        case 2: {
                            iterator.remove();
                            this.handlersSkipped.add(uRL);
                            break;
                        }
                    }
                } else {
                    Iterator iterator = this.handlersToUndo.keySet().iterator();
                    URL uRL = (URL)iterator.next();
                    String[] stringArray = new String[]{"unmodification-failed.cancel.button.label", "unmodification-failed.stop.button.label", "unmodification-failed.skip.button.label", "unmodification-failed.retry.button.label"};
                    switch (NodeActionController.maS$showAbortDialog("unmodification-failed", uRL, throwable, stringArray)) {
                        case 0: {
                            this.reverting = true;
                            Do do_ = new Do(null);
                            break;
                        }
                        case 1: {
                            n = 0;
                            break block14;
                        }
                        case 2: {
                            iterator.remove();
                            this.handlersSkipped.add(uRL);
                        }
                    }
                }
                if (var1_2 instanceof Undo) {
                    this.log(NodeActionController.ra$bundle().get("status.continuing-undo", (Object)this.label));
                    continue;
                }
                this.log(NodeActionController.ra$bundle().get("status.cancelling-undo", (Object)this.label));
            }
            if (var1_2 instanceof Undo) {
                this.log(NodeActionController.ra$bundle().get("status.completed-undo", (Object)this.label));
                return n;
            }
            this.log(NodeActionController.ra$bundle().get("status.cancelled-undo", (Object)this.label));
            return n;
        }

        static void wa$vcsPhase(NodeActionCommand nodeActionCommand, boolean bl) {
            nodeActionCommand.vcsPhase = bl;
        }

        static Map ra$handlersToCheckout(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersToCheckout;
        }

        static Set ra$handlersSkipped(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersSkipped;
        }

        static boolean ra$reverting(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.reverting;
        }

        static void mav$advance(NodeActionCommand nodeActionCommand, String string, String string2) {
            nodeActionCommand.advance(string, string2);
        }

        static void mav$revert(NodeActionCommand nodeActionCommand, String string, String string2) {
            nodeActionCommand.revert(string, string2);
        }

        static Map ra$handlersToUncheckout(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersToUncheckout;
        }

        static void mav$log(NodeActionCommand nodeActionCommand, String string) {
            nodeActionCommand.log(string);
        }

        static Map ra$handlersToDo(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersToDo;
        }

        static Map ra$handlersToUndo(NodeActionCommand nodeActionCommand) {
            return nodeActionCommand.handlersToUndo;
        }

        private abstract class Task
        implements Runnable {
            private Throwable exception;

            public final void run() {
                this.exception = null;
                try {
                    this.execute();
                }
                catch (Throwable throwable) {
                    this.exception = throwable;
                }
            }

            public Throwable getException() {
                return this.exception;
            }

            protected abstract void execute() throws Exception;

            private Task() {
            }

            Task(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private class Do
        extends Task {
            public void execute() throws Exception {
                NodeActionController.ra$LOG().trace("running Do phase 1");
                NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, false);
                Iterator iterator = NodeActionCommand.ra$handlersToCheckout(NodeActionCommand.this).values().iterator();
                while (iterator.hasNext()) {
                    NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, true);
                    NodeHandler nodeHandler = (NodeHandler)iterator.next();
                    URL uRL = NodeHandler.ra$url(nodeHandler);
                    if (NodeActionCommand.ra$handlersSkipped(NodeActionCommand.this).contains(uRL)) continue;
                    if (!NodeActionCommand.ra$reverting(NodeActionCommand.this)) {
                        NodeActionCommand.mav$advance(NodeActionCommand.this, NodeActionController.ra$bundle().get("do.make-writable.major.label"), NodeActionController.ra$bundle().get("do.make-writable.minor.label", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    } else {
                        NodeActionCommand.mav$revert(NodeActionCommand.this, NodeActionController.ra$bundle().get("do.make-writable.major.reverting, label"), NodeActionController.ra$bundle().get("do.make-writable.minor.reverting.label", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    }
                    NodeHandler.ra$checkoutCommand(nodeHandler).doit();
                    iterator.remove();
                    NodeActionCommand.ra$handlersToUncheckout(NodeActionCommand.this).put(uRL, nodeHandler);
                    NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.made-writable", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                }
                NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, false);
                NodeActionController.ra$LOG().trace("running Do phase 2");
                URL uRL = null;
                Iterator iterator2 = NodeActionCommand.ra$handlersToDo(NodeActionCommand.this).values().iterator();
                while (iterator2.hasNext()) {
                    NodeHandler nodeHandler = (NodeHandler)iterator2.next();
                    uRL = NodeHandler.ra$url(nodeHandler);
                    if (NodeActionCommand.ra$handlersSkipped(NodeActionCommand.this).contains(uRL)) continue;
                    if (!NodeActionCommand.ra$reverting(NodeActionCommand.this)) {
                        NodeActionCommand.mav$advance(NodeActionCommand.this, NodeActionController.ra$bundle().get("do.process.major.label"), NodeActionController.ra$bundle().get("do.process.minor.label", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    } else {
                        NodeActionCommand.mav$revert(NodeActionCommand.this, NodeActionController.ra$bundle().get("do.process.major.reverting, label"), NodeActionController.ra$bundle().get("do.process.minor.reverting.label", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    }
                    NodeHandler.wa$saved(nodeHandler, false);
                    nodeHandler.doAction();
                    iterator2.remove();
                    NodeActionCommand.ra$handlersToUndo(NodeActionCommand.this).put(uRL, nodeHandler);
                    if (NodeHandler.ra$open(nodeHandler) || NodeHandler.ra$dirty(nodeHandler)) continue;
                    try {
                        NodeActionController.ra$LOG().trace("saving {0}", (Object)uRL);
                        NodeHandler.ra$context(nodeHandler).getNode().save();
                        NodeHandler.wa$saved(nodeHandler, true);
                        NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.saved", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    }
                    catch (IOException iOException) {
                        NodeActionController.ra$LOG().trace("exception saving {0}: {1}", (Object)uRL, (Object)iOException);
                        NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.save-failed", (Object)URLFileSystem.getPlatformPathName((URL)uRL), (Object)iOException));
                    }
                }
            }

            private Do() {
                super(null);
            }

            Do(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private class Undo
        extends Task {
            public void execute() throws Exception {
                NodeActionController.ra$LOG().trace("running Do phase 1");
                NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, false);
                URL uRL = null;
                Iterator iterator = NodeActionCommand.ra$handlersToUndo(NodeActionCommand.this).values().iterator();
                while (iterator.hasNext()) {
                    NodeHandler nodeHandler = (NodeHandler)iterator.next();
                    uRL = NodeHandler.ra$url(nodeHandler);
                    if (NodeActionCommand.ra$handlersSkipped(NodeActionCommand.this).contains(uRL)) continue;
                    if (!NodeActionCommand.ra$reverting(NodeActionCommand.this)) {
                        NodeActionCommand.mav$advance(NodeActionCommand.this, NodeActionController.ra$bundle().get("undo.process.major.label"), NodeActionController.ra$bundle().get("undo.process.minor.label", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    } else {
                        NodeActionCommand.mav$revert(NodeActionCommand.this, NodeActionController.ra$bundle().get("undo.process.major.reverting, label"), NodeActionController.ra$bundle().get("undo.process.minor.reverting.label", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    }
                    nodeHandler.undoAction();
                    iterator.remove();
                    NodeActionCommand.ra$handlersToDo(NodeActionCommand.this).put(uRL, nodeHandler);
                    if (!NodeHandler.ra$saved(nodeHandler)) continue;
                    try {
                        NodeHandler.ra$context(nodeHandler).getNode().save();
                        NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.saved", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    }
                    catch (IOException iOException) {
                        NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.save-failed", (Object)URLFileSystem.getPlatformPathName((URL)uRL), (Object)iOException));
                    }
                    NodeHandler.wa$saved(nodeHandler, false);
                }
                NodeActionController.ra$LOG().trace("running Undo phase 2");
                Iterator iterator2 = NodeActionCommand.ra$handlersToUncheckout(NodeActionCommand.this).values().iterator();
                while (iterator2.hasNext()) {
                    NodeActionCommand.wa$vcsPhase(NodeActionCommand.this, true);
                    NodeHandler nodeHandler = (NodeHandler)iterator2.next();
                    uRL = NodeHandler.ra$url(nodeHandler);
                    if (NodeActionCommand.ra$handlersSkipped(NodeActionCommand.this).contains(uRL)) continue;
                    if (!NodeActionCommand.ra$reverting(NodeActionCommand.this)) {
                        NodeActionCommand.mav$advance(NodeActionCommand.this, NodeActionController.ra$bundle().get("undo.make-writable.major.label"), NodeActionController.ra$bundle().get("undo.make-writable.minor.label", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    } else {
                        NodeActionCommand.mav$revert(NodeActionCommand.this, NodeActionController.ra$bundle().get("undo.make-writable.major.reverting, label"), NodeActionController.ra$bundle().get("undo.make-writable.minor.reverting.label", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                    }
                    NodeHandler.ra$checkoutCommand(nodeHandler).undo();
                    iterator2.remove();
                    NodeActionCommand.ra$handlersToCheckout(NodeActionCommand.this).put(NodeHandler.ra$url(nodeHandler), nodeHandler);
                    NodeActionCommand.mav$log(NodeActionCommand.this, NodeActionController.ra$bundle().get("status.restored", (Object)URLFileSystem.getPlatformPathName((URL)uRL)));
                }
            }

            private Undo() {
                super(null);
            }

            Undo(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    private static class NodeHandler {
        private IdeAction action;
        private Context context;
        private URL url;
        private Element[] elementSelection;
        private int[] textSelection;
        private NodeActionDelegate delegate;
        private boolean open;
        private int[] initialSelection;
        private Command checkoutCommand;
        private boolean dirty;
        private boolean saved;

        void $init$() {
            this.open = false;
            this.initialSelection = null;
            this.dirty = false;
            this.saved = false;
        }

        public void doAction() throws Exception {
            NodeActionController.ra$LOG().trace("invoking delegate {0} doAction for {1}", (Object)this.delegate, (Object)this.url);
            this.context.getNode().ensureOpen();
            this.delegate.doAction(this.context, this.elementSelection, this.textSelection, this.action);
        }

        public void undoAction() {
            NodeActionController.ra$LOG().trace("invoking delegate {0} undoAction for {1}", (Object)this.delegate, (Object)this.url);
            this.context.getNode().ensureOpen();
            this.delegate.undoAction(this.context, this.elementSelection, this.textSelection, this.action);
        }

        public String toString() {
            return "NodeHandler " + URLFileSystem.getFileName((URL)this.url);
        }

        private NodeHandler() {
            this.$init$();
        }

        NodeHandler(1 var1_1) {
            this();
        }

        static void wa$action(NodeHandler nodeHandler, IdeAction ideAction) {
            nodeHandler.action = ideAction;
        }

        static void wa$elementSelection(NodeHandler nodeHandler, Element[] elementArray) {
            nodeHandler.elementSelection = elementArray;
        }

        static void wa$textSelection(NodeHandler nodeHandler, int[] nArray) {
            nodeHandler.textSelection = nArray;
        }

        static void wa$context(NodeHandler nodeHandler, Context context) {
            nodeHandler.context = context;
        }

        static void wa$url(NodeHandler nodeHandler, URL uRL) {
            nodeHandler.url = uRL;
        }

        static void wa$delegate(NodeHandler nodeHandler, NodeActionDelegate nodeActionDelegate) {
            nodeHandler.delegate = nodeActionDelegate;
        }

        static URL ra$url(NodeHandler nodeHandler) {
            return nodeHandler.url;
        }

        static Context ra$context(NodeHandler nodeHandler) {
            return nodeHandler.context;
        }

        static void wa$dirty(NodeHandler nodeHandler, boolean bl) {
            nodeHandler.dirty = bl;
        }

        static void wa$open(NodeHandler nodeHandler, boolean bl) {
            nodeHandler.open = bl;
        }

        static void wa$initialSelection(NodeHandler nodeHandler, int[] nArray) {
            nodeHandler.initialSelection = nArray;
        }

        static void wa$checkoutCommand(NodeHandler nodeHandler, Command command) {
            nodeHandler.checkoutCommand = command;
        }

        static Command ra$checkoutCommand(NodeHandler nodeHandler) {
            return nodeHandler.checkoutCommand;
        }

        static void wa$saved(NodeHandler nodeHandler, boolean bl) {
            nodeHandler.saved = bl;
        }

        static boolean ra$open(NodeHandler nodeHandler) {
            return nodeHandler.open;
        }

        static boolean ra$dirty(NodeHandler nodeHandler) {
            return nodeHandler.dirty;
        }

        static boolean ra$saved(NodeHandler nodeHandler) {
            return nodeHandler.saved;
        }

        public final class 1 {
        }
    }

    public static final class 1
    implements ActionListener {
        private final /* synthetic */ JRadioButton[] v$buttons;
        private final /* synthetic */ JButton v$okButton;
        private final /* synthetic */ DialogFactory v$dialog;

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            int n = 0;
            while (n < this.v$buttons.length) {
                bl |= this.v$buttons[n].isSelected();
                ++n;
            }
            this.v$okButton.setEnabled(bl);
            this.v$dialog.setDefaultCloseButtonIgnored(bl ^ true);
        }

        public 1(JRadioButton[] jRadioButtonArray, JButton jButton, DialogFactory dialogFactory) {
            this.v$dialog = dialogFactory;
            this.v$okButton = jButton;
            this.v$buttons = jRadioButtonArray;
        }
    }

    private static class ProgressModel {
        private int minimum;
        private int maximum;
        private int progress;
        private String majorStep;
        private String minorStep;
        private ChangeSupport support;
        private boolean canceled;

        void $init$() {
            this.maximum = 100;
            this.support = new ChangeSupport();
        }

        public ProgressModel() {
            this.$init$();
        }

        public ProgressModel(int n, int n2) {
            this.$init$();
            this.minimum = n;
            this.maximum = n2;
            this.progress = n;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.support.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.support.removeChangeListener(changeListener);
        }

        public void setCanceled(boolean bl) {
            this.canceled = bl;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public synchronized int getMinimum() {
            return this.minimum;
        }

        public synchronized void setMinimum(int n) {
            this.minimum = n;
            this.support.fireStateChanged();
        }

        public synchronized int getMaximum() {
            return this.maximum;
        }

        public synchronized void setMaximum(int n) {
            this.maximum = n;
            this.support.fireStateChanged();
        }

        public synchronized int getProgress() {
            return this.progress;
        }

        public synchronized void setProgress(int n) {
            this.progress = n;
            this.support.fireStateChanged();
        }

        public synchronized String getMajorStep() {
            return this.majorStep;
        }

        public synchronized void setMajorStep(String string) {
            this.majorStep = string;
            this.support.fireStateChanged();
        }

        public synchronized String getMinorStep() {
            return this.minorStep;
        }

        public synchronized void setMinorStep(String string) {
            this.minorStep = string;
            this.support.fireStateChanged();
        }

        public synchronized void set(String string, int n, String string2) {
            if (string != null) {
                this.majorStep = string;
            }
            if (n >= this.minimum && n < this.maximum) {
                this.progress = n;
            }
            if (string2 != null) {
                this.minorStep = string2;
            }
            this.support.fireStateChanged();
        }
    }

    private static class ProgressMonitor {
        private String title;
        private ProgressDialog dialog;
        private boolean synchronous;
        private Runnable task;
        private ProgressModel model;
        private Thread taskThread;
        private Throwable exception;

        public ProgressMonitor(String string) {
            this.title = string;
        }

        public boolean isSynchronous() {
            return this.synchronous;
        }

        public void setSynchronous(boolean bl) {
            this.synchronous = bl;
        }

        public Throwable execute(Runnable runnable, int n, ProgressModel progressModel) {
            NodeActionController.ra$LOG().trace("monitor execute");
            this.task = runnable;
            this.model = progressModel;
            this.exception = null;
            progressModel.addChangeListener(new 4());
            if (this.synchronous) {
                this.execute();
            } else {
                this.taskThread = new Thread((Runnable)new 3(), this.title);
                this.taskThread.setPriority(5);
                this.taskThread.start();
                if (n == 0) {
                    this.start();
                } else {
                    this.start();
                }
            }
            return this.exception;
        }

        private void modelChanged() {
            if (this.dialog != null) {
                this.dialog.setMajorLabelText(this.model.getMajorStep());
                this.dialog.setProgress(this.model.getProgress());
                this.dialog.setMinorLabelText(this.model.getMinorStep());
            }
        }

        private void execute() {
            NodeActionController.ra$LOG().trace("monitor execute  task");
            try {
                try {
                    this.task.run();
                    NodeActionController.ra$LOG().trace("task completed");
                }
                catch (Throwable throwable) {
                    this.exception = throwable;
                }
            }
            finally {
                EventQueue.invokeLater(new 2());
            }
        }

        private void start() {
            NodeActionController.ra$LOG().trace("monitor start, {0}", (Object)this.dialog);
            if (this.dialog == null) {
                this.dialog = new ProgressDialog(this.title, this.model.getMinimum(), this.model.getMaximum());
                this.dialog.setColumns(80);
                this.dialog.addCancelAction(new 1());
            }
            this.dialog.setMajorLabelText(this.model.getMajorStep());
            this.dialog.setProgress(this.model.getProgress());
            this.dialog.setMinorLabelText(this.model.getMinorStep());
            this.dialog.show();
        }

        private void cancel() {
            NodeActionController.ra$LOG().trace("monitor cancel");
            this.model.setCanceled(true);
        }

        private void finish() {
            NodeActionController.ra$LOG().trace("monitor finish");
            if (this.dialog != null) {
                this.dialog.hide();
            }
        }

        static void mav$modelChanged(ProgressMonitor progressMonitor) {
            progressMonitor.modelChanged();
        }

        static void mav$execute(ProgressMonitor progressMonitor) {
            progressMonitor.execute();
        }

        static void mav$finish(ProgressMonitor progressMonitor) {
            progressMonitor.finish();
        }

        static void mav$cancel(ProgressMonitor progressMonitor) {
            progressMonitor.cancel();
        }

        public final class 4
        implements ChangeListener {
            public void stateChanged(ChangeEvent changeEvent) {
                ProgressMonitor.mav$modelChanged(ProgressMonitor.this);
            }
        }

        public final class 3
        implements Runnable {
            public void run() {
                ProgressMonitor.mav$execute(ProgressMonitor.this);
            }
        }

        public final class 2
        implements Runnable {
            public void run() {
                ProgressMonitor.mav$finish(ProgressMonitor.this);
            }
        }

        public final class 1
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ProgressMonitor.mav$cancel(ProgressMonitor.this);
            }
        }
    }

    private static class ProgressDialog {
        private JLabel majorLabel = new JLabel("Initializing");
        private JProgressBar bar;
        private JLabel minorLabel;
        private DialogFactory dialog;

        public ProgressDialog(String string, int n, int n2) {
            this.bar = new JProgressBar(n, n2);
            this.minorLabel = new JLabel(" ");
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.majorLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.bar, gridBagConstraints);
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.minorLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            jPanel.add(Box.createHorizontalStrut(450), gridBagConstraints);
            this.dialog = new DialogFactory();
            this.dialog.setTitle(string);
            this.dialog.setContent((Component)jPanel);
        }

        public void setColumns(int n) {
            int n2 = this.majorLabel.getFontMetrics(this.majorLabel.getFont()).charWidth('m');
            Dimension dimension = new Dimension(n * n2, this.majorLabel.getPreferredSize().height);
            this.majorLabel.setPreferredSize(dimension);
            this.minorLabel.setPreferredSize(dimension);
        }

        public void setMajorLabelText(String string) {
            if (string != null) {
                this.majorLabel.setText(string);
            }
        }

        public void setProgress(int n) {
            if (n >= this.bar.getMinimum() && n <= this.bar.getMaximum()) {
                this.bar.setValue(n);
            }
        }

        public void setMinorLabelText(String string) {
            if (string != null) {
                this.minorLabel.setText(string);
            }
        }

        public void addCancelAction(ActionListener actionListener) {
            this.dialog.addCancelAction(actionListener);
        }

        public void show() {
            this.dialog.show();
        }

        public void hide() {
            this.dialog.hide();
        }
    }
}

