/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.controls.FileField;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;

public abstract class ConnectionImportExportPanel
extends JPanel {
    private GridBagLayout m_layout;
    private JLabel m_hintText;
    private JLabel m_fileNameLabel;
    private FileField m_fileNameField;
    private JButton m_browseButton;
    private JLabel m_connectionsLabel;
    private JScrollPane m_connectionsPane;
    private JList m_connectionsList;
    private boolean m_isImportMode;
    private JEWTDialog m_dialog;

    void $init$() {
        this.m_layout = new GridBagLayout();
        this.m_hintText = new JLabel();
        this.m_fileNameLabel = new JLabel();
        this.m_fileNameField = new FileField();
        this.m_browseButton = new JButton();
        this.m_connectionsLabel = new JLabel();
        this.m_connectionsPane = new JScrollPane();
        this.m_connectionsList = new JList();
        this.m_isImportMode = true;
        this.m_dialog = null;
    }

    public ConnectionImportExportPanel() {
        this.$init$();
        try {
            this.jbInit();
            this.m_browseButton.addActionListener(new 4());
            3 var1_1 = new 3();
            this.m_fileNameField.getDocument().addDocumentListener(var1_1);
            this.m_connectionsList.getSelectionModel().addListSelectionListener(new 2());
            ResourcePicker.getPicker(ConnectionImportExportPanel.class).start((Container)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setConnectionsCellRenderer(ListCellRenderer listCellRenderer) {
        this.m_connectionsList.setCellRenderer(listCellRenderer);
    }

    public void setImportMode(boolean bl) {
        this.m_isImportMode = bl;
        if (!bl) {
            this.setConnections(this.getExportableConnections());
        }
    }

    public boolean isImportMode() {
        return this.m_isImportMode;
    }

    public void setExplanatoryText(String string) {
        this.m_hintText.setText(string);
    }

    public void setConnections(Object[] objectArray) {
        this.m_connectionsList.setModel(new ArrayListModel(objectArray));
        int n = this.m_connectionsList.getModel().getSize();
        if (n > 0) {
            this.m_connectionsList.setSelectionInterval(0, n - 1);
        }
    }

    public Object[] getSelectedConnections() {
        return this.m_connectionsList.getSelectedValues();
    }

    private void filenameChangedImpl() {
        try {
            if (this.isImportMode()) {
                this.filenameChanged(this.m_fileNameField.getText());
            }
            this.checkDialogOKButton();
        }
        catch (RuntimeException runtimeException) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)runtimeException);
        }
    }

    protected abstract void filenameChanged(String var1);

    protected abstract Object[] getExportableConnections();

    protected Object getRenderedConnectionValue(Object object) {
        return object;
    }

    protected void browseClicked() {
        int n;
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.setSelectionMode(0);
        String string = this.m_fileNameField.getText();
        if (string.trim().length() > 0) {
            URL uRL = URLFactory.newURL((String)string);
            uRLChooser.setSelectedURL(uRL);
        }
        if ((n = this.isImportMode() ? uRLChooser.showOpenDialog((Component)this) : uRLChooser.showSaveDialog((Component)this)) == 0) {
            this.m_fileNameField.setText(URLFileSystem.getPlatformPathName((URL)uRLChooser.getSelectedURL()));
        }
    }

    protected abstract boolean importConnections();

    protected abstract boolean exportConnections(String var1);

    public boolean runDialog(Component component, String string, String string2) {
        int n;
        if (string2 == null) {
            n = 3;
        } else {
            n = 7;
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, string2);
        }
        JEWTDialog jEWTDialog = null;
        try {
            this.m_dialog = jEWTDialog = JEWTDialog.createDialog((Component)component, (String)string, (int)n);
            jEWTDialog.setContent((Component)this);
            jEWTDialog.setInitialFocus((Component)this.m_fileNameField);
            jEWTDialog.setOKButtonEnabled(false);
            jEWTDialog.setPreferredSize(new Dimension(588, 401));
            jEWTDialog.setResizable(true);
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1());
            boolean bl = jEWTDialog.runDialog();
            if (jEWTDialog != null) {
                jEWTDialog.dispose();
            }
            this.m_dialog = null;
            return bl;
        }
        catch (Throwable throwable) {
            if (jEWTDialog != null) {
                jEWTDialog.dispose();
            }
            this.m_dialog = null;
            throw throwable;
        }
    }

    protected boolean checkCanWrite(String string) {
        URL uRL = URLFactory.newURL((String)string);
        if (URLFileSystem.exists((URL)uRL)) {
            ResourcePicker resourcePicker = ResourcePicker.getPicker(ConnectionImportExportPanel.class);
            return MessageDialog.confirm((Component)this, (Object)resourcePicker.getString("ConfirmOverwrite.text", (Object)string), (String)resourcePicker.getString("ConfirmOverwrite.title"), null, (boolean)true);
        }
        return true;
    }

    private void dialogCommitImpl(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        try {
            boolean bl = false;
            if (this.isImportMode()) {
                bl = this.importConnections();
            } else {
                String string = this.m_fileNameField.getText();
                if (this.checkCanWrite(string)) {
                    bl = this.exportConnections(this.m_fileNameField.getText());
                }
            }
            if (!bl) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)runtimeException);
            throw new PropertyVetoException("", propertyChangeEvent);
        }
    }

    private void checkDialogOKButton() {
        try {
            if (this.m_dialog != null) {
                Object[] objectArray = this.getSelectedConnections();
                String string = this.m_fileNameField.getText();
                this.m_dialog.setOKButtonEnabled(objectArray != null && objectArray.length > 0 && (this.isImportMode() || string.trim().length() > 0));
            }
        }
        catch (RuntimeException runtimeException) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)runtimeException);
        }
    }

    private void jbInit() throws Exception {
        this.setName("ConnectionImportExportPanel");
        this.setLayout(this.m_layout);
        this.m_hintText.setName("ExplanatoryText");
        this.m_fileNameLabel.setName("FileNameLabel");
        this.m_fileNameLabel.setLabelFor((Component)this.m_fileNameField);
        this.m_browseButton.setName("BrowseButton");
        this.m_connectionsLabel.setName("ConnectionsLabel");
        this.m_connectionsLabel.setLabelFor(this.m_connectionsList);
        this.add((Component)this.m_hintText, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_fileNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add((Component)this.m_fileNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.m_connectionsLabel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.m_connectionsPane.getViewport().add((Component)this.m_connectionsList, null);
        this.add((Component)this.m_connectionsPane, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    static void mav$filenameChangedImpl(ConnectionImportExportPanel connectionImportExportPanel) {
        connectionImportExportPanel.filenameChangedImpl();
    }

    static void mav$checkDialogOKButton(ConnectionImportExportPanel connectionImportExportPanel) {
        connectionImportExportPanel.checkDialogOKButton();
    }

    static void mav$dialogCommitImpl(ConnectionImportExportPanel connectionImportExportPanel, PropertyChangeEvent propertyChangeEvent) {
        connectionImportExportPanel.dialogCommitImpl(propertyChangeEvent);
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ConnectionImportExportPanel.this.browseClicked();
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Component)ConnectionImportExportPanel.this, (Throwable)runtimeException);
            }
        }
    }

    public final class 3
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            try {
                ConnectionImportExportPanel.mav$filenameChangedImpl(ConnectionImportExportPanel.this);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            try {
                ConnectionImportExportPanel.mav$filenameChangedImpl(ConnectionImportExportPanel.this);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            try {
                ConnectionImportExportPanel.mav$filenameChangedImpl(ConnectionImportExportPanel.this);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ConnectionImportExportPanel.mav$checkDialogOKButton(ConnectionImportExportPanel.this);
        }
    }

    public final class 1
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                ConnectionImportExportPanel.mav$dialogCommitImpl(ConnectionImportExportPanel.this, propertyChangeEvent);
            }
        }
    }

    private class ArrayListModel
    extends AbstractListModel {
        private Object[] m_items;

        ArrayListModel(Object[] objectArray) {
            this.m_items = objectArray;
        }

        public int getSize() {
            return this.m_items.length;
        }

        public Object getElementAt(int n) {
            return this.m_items[n];
        }
    }
}

