/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.MutableComboBoxModel;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;

public class PackagePicker
extends AbstractPicker {
    private Project _proj;

    public PackagePicker() {
        this.setEditable(true);
        this.setValidator(new PackageValidator(null));
    }

    public PackagePicker(Project project) {
        this();
        this.setProject(project);
    }

    public void setProject(Project project) {
        if (this._proj != project) {
            Iterator iterator;
            MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.getModel();
            int n = mutableComboBoxModel.getSize();
            int n2 = n - 1;
            while (n2 >= 0) {
                mutableComboBoxModel.removeElementAt(n2);
                --n2;
            }
            ListStructure listStructure = JavaProject.getInstance(project).getRecentPackages();
            if (listStructure != null && (iterator = listStructure.iterator()) != null) {
                while (iterator.hasNext()) {
                    mutableComboBoxModel.addElement(iterator.next());
                }
            }
            String string = JavaProject.getInstance(project).getMostRecentPackage();
            this.addValue(string);
            mutableComboBoxModel.setSelectedItem(string);
            this._proj = project;
        }
    }

    public void setPackage(String string) {
        if (string == null) {
            string = "";
        }
        this.setCurrentValue(string);
    }

    public String getPackage() {
        Object object = this.getCurrentValue();
        return object != null ? object.toString() : "";
    }

    protected void doBrowse() {
        if (this._proj != null) {
            String string = ClassPackageBrowserV2.browseClassOrPackage((Component)((Object)this), this._proj, 1);
            this.setBrowseResult(string);
        }
    }

    protected String getInvalidValueErrorTitle() {
        return ControlsArb.getString(67);
    }

    private static class PackageValidator
    implements AbstractPicker.PickerResultValidator {
        public boolean isResultValid(Object object) {
            boolean bl = false;
            if (object instanceof String) {
                bl = IdeUtil.isPackageIdentifier((String)((String)object));
            }
            return bl;
        }

        public String getInvalidValueMsg(Object object) {
            return JProjectArb.format(125, object);
        }

        private PackageValidator() {
        }

        PackageValidator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

