/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;

public class PackagePopup
extends JTextField
implements ActionListener {
    protected Project _project;
    protected JavaManager _javaManager;
    protected BrowseHandler _browseHandler;

    public PackagePopup() {
        this.addFocusListener(new FL(this));
    }

    public PackagePopup(Project project) {
        this();
        this.setProject(project);
    }

    public void setProject(Project project) {
        this._project = project;
        this._javaManager = JavaManager.getJavaManager(this._project);
        this._browseHandler = BrowseHandler.createPackageBrowserPopup(this._javaManager, this, null);
    }

    public String getPackage() {
        return this._browseHandler != null ? this._browseHandler.getSelectedItem() : this.getText();
    }

    public void setPackage(String string) {
        this.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doBrowse();
    }

    protected void doBrowse() {
        ClassPackageBrowserV2 classPackageBrowserV2 = new ClassPackageBrowserV2();
        int n = 1;
        String[] stringArray = classPackageBrowserV2.browseClassOrPackage(this._javaManager, n, false, (ClassPackageBrowserFilterV2)null, this.getText());
        if (stringArray.length > 0) {
            this.setBrowseResult(stringArray[0]);
        }
    }

    protected final void setBrowseResult(Object object) {
        if (object != null && this.isResultValid(object)) {
            this.setPackage((String)object);
        }
    }

    private boolean isResultValid(Object object) {
        boolean bl = false;
        if (object instanceof String) {
            bl = IdeUtil.isPackageIdentifier((String)((String)object));
        }
        return bl;
    }

    private class FL
    implements FocusListener {
        JTextField textField;

        FL(JTextField jTextField) {
            this.textField = jTextField;
        }

        public void focusGained(FocusEvent focusEvent) {
            int n = this.textField.getText().length();
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(n);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

