/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls.classpick;

import javax.swing.Icon;
import oracle.jdeveloper.icons.JavaIcons;

class Entry
implements Comparable {
    public static final int TYPE_PACKAGE = 0;
    public static final int TYPE_CLASS = 10;
    public static final int TYPE_INTERFACE = 11;
    public static final int TYPE_DOTDOTDOT = 20;
    private int _type;
    private String _packageName;
    private String _className;
    private String _text;

    public Entry(int n, String string, String string2, String string3) {
        this._type = n;
        this._packageName = string;
        this._className = string2;
        this._text = string3;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof Entry) {
            int n2;
            Entry entry = (Entry)object;
            int n3 = this.getType();
            n = n3 / 10 == (n2 = entry.getType()) / 10 ? this.toString().compareTo(entry.toString()) : n3 - n2;
        }
        return n;
    }

    static Entry createClassEntry(String string, String string2) {
        return new Entry(10, string, string2, string2 + " (" + string + ")");
    }

    static Entry createInterface(String string, String string2) {
        return new Entry(11, string, string2, string2 + " (" + string + ")");
    }

    static Entry createPackageEntry(String string) {
        return new Entry(0, string, null, string);
    }

    public static Entry createDotDotDotEntry() {
        return new Entry(20, null, null, "...");
    }

    public boolean isPackage() {
        return this._className == null;
    }

    public String getFqClassName() {
        if (this._packageName.length() != 0) {
            return this._packageName + "." + this._className;
        }
        return this._className;
    }

    public String getClassName() {
        return this._className;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public String getFullName() {
        if (this.isPackage()) {
            return this.getPackageName();
        }
        return this.getFqClassName();
    }

    public String toString() {
        return this._text;
    }

    public Icon getIcon() {
        switch (this._type) {
            case 0: {
                return JavaIcons.getIcon(5);
            }
            case 10: {
                return JavaIcons.getIcon(0);
            }
            case 11: {
                return JavaIcons.getIcon(1);
            }
        }
        return null;
    }

    public int getType() {
        return this._type;
    }
}

