/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls.classpick;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.controls.classpick.DualFiter;
import oracle.jdeveloper.controls.classpick.Entry;
import oracle.jdeveloper.controls.classpick.Filter;
import oracle.jdeveloper.controls.classpick.PatternFilter;
import oracle.jdeveloper.controls.classpick.SmartFilter;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.model.PathsConfiguration;

public class TextFieldAdapter {
    private static final int MAX_CONTENT = 10;
    private int _flags;
    private JTextField _textField;
    private Context _context;
    private Listeners _listeners;
    private Popup _popup;
    private JList _jList;
    private DefaultListModel _dataModel;
    private JavaManager _javaManager;
    private boolean _updateListOnTextChanges;
    private String _valueBeforeListUpdate;
    private volatile int _changeId;
    private Filter _filter;
    private JavaClassLocator _javaClassLocator;
    private Timer _timer;
    private boolean _textExists;

    void $init$() {
        this._flags = 26;
        this._listeners = new Listeners(null);
        this._dataModel = new DefaultListModel();
        this._updateListOnTextChanges = true;
        this._valueBeforeListUpdate = null;
    }

    TextFieldAdapter(JTextField jTextField, Context context, int n) {
        this.$init$();
        this._textField = jTextField;
        this._context = context;
        this._javaManager = JavaManager.getJavaManager(context.getProject());
        this._flags = n;
        Document document = jTextField.getDocument();
        document.addDocumentListener(this._listeners);
        jTextField.addFocusListener(this._listeners);
        jTextField.addKeyListener(this._listeners);
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    public void setFlags(int n) {
        this._flags = n;
    }

    private void updateDropDown() {
        if (this._updateListOnTextChanges) {
            if (this._timer == null) {
                this._timer = new Timer(500, this._listeners);
                this._timer.setRepeats(false);
            }
            if (!this._timer.isRunning()) {
                this._timer.start();
            }
        }
    }

    private void whenTimerKiks() {
        new 2().start();
    }

    private void updateList(ArrayList arrayList) {
        if (this._textField.hasFocus()) {
            String string = this._textField.getText();
            this._dataModel.removeAllElements();
            this._textExists = false;
            int n = 0;
            while (n < arrayList.size()) {
                Entry entry = (Entry)arrayList.get(n);
                if (!string.equals(entry.getFullName())) {
                    this._dataModel.addElement(entry);
                } else {
                    this._textExists = true;
                }
                ++n;
            }
            this.closeDropDown();
            if (!this._dataModel.isEmpty() && this._textField.isVisible()) {
                this.showPopup();
            }
        }
    }

    private ArrayList getEntries(int n) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        try {
            String string = this._textField.getText();
            DualFiter dualFiter = string.indexOf(42) == -1 ? new SmartFilter() : new PatternFilter();
            dualFiter.setMatchName(string);
            JavaClassLocator javaClassLocator = this.getJavaLocator();
            Collection collection = javaClassLocator.getAllPackages(dualFiter);
            int n2 = 0;
            Iterator iterator = collection.iterator();
            while (n == this._changeId && n2 < 10 && iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (this._filter != null && !this._filter.acceptPackageName(string2)) continue;
                Entry entry = Entry.createPackageEntry(string2);
                arrayList.add(entry);
                ++n2;
            }
            if (n == this._changeId && n2 < 10) {
                boolean bl = BitField.isSet((int)this._flags, (int)8);
                boolean bl2 = BitField.isSet((int)this._flags, (int)16);
                if (bl || bl2) {
                    Collection collection2 = javaClassLocator.getAllClasses(dualFiter);
                    Iterator iterator2 = collection2.iterator();
                    while (n == this._changeId && n2 < 10 && iterator2.hasNext()) {
                        String string3 = (String)iterator2.next();
                        JavaClass javaClass = this._javaManager.getClass(string3);
                        String string4 = javaClass.getName();
                        String string5 = javaClass.getPackageName();
                        if (this._filter != null && !this._filter.acceptClassName(string5, string4)) continue;
                        Entry entry = null;
                        if (javaClass.isInterface()) {
                            if (bl2) {
                                entry = Entry.createInterface(string5, string4);
                            }
                        } else if (bl) {
                            entry = Entry.createClassEntry(string5, string4);
                        }
                        if (entry == null) continue;
                        arrayList.add(entry);
                        ++n2;
                    }
                }
            }
            if (n2 == 10) {
                Entry entry = Entry.createDotDotDotEntry();
                arrayList.add(entry);
            }
            Collections.sort(arrayList);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return arrayList;
    }

    private JavaClassLocator getJavaLocator() {
        if (this._javaClassLocator == null) {
            switch (this._flags & 3) {
                case 2: {
                    this._javaClassLocator = this.getBaseProjectSourcesLocator();
                    break;
                }
                case 1: {
                    Project project = this._context.getProject();
                    BaseClassLocator baseClassLocator = this.getSourceLocator(project);
                    this._javaClassLocator = baseClassLocator;
                    break;
                }
                default: {
                    this._javaClassLocator = this._javaManager.getJavaClassLocator();
                }
            }
        }
        return this._javaClassLocator;
    }

    private ArrayClassLocator getBaseProjectSourcesLocator() {
        Project project = this._context.getProject();
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        hashSet.add(project);
        arrayList.add(project);
        while (!arrayList.isEmpty()) {
            Project project2 = (Project)arrayList.remove(0);
            Iterator iterator = DependencyConfiguration.getInstance((Project)project2).getDependencies();
            while (iterator.hasNext()) {
                Dependable dependable = (Dependable)iterator.next();
                Element element = dependable.getSource();
                if (!(element instanceof Project) || !hashSet.add(element)) continue;
                arrayList.add(element);
            }
        }
        Project[] projectArray = hashSet.toArray(new Project[hashSet.size()]);
        BaseClassLocator[] baseClassLocatorArray = new BaseClassLocator[projectArray.length];
        int n = 0;
        while (n < projectArray.length) {
            Project project3 = projectArray[n];
            baseClassLocatorArray[n] = this.getSourceLocator(project3);
            ++n;
        }
        ArrayClassLocator arrayClassLocator = new ArrayClassLocator(baseClassLocatorArray);
        return arrayClassLocator;
    }

    private BaseClassLocator getSourceLocator(Project project) {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project);
        URLPath uRLPath = pathsConfiguration.getProjectSourcePath();
        BaseClassLocator baseClassLocator = ClassLocatorFactory.getSourceLocator(uRLPath);
        return baseClassLocator;
    }

    private void showPopup() {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this._jList = new JList(this._dataModel);
        this._jList.addListSelectionListener(this._listeners);
        this._jList.setCellRenderer(new 1());
        this._jList.addFocusListener(this._listeners);
        Border border = UIManager.getLookAndFeel().getDefaults().getBorder("ScrollPane.border");
        this._jList.setBorder(border);
        Dimension dimension = this._jList.getPreferredSize();
        dimension.width = this._textField.getWidth();
        this._jList.setPreferredSize(dimension);
        Point point = this._textField.getLocationOnScreen();
        int n = point.x;
        int n2 = point.y + this._textField.getHeight();
        this._popup = popupFactory.getPopup(this._textField, this._jList, n, n2);
        this._popup.show();
    }

    private void closeDropDown() {
        if (this._popup != null) {
            this._updateListOnTextChanges = true;
            this._valueBeforeListUpdate = null;
            this._popup.hide();
            this._jList.removeListSelectionListener(this._listeners);
            this._popup = null;
            this._jList = null;
        }
    }

    private void focusLost(FocusEvent focusEvent) {
        if (this._timer != null) {
            this._timer.stop();
        }
        if (this._jList != null) {
            boolean bl = true;
            Component component = focusEvent.getOppositeComponent();
            if (component != null && SwingUtilities.isDescendingFrom(component, this._jList)) {
                bl = false;
            }
            if (bl) {
                this.closeDropDown();
            }
        }
    }

    private void keyPressed(KeyEvent keyEvent) {
        if (this._jList != null) {
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    keyEvent.consume();
                    int n = this._jList.getSelectedIndex();
                    int n2 = n + 1;
                    int n3 = this._dataModel.getSize();
                    if (n2 < n3) {
                        this._jList.ensureIndexIsVisible(n2);
                        this._jList.setSelectedIndex(n2);
                        break;
                    }
                    if (n3 <= 0) break;
                    this._jList.ensureIndexIsVisible(0);
                    this._jList.setSelectedIndex(0);
                    break;
                }
                case 38: {
                    keyEvent.consume();
                    int n = this._jList.getSelectedIndex();
                    int n4 = n - 1;
                    if (n4 >= 0) {
                        this._jList.ensureIndexIsVisible(n4);
                        this._jList.setSelectedIndex(n4);
                        break;
                    }
                    if (this._dataModel.isEmpty()) break;
                    int n5 = this._dataModel.size() - 1;
                    this._jList.ensureIndexIsVisible(n5);
                    this._jList.setSelectedIndex(n5);
                    break;
                }
                case 27: {
                    if (this._popup == null) break;
                    keyEvent.consume();
                    String string = this._valueBeforeListUpdate;
                    this.closeDropDown();
                    if (string == null) break;
                    this._updateListOnTextChanges = false;
                    this._textField.setText(string);
                    this._updateListOnTextChanges = true;
                    break;
                }
                case 10: {
                    int n;
                    if (this._popup == null) break;
                    keyEvent.consume();
                    if (!this._textExists && (n = this._dataModel.getSize()) == 1) {
                        Entry entry = (Entry)this._dataModel.get(0);
                        String string = entry.getFullName();
                        this._updateListOnTextChanges = false;
                        this._textField.setText(string);
                        this._updateListOnTextChanges = true;
                    }
                    this.closeDropDown();
                }
            }
        }
    }

    private void valueChanged(ListSelectionEvent listSelectionEvent) {
        Entry entry;
        if (!listSelectionEvent.getValueIsAdjusting() && (entry = (Entry)this._jList.getSelectedValue()) != null && entry.getType() != 20) {
            if (this._valueBeforeListUpdate == null) {
                this._valueBeforeListUpdate = this._textField.getText();
            }
            this._updateListOnTextChanges = false;
            this._textField.setText(entry.getFullName());
            this._updateListOnTextChanges = true;
        }
    }

    static int ra$_changeId(TextFieldAdapter textFieldAdapter) {
        return textFieldAdapter._changeId;
    }

    static void wa$_changeId(TextFieldAdapter textFieldAdapter, int n) {
        textFieldAdapter._changeId = n;
    }

    static JTextField ra$_textField(TextFieldAdapter textFieldAdapter) {
        return textFieldAdapter._textField;
    }

    static ArrayList mav$getEntries(TextFieldAdapter textFieldAdapter, int n) {
        return textFieldAdapter.getEntries(n);
    }

    static void mav$closeDropDown(TextFieldAdapter textFieldAdapter) {
        textFieldAdapter.closeDropDown();
    }

    static void mav$updateList(TextFieldAdapter textFieldAdapter, ArrayList arrayList) {
        textFieldAdapter.updateList(arrayList);
    }

    static void mav$whenTimerKiks(TextFieldAdapter textFieldAdapter) {
        textFieldAdapter.whenTimerKiks();
    }

    static void mav$valueChanged(TextFieldAdapter textFieldAdapter, ListSelectionEvent listSelectionEvent) {
        textFieldAdapter.valueChanged(listSelectionEvent);
    }

    static void mav$keyPressed(TextFieldAdapter textFieldAdapter, KeyEvent keyEvent) {
        textFieldAdapter.keyPressed(keyEvent);
    }

    static void mav$focusLost(TextFieldAdapter textFieldAdapter, FocusEvent focusEvent) {
        textFieldAdapter.focusLost(focusEvent);
    }

    static void mav$updateDropDown(TextFieldAdapter textFieldAdapter) {
        textFieldAdapter.updateDropDown();
    }

    public final class 2
    extends Thread {
        public void run() {
            TextFieldAdapter textFieldAdapter = TextFieldAdapter.this;
            int n = TextFieldAdapter.ra$_changeId(textFieldAdapter) + 1;
            TextFieldAdapter.wa$_changeId(textFieldAdapter, n);
            int n2 = n;
            String string = TextFieldAdapter.ra$_textField(TextFieldAdapter.this).getText();
            if (string.length() >= 2) {
                ArrayList arrayList = TextFieldAdapter.mav$getEntries(TextFieldAdapter.this, n2);
                SwingUtilities.invokeLater(new 1(this, n2, arrayList));
            } else {
                TextFieldAdapter.mav$closeDropDown(TextFieldAdapter.this);
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ int v$changeId;
            private final /* synthetic */ ArrayList v$entries;
            final /* synthetic */ 2 this$0;

            public void run() {
                if (this.v$changeId == TextFieldAdapter.ra$_changeId(this.this$0.TextFieldAdapter.this)) {
                    TextFieldAdapter.mav$updateList(this.this$0.TextFieldAdapter.this, this.v$entries);
                }
            }

            public 1(2 var1_1, int n, ArrayList arrayList) {
                this.v$entries = arrayList;
                this.v$changeId = n;
                this.this$0 = var1_1;
            }
        }
    }

    public final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Entry entry = (Entry)object;
            this.setIcon(entry.getIcon());
            return component;
        }
    }

    private class Listeners
    implements ActionListener,
    ListSelectionListener,
    KeyListener,
    FocusListener,
    DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            TextFieldAdapter.mav$updateDropDown(TextFieldAdapter.this);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            TextFieldAdapter.mav$updateDropDown(TextFieldAdapter.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TextFieldAdapter.mav$updateDropDown(TextFieldAdapter.this);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            TextFieldAdapter.mav$focusLost(TextFieldAdapter.this, focusEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            TextFieldAdapter.mav$keyPressed(TextFieldAdapter.this, keyEvent);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TextFieldAdapter.mav$valueChanged(TextFieldAdapter.this, listSelectionEvent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextFieldAdapter.mav$whenTimerKiks(TextFieldAdapter.this);
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

