/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import oracle.ide.Ide;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.dialogs.ClassPackageNamePrefixFilter;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;
import oracle.jdevimpl.java.JavaArb;

public final class BrowseHandler {
    private final boolean USE_POPUP_WINDOW;
    private JList resultsList;
    private JTextField browseField;
    private ActionListener clientListener;
    private ListGestureHandler listBrowseListener;
    private PopupGestureHandler popupGestureHandler;
    private ClassNameFilter classFilter;
    private PackageNameFilter packageFilter;
    private JWindow popupWindow;
    private ListInsightView popupList;
    private BrowseTask browseTask;
    private PopulateTask populateTask;
    private Map brPackageMap;
    private Set brPackageSet;
    private JavaManager brJavaManager;
    private int classOrPackage;
    private FoundItem lastDefaultItem;
    private boolean pendingLookup;
    private boolean inNavigation;
    private int lastLength;
    private boolean gotLonger;
    private AsyncScheduler brScheduler;
    private static final boolean CHECK_FOR_INTERFACE = false;
    private static final int PACKAGE_ONLY = 1;
    private static final int CLASS_ONLY = 2;
    private static final int CLASS_AND_PACKAGE = 3;
    static final String EMPTY_LIST_ITEM = DialogsArb.getString(12);
    private static final DefaultListModel EMPTY_LIST_MODEL = new DefaultListModel();
    static final String PROGRESS_LIST_ITEM = DialogsArb.getString(13);
    private static final DefaultListModel PROGRESS_LIST_MODEL = new DefaultListModel();
    private static final int PACKAGE_ITEM = 1;
    private static final int UNQ_CLASS_ITEM = 2;
    private static final int UNQ_INTERFACE_ITEM = 4;
    private static final int FQ_CLASS_ITEM = 3;
    private static final int FQ_INTERFACE_ITEM = 5;
    private static final int MIN_PREFIX_LEN = 1;

    public static BrowseHandler createClassBrowserPopup(JavaManager javaManager, JTextField jTextField, ActionListener actionListener) {
        return new BrowseHandler(true, javaManager, jTextField, actionListener, null, 2, null, null);
    }

    public static BrowseHandler createPackageBrowserPopup(JavaManager javaManager, JTextField jTextField, ActionListener actionListener) {
        return new BrowseHandler(true, javaManager, jTextField, actionListener, null, 1, null, null);
    }

    public static BrowseHandler createClassPackageBrowserPopup(JavaManager javaManager, JTextField jTextField, ActionListener actionListener) {
        return new BrowseHandler(true, javaManager, jTextField, actionListener, null, 3, null, null);
    }

    public static BrowseHandler createClassBrowserList(JavaManager javaManager, JTextField jTextField, JList jList) {
        return new BrowseHandler(false, javaManager, jTextField, null, jList, 2, null, null);
    }

    public static BrowseHandler createClassBrowserList(JavaManager javaManager, JTextField jTextField, JList jList, ClassNameFilter classNameFilter) {
        return new BrowseHandler(false, javaManager, jTextField, null, jList, 2, classNameFilter, null);
    }

    public static BrowseHandler createPackageBrowserList(JavaManager javaManager, JTextField jTextField, JList jList) {
        return new BrowseHandler(false, javaManager, jTextField, null, jList, 1, null, null);
    }

    public static BrowseHandler createPackageBrowserList(JavaManager javaManager, JTextField jTextField, JList jList, PackageNameFilter packageNameFilter) {
        return new BrowseHandler(false, javaManager, jTextField, null, jList, 1, null, packageNameFilter);
    }

    public static BrowseHandler createClassPackageBrowserList(JavaManager javaManager, JTextField jTextField, JList jList) {
        return new BrowseHandler(false, javaManager, jTextField, null, jList, 3, null, null);
    }

    public static BrowseHandler createClassPackageBrowserList(JavaManager javaManager, JTextField jTextField, JList jList, ClassNameFilter classNameFilter, PackageNameFilter packageNameFilter) {
        return new BrowseHandler(false, javaManager, jTextField, null, jList, 3, classNameFilter, packageNameFilter);
    }

    private BrowseHandler(boolean bl, JavaManager javaManager, JTextField jTextField, ActionListener actionListener, JList jList, int n, ClassNameFilter classNameFilter, PackageNameFilter packageNameFilter) {
        this.$init$();
        this.USE_POPUP_WINDOW = bl;
        if (javaManager == null) {
            throw new IllegalArgumentException("The JavaManager cannot be null.");
        }
        if (this.USE_POPUP_WINDOW) {
            if (jTextField == null) {
                throw new IllegalArgumentException("The text field cannot be null.");
            }
        } else if (jList == null) {
            throw new IllegalArgumentException("The list cannot be null.");
        }
        this.brJavaManager = javaManager;
        this.browseField = jTextField;
        this.clientListener = actionListener;
        this.resultsList = jList;
        this.classOrPackage = n;
        this.initializeFilters(classNameFilter, packageNameFilter);
        if (this.resultsList != null) {
            this.resultsList.setModel(EMPTY_LIST_MODEL);
            if (EMPTY_LIST_MODEL.size() == 0) {
                EMPTY_LIST_MODEL.addElement(EMPTY_LIST_ITEM);
            }
            if (PROGRESS_LIST_MODEL.size() == 0) {
                PROGRESS_LIST_MODEL.addElement(PROGRESS_LIST_ITEM);
            }
        }
        this.schedulePopulate();
        if (this.USE_POPUP_WINDOW) {
            Caret caret = jTextField.getCaret();
            DefaultCaret defaultCaret = new DefaultCaret();
            defaultCaret.setBlinkRate(caret.getBlinkRate());
            jTextField.setCaret(defaultCaret);
            this.browseField.addCaretListener(this.getPopupGestureHandler());
            this.browseField.addKeyListener(this.getPopupGestureHandler());
            this.browseField.addFocusListener(this.getPopupGestureHandler());
        } else {
            this.browseField.getDocument().addDocumentListener(this.getListGestureHandler());
        }
    }

    void $init$() {
        this.pendingLookup = false;
        this.inNavigation = false;
        this.lastLength = 0;
        this.gotLonger = false;
        this.brScheduler = new AsyncScheduler("BrowseHandlerBrowser", 10000);
    }

    public void dispose() {
        this.cancelLookup();
        this.cancelPopulate();
        if (this.popupList != null) {
            this.popupList.removeListSelectionListener((ListSelectionListener)this.getPopupGestureHandler());
            this.popupList.removeMouseListener((MouseListener)this.getPopupGestureHandler());
            this.popupList = null;
        }
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
        if (this.resultsList != null) {
            this.browseField.getDocument().removeDocumentListener(this.getListGestureHandler());
            this.resultsList = null;
        }
        if (this.browseField != null) {
            this.browseField.removeCaretListener(this.getPopupGestureHandler());
            this.browseField.removeKeyListener(this.getPopupGestureHandler());
            this.browseField.removeFocusListener(this.getPopupGestureHandler());
            this.browseField = null;
        }
    }

    public String getSelectedItem() {
        if (this.lastDefaultItem != null) {
            return FoundItem.ra$name(this.lastDefaultItem);
        }
        if (this.browseField != null) {
            return this.browseField.getText();
        }
        return null;
    }

    void doLookup(String string) {
        this.scheduleLookup(string);
    }

    private void initializeFilters(ClassNameFilter classNameFilter, PackageNameFilter packageNameFilter) {
        if (classNameFilter == null || packageNameFilter == null) {
            ClassPackageNamePrefixFilter classPackageNamePrefixFilter = new ClassPackageNamePrefixFilter();
            this.classFilter = classNameFilter != null ? classNameFilter : classPackageNamePrefixFilter;
            this.packageFilter = packageNameFilter != null ? packageNameFilter : classPackageNamePrefixFilter;
        } else {
            this.classFilter = classNameFilter;
            this.packageFilter = packageNameFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLookup(String string) {
        if (!this.populateTask.isFinished()) {
            return;
        }
        BrowseTask browseTask = new BrowseTask(string, null);
        BrowseHandler browseHandler = this;
        synchronized (browseHandler) {
            if (this.browseTask != null) {
                this.brScheduler.cancelTask((AsyncTask)this.browseTask);
            }
            this.browseTask = browseTask;
        }
        this.brScheduler.scheduleTask((AsyncTask)browseTask);
        this.pendingLookup = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLookup() {
        BrowseTask browseTask;
        BrowseHandler browseHandler = this;
        synchronized (browseHandler) {
            browseTask = this.browseTask;
            this.browseTask = null;
        }
        if (browseTask != null) {
            this.brScheduler.cancelTask((AsyncTask)browseTask);
        }
        this.pendingLookup = false;
    }

    private void schedulePopulate() {
        this.populateTask = new PopulateTask(null);
        this.brScheduler.scheduleTask((AsyncTask)this.populateTask);
    }

    private void cancelPopulate() {
        this.brScheduler.cancelTask((AsyncTask)this.populateTask);
    }

    private void updatePopup() {
        if (this.browseField == null || !this.browseField.isVisible() || !this.browseField.hasFocus()) {
            return;
        }
        int n = this.browseField.getCaretPosition();
        if (n >= 1) {
            String string = this.browseField.getText().substring(0, n);
            this.scheduleLookup(string);
        } else {
            this.hidePopup();
        }
    }

    private void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    private void displayResults(FoundData foundData) {
        if (this.USE_POPUP_WINDOW) {
            if (this.browseField == null || !this.browseField.isVisible()) {
                return;
            }
            if (this.popupWindow == null) {
                this.popupList = new ListInsightView((ListCellRenderer)((Object)new FoundRenderer(null)));
                this.popupList.addListSelectionListener((ListSelectionListener)this.getPopupGestureHandler());
                this.popupList.addMouseListener((MouseListener)this.getPopupGestureHandler());
                this.popupList.setData((InsightData)foundData);
                JScrollPane jScrollPane = new JScrollPane((Component)this.popupList);
                jScrollPane.setHorizontalScrollBarPolicy(31);
                Window window = SwingUtilities.getWindowAncestor(this.browseField);
                this.popupWindow = new JWindow(window);
                this.popupWindow.getContentPane().add(jScrollPane);
                this.popupWindow.setFocusableWindowState(false);
            } else {
                this.popupList.setData((InsightData)foundData);
            }
            if (!this.popupWindow.isVisible()) {
                Point point = this.browseField.getLocationOnScreen();
                point.y += this.browseField.getHeight() + 2;
                this.popupWindow.setLocation(point);
            }
            if (foundData.getData().length == 0) {
                this.lastDefaultItem = null;
                this.popupWindow.setVisible(false);
            } else {
                this.inNavigation = true;
                this.popupList.selectDefault();
                this.inNavigation = false;
                this.lastDefaultItem = (FoundItem)((Object)foundData.getDefault());
                if (this.gotLonger) {
                    String string = this.browseField.getText();
                    String string2 = this.lastDefaultItem.getName();
                    this.inNavigation = true;
                    int n = Math.min(string.length(), string2.length());
                    int n2 = string2.length();
                    this.browseField.setText(string2);
                    this.browseField.setCaretPosition(n2);
                    this.browseField.moveCaretPosition(n);
                    this.inNavigation = false;
                }
                this.popupWindow.pack();
                this.popupWindow.setVisible(true);
            }
        } else {
            ListModel listModel = foundData.getListModel();
            if (listModel.getSize() > 0) {
                this.resultsList.setModel(listModel);
                this.resultsList.setSelectedIndex(0);
            } else {
                this.resultsList.setModel(EMPTY_LIST_MODEL);
            }
        }
        this.pendingLookup = false;
    }

    private void populateFinished(Map map, Set set) {
        this.brPackageMap = map;
        this.brPackageSet = set;
        1 var3_3 = new 1();
        SwingUtilities.invokeLater(var3_3);
    }

    private PopupGestureHandler getPopupGestureHandler() {
        if (this.popupGestureHandler == null) {
            this.popupGestureHandler = new PopupGestureHandler(null);
        }
        return this.popupGestureHandler;
    }

    private ListGestureHandler getListGestureHandler() {
        if (this.listBrowseListener == null) {
            this.listBrowseListener = new ListGestureHandler(null);
        }
        return this.listBrowseListener;
    }

    static void mav$updatePopup(BrowseHandler browseHandler) {
        browseHandler.updatePopup();
    }

    static JavaManager ra$brJavaManager(BrowseHandler browseHandler) {
        return browseHandler.brJavaManager;
    }

    static ClassNameFilter ra$classFilter(BrowseHandler browseHandler) {
        return browseHandler.classFilter;
    }

    static Map ra$brPackageMap(BrowseHandler browseHandler) {
        return browseHandler.brPackageMap;
    }

    static int ra$classOrPackage(BrowseHandler browseHandler) {
        return browseHandler.classOrPackage;
    }

    static PackageNameFilter ra$packageFilter(BrowseHandler browseHandler) {
        return browseHandler.packageFilter;
    }

    static Set ra$brPackageSet(BrowseHandler browseHandler) {
        return browseHandler.brPackageSet;
    }

    static JList ra$resultsList(BrowseHandler browseHandler) {
        return browseHandler.resultsList;
    }

    static DefaultListModel ra$EMPTY_LIST_MODEL() {
        return EMPTY_LIST_MODEL;
    }

    static void mav$displayResults(BrowseHandler browseHandler, FoundData foundData) {
        browseHandler.displayResults(foundData);
    }

    static void mav$populateFinished(BrowseHandler browseHandler, Map map, Set set) {
        browseHandler.populateFinished(map, set);
    }

    static JTextField ra$browseField(BrowseHandler browseHandler) {
        return browseHandler.browseField;
    }

    static DefaultListModel ra$PROGRESS_LIST_MODEL() {
        return PROGRESS_LIST_MODEL;
    }

    static void mav$scheduleLookup(BrowseHandler browseHandler, String string) {
        browseHandler.scheduleLookup(string);
    }

    static void mav$cancelLookup(BrowseHandler browseHandler) {
        browseHandler.cancelLookup();
    }

    static boolean ra$inNavigation(BrowseHandler browseHandler) {
        return browseHandler.inNavigation;
    }

    static ListInsightView ra$popupList(BrowseHandler browseHandler) {
        return browseHandler.popupList;
    }

    static void wa$lastDefaultItem(BrowseHandler browseHandler, FoundItem foundItem) {
        browseHandler.lastDefaultItem = foundItem;
    }

    static FoundItem ra$lastDefaultItem(BrowseHandler browseHandler) {
        return browseHandler.lastDefaultItem;
    }

    static void wa$inNavigation(BrowseHandler browseHandler, boolean bl) {
        browseHandler.inNavigation = bl;
    }

    static ActionListener ra$clientListener(BrowseHandler browseHandler) {
        return browseHandler.clientListener;
    }

    static boolean ra$pendingLookup(BrowseHandler browseHandler) {
        return browseHandler.pendingLookup;
    }

    static JWindow ra$popupWindow(BrowseHandler browseHandler) {
        return browseHandler.popupWindow;
    }

    static void mav$hidePopup(BrowseHandler browseHandler) {
        browseHandler.hidePopup();
    }

    static int ra$lastLength(BrowseHandler browseHandler) {
        return browseHandler.lastLength;
    }

    static void wa$gotLonger(BrowseHandler browseHandler, boolean bl) {
        browseHandler.gotLonger = bl;
    }

    static void wa$lastLength(BrowseHandler browseHandler, int n) {
        browseHandler.lastLength = n;
    }

    public final class 1
    implements Runnable {
        public void run() {
            try {
                Thread.sleep(25);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            BrowseHandler.mav$updatePopup(BrowseHandler.this);
        }
    }

    private final class BrowseTask
    extends AsyncTask {
        private String brText;
        private boolean brCancelled;

        private BrowseTask(String string) {
            this.$init$();
            this.brText = string;
        }

        void $init$() {
            this.brCancelled = false;
        }

        protected void requestCancelImpl() {
            this.brCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.brCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            if (this.brText == null || this.brText.length() == 0) {
                BrowseHandler.ra$resultsList(BrowseHandler.this).setModel(BrowseHandler.ra$EMPTY_LIST_MODEL());
                return null;
            }
            BrowseTask.sleep((int)10);
            this.bailIfCancelled();
            Map map = BrowseHandler.ra$brPackageMap(BrowseHandler.this);
            if (map == null) {
                BrowseHandler.ra$resultsList(BrowseHandler.this).setModel(BrowseHandler.ra$EMPTY_LIST_MODEL());
                return null;
            }
            ArrayList arrayList = new ArrayList();
            this.taskMatchClassOrPackage(this.brText, arrayList);
            int n = arrayList.size();
            FoundItem[] foundItemArray = arrayList.toArray(new FoundItem[n]);
            FoundData foundData = new FoundData(foundItemArray, this.brText, null);
            1 var6_6 = new 1(this, foundData);
            SwingUtilities.invokeLater(var6_6);
            return foundData;
        }

        private void taskMatchClassOrPackage(String string, List list) throws AsyncTask.CancelledException {
            boolean bl;
            Map map = BrowseHandler.ra$brPackageMap(BrowseHandler.this);
            if ((BrowseHandler.ra$classOrPackage(BrowseHandler.this) & 1) > 0) {
                BrowseHandler.ra$packageFilter(BrowseHandler.this).setMatchName(string);
                Set set = BrowseHandler.ra$brPackageSet(BrowseHandler.this);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.bailIfCancelled();
                    String string2 = iterator.next().toString();
                    if (!BrowseHandler.ra$packageFilter(BrowseHandler.this).acceptPackageName(string2)) continue;
                    list.add(new FoundItem(string2, 1, null));
                }
            }
            boolean bl2 = bl = string.indexOf(46) != -1;
            if ((BrowseHandler.ra$classOrPackage(BrowseHandler.this) & 2) > 0) {
                BrowseHandler.ra$classFilter(BrowseHandler.this).setMatchName(string);
                if (bl) {
                    int n = string.lastIndexOf(46);
                    String string3 = string.substring(0, n);
                    String[] stringArray = (String[])map.get(string3);
                    this.addMatchingClasses(stringArray, string3, list, bl);
                } else {
                    Set set = map.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        this.bailIfCancelled();
                        String string4 = iterator.next().toString();
                        String[] stringArray = (String[])map.get(string4);
                        this.addMatchingClasses(stringArray, string4, list, bl);
                    }
                }
                if (map.containsKey(string)) {
                    if ((BrowseHandler.ra$classOrPackage(BrowseHandler.this) & 2) > 0) {
                        BrowseHandler.ra$classFilter(BrowseHandler.this).setMatchName(string + ".");
                    }
                    String[] stringArray = (String[])map.get(string);
                    this.addMatchingClasses(stringArray, string, list, true);
                }
            }
        }

        private void addMatchingClasses(String[] stringArray, String string, List list, boolean bl) throws AsyncTask.CancelledException {
            int n = stringArray != null ? stringArray.length : 0;
            int n2 = 0;
            while (n2 < n) {
                this.bailIfCancelled();
                String string2 = stringArray[n2];
                if (BrowseHandler.ra$classFilter(BrowseHandler.this).acceptClassName(string2, string)) {
                    String string3;
                    String string4 = string3 = string.length() > 0 ? string + "." + string2 : string2;
                    int n3 = this.isInterface(string3) ? (bl ? 5 : 4) : (bl ? 3 : 2);
                    list.add(new FoundItem(string3, n3, null));
                }
                ++n2;
            }
        }

        private boolean checkForInterface() {
            return false;
        }

        private boolean isInterface(String string) {
            if (!this.checkForInterface()) {
                return false;
            }
            JavaManager javaManager = BrowseHandler.ra$brJavaManager(BrowseHandler.this);
            JavaClass javaClass = javaManager.getClass(string);
            if (javaClass != null) {
                return javaClass.isInterface();
            }
            return false;
        }

        BrowseTask(String string, 1 var3_3) {
            this(string);
        }

        static boolean ra$brCancelled(BrowseTask browseTask) {
            return browseTask.brCancelled;
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ FoundData v$data;
            final /* synthetic */ BrowseTask this$0;

            public void run() {
                if (!BrowseTask.ra$brCancelled(this.this$0)) {
                    BrowseHandler.mav$displayResults(this.this$0.BrowseHandler.this, this.v$data);
                }
            }

            public 1(BrowseTask browseTask, FoundData foundData) {
                this.v$data = foundData;
                this.this$0 = browseTask;
            }
        }
    }

    private final class PopulateTask
    extends AsyncTask {
        private boolean popCancelled;

        void $init$() {
            this.popCancelled = false;
        }

        protected void requestCancelImpl() {
            this.popCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.popCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            JavaManager javaManager = BrowseHandler.ra$brJavaManager(BrowseHandler.this);
            String string = JavaArb.getString(12);
            Ide.getStatusBar().setText(string);
            try {
                JavaClassLocator javaClassLocator = javaManager.getJavaClassLocator();
                Collection collection = javaClassLocator.getAllClasses();
                HashMap<String, Set> hashMap = new HashMap<String, Set>(500);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    this.bailIfCancelled();
                    String string3 = iterator.next().toString();
                    int n = string3.lastIndexOf(46);
                    String string4 = n == -1 ? "" : string3.substring(0, n);
                    String string5 = string2 = n == -1 ? string3 : string3.substring(n + 1);
                    if (string2.length() <= 0) continue;
                    Set set = (Set)hashMap.get(string4);
                    if (set == null) {
                        set = new ArraySortedSet(100);
                        hashMap.put(string4, set);
                    }
                    set.add(string2);
                }
                HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>(hashMap.size());
                Iterator iterator2 = hashMap.keySet().iterator();
                while (iterator2.hasNext()) {
                    int n;
                    String string6 = iterator2.next().toString();
                    Set set = (Set)hashMap.get(string6);
                    int n2 = n = set == null ? 0 : set.size();
                    if (n <= 0) continue;
                    String[] stringArray = set.toArray(new String[n]);
                    hashMap2.put(string6, stringArray);
                }
                BrowseHandler.mav$populateFinished(BrowseHandler.this, hashMap2, hashMap2.keySet());
                HashMap<String, String[]> hashMap3 = hashMap2;
                String string7 = Ide.getStatusBar().getText();
                if (string7.equals(string)) {
                    Ide.getStatusBar().setText("");
                }
                return hashMap3;
            }
            catch (Throwable throwable) {
                String string8 = Ide.getStatusBar().getText();
                if (string8.equals(string)) {
                    Ide.getStatusBar().setText("");
                }
                throw throwable;
            }
        }

        private PopulateTask() {
            this.$init$();
        }

        PopulateTask(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class FoundItem
    extends ListDataItem {
        private int type;
        private String name;
        private String display;
        private static final String[] PRIO_PKGS = new String[]{"java.lang.", "java.util", "java.", "javax."};

        private FoundItem(String string, int n) {
            this.type = n;
            this.name = string;
        }

        public Icon getIcon() {
            switch (this.type) {
                case 1: {
                    return JavaIcons.getIcon(5);
                }
                case 2: 
                case 3: {
                    return JavaIcons.getIcon(0);
                }
                case 4: 
                case 5: {
                    return JavaIcons.getIcon(1);
                }
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public String getDisplayText() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            if (this.display == null) {
                String string;
                String string2;
                int n = this.name.lastIndexOf(46);
                if (n == -1) {
                    string2 = "";
                    string = this.name;
                } else {
                    string2 = this.name.substring(0, n);
                    string = this.name.substring(n + 1);
                }
                this.display = string2.length() > 0 ? string + " ( " + string2 + " )" : string;
            }
            return this.display;
        }

        public String getName() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            int n = this.name.lastIndexOf(46);
            return n != -1 ? this.name.substring(n + 1) : this.name;
        }

        private String getPackage() {
            int n = this.name.lastIndexOf(46);
            return n != -1 ? this.name.substring(0, n) : this.name;
        }

        public int compareTo(Object object) {
            String string;
            FoundItem foundItem = (FoundItem)((Object)object);
            String string2 = this.getName();
            if (string2.equalsIgnoreCase(string = foundItem.getName())) {
                int n = this.type;
                int n2 = foundItem.type;
                if ((n == 1 || n2 == 1) && n != n2) {
                    return n - n2;
                }
                if (!(n != 2 && n != 4 || n2 != 2 && n2 != 4)) {
                    int n3;
                    String string3 = this.getPackage();
                    String string4 = foundItem.getPackage();
                    int n4 = FoundItem.getPackagePriority(string3);
                    if (n4 != (n3 = FoundItem.getPackagePriority(string4))) {
                        return n4 - n3;
                    }
                }
            }
            String string5 = this.getDisplayText();
            String string6 = foundItem.getDisplayText();
            return FoundItem.compareInsensitive((String)string5, (String)string6);
        }

        private static int getPackagePriority(String string) {
            int n = 0;
            while (n < PRIO_PKGS.length) {
                String string2 = PRIO_PKGS[n];
                if (string.startsWith(string2)) {
                    return n;
                }
                ++n;
            }
            return PRIO_PKGS.length;
        }

        static String ra$name(FoundItem foundItem) {
            return foundItem.name;
        }

        FoundItem(String string, int n, 1 var3_3) {
            this(string, n);
        }

        static int ra$type(FoundItem foundItem) {
            return foundItem.type;
        }

        public final class 1 {
        }
    }

    private static final class FoundData
    implements ListInsightData {
        private FoundItem[] items;
        private ListDataItemListModel model;
        private String prefix;

        private FoundData(FoundItem[] foundItemArray, String string) {
            this.items = foundItemArray;
            this.prefix = string;
        }

        public ListModel getListModel() {
            if (this.model == null) {
                this.model = new ListDataItemListModel((ListDataItem[])this.items);
            }
            return this.model;
        }

        public Object[] getData() {
            return this.items;
        }

        public Object[] getMatchingData() {
            return this.items;
        }

        public int getMatchingDataCount() {
            return this.items.length;
        }

        public Object getDefault() {
            this.getListModel();
            return this.model.findClosestDataItem(this.prefix);
        }

        public boolean complete(Object object) {
            return false;
        }

        public void partialComplete() {
        }

        FoundData(FoundItem[] foundItemArray, String string, 1 var3_3) {
            this(foundItemArray, string);
        }

        public final class 1 {
        }
    }

    private static final class FoundRenderer
    extends ListDataItemCellRenderer {
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Dimension dimension2 = new Dimension(Math.max(dimension.width, 200), dimension.height);
            return dimension2;
        }

        private FoundRenderer() {
        }

        FoundRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListGestureHandler
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            this.lookup();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.lookup();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void lookup() {
            String string = BrowseHandler.ra$browseField(BrowseHandler.this).getText().trim();
            if (string.length() >= 1) {
                BrowseHandler.ra$resultsList(BrowseHandler.this).setModel(BrowseHandler.ra$PROGRESS_LIST_MODEL());
                BrowseHandler.mav$scheduleLookup(BrowseHandler.this, string);
            } else {
                BrowseHandler.ra$resultsList(BrowseHandler.this).setModel(BrowseHandler.ra$EMPTY_LIST_MODEL());
                BrowseHandler.mav$cancelLookup(BrowseHandler.this);
            }
        }

        private ListGestureHandler() {
        }

        ListGestureHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PopupGestureHandler
    implements MouseListener,
    ListSelectionListener,
    KeyListener,
    FocusListener,
    CaretListener {
        public void caretUpdate(CaretEvent caretEvent) {
            if (!BrowseHandler.ra$inNavigation(BrowseHandler.this)) {
                this.caretChanged();
            }
        }

        private void caretChanged() {
            if (BrowseHandler.ra$browseField(BrowseHandler.this) != null) {
                int n = BrowseHandler.ra$browseField(BrowseHandler.this).getText().length();
                BrowseHandler.wa$gotLonger(BrowseHandler.this, n > BrowseHandler.ra$lastLength(BrowseHandler.this));
                BrowseHandler.wa$lastLength(BrowseHandler.this, n);
                BrowseHandler.mav$updatePopup(BrowseHandler.this);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (BrowseHandler.ra$popupWindow(BrowseHandler.this) != null && !BrowseHandler.ra$popupWindow(BrowseHandler.this).isVisible()) {
                BrowseHandler.mav$updatePopup(BrowseHandler.this);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                BrowseHandler.mav$hidePopup(BrowseHandler.this);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (!(BrowseHandler.ra$pendingLookup(BrowseHandler.this) || BrowseHandler.ra$popupWindow(BrowseHandler.this) != null && BrowseHandler.ra$popupWindow(BrowseHandler.this).isVisible())) {
                return;
            }
            switch (n) {
                case 10: {
                    if (BrowseHandler.ra$pendingLookup(BrowseHandler.this)) {
                        keyEvent.consume();
                    }
                    return;
                }
                default: {
                    return;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 38: 
                case 40: 
            }
            if (BrowseHandler.ra$pendingLookup(BrowseHandler.this)) {
                keyEvent.consume();
                return;
            }
            try {
                BrowseHandler.wa$inNavigation(BrowseHandler.this, true);
                switch (n) {
                    default: {
                        throw new IllegalStateException("unexpected key: " + n);
                    }
                    case 40: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).down();
                        break;
                    }
                    case 38: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).up();
                        break;
                    }
                    case 34: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).pageDown();
                        break;
                    }
                    case 33: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).pageUp();
                        break;
                    }
                    case 36: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).begin();
                        break;
                    }
                    case 35: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).end();
                        break;
                    }
                }
            }
            finally {
                BrowseHandler.wa$inNavigation(BrowseHandler.this, false);
            }
            BrowseHandler.wa$lastDefaultItem(BrowseHandler.this, (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue()));
            BrowseHandler.wa$inNavigation(BrowseHandler.this, true);
            String string = BrowseHandler.ra$lastDefaultItem(BrowseHandler.this).getName();
            BrowseHandler.ra$browseField(BrowseHandler.this).setText(string);
            BrowseHandler.wa$inNavigation(BrowseHandler.this, false);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                FoundItem foundItem;
                if (BrowseHandler.ra$popupList(BrowseHandler.this) != null && (foundItem = (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue())) != null && FoundItem.ra$type(foundItem) == 1) {
                    String string = (BrowseHandler.ra$classOrPackage(BrowseHandler.this) & 2) == 0 ? BrowseHandler.ra$lastDefaultItem(BrowseHandler.this).getName() : BrowseHandler.ra$lastDefaultItem(BrowseHandler.this).getName() + ".";
                    BrowseHandler.ra$browseField(BrowseHandler.this).setText(string);
                    return;
                }
                if (BrowseHandler.ra$clientListener(BrowseHandler.this) != null) {
                    ActionEvent actionEvent = new ActionEvent(this, 1001, null);
                    BrowseHandler.ra$clientListener(BrowseHandler.this).actionPerformed(actionEvent);
                }
                mouseEvent.consume();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!BrowseHandler.ra$inNavigation(BrowseHandler.this) && BrowseHandler.ra$popupList(BrowseHandler.this) != null) {
                BrowseHandler.wa$lastDefaultItem(BrowseHandler.this, (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue()));
                if (BrowseHandler.ra$lastDefaultItem(BrowseHandler.this) != null) {
                    BrowseHandler.wa$inNavigation(BrowseHandler.this, true);
                    String string = BrowseHandler.ra$lastDefaultItem(BrowseHandler.this).getName();
                    if (!BrowseHandler.ra$browseField(BrowseHandler.this).getText().equals(string)) {
                        BrowseHandler.ra$browseField(BrowseHandler.this).setText(string);
                    }
                    BrowseHandler.wa$inNavigation(BrowseHandler.this, false);
                }
            }
        }

        private PopupGestureHandler() {
        }

        PopupGestureHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

