/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilter2V2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageSearchPanel;
import oracle.jdeveloper.dialogs.ClassPackageTreePanel;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.dialogs.DlgArb;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.PatternMatchNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageBrowserV2
extends JPanel
implements ItemListener,
ClassPackageBrowserContext {
    JTabbedPane tabControl;
    JLabel filterLabel;
    DefaultComboBoxModel filterModel;
    JComboBox filterCombo;
    JDevDialogHeader header;
    BorderLayout borderLayout;
    private int _classPackageMode;
    private JavaManager _javaManager;
    private JEWTDialog _dlg;
    private String _title;
    private Component _hostParent;
    private CompoundFilter _classFilter;
    private CompoundFilter _packageFilter;
    private ClassPackageView[] tabs;
    private static int activeTab = 0;
    private static final ClassPackageBrowserFilter2V2 _defaultFilter = new DefaultFilter(null);
    public static final int PACKAGE_ONLY = 1;
    public static final int CLASS_ONLY = 2;
    public static final int CLASS_AND_PACKAGE = 3;
    public static final String PACKAGE_TITLE = DialogsArb.getString(0);
    public static final String CLASS_TITLE = DialogsArb.getString(1);
    public static final String CLASS_PACKAGE_TITLE = DialogsArb.getString(2);

    void $init$() {
        this.tabControl = new JTabbedPane();
        this.filterLabel = new JLabel();
        this.filterModel = new DefaultComboBoxModel();
        this.filterCombo = new JComboBox(this.filterModel);
        this.header = new JDevDialogHeader();
        this.borderLayout = new BorderLayout(0, 10);
        this._classPackageMode = 3;
        this._classFilter = new CompoundFilter();
        this._packageFilter = new CompoundFilter();
    }

    public ClassPackageBrowserV2() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSelection() {
        return this.tabs[activeTab].getSelection();
    }

    public void setSelection(String string) {
        int n = 0;
        while (n < this.tabs.length) {
            this.tabs[n].setSelection(string);
            ++n;
        }
    }

    public void setSelectedItems(String[] stringArray) {
        int n = 0;
        while (n < this.tabs.length) {
            this.tabs[n].setSelectedItems(stringArray);
            ++n;
        }
    }

    public String[] getSelectedItems() {
        return this.tabs[activeTab].getSelectedItems();
    }

    public void setJavaManager(JavaManager javaManager) {
        this._javaManager = javaManager;
        this.initializeFilters();
        int n = 0;
        while (n < this.tabs.length) {
            this.tabs[n].setJavaManager(javaManager);
            this.tabs[n].setMode(this._classPackageMode);
            this.tabs[n].setClassAndPackageNameFilters(this._classFilter, this._packageFilter);
            ++n;
        }
    }

    private void initializeFilters() {
        if (this._javaManager == null) {
            return;
        }
        switch (this._classPackageMode) {
            case 3: {
                this._packageFilter = new CompoundFilter();
                this._classFilter = new CompoundFilter();
                break;
            }
            case 1: {
                this._packageFilter = new CompoundFilter();
                break;
            }
            default: {
                this._classFilter = new CompoundFilter();
            }
        }
        int n = 0;
        while (n < this.tabs.length) {
            this.tabs[n].setJavaManager(this._javaManager);
            this.tabs[n].setMode(this._classPackageMode);
            this.tabs[n].setClassAndPackageNameFilters(this._classFilter, this._packageFilter);
            ++n;
        }
    }

    public void setMode(int n) {
        this._classPackageMode = n;
        int n2 = 0;
        while (n2 < this.tabs.length) {
            this.tabs[n2].setMode(n);
            ++n2;
        }
        this.initializeFilters();
    }

    public void setHostParent(Component component) {
        this._hostParent = component;
    }

    public Component getInitialFocusComponent() {
        return this.tabs[activeTab].getComponent();
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public ClassPackageBrowserFilterV2 getFilter() {
        return (ClassPackageBrowserFilterV2)this.filterModel.getSelectedItem();
    }

    public void setFilter(ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        this.filterCombo.setVisible(false);
        this.filterLabel.setVisible(false);
        this.filterCombo.removeItemListener(this);
        this.filterModel.removeAllElements();
        ClassPackageBrowserFilterV2 classPackageBrowserFilterV22 = classPackageBrowserFilterV2 != null ? classPackageBrowserFilterV2 : _defaultFilter;
        this.filterModel.addElement(classPackageBrowserFilterV22);
        this.activateFilter(classPackageBrowserFilterV22);
    }

    public void setFilters(ClassPackageBrowserFilterV2[] classPackageBrowserFilterV2Array) {
        ClassPackageBrowserFilterV2 classPackageBrowserFilterV2;
        this.filterCombo.removeItemListener(this);
        this.filterModel.removeAllElements();
        if (classPackageBrowserFilterV2Array != null && classPackageBrowserFilterV2Array.length > 0) {
            classPackageBrowserFilterV2 = classPackageBrowserFilterV2Array[0];
            int n = 0;
            while (n < classPackageBrowserFilterV2Array.length) {
                this.filterModel.addElement(classPackageBrowserFilterV2Array[n]);
                ++n;
            }
        } else {
            classPackageBrowserFilterV2 = _defaultFilter;
            this.filterModel.addElement(_defaultFilter);
            this.filterLabel.setVisible(false);
            this.filterCombo.setVisible(false);
        }
        this.activateFilter(classPackageBrowserFilterV2);
        boolean bl = classPackageBrowserFilterV2Array.length > 1;
        this.filterLabel.setVisible(bl);
        this.filterCombo.setVisible(bl);
        if (bl) {
            this.filterCombo.addItemListener(this);
        }
    }

    public void addFilters(ClassPackageBrowserFilterV2[] classPackageBrowserFilterV2Array) {
        if (classPackageBrowserFilterV2Array == null || classPackageBrowserFilterV2Array.length == 0) {
            return;
        }
        this.filterCombo.removeItemListener(this);
        int n = 0;
        while (n < classPackageBrowserFilterV2Array.length) {
            this.filterModel.addElement(classPackageBrowserFilterV2Array[n]);
            ++n;
        }
        boolean bl = this.filterModel.getSize() > 1;
        this.filterLabel.setVisible(bl);
        this.filterCombo.setVisible(bl);
        this.activateFilter(_defaultFilter);
        if (bl) {
            this.filterCombo.addItemListener(this);
        }
    }

    private void activateFilter(ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        if (this.filterModel.getIndexOf(classPackageBrowserFilterV2) == -1) {
            this.filterModel.addElement(classPackageBrowserFilterV2);
        }
        this.filterCombo.setSelectedItem(classPackageBrowserFilterV2);
        int n = 0;
        while (n < this.tabs.length) {
            this.tabs[n].setFilter(classPackageBrowserFilterV2);
            ++n;
        }
    }

    public void setMultiSelect(boolean bl) {
        int n = 0;
        while (n < this.tabs.length) {
            this.tabs[n].setMultiSelect(bl);
            ++n;
        }
    }

    public void classPackageSelected() {
        this.fireActionPerformed(this.tabControl.getSelectedComponent());
    }

    public void enableControls(boolean bl) {
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(bl);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && this._javaManager != null) {
            int n = 0;
            while (n < this.tabs.length) {
                this.tabs[n].setFilter(this.getFilter());
                ++n;
            }
            String[] stringArray = this.getSelectedItems();
            this.setSelectedItems(stringArray);
            this.tabs[activeTab].activateView();
        }
    }

    public String browseClassOrPackage(JavaManager javaManager, int n) {
        return this.browseClassOrPackage(javaManager, n, null);
    }

    public String browseClassOrPackage(JavaManager javaManager, int n, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        String[] stringArray = this.browseClassOrPackage(javaManager, n, false, classPackageBrowserFilterV2);
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    public String[] browseClassOrPackage(JavaManager javaManager, int n, boolean bl) {
        return this.browseClassOrPackage(javaManager, n, bl, null);
    }

    public String[] browseClassOrPackage(JavaManager javaManager, int n, boolean bl, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        return this.browseClassOrPackage(javaManager, n, bl, classPackageBrowserFilterV2, null);
    }

    public String[] browseClassOrPackage(JavaManager javaManager, int n, boolean bl, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2, String string) {
        ClassPackageBrowserFilterV2[] classPackageBrowserFilterV2Array;
        if (classPackageBrowserFilterV2 == null) {
            classPackageBrowserFilterV2Array = new ClassPackageBrowserFilterV2[]{};
        } else {
            ClassPackageBrowserFilterV2[] classPackageBrowserFilterV2Array2 = new ClassPackageBrowserFilterV2[1];
            classPackageBrowserFilterV2Array = classPackageBrowserFilterV2Array2;
            classPackageBrowserFilterV2Array2[0] = classPackageBrowserFilterV2;
        }
        ClassPackageBrowserFilterV2[] classPackageBrowserFilterV2Array3 = classPackageBrowserFilterV2Array;
        return this.showDialog(javaManager, n, bl, classPackageBrowserFilterV2Array3, true, string);
    }

    public String[] browseClassOrPackage(JavaManager javaManager, int n, boolean bl, ClassPackageBrowserFilter2V2[] classPackageBrowserFilter2V2Array, String string) {
        return this.showDialog(javaManager, n, bl, classPackageBrowserFilter2V2Array, false, string);
    }

    private String[] showDialog(JavaManager javaManager, int n, boolean bl, ClassPackageBrowserFilterV2[] classPackageBrowserFilterV2Array, boolean bl2, String string) {
        this.setMode(n);
        this.setJavaManager(javaManager);
        if (bl2) {
            this.setFilters(classPackageBrowserFilterV2Array);
        } else {
            this.addFilters(classPackageBrowserFilterV2Array);
        }
        this.setMultiSelect(bl);
        this.setSelection(string);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_ideclasspkgbrowser_html");
        return WizardLauncher.runDialog((JDialog)this._createDialog()) ? this.getSelectedItems() : new String[]{};
    }

    public static String browseClassOrPackage(Component component, Project project, int n) {
        return ClassPackageBrowserV2.browseClassOrPackage(component, project, n, null);
    }

    public static String browseClassOrPackage(Component component, Project project, int n, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        String[] stringArray = ClassPackageBrowserV2.browseClassOrPackage(component, project, n, false, classPackageBrowserFilterV2);
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    public static String[] browseClassOrPackage(Component component, Project project, int n, boolean bl) {
        return ClassPackageBrowserV2.browseClassOrPackage(component, project, n, bl, null);
    }

    public static String[] browseClassOrPackage(Component component, Project project, int n, boolean bl, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        return ClassPackageBrowserV2.browseClassOrPackage(component, project, n, bl, classPackageBrowserFilterV2, null);
    }

    public static String[] browseClassOrPackage(Component component, Project project, int n, boolean bl, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2, String string) {
        JavaManager javaManager = JavaManager.getJavaManager(project);
        ClassPackageBrowserV2 classPackageBrowserV2 = new ClassPackageBrowserV2();
        if (component != null) {
            classPackageBrowserV2.setHostParent(component);
        }
        return classPackageBrowserV2.browseClassOrPackage(javaManager, n, bl, classPackageBrowserFilterV2, string);
    }

    private static String toSingleSelection(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    private void jbInit() throws Exception {
        this.filterModel.addElement(_defaultFilter);
        this.filterModel.setSelectedItem(_defaultFilter);
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.filterCombo, (String)DlgArb.getString(2));
        this.filterLabel.setVisible(false);
        this.filterCombo.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.filterLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.filterCombo, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 50, 0));
        ClassPackageSearchPanel classPackageSearchPanel = new ClassPackageSearchPanel(this);
        ClassPackageTreePanel classPackageTreePanel = new ClassPackageTreePanel(this, _defaultFilter);
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        classPackageSearchPanel.setBorder(border);
        classPackageTreePanel.setBorder(border);
        this.tabControl.add(classPackageSearchPanel.getTitle(), classPackageSearchPanel);
        this.tabControl.add(classPackageTreePanel.getTitle(), classPackageTreePanel);
        this.tabControl.addChangeListener(new 1());
        this.tabs = new ClassPackageView[]{classPackageSearchPanel, classPackageTreePanel};
        if (activeTab >= 2) {
            activeTab = 0;
        }
        this.tabControl.setSelectedIndex(activeTab);
        this.setLayout(this.borderLayout);
        this.add((Component)this.tabControl, "Center");
        this.add((Component)jPanel, "South");
    }

    private JEWTDialog _createDialog() {
        String string;
        String string2;
        BrowserDialog browserDialog;
        Dialog dialog = null;
        Object object = null;
        if (this._hostParent != null && (dialog = DialogUtil.getAncestorDialog((Component)this._hostParent)) == null) {
            object = DialogUtil.getAncestorFrame((Component)this._hostParent);
        }
        if (dialog != null) {
            browserDialog = new BrowserDialog(dialog);
        } else {
            if (object == null) {
                object = Ide.getMainWindow();
            }
            browserDialog = new BrowserDialog((Frame)object);
        }
        switch (this._classPackageMode) {
            case 1: {
                string2 = DialogsArb.getString(8);
                string = DialogsArb.getString(9);
                break;
            }
            case 2: {
                string2 = DialogsArb.getString(3);
                string = DialogsArb.getString(4);
                break;
            }
            case 3: {
                string2 = DialogsArb.getString(14);
                string = DialogsArb.getString(15);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode '" + this._classPackageMode + "'");
            }
        }
        this.header.setHeaderTitle(string2);
        this.header.setHeaderDescription(string);
        browserDialog.setDialogHeader(this.header);
        browserDialog.setContent(this);
        browserDialog.setOKButtonEnabled(false);
        browserDialog.setResizable(true);
        browserDialog.setMaximumInitialSize(525, 400);
        browserDialog.setInitialFocus(this.tabs[activeTab].getComponent());
        this.addActionListener(browserDialog);
        return browserDialog;
    }

    protected String _getTitle() {
        if (this._title != null && this._title.length() > 0) {
            return this._title;
        }
        int n = 0;
        while (n < this.tabs.length) {
            this.tabs[n].setMode(this._classPackageMode);
            ++n;
        }
        switch (this._classPackageMode) {
            case 1: {
                return PACKAGE_TITLE;
            }
            case 2: {
                return CLASS_TITLE;
            }
            case 3: {
                return CLASS_PACKAGE_TITLE;
            }
        }
        throw new IllegalArgumentException("Invalid mode '" + this._classPackageMode + "' passed to ClassPackageBrowserV2._getTitle()");
    }

    public void addNotify() {
        super.addNotify();
        if (this._dlg == null) {
            Container container = this.getParent();
            while (container != null && this._dlg == null) {
                if (container instanceof JEWTDialog) {
                    this._dlg = (JEWTDialog)container;
                    continue;
                }
                container = container.getParent();
            }
        }
        if (this._dlg != null) {
            Ide.getWaitCursor().attach((RootPaneContainer)this._dlg);
        }
    }

    public void removeNotify() {
        if (this._dlg != null) {
            Ide.getWaitCursor().detach((RootPaneContainer)this._dlg);
            this._dlg = null;
        }
        super.removeNotify();
    }

    public void requestFocus() {
        this.tabs[activeTab].getComponent().requestFocus();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void fireActionPerformed(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        String string = "ITEM_INVOKED";
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == ActionListener.class) {
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(object, 1001, string, 0);
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    public static String[] browseClassOrPackage(Component component, Project project, int n, int n2, boolean bl, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        return ClassPackageBrowserV2.browseClassOrPackage(component, project, n, bl, classPackageBrowserFilterV2);
    }

    public static String[] browseClassOrPackage(Component component, Project project, int n, int n2, boolean bl, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2, String[] stringArray) {
        return ClassPackageBrowserV2.browseClassOrPackage(component, project, n, bl, classPackageBrowserFilterV2);
    }

    static void wa$activeTab(int n) {
        activeTab = n;
    }

    static ClassPackageView[] ra$tabs(ClassPackageBrowserV2 classPackageBrowserV2) {
        return classPackageBrowserV2.tabs;
    }

    static int ra$activeTab() {
        return activeTab;
    }

    static JavaManager ra$_javaManager(ClassPackageBrowserV2 classPackageBrowserV2) {
        return classPackageBrowserV2._javaManager;
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            ClassPackageBrowserV2.wa$activeTab(ClassPackageBrowserV2.this.tabControl.getSelectedIndex());
            ClassPackageBrowserV2.ra$tabs(ClassPackageBrowserV2.this)[ClassPackageBrowserV2.ra$activeTab()].activateView();
        }
    }

    private class BrowserDialog
    extends JEWTDialog
    implements ActionListener {
        public BrowserDialog(Dialog dialog) {
            super(dialog, ClassPackageBrowserV2.this._getTitle(), 7);
        }

        public BrowserDialog(Frame frame) {
            super(frame, ClassPackageBrowserV2.this._getTitle(), 7);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dismissDialog(false);
        }
    }

    private class CompoundFilter
    extends PatternMatchNameFilter {
        CompoundFilter() {
            super(false);
        }

        public boolean acceptPackageName(String string) {
            if (super.acceptPackageName(string)) {
                ClassPackageBrowserFilterV2 classPackageBrowserFilterV2 = ClassPackageBrowserV2.this.getFilter();
                if (classPackageBrowserFilterV2 == null) {
                    return true;
                }
                return classPackageBrowserFilterV2.acceptPackage(string);
            }
            return false;
        }

        public boolean acceptClassName(String string, String string2) {
            if (super.acceptClassName(string, string2)) {
                ClassPackageBrowserFilterV2 classPackageBrowserFilterV2 = ClassPackageBrowserV2.this.getFilter();
                if (classPackageBrowserFilterV2 == null) {
                    return true;
                }
                String string3 = string2.length() == 0 ? string : string2 + "." + string;
                JavaClass javaClass = ClassPackageBrowserV2.ra$_javaManager(ClassPackageBrowserV2.this).getClass(string3);
                if (javaClass == null) {
                    return false;
                }
                return classPackageBrowserFilterV2.acceptClass(javaClass);
            }
            return false;
        }
    }

    private static class DefaultFilter
    implements ClassPackageBrowserFilter2V2 {
        public boolean acceptPackage(String string) {
            return true;
        }

        public boolean acceptClass(JavaClass javaClass) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof DefaultFilter;
        }

        public String toString() {
            return DlgArb.getString(3);
        }

        public void setContext(Context context) {
        }

        private DefaultFilter() {
        }

        DefaultFilter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

