/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.dialogs.DlgArb;

public class ClassPackageListBrowser
extends JPanel
implements ListSelectionListener,
ActionListener {
    private Project project;
    private int mode;
    private List list;
    private DefaultListModel listModel;
    GridBagLayout gridBagLayout1;
    JScrollPane scrList;
    JList jList1;
    JButton butAdd;
    JButton butRemove;
    JPanel buttonPanel;
    GridLayout gridLayout1;
    Border bdrScroller;

    void $init$() {
        this.listModel = new DefaultListModel();
        this.gridBagLayout1 = new GridBagLayout();
        this.scrList = new JScrollPane();
        this.jList1 = new JList();
        this.butAdd = new JButton();
        this.butRemove = new JButton();
        this.buttonPanel = new JPanel();
        this.gridLayout1 = new GridLayout();
        this.bdrScroller = BorderFactory.createLoweredBevelBorder();
    }

    public ClassPackageListBrowser(Project project, int n, List list) {
        this.$init$();
        this.project = project;
        this.mode = n;
        this.list = list;
        for (String string : list) {
            this.listModel.addElement(string);
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.listModel.isEmpty()) {
            this.jList1.setSelectedIndex(0);
        }
        this.updateButtons();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.scrList.setBorder(this.bdrScroller);
        this.scrList.getViewport().add((Component)this.jList1, null);
        this.jList1.setSelectionMode(2);
        this.jList1.setModel(this.listModel);
        this.jList1.addListSelectionListener(this);
        ResourceUtils.resButton((AbstractButton)this.butAdd, (String)DlgArb.getString(0));
        this.butAdd.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.butRemove, (String)DlgArb.getString(1));
        this.butRemove.addActionListener(this);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(8);
        this.buttonPanel.setLayout(this.gridLayout1);
        this.buttonPanel.add(this.butAdd);
        this.buttonPanel.add(this.butRemove);
        this.add((Component)this.scrList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        Object object = actionEvent.getSource();
        if (object == this.butAdd) {
            String[] stringArray = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this.project, this.mode, true);
            if (stringArray.length > 0) {
                int n = 0;
                while (n < stringArray.length) {
                    this.listModel.addElement(stringArray[n]);
                    ++n;
                }
                int n2 = this.listModel.getSize();
                this.jList1.setSelectedIndex(n2 - 1);
            }
        } else if (object == this.butRemove && (objectArray = this.jList1.getSelectedValues()) != null && objectArray.length > 0) {
            int n = this.listModel.indexOf(objectArray[0]);
            int n3 = 0;
            while (n3 < objectArray.length) {
                this.listModel.removeElement(objectArray[n3]);
                ++n3;
            }
            int n4 = this.listModel.getSize();
            this.jList1.setSelectedIndex(n < n4 ? n : n4 - 1);
            if (n4 <= 0) {
                this.butRemove.setEnabled(false);
            }
        }
    }

    private void updateButtons() {
        int[] nArray = this.jList1.getSelectedIndices();
        boolean bl = nArray != null && nArray.length > 0;
        this.butRemove.setEnabled(bl);
    }

    private Component getInitialFocus() {
        if (this.listModel.isEmpty()) {
            return this.butAdd;
        }
        return this.jList1;
    }

    public static boolean browseClassPackageList(String string, Project project, boolean bl, boolean bl2, List list) {
        return ClassPackageListBrowser.browseClassPackageList(null, string, project, bl, bl2, list, null);
    }

    public static boolean browseClassPackageList(String string, Project project, boolean bl, boolean bl2, List list, String string2) {
        return ClassPackageListBrowser.browseClassPackageList(null, string, project, bl, bl2, list, string2);
    }

    public static boolean browseClassPackageList(Component component, String string, Project project, boolean bl, boolean bl2, List list, String string2) {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        ClassPackageListBrowser classPackageListBrowser = new ClassPackageListBrowser(project, n, list);
        if (string2 != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)classPackageListBrowser, string2);
        }
        if (OnePageWizardDialogFactory.runDialog((Component)component, (Component)classPackageListBrowser, (Component)classPackageListBrowser.getInitialFocus(), (String)string)) {
            list.clear();
            Enumeration enumeration = classPackageListBrowser.listModel.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                list.add(string3);
            }
            return true;
        }
        return false;
    }
}

