/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageSearchPanel
extends JPanel
implements ClassPackageView {
    private final JLabel searchLabel;
    private final JTextField searchTextField;
    private final JLabel classPkgLabel;
    private final ListSelectionModel selectionModel;
    private final JList classPkgList;
    private final JScrollPane scroller;
    private final DefaultListCellRenderer renderer;
    private final GridBagLayout mainLayout;
    private boolean _multiSelect;
    private int _classPackageMode;
    private ClassNameFilter _classFilter;
    private PackageNameFilter _packageFilter;
    private BrowseHandler _browseHandler;
    private JavaManager _javaManager;
    private final ClassPackageBrowserContext _browserContext;

    void $init$() {
        this.searchLabel = new JLabel();
        this.searchTextField = new JTextField();
        this.classPkgLabel = new JLabel();
        this.selectionModel = new DefaultListSelectionModel();
        this.classPkgList = new JList();
        this.scroller = new JScrollPane(this.classPkgList);
        this.renderer = new ListDataItemCellRenderer();
        this.mainLayout = new GridBagLayout();
    }

    public ClassPackageSearchPanel(ClassPackageBrowserContext classPackageBrowserContext) {
        this.$init$();
        this._browserContext = classPackageBrowserContext;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void activateView() {
        String string;
        if (this.classPkgList.getModel().getSize() == 1 && (BrowseHandler.PROGRESS_LIST_ITEM == this.classPkgList.getModel().getElementAt(0) || BrowseHandler.EMPTY_LIST_ITEM == this.classPkgList.getModel().getElementAt(0)) && (string = this.searchTextField.getText()).length() > 0) {
            this._browseHandler.doLookup(string);
        }
        this.enableControls();
    }

    public String getTitle() {
        return DialogsArb.getString(18);
    }

    public Component getComponent() {
        return this.searchTextField;
    }

    public void setSelection(String string) {
        this.searchTextField.setText(string);
    }

    public String getSelection() {
        String[] stringArray = this.getSelectedItems();
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    public void setSelectedItems(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.setSelection(stringArray[0]);
        }
    }

    public String[] getSelectedItems() {
        Object[] objectArray = this.classPkgList.getSelectedValues();
        if (objectArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != BrowseHandler.EMPTY_LIST_ITEM && objectArray[n] != BrowseHandler.PROGRESS_LIST_ITEM) {
                    arrayList.add(objectArray[n].toString());
                }
                ++n;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    public void setJavaManager(JavaManager javaManager) {
        this._javaManager = javaManager;
    }

    public void setClassAndPackageNameFilters(ClassNameFilter classNameFilter, PackageNameFilter packageNameFilter) {
        this._classFilter = classNameFilter;
        this._packageFilter = packageNameFilter;
        if (this._javaManager != null) {
            switch (this._classPackageMode) {
                case 1: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(11));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(10));
                    this._browseHandler = BrowseHandler.createPackageBrowserList(this._javaManager, this.searchTextField, this.classPkgList, packageNameFilter);
                    break;
                }
                case 2: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(6));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(5));
                    this._browseHandler = BrowseHandler.createClassBrowserList(this._javaManager, this.searchTextField, this.classPkgList, classNameFilter);
                    break;
                }
                default: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(17));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(16));
                    this._browseHandler = BrowseHandler.createClassPackageBrowserList(this._javaManager, this.searchTextField, this.classPkgList, classNameFilter, packageNameFilter);
                }
            }
        }
    }

    public void setFilter(ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
    }

    public void setMultiSelect(boolean bl) {
        if (bl != this._multiSelect) {
            this._multiSelect = bl;
        }
        this.selectionModel.setSelectionMode(this._multiSelect ? 2 : 0);
    }

    public void setMode(int n) {
        this._classPackageMode = n;
        switch (this._classPackageMode) {
            case 1: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(11));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(10));
                break;
            }
            case 2: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(6));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(5));
                break;
            }
            default: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(17));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(16));
            }
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(17));
        ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(16));
        this.setLayout(this.mainLayout);
        this.classPkgList.addListSelectionListener(new 3());
        this.searchTextField.addFocusListener(new 2());
        this.searchTextField.addKeyListener(new 1());
        EventListener eventListener = new EventListener(null);
        this.classPkgList.addMouseListener(eventListener);
        this.selectionModel.setSelectionMode(0);
        this.classPkgList.setCellRenderer(this.renderer);
        int n = -1;
        this.add((Component)this.searchLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.searchTextField, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.classPkgLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.scroller, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
    }

    private void enableControls() {
        Object e = this.classPkgList.getSelectedValue();
        this._browserContext.enableControls(e != null && e != BrowseHandler.EMPTY_LIST_ITEM && e != BrowseHandler.PROGRESS_LIST_ITEM);
    }

    static void mav$enableControls(ClassPackageSearchPanel classPackageSearchPanel) {
        classPackageSearchPanel.enableControls();
    }

    static JTextField ra$searchTextField(ClassPackageSearchPanel classPackageSearchPanel) {
        return classPackageSearchPanel.searchTextField;
    }

    static JList ra$classPkgList(ClassPackageSearchPanel classPackageSearchPanel) {
        return classPackageSearchPanel.classPkgList;
    }

    static ClassPackageBrowserContext ra$_browserContext(ClassPackageSearchPanel classPackageSearchPanel) {
        return classPackageSearchPanel._browserContext;
    }

    public final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ClassPackageSearchPanel.mav$enableControls(ClassPackageSearchPanel.this);
            }
        }
    }

    public final class 2
    implements FocusListener {
        public void focusLost(FocusEvent focusEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            int n = ClassPackageSearchPanel.ra$searchTextField(ClassPackageSearchPanel.this).getText().length();
            ClassPackageSearchPanel.ra$searchTextField(ClassPackageSearchPanel.this).setSelectionStart(0);
            ClassPackageSearchPanel.ra$searchTextField(ClassPackageSearchPanel.this).setSelectionEnd(n);
        }
    }

    public final class 1
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2 = keyEvent.getKeyCode();
            if (40 == n2) {
                int n3 = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedIndex();
                if (n3 < ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getModel().getSize() - 1) {
                    ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).setSelectedIndex(n3 + 1);
                }
            } else if (38 == n2 && (n = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedIndex()) > 0) {
                ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).setSelectedIndex(n - 1);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private final class EventListener
    extends MouseAdapter {
        int y;

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            int n2 = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedIndex();
            if (n == 2 && n2 != -1) {
                Object e;
                if (n2 == 0 && ((e = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedValue()) == BrowseHandler.EMPTY_LIST_ITEM || e == BrowseHandler.PROGRESS_LIST_ITEM)) {
                    return;
                }
                ClassPackageSearchPanel.ra$_browserContext(ClassPackageSearchPanel.this).classPackageSelected();
            }
        }

        private EventListener() {
        }

        EventListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

