/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Ide;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.SwingWorker;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageTreePanel
extends JPanel
implements ClassPackageView {
    JScrollPane pkgScrollPane;
    JTree pkgTree;
    DefaultTreeModel pkgModel;
    DefaultTreeCellRenderer renderer;
    GridBagLayout mainLayout;
    TreeSelectionModel selModel;
    private JavaManager _jmgr;
    private int mode;
    private ClassPackageBrowserFilterV2 _filter;
    private boolean _multiSelect;
    private final ClassPackageBrowserContext _browserContext;
    private static final Icon PKG_ICON = JavaIcons.getIcon(5);
    private static final Icon IFACE_ICON = JavaIcons.getIcon(1);
    private static final Icon CLASS_ICON = JavaIcons.getIcon(0);

    void $init$() {
        this.pkgScrollPane = new JScrollPane();
        this.pkgTree = KeyNavigationManager.createNavigableTree();
        this.pkgModel = new DefaultTreeModel(new DefaultMutableTreeNode("Packages"));
        this.renderer = new TreeRenderer(null);
        this.mainLayout = new GridBagLayout();
        this.selModel = new DefaultTreeSelectionModel();
        this.mode = 1;
    }

    public ClassPackageTreePanel(ClassPackageBrowserContext classPackageBrowserContext, ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        this.$init$();
        this._browserContext = classPackageBrowserContext;
        this._filter = classPackageBrowserFilterV2;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void activateView() {
        this.enableControls();
    }

    public String getTitle() {
        return DialogsArb.getString(19);
    }

    public Component getComponent() {
        return this.pkgTree;
    }

    public void setSelection(String string) {
        if (string != null) {
            this.setSelectedItems(new String[]{string});
        }
    }

    public String getSelection() {
        String[] stringArray = this.getSelectedItems();
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    public void setSelectedItems(String[] stringArray) {
        this._setSelectedItems(stringArray);
    }

    public String[] getSelectedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreePath[] treePathArray = this.pkgTree.getSelectionPaths();
        if (treePathArray != null) {
            int n = 0;
            while (n < treePathArray.length) {
                Object object = treePathArray[n].getLastPathComponent();
                if (object instanceof PackageNode && (this.mode & 1) > 0) {
                    arrayList.add(((PackageNode)object).getPackage());
                } else if (object instanceof ClassNode && (this.mode & 2) > 0) {
                    arrayList.add(((ClassNode)object).getClassName());
                }
                ++n;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setJavaManager(JavaManager javaManager) {
        this._jmgr = javaManager;
        Collection collection = this._jmgr.getJavaClassLocator().getPackages("");
        this.setPackageList(collection.iterator());
    }

    public void setClassAndPackageNameFilters(ClassNameFilter classNameFilter, PackageNameFilter packageNameFilter) {
    }

    public void setFilter(ClassPackageBrowserFilterV2 classPackageBrowserFilterV2) {
        this._filter = classPackageBrowserFilterV2;
        Collection collection = this._jmgr.getJavaClassLocator().getPackages("");
        this.setPackageList(collection.iterator());
    }

    public void setMultiSelect(boolean bl) {
        if (bl != this._multiSelect) {
            this._multiSelect = bl;
        }
        this.selModel.setSelectionMode(this._multiSelect ? 4 : 1);
    }

    public void setMode(int n) {
        this.mode = n;
    }

    private void jbInit() throws Exception {
        this.pkgTree.setVisibleRowCount(10);
        this.pkgTree.setRootVisible(false);
        this.pkgTree.setShowsRootHandles(true);
        this.pkgTree.setModel(this.pkgModel);
        this.pkgTree.setCellRenderer(this.renderer);
        EventListener eventListener = new EventListener(null);
        this.pkgTree.addMouseListener(eventListener);
        this.pkgTree.addTreeWillExpandListener(new 5());
        this.pkgTree.addFocusListener(new 4());
        this.pkgTree.setSelectionModel(this.selModel);
        this.selModel.setSelectionMode(1);
        this.selModel.addTreeSelectionListener(new 3());
        this.pkgScrollPane.getViewport().add((Component)this.pkgTree, null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pkgScrollPane, "Center");
    }

    private void setPackageList(Iterator iterator) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.pkgModel.getRoot();
        int n = mutableTreeNode.getChildCount() - 1;
        while (n >= 0) {
            mutableTreeNode.remove(n);
            --n;
        }
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (string == null || !this._filter.acceptPackage(string)) continue;
            PackageNode packageNode = new PackageNode(string);
            packageNode.loadChildren(false);
            if ((this.mode & 1) <= 0 && (this.mode ^ 1) > 0 && packageNode.children() == DefaultMutableTreeNode.EMPTY_ENUMERATION) continue;
            mutableTreeNode.insert(packageNode, mutableTreeNode.getChildCount());
        }
        if ((this.mode & 2) > 0) {
            for (String string : this._jmgr.getJavaClassLocator().getClassesInPackage("")) {
                JavaClass javaClass = this._jmgr.getClass(string);
                if (javaClass == null || !this._filter.acceptClass(javaClass)) continue;
                mutableTreeNode.insert(new ClassNode(javaClass), mutableTreeNode.getChildCount());
            }
        }
        if (mutableTreeNode.getChildCount() == 0) {
            String string = DialogsArb.getString(12);
            mutableTreeNode.insert(new DefaultMutableTreeNode(string), 0);
        }
        this.pkgModel.nodeChanged(mutableTreeNode);
        this.pkgTree.updateUI();
        this.pkgTree.expandPath(new TreePath(new Object[]{mutableTreeNode}));
    }

    private void _setSelectedItems(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.pkgTree.setSelectionRow(0);
        } else {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < stringArray2.length) {
                String string = stringArray2[n];
                if (string.endsWith(".*")) {
                    stringArray2[n] = string = string.substring(0, string.length() - 2);
                }
                int n2 = string.lastIndexOf(46);
                while (n2 != -1) {
                    string = string.substring(0, n2);
                    hashSet.add(string);
                    n2 = string.lastIndexOf(46);
                }
                ++n;
            }
            Object[] objectArray = hashSet.toArray(new String[hashSet.size()]);
            Arrays.sort(objectArray);
            MutableTreeNode mutableTreeNode = (MutableTreeNode)this.pkgModel.getRoot();
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            2 var10_10 = new 2(this, mutableTreeNode, (String[])objectArray, stringArray2, waitCursor);
            var10_10.start();
        }
    }

    private void enableControls() {
        boolean bl = false;
        TreePath[] treePathArray = this.selModel.getSelectionPaths();
        if (treePathArray != null) {
            int n = 0;
            while (!bl && n < treePathArray.length) {
                TreePath treePath = treePathArray[n];
                if (treePath != null) {
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof PackageNode) {
                        bl = (this.mode & 1) > 0;
                    } else if (object instanceof ClassNode) {
                        bl = (this.mode & 2) > 0;
                    }
                }
                ++n;
            }
        }
        this._browserContext.enableControls(bl);
    }

    void selModel_valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.enableControls();
    }

    void pkgTree_treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        PackageNode packageNode;
        TreePath treePath = treeExpansionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object instanceof PackageNode && !(packageNode = (PackageNode)object).isChildrenLoaded()) {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            this.pkgModel.addTreeModelListener(new 1(this, treePath, waitCursor));
            packageNode.loadChildren(true);
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    static JavaManager ra$_jmgr(ClassPackageTreePanel classPackageTreePanel) {
        return classPackageTreePanel._jmgr;
    }

    static ClassPackageBrowserFilterV2 ra$_filter(ClassPackageTreePanel classPackageTreePanel) {
        return classPackageTreePanel._filter;
    }

    static int ra$mode(ClassPackageTreePanel classPackageTreePanel) {
        return classPackageTreePanel.mode;
    }

    static Icon ra$PKG_ICON() {
        return PKG_ICON;
    }

    static Icon ra$IFACE_ICON() {
        return IFACE_ICON;
    }

    static Icon ra$CLASS_ICON() {
        return CLASS_ICON;
    }

    static ClassPackageBrowserContext ra$_browserContext(ClassPackageTreePanel classPackageTreePanel) {
        return classPackageTreePanel._browserContext;
    }

    public final class 5
    implements TreeWillExpandListener {
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            ClassPackageTreePanel.this.pkgTree_treeWillExpand(treeExpansionEvent);
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        }
    }

    public final class 4
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (ClassPackageTreePanel.this.pkgTree.getSelectionCount() == 0) {
                ClassPackageTreePanel.this.pkgTree.setSelectionInterval(0, 0);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    public final class 3
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ClassPackageTreePanel.this.selModel_valueChanged(treeSelectionEvent);
        }
    }

    public final class 2
    extends SwingWorker {
        private final /* synthetic */ MutableTreeNode v$root;
        private final /* synthetic */ String[] v$paths;
        private final /* synthetic */ String[] v$cleanSel;
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ ClassPackageTreePanel this$0;

        public Object construct() {
            HashMap<String, TreePath> hashMap = new HashMap<String, TreePath>();
            hashMap.put("", new TreePath(this.v$root));
            int n = 0;
            while (n < this.v$paths.length) {
                MutableTreeNode mutableTreeNode;
                TreeNode treeNode;
                String string = this.v$paths[n];
                int n2 = string.lastIndexOf(46);
                String string2 = n2 != -1 ? string.substring(0, n2) : "";
                String string3 = string.substring(n2 + 1);
                TreePath treePath = (TreePath)hashMap.get(string2);
                if (treePath != null && (treeNode = this.getChild(mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent(), string3)) instanceof PackageNode) {
                    PackageNode packageNode = (PackageNode)treeNode;
                    if (!packageNode.isChildrenLoaded()) {
                        packageNode.loadChildren(false);
                    }
                    TreePath treePath2 = treePath.pathByAddingChild(packageNode);
                    hashMap.put(string, treePath2);
                }
                ++n;
            }
            return hashMap;
        }

        public void finished() {
            try {
                Map map = (Map)this.get();
                int n = 0;
                while (n < this.v$paths.length) {
                    TreePath treePath = (TreePath)map.get(this.v$paths[n]);
                    if (treePath != null) {
                        this.this$0.pkgTree.expandPath(treePath);
                    }
                    ++n;
                }
                this.this$0.selModel.clearSelection();
                int n2 = 0;
                while (n2 < this.v$cleanSel.length) {
                    MutableTreeNode mutableTreeNode;
                    TreeNode treeNode;
                    String string = this.v$cleanSel[n2];
                    int n3 = string.lastIndexOf(46);
                    String string2 = n3 != -1 ? string.substring(0, n3) : "";
                    String string3 = string.substring(n3 + 1);
                    TreePath treePath = (TreePath)map.get(string2);
                    if (treePath != null && (treeNode = this.getChild(mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent(), string3)) != null) {
                        TreePath treePath2 = treePath.pathByAddingChild(treeNode);
                        this.this$0.selModel.addSelectionPath(treePath2);
                        this.this$0.pkgTree.scrollPathToVisible(treePath2);
                    }
                    ++n2;
                }
            }
            finally {
                this.v$wc.hide();
            }
        }

        private TreeNode getChild(MutableTreeNode mutableTreeNode, String string) {
            TreeNode treeNode = null;
            int n = mutableTreeNode.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                TreeNode treeNode2 = mutableTreeNode.getChildAt(n2);
                if (string.equals(treeNode2.toString())) {
                    treeNode = treeNode2;
                    break;
                }
                ++n2;
            }
            return treeNode;
        }

        public 2(ClassPackageTreePanel classPackageTreePanel, MutableTreeNode mutableTreeNode, String[] stringArray, String[] stringArray2, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.v$cleanSel = stringArray2;
            this.v$paths = stringArray;
            this.v$root = mutableTreeNode;
            this.this$0 = classPackageTreePanel;
        }
    }

    public final class 1
    implements TreeModelListener {
        private final /* synthetic */ TreePath v$path;
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ ClassPackageTreePanel this$0;

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.this$0.pkgTree.expandPath(this.v$path);
            this.this$0.pkgModel.removeTreeModelListener(this);
            this.v$wc.hide();
        }

        public 1(ClassPackageTreePanel classPackageTreePanel, TreePath treePath, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.v$path = treePath;
            this.this$0 = classPackageTreePanel;
        }
    }

    private class PackageNode
    extends DefaultMutableTreeNode {
        String displayName;
        String pkgName;
        boolean childrenFetched;
        boolean isSelectable;
        boolean loading;

        PackageNode(String string) {
            this.pkgName = string;
            int n = string.lastIndexOf(".");
            this.displayName = n != -1 ? string.substring(n + 1) : string;
            this.isSelectable = true;
        }

        Icon getIcon() {
            return null;
        }

        public String toString() {
            return this.displayName;
        }

        public String getPackage() {
            return this.pkgName;
        }

        boolean isSelectable() {
            return this.isSelectable;
        }

        void setSelectable(boolean bl) {
            this.isSelectable = bl;
        }

        boolean isChildrenLoaded() {
            return this.childrenFetched;
        }

        void setChildrenLoaded(boolean bl) {
            this.childrenFetched = bl;
        }

        public boolean isLeaf() {
            return !this.childrenFetched ? false : super.isLeaf();
        }

        void loadChildren(boolean bl) {
            if (this.loading) {
                return;
            }
            this.loading = true;
            if (bl) {
                1 var2_2 = new 1();
                var2_2.start();
            } else {
                ArrayList arrayList = null;
                try {
                    arrayList = this._loadChildList();
                }
                finally {
                    this._finishChildLoad(arrayList);
                }
            }
        }

        private ArrayList _loadChildList() {
            ArrayList<DefaultMutableTreeNode> arrayList;
            block5: {
                arrayList = new ArrayList<DefaultMutableTreeNode>();
                try {
                    Iterator iterator = ClassPackageTreePanel.ra$_jmgr(ClassPackageTreePanel.this).getJavaClassLocator().getPackages(this.pkgName).iterator();
                    while (iterator.hasNext()) {
                        String string = this.pkgName.length() == 0 ? (String)iterator.next() : this.pkgName + '.' + iterator.next();
                        if (string == null || !ClassPackageTreePanel.ra$_filter(ClassPackageTreePanel.this).acceptPackage(string)) continue;
                        arrayList.add(new PackageNode(string));
                    }
                    if ((ClassPackageTreePanel.ra$mode(ClassPackageTreePanel.this) & 2) > 0) {
                        iterator = ClassPackageTreePanel.ra$_jmgr(ClassPackageTreePanel.this).getJavaClassLocator().getClassesInPackage(this.pkgName).iterator();
                        while (iterator.hasNext()) {
                            String string = this.pkgName.length() == 0 ? (String)iterator.next() : this.pkgName + '.' + iterator.next();
                            JavaClass javaClass = ClassPackageTreePanel.ra$_jmgr(ClassPackageTreePanel.this).getClass(string);
                            if (javaClass == null || !ClassPackageTreePanel.ra$_filter(ClassPackageTreePanel.this).acceptClass(javaClass)) continue;
                            arrayList.add(new ClassNode(javaClass));
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)throwable;
                }
            }
            return arrayList;
        }

        private void _finishChildLoad(Object object) {
            try {
                if (object instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)object;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        this.add((MutableTreeNode)iterator.next());
                    }
                }
            }
            finally {
                this.childrenFetched = true;
                TreePath[] treePathArray = ClassPackageTreePanel.this.selModel.getSelectionPaths();
                ClassPackageTreePanel.this.pkgModel.reload(this);
                ClassPackageTreePanel.this.selModel.setSelectionPaths(treePathArray);
            }
        }

        public Object getUserObject() {
            return this.displayName;
        }

        static void mav$_finishChildLoad(PackageNode packageNode, Object object) {
            packageNode._finishChildLoad(object);
        }

        static ArrayList mav$_loadChildList(PackageNode packageNode) {
            return packageNode._loadChildList();
        }

        public final class 1
        extends SwingWorker {
            public Object construct() {
                return PackageNode.mav$_loadChildList(PackageNode.this);
            }

            public void finished() {
                PackageNode.mav$_finishChildLoad(PackageNode.this, this.get());
            }
        }
    }

    private class ClassNode
    extends DefaultMutableTreeNode {
        private String displayName;
        private JavaClass cls;

        ClassNode(JavaClass javaClass) {
            int n;
            super(javaClass, false);
            this.cls = javaClass;
            String string = javaClass.getPackageName();
            this.displayName = javaClass.getName();
            if (string != null && string.length() > 0 && (n = this.displayName.indexOf(string)) >= 0 && n + string.length() < this.displayName.length() - 1) {
                this.displayName = this.displayName.substring(n + string.length() + 1);
            }
        }

        public String toString() {
            return this.displayName;
        }

        String getClassName() {
            return this.cls.getQualifiedName();
        }

        public Object getUserObject() {
            return this.displayName;
        }

        public boolean isInterface() {
            return this.cls.isInterface();
        }
    }

    private static final class TreeRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof PackageNode) {
                if (bl3) {
                    this.setLeafIcon(ClassPackageTreePanel.ra$PKG_ICON());
                }
                if (bl2) {
                    this.setOpenIcon(ClassPackageTreePanel.ra$PKG_ICON());
                } else {
                    this.setClosedIcon(ClassPackageTreePanel.ra$PKG_ICON());
                }
            } else if (object instanceof ClassNode) {
                this.setLeafIcon(((ClassNode)object).isInterface() ? ClassPackageTreePanel.ra$IFACE_ICON() : ClassPackageTreePanel.ra$CLASS_ICON());
            }
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            return component;
        }

        private TreeRenderer() {
        }

        TreeRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class EventListener
    extends MouseAdapter {
        int y;

        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath;
            int n = mouseEvent.getClickCount();
            if (n == 1) {
                this.y = mouseEvent.getY();
            }
            if (this.y == mouseEvent.getY() && n == 2 && (treePath = ((JTree)mouseEvent.getSource()).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.getLastPathComponent() instanceof ClassNode) {
                ClassPackageTreePanel.ra$_browserContext(ClassPackageTreePanel.this).classPackageSelected();
            }
        }

        private EventListener() {
        }

        EventListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

