/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.jdeveloper.icons.JDevIcons;

public final class JDevDialogHeader
extends JPanel {
    private static final float HEADER_BRIGHTNESS_BOOST = 0.25f;
    private static final Border HEADER_BORDER = new EtchedUnderlineBorder(null);
    private static final Image HEADER_DEFAULT_IMAGE = JDevIcons.getImage(3);
    private final JLabel _iconLabel;
    private final JLabel _titleLabel;
    private final WordWrappingLabel _descriptionLabel;

    void $init$() {
        this._iconLabel = new JLabel();
        this._titleLabel = new JLabel();
        this._descriptionLabel = new WordWrappingLabel();
    }

    public JDevDialogHeader() {
        this.$init$();
        this.setBorder(HEADER_BORDER);
        this.setLayout(new BorderLayout());
        this.setHeaderImage(null);
        this._iconLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._titleLabel.setAlignmentX(0.0f);
        this._titleLabel.setFont(this._titleLabel.getFont().deriveFont(1));
        this._descriptionLabel.setAlignmentX(0.0f);
        this._descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        Box box = new Box(1);
        box.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 10));
        box.add(this._titleLabel);
        box.add((Component)((Object)this._descriptionLabel));
        box.add(Box.createVerticalGlue());
        this.add((Component)box, "Center");
        this.add((Component)this._iconLabel, "East");
    }

    public void setHeaderTitle(String string) {
        this._titleLabel.setText(string);
    }

    public String getHeaderTitle() {
        return this._titleLabel.getText();
    }

    public void setHeaderDescription(String string) {
        this._descriptionLabel.setText(string);
    }

    public String getHeaderDescription() {
        return this._descriptionLabel.getText();
    }

    public void setHeaderImage(Image image) {
        ImageIcon imageIcon = new ImageIcon(image != null ? image : HEADER_DEFAULT_IMAGE);
        this._iconLabel.setIcon(imageIcon);
    }

    public Image getHeaderImage() {
        ImageIcon imageIcon = (ImageIcon)this._iconLabel.getIcon();
        return imageIcon.getImage();
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.top - insets.bottom;
            graphics.translate(insets.left, insets.top);
            graphics.setColor(this.getBackground());
            if (graphics instanceof Graphics2D) {
                float[] fArray = JDevDialogHeader.getHSBValues(this.getBackground());
                Color color = JDevDialogHeader.getGradientStartColor(fArray[0], fArray[1], fArray[2]);
                Color color2 = JDevDialogHeader.getGradientEndColor(fArray[0], fArray[1], fArray[2]);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, n, 0.0f, color2);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(gradientPaint);
            }
            graphics.fillRect(0, 0, n, n2);
        }
    }

    private static float[] getHSBValues(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return Color.RGBtoHSB(n, n2, n3, null);
    }

    private static Color getGradientStartColor(float f, float f2, float f3) {
        float f4 = f3 + 0.25f;
        return f4 < 1.0f ? Color.getHSBColor(f, f2, f4) : Color.white;
    }

    private static Color getGradientEndColor(float f, float f2, float f3) {
        float f4 = Math.min(f3 + 0.25f, 1.0f);
        float f5 = (f4 + f4 + f3) / 3.0f;
        return Color.getHSBColor(f, f2, f5);
    }

    private static final class WordWrappingLabel
    extends MultiLineLabel {
        public WordWrappingLabel() {
            super(WordWrapper.getTextWrapper(), null);
            this.setPreferredAspectRatio(12.0f);
            this.setVerticalShrinking(false);
        }
    }

    private static final class EtchedUnderlineBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics graphics2 = graphics.create(n, n2, n3, n4);
            graphics2.setColor(EtchedUnderlineBorder.getShadowColor());
            graphics2.drawLine(0, n4 - 2, n3 - 2, n4 - 2);
            graphics2.setColor(EtchedUnderlineBorder.getHighlightColor());
            graphics2.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics2.drawLine(n3 - 1, n4 - 2, n3 - 1, n4 - 2);
            graphics2.dispose();
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
            insets.bottom = 2;
            return insets;
        }

        private static Color getShadowColor() {
            Color color = UIManager.getColor("controlShadow");
            return color != null ? color : SystemColor.controlShadow;
        }

        private static Color getHighlightColor() {
            Color color = UIManager.getColor("controlLtHighlight");
            return color != null ? color : SystemColor.controlLtHighlight;
        }

        private EtchedUnderlineBorder() {
        }

        EtchedUnderlineBorder(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

