/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceChange;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.parser.java.v2.write.SourceTransactionListener;
import oracle.jdeveloper.engine.BaseEngine;
import oracle.jdeveloper.engine.CallMode;
import oracle.jdeveloper.engine.EngineConstants;
import oracle.jdeveloper.engine.EngineException;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.MethodEngine;
import oracle.jdeveloper.engine.MethodInfo;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;

public class ClassEngine
extends BaseEngine
implements Observer,
SourceTransactionListener,
EngineConstants {
    private Project _project;
    private String _className;
    private SourceFile _srcFile;
    private static final boolean _enableMICaching = true;
    private boolean _attachedToNode;
    private boolean _attachedToSrcTrans;
    private JavaSourceNode _node;
    private MethodInfo[] _methodInfos;
    private MethodInfo[] _constructorMethodInfos;
    private boolean _onlyPublic;
    private Set _ignoreClasses;

    public ClassEngine(Project project, String string) {
        this._project = project;
        this._className = string;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String string) {
        this._className = string;
        this.invalidateCache();
    }

    public JavaManager getJavaManager() {
        return JavaManager.getJavaManager(this._project);
    }

    public JavaClass getJavaClass() {
        return this.getJavaManager().getClass(this._className);
    }

    public SourceClass getSourceClass() {
        if (this.getSourceFile() != null) {
            return (SourceClass)this._srcFile.getPrimaryClass().getSourceElement();
        }
        return null;
    }

    public SourceFile getSourceFile() {
        if (this._srcFile == null || this._srcFile.isExpired()) {
            this._srcFile = EngineUtils.getSourceFile(this.getJavaManager(), this._className);
        }
        return this._srcFile;
    }

    public SourceFactory getFactory() {
        return this.getSourceFile().getFactory();
    }

    public SourceTransaction openTransaction() {
        return EngineUtils.openTransaction(this.getSourceFile());
    }

    public SourceSavepoint createSavepoint() {
        return EngineUtils.createSavepoint(this.getSourceFile());
    }

    public JavaSourceNode getJavaSourceNode() {
        if (this._node == null && this.getSourceFile() != null) {
            this._node = (JavaSourceNode)EngineUtils.findNode(JavaSourceNode.class, this._srcFile.getURL());
        }
        return this._node;
    }

    public boolean isEditable() {
        return this.getSourceFile() != null && !URLFileSystem.isReadOnly((URL)this._srcFile.getURL());
    }

    public long getTimestamp() {
        Node node;
        if (this.getSourceFile() != null && (node = NodeFactory.find((URL)this._srcFile.getURL())) != null) {
            return node.getTimestamp();
        }
        return 0L;
    }

    public MethodInfo[] getMethods(boolean bl, Set set) {
        return this.getMethods(bl, set, true);
    }

    public MethodInfo[] getConstructorMethods(Set set, boolean bl) {
        if (bl) {
            SourceTransaction sourceTransaction = null;
            if (this._constructorMethodInfos != null && EngineUtils.areEquivalentCollections(this._ignoreClasses, set) && !this._attachedToSrcTrans && (sourceTransaction = this.getSrcTrans()) == null) {
                return this.cloneMethodInfos(this._constructorMethodInfos);
            }
            if (this.getSourceClass() != null) {
                this.attachNode(this, null);
                this.attachSourceTransactionListener(this, sourceTransaction);
            }
        }
        List list = this.getConstructorMethodsImpl(set);
        JavaClass javaClass = this.getJavaClass();
        MethodInfo[] methodInfoArray = new MethodInfo[list.size()];
        list.toArray(methodInfoArray);
        if (bl) {
            this._constructorMethodInfos = this.cloneMethodInfos(methodInfoArray);
            this._ignoreClasses = set;
        }
        return methodInfoArray;
    }

    public MethodInfo[] getMethods(boolean bl, Set set, boolean bl2) {
        if (bl2) {
            SourceTransaction sourceTransaction = null;
            if (this._methodInfos != null && this._onlyPublic == bl && EngineUtils.areEquivalentCollections(this._ignoreClasses, set) && !this._attachedToSrcTrans && (sourceTransaction = this.getSrcTrans()) == null) {
                return this.cloneMethodInfos(this._methodInfos);
            }
            if (this.getSourceClass() != null) {
                this.attachNode(this, null);
                this.attachSourceTransactionListener(this, sourceTransaction);
            }
        }
        List list = this.getMethodsImpl(bl, set);
        JavaClass javaClass = this.getJavaClass();
        if (javaClass.isInterface()) {
            Collection collection = javaClass.getInterfaces();
            if (collection != null) {
                for (JavaType javaType : collection) {
                    this._addSuperMethods(bl, set, bl2, list, javaType.getQualifiedName());
                }
            }
        } else {
            String string = javaClass.getSuperclass().getQualifiedName();
            this._addSuperMethods(bl, set, bl2, list, string);
        }
        MethodInfo[] methodInfoArray = new MethodInfo[list.size()];
        list.toArray(methodInfoArray);
        if (bl2) {
            this._methodInfos = this.cloneMethodInfos(methodInfoArray);
            this._onlyPublic = bl;
            this._ignoreClasses = set;
        }
        return methodInfoArray;
    }

    private void _addSuperMethods(boolean bl, Set set, boolean bl2, List list, String string) {
        ClassEngine classEngine;
        MethodInfo[] methodInfoArray;
        if (!"java.lang.Object".equals(string) && (methodInfoArray = (classEngine = new ClassEngine(this._project, string)).getMethods(bl, set, bl2)) != null && methodInfoArray.length > 0) {
            int n = 0;
            while (n < methodInfoArray.length) {
                if (!list.contains(methodInfoArray[n])) {
                    list.add(methodInfoArray[n]);
                }
                ++n;
            }
        }
    }

    private List getMethodsImpl(boolean bl, Set set) {
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        SourceClass sourceClass = this.getSourceClass();
        Collection collection = sourceClass == null ? ((sourceClass = this.getJavaClass()) != null ? sourceClass.getDeclaredMethods() : null) : sourceClass.getSourceMethods();
        if (collection != null) {
            boolean bl2 = sourceClass.isInterface();
            for (JavaMethod javaMethod : collection) {
                MethodInfo methodInfo;
                if (!bl2 && bl && !EngineUtils.isPublic(javaMethod.getModifiers()) || set != null && set.contains(javaMethod.getOwningClass().getQualifiedName()) || arrayList.contains(methodInfo = new MethodInfo(javaMethod))) continue;
                arrayList.add(methodInfo);
            }
        }
        return arrayList;
    }

    private List getConstructorMethodsImpl(Set set) {
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        SourceClass sourceClass = this.getSourceClass();
        Collection collection = sourceClass == null ? ((sourceClass = this.getJavaClass()) != null ? sourceClass.getDeclaredConstructors() : null) : sourceClass.getDeclaredConstructors();
        if (collection != null) {
            boolean bl = sourceClass.isInterface();
            for (JavaMethod javaMethod : collection) {
                MethodInfo methodInfo;
                if (!EngineUtils.isPublic(javaMethod.getModifiers()) || set != null && set.contains(javaMethod.getOwningClass().getQualifiedName()) || arrayList.contains(methodInfo = new MethodInfo(javaMethod))) continue;
                arrayList.add(methodInfo);
            }
        }
        return arrayList;
    }

    private MethodInfo[] cloneMethodInfos(MethodInfo[] methodInfoArray) {
        int n = methodInfoArray != null ? methodInfoArray.length : 0;
        MethodInfo[] methodInfoArray2 = new MethodInfo[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            methodInfoArray2[n2] = new MethodInfo(methodInfoArray[n2]);
            --n2;
        }
        return methodInfoArray2;
    }

    public MethodInfo addMethod(MethodInfo methodInfo) throws EngineException {
        return this.addMethod(methodInfo, null);
    }

    public MethodInfo addMethod(MethodInfo methodInfo, MethodInfo methodInfo2) throws EngineException {
        return this.addMethodImpl(methodInfo, methodInfo2, CallMode.VALIDATE_AND_EXECUTE);
    }

    MethodInfo addMethodImpl(MethodInfo methodInfo, CallMode callMode) throws EngineException {
        return this.addMethodImpl(methodInfo, null, callMode);
    }

    MethodInfo addMethodImpl(MethodInfo methodInfo, MethodInfo methodInfo2, CallMode callMode) throws EngineException {
        if (callMode.execute()) {
            return new MethodInfo(MethodEngine.addMethod(this, methodInfo, methodInfo2));
        }
        return null;
    }

    public MethodInfo updateMethod(MethodInfo methodInfo, MethodInfo methodInfo2) throws EngineException {
        return this.updateMethodImpl(methodInfo, methodInfo2, CallMode.VALIDATE_AND_EXECUTE);
    }

    MethodInfo updateMethodImpl(MethodInfo methodInfo, MethodInfo methodInfo2, CallMode callMode) throws EngineException {
        if (callMode.execute()) {
            return new MethodInfo(MethodEngine.updateMethod(this, methodInfo, methodInfo2));
        }
        return methodInfo2;
    }

    public void removeMethod(MethodInfo methodInfo) throws EngineException {
        this.removeMethodImpl(methodInfo, CallMode.VALIDATE_AND_EXECUTE);
    }

    void removeMethodImpl(MethodInfo methodInfo, CallMode callMode) throws EngineException {
        if (callMode.execute()) {
            MethodEngine.removeMethod(this, methodInfo);
        }
    }

    protected void doApply() {
        SourceTransaction sourceTransaction;
        if (this.isEditable() && this._srcFile != null && (sourceTransaction = this._srcFile.getTransaction()) != null) {
            this.invalidateCache(sourceTransaction);
            sourceTransaction.commit();
        }
    }

    protected void doRevert() {
        SourceTransaction sourceTransaction;
        if (this.isEditable() && this._srcFile != null && (sourceTransaction = this._srcFile.getTransaction()) != null) {
            this.invalidateCache(sourceTransaction);
            sourceTransaction.abort();
        }
    }

    protected void invalidateCache() {
        this.invalidateCache(null);
    }

    protected void invalidateCache(SourceTransaction sourceTransaction) {
        this._methodInfos = null;
        this.detachNode(this);
        this.detachSourceTransactionListener(this, sourceTransaction);
    }

    private void attachSourceTransactionListener(SourceTransactionListener sourceTransactionListener, SourceTransaction sourceTransaction) {
        if (!this._attachedToSrcTrans) {
            if (sourceTransaction == null) {
                sourceTransaction = this.getSrcTrans();
            }
            if (sourceTransaction != null) {
                sourceTransaction.removeListener(sourceTransactionListener);
                sourceTransaction.addListener(sourceTransactionListener);
                this._attachedToSrcTrans = true;
            } else {
                this._attachedToSrcTrans = false;
            }
        }
    }

    private void detachSourceTransactionListener(SourceTransactionListener sourceTransactionListener, SourceTransaction sourceTransaction) {
        if (this._attachedToSrcTrans) {
            if (sourceTransaction == null) {
                sourceTransaction = this.getSrcTrans();
            }
            if (sourceTransaction != null) {
                sourceTransaction.removeListener(sourceTransactionListener);
            }
            this._attachedToSrcTrans = false;
        }
    }

    private SourceTransaction getSrcTrans() {
        SourceFile sourceFile = this.getSourceFile();
        return sourceFile != null ? sourceFile.getTransaction() : null;
    }

    private void attachNode(Observer observer, JavaSourceNode javaSourceNode) {
        if (!this._attachedToNode) {
            this._node = javaSourceNode == null ? this.getJavaSourceNode() : javaSourceNode;
            if (this._node != null) {
                this._node.detach(observer);
                this._node.attach(observer);
                this._attachedToNode = true;
            } else {
                this._attachedToNode = false;
            }
        }
    }

    private void detachNode(Observer observer) {
        if (this._attachedToNode) {
            if (this._node != null) {
                this._node.detach(observer);
            }
            this._attachedToNode = false;
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        this.invalidateCache(null);
    }

    public void changeUpdate(SourceTransaction sourceTransaction, SourceChange sourceChange) {
        this.invalidateCache(sourceTransaction);
    }

    public void closeUpdate(SourceTransaction sourceTransaction, boolean bl) {
    }
}

