/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.ide.Ide;
import oracle.ide.controls.StatusBar;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.engine.EngineConstants;
import oracle.jdeveloper.engine.EngineException;
import oracle.jdeveloper.engine.FieldInfo;
import oracle.jdeveloper.engine.MethodInfo;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public class EngineUtils
implements EngineConstants {
    public static final String JAVA_LANG = "java.lang";
    public static final String JAVA_MATH = "java.math";
    private static String[][] primitiveTypeMap = new String[][]{{"boolean", "java.lang.Boolean"}, {"byte", "java.lang.Byte"}, {"char", "java.lang.Character"}, {"double", "java.lang.Double"}, {"float", "java.lang.Float"}, {"int", "java.lang.Integer"}, {"long", "java.lang.Long"}, {"short", "java.lang.Short"}};

    public static void printStatus(String string, String string2) {
        StatusBar statusBar = Ide.getStatusBar();
        statusBar.setText(string + string2);
    }

    public static String getShortName(String string) {
        String string2 = null;
        int n = string.indexOf(60);
        if (n > 0) {
            String string3 = string.substring(n + 1, string.length() - 1);
            string2 = EngineUtils.getShortName(string3);
            string = string.substring(0, n);
        }
        String string4 = string;
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string4 = string.substring(n2 + 1);
        }
        if (n >= 0) {
            string4 = string4 + '<' + string2 + '>';
        }
        return string4;
    }

    public static final String getPackage(String string) {
        int n;
        int n2 = string.indexOf(60);
        if (n2 > 0) {
            string = string.substring(0, n2 - 1);
        }
        return (n = string.lastIndexOf(46)) >= 0 ? string.substring(0, n) : "";
    }

    public static boolean isValidClassName(String string) {
        boolean bl = false;
        if (string.length() > 0 && !string.startsWith(".") && !string.endsWith(".") && string.indexOf("..") == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            bl = true;
            while (stringTokenizer.hasMoreTokens()) {
                if (IdeUtil.isJavaIdentifier((String)stringTokenizer.nextToken())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static String renderMethod(int n, String string, String string2, List list, Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            stringBuffer.append(Modifier.toString(n));
            stringBuffer.append(' ');
        }
        if (string != null) {
            stringBuffer.append(EngineUtils.getShortName(string));
            stringBuffer.append(' ');
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(EngineUtils.renderParams(list));
        if (set != null && set.size() > 0) {
            stringBuffer.append(" throws ");
            stringBuffer.append(EngineUtils.renderThrown(set));
        }
        return stringBuffer.toString();
    }

    public static String renderParams(List list) {
        return EngineUtils.renderParams(list, -1);
    }

    public static String renderParams(List list, int n) {
        return EngineUtils.renderParams(list, n, true);
    }

    public static String renderParams(List list, int n, boolean bl) {
        if (list == null || list.size() == 0) {
            return bl ? "()" : "";
        }
        char[] cArray = new char[n + 2];
        Arrays.fill(cArray, ' ');
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        Object e = iterator.next();
        if (e instanceof List) {
            if (bl) {
                stringBuffer.append("( ");
            }
            Iterator iterator2 = ((List)e).iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append(EngineUtils.getShortName(iterator2.next().toString()));
                if (!iterator2.hasNext()) continue;
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(EngineUtils.getShortName(e.toString()));
        }
        while (iterator.hasNext()) {
            if (n >= 0) {
                stringBuffer.append(",\n");
                stringBuffer.append(cArray);
            } else {
                stringBuffer.append(", ");
            }
            e = iterator.next();
            if (e instanceof List) {
                Iterator iterator3 = ((List)e).iterator();
                while (iterator3.hasNext()) {
                    stringBuffer.append(EngineUtils.getShortName(iterator3.next().toString()));
                    if (!iterator3.hasNext()) continue;
                    stringBuffer.append(" ");
                }
                continue;
            }
            stringBuffer.append(EngineUtils.getShortName(e.toString()));
        }
        if (bl && stringBuffer.charAt(0) == '(') {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    public static String renderThrown(Set set) {
        String string;
        if (set == null || set.size() == 0) {
            string = "";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = set.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                stringBuffer.append(EngineUtils.getShortName(iterator.next().toString()));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String renderColumn(ResultSet resultSet) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            stringBuffer.append(resultSet.getString("TYPE_NAME"));
            if (!stringBuffer.toString().equals("DATE") && !stringBuffer.toString().startsWith("TIMESTAMP") && (n = resultSet.getInt("COLUMN_SIZE")) > 0) {
                stringBuffer.append('(');
                stringBuffer.append(n);
                int n2 = resultSet.getInt("DECIMAL_DIGITS");
                if (n2 > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(n2);
                }
                stringBuffer.append(')');
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static String getJavaType(String string) {
        if (string.startsWith("NUMBER") || string.startsWith("INTEGER")) {
            if (string.indexOf(",") > 0) {
                return Double.class.getName();
            }
            return Long.class.getName();
        }
        if (string.startsWith("FLOAT")) {
            return Float.class.getName();
        }
        if (string.startsWith("DOUBLE")) {
            return Double.class.getName();
        }
        if (string.startsWith("CLOB")) {
            return "char[]";
        }
        if (string.startsWith("BLOB")) {
            return "byte[]";
        }
        if (string.equals("DATE") || string.startsWith("TIMESTAMP")) {
            return Timestamp.class.getName();
        }
        return String.class.getName();
    }

    public static boolean isComplex(String string) {
        String string2;
        if (string == null) {
            return false;
        }
        return ModelUtil.hasLength((String)string) && PrimitiveType.lookupPrimitive((String)string) == null && (string2 = EngineUtils.getPackage(string)) != null && !JAVA_LANG.equals(string2) && !JAVA_MATH.equals(string2) && !"java.sql".equals(string2) && !"java.util".equals(string2);
    }

    public static boolean isCollection(JavaManager javaManager, String string) {
        JavaClass javaClass = javaManager.getClass(string);
        return javaClass != null && javaManager.getClass("java.util.Collection").isAssignableFrom((JavaType)javaClass);
    }

    public static boolean isArray(String string) {
        return string.indexOf(91) > 0;
    }

    public static void updateProjectAndNotify(Project project, Object object, String[] stringArray, URL uRL) {
        EngineUtils.updateProjectAndNotify(project, object, stringArray, uRL, null);
    }

    public static void updateProjectAndNotify(Project project, Object object, String[] stringArray, URL uRL, URL uRL2) {
        EngineUtils.updateProjectAndNotify(project, object, stringArray, uRL, uRL2, false);
    }

    public static void updateProjectAndNotify(Project project, Object object, String[] stringArray, URL uRL, URL uRL2, boolean bl) {
        project.applyBatchChanges((Runnable)new 1(uRL2, project, stringArray, uRL));
    }

    public static URL getProjectSourceDir(Project project) {
        URLPath uRLPath;
        URL[] uRLArray;
        URL uRL = null;
        if (project != null && (uRLArray = (uRLPath = PathsConfiguration.getInstance(project).getProjectSourcePath()).getEntries()) != null) {
            int n = 0;
            while (n < uRLArray.length) {
                if (URLFileSystem.isDirectoryPath((URL)uRLArray[n])) {
                    uRL = uRLArray[n];
                    break;
                }
                ++n;
            }
        }
        return uRL;
    }

    public static URL[] getProjectSourceDirs(Project project) {
        URL[] uRLArray;
        URLPath uRLPath;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URLPath uRLPath2 = uRLPath = project != null ? PathsConfiguration.getInstance(project).getProjectSourcePath() : null;
        if (uRLPath != null && (uRLArray = uRLPath.getEntries()) != null) {
            int n = 0;
            while (n < uRLArray.length) {
                URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper((URL)uRLArray[n]);
                if (uRLFileSystemHelper.isDirectoryPath(uRLArray[n]) || uRLFileSystemHelper.isDirectory(uRLArray[n])) {
                    arrayList.add(uRLArray[n]);
                }
                ++n;
            }
        }
        URL[] uRLArray2 = new URL[arrayList.size()];
        arrayList.toArray(uRLArray2);
        return uRLArray2;
    }

    public static boolean areEquivalentCollections(Collection collection, Collection collection2) {
        return ModelUtil.areEqual((Object)collection, (Object)collection2) || collection == null && collection2.size() == 0 || collection2 == null && collection.size() == 0;
    }

    public static void expandTypes(SourceFile sourceFile, MethodInfo methodInfo) {
        EngineUtils.expandType(sourceFile, methodInfo);
        List list = methodInfo.parameters;
        int n = list != null ? list.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            List list2 = (List)list.get(n2);
            list2.set(0, EngineUtils.expandType(sourceFile, (String)list2.get(0)));
            ++n2;
        }
    }

    public static void expandType(SourceFile sourceFile, FieldInfo fieldInfo) {
        if (fieldInfo != null) {
            fieldInfo.type = EngineUtils.expandType(sourceFile, fieldInfo.type);
        }
    }

    public static String expandType(SourceFile sourceFile, String string) {
        if (ModelUtil.hasLength((String)string) && "".equals(EngineUtils.getPackage(string))) {
            JavaType javaType;
            CallerContext callerContext;
            if ("String".equals(string)) {
                return "java.lang.String";
            }
            if ("Boolean".equals(string)) {
                return "java.lang.Boolean";
            }
            if ("Byte".equals(string)) {
                return "java.lang.Byte";
            }
            if ("Character".equals(string)) {
                return "java.lang.Character";
            }
            if ("Double".equals(string)) {
                return "java.lang.Double";
            }
            if ("Float".equals(string)) {
                return "java.lang.Float";
            }
            if ("Integer".equals(string)) {
                return "java.lang.Integer";
            }
            if ("Long".equals(string)) {
                return "java.lang.Long";
            }
            if ("Number".equals(string)) {
                return "java.lang.Number";
            }
            if ("Short".equals(string)) {
                return "java.lang.Short";
            }
            if ("Void".equals(string)) {
                return "java.lang.Void";
            }
            if ("Object".equals(string)) {
                return "java.lang.Object";
            }
            if ("Date".equals(string)) {
                return "java.sql.Date";
            }
            if ("Timestamp".equals(string)) {
                return "java.sql.Timestamp";
            }
            if ("Collection".equals(string)) {
                return "java.util.Collection";
            }
            if ("List".equals(string)) {
                return "java.util.List";
            }
            if ("Set".equals(string)) {
                return "java.util.Set";
            }
            if ("Map".equals(string)) {
                return "java.util.Map";
            }
            if ("Iterator".equals(string)) {
                return "java.util.Iterator";
            }
            if ("Enumeration".equals(string)) {
                return "java.util.Enumeration";
            }
            if (string.startsWith("Set<") || string.startsWith("Collection<") || string.startsWith("List<")) {
                return "java.util." + string;
            }
            if (sourceFile != null && (callerContext = CallerContext.createContext((SourceElement)sourceFile)) != null && (javaType = callerContext.resolveTypeName(string)) != null) {
                return javaType.getQualifiedName();
            }
        }
        return string;
    }

    public static JavaClass getJavaClass(JavaManager javaManager, String string, int n) {
        JavaClass javaClass = null;
        try {
            javaClass = javaManager.getClass(string);
        }
        catch (Exception exception) {
            javaClass = null;
        }
        if (javaClass == null) {
            javaManager.getCacheSupport().flushCache();
            javaClass = javaManager.getClass(string);
        }
        return javaClass;
    }

    public static SourceClass getSourceClass(JavaManager javaManager, String string) {
        SourceClass sourceClass = null;
        try {
            sourceClass = javaManager.getSourceClass(string);
        }
        catch (Exception exception) {
            sourceClass = null;
        }
        if (sourceClass == null) {
            javaManager.getCacheSupport().flushCache();
            sourceClass = javaManager.getSourceClass(string);
        }
        return sourceClass;
    }

    public static SourceFile getSourceFile(JavaManager javaManager, String string) {
        SourceClass sourceClass = EngineUtils.getSourceClass(javaManager, string);
        return sourceClass != null ? sourceClass.getOwningSourceFile() : null;
    }

    public static SourceClass getSourceClass(JavaSourceNode javaSourceNode, Project project) {
        JavaClass javaClass;
        SourceFile sourceFile = JavaManager.getJavaManager(project).getSourceFile(javaSourceNode.getURL());
        if (sourceFile != null && (javaClass = sourceFile.getPrimaryClass()) != null) {
            return (SourceClass)javaClass.getSourceElement();
        }
        return null;
    }

    public static JavaNode getJavaNode(Project project, String string) {
        URL uRL;
        string = string.replace('.', '/');
        URLPath uRLPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        URL[] uRLArray = uRLPath.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            Node node;
            uRL = URLFactory.newURL((URL)uRLArray[n], (String)(string + ".java"));
            if (URLFileSystem.isBound((URL)uRL) && (node = EngineUtils.findNode(JavaSourceNode.class, uRL)) != null) {
                return (JavaNode)node;
            }
            ++n;
        }
        URL uRL2 = JavaProject.getInstance(project).getOutputDirectory();
        uRL = URLFactory.newURL((URL)uRL2, (String)(string + ".class"));
        if (URLFileSystem.isBound((URL)uRL)) {
            return (JavaNode)EngineUtils.findNode(JavaClassNode.class, uRL);
        }
        return null;
    }

    public static Node findNode(Class clazz, URL uRL) {
        Node node = NodeFactory.find((URL)uRL);
        if (node == null && URLFileSystem.isBound((URL)uRL)) {
            try {
                node = clazz != null ? NodeFactory.findOrCreate((Class)clazz, (URL)uRL) : NodeFactory.findOrCreate((URL)uRL);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return node;
    }

    public static boolean removeImport(SourceFile sourceFile, String string) {
        if (sourceFile != null && string != null && ModelUtil.hasLength((String)(string = EngineUtils.trimClass(string)))) {
            Iterator iterator = sourceFile.getSourceImports().iterator();
            while (iterator.hasNext()) {
                SourceImport sourceImport = (SourceImport)iterator.next();
                if (!string.equals(sourceImport.getName())) continue;
                EngineUtils.openTransaction(sourceFile);
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    public static void addImport(String string, SourceFile sourceFile) {
        EngineUtils.addImport(string, sourceFile, false);
    }

    public static void addImport(String string, SourceFile sourceFile, boolean bl) {
        if (ModelUtil.hasLength((String)string) && !"void".equals(string) && !string.startsWith("java.lang.")) {
            int n = (string = EngineUtils.trimClass(string)).indexOf(60);
            if (n > 0) {
                String string2 = string.substring(n + 1, string.length() - 1);
                EngineUtils.addImport(string2, sourceFile);
                string = string.substring(0, n);
            }
            if (ModelUtil.hasLength((String)string) && string.indexOf(46) > 0 && !EngineUtils.getPackage(string).equals(sourceFile.getPackageName())) {
                SourceFactory sourceFactory = sourceFile.getFactory();
                SourceTypeReference sourceTypeReference = EngineUtils.createType(sourceFactory, string);
                List list = sourceFile.getSourceImports();
                if (!sourceTypeReference.isPrimitive()) {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    for (SourceImport sourceImport : list) {
                        if (string.equals(sourceImport.getName())) {
                            return;
                        }
                        treeSet.add(sourceImport.getName());
                    }
                    EngineUtils.openTransaction(sourceFile);
                    SourceImport sourceImport = sourceFactory.createImportDeclaration(string);
                    if (bl) {
                        sourceImport.setModifiers(8);
                    }
                    int n2 = 0;
                    for (SourceImport sourceImport2 : list) {
                        if (string.compareTo(sourceImport2.getName()) < 0) {
                            list.add(n2, sourceImport);
                            return;
                        }
                        ++n2;
                    }
                    list.add(sourceImport);
                }
            }
        }
    }

    public static String getGenericCollectionType(String string) {
        int n;
        int n2 = string.indexOf(60);
        if (n2 > 0 && (n = string.indexOf(62)) > n2) {
            return string.substring(n2 + 1, n);
        }
        return null;
    }

    public static SourceTypeReference createType(SourceFactory sourceFactory, String string) {
        int n = string.indexOf(60);
        SourceTypeReference sourceTypeReference = null;
        if (n > 0) {
            String string2 = string.substring(n + 1, string.length() - 1);
            sourceTypeReference = sourceFactory.createType(EngineUtils.getShortName(string2));
            string = string.substring(0, n);
        }
        SourceTypeReference sourceTypeReference2 = sourceFactory.createType(EngineUtils.getShortName(string));
        if (sourceTypeReference != null) {
            SourceTypeArgument sourceTypeArgument = sourceFactory.createTypeArgument(0, sourceTypeReference);
            sourceTypeReference2.getTypeArguments().add(sourceTypeArgument);
        }
        return sourceTypeReference2;
    }

    public static String trimClass(String string) {
        if (string != null) {
            string = string.trim();
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.length() - 1;
            while (n >= 0) {
                if (stringBuffer.charAt(n) == '[') {
                    stringBuffer.setLength(n);
                    break;
                }
                --n;
            }
            return stringBuffer.toString().trim();
        }
        return string;
    }

    public static boolean implementInterface(JavaManager javaManager, SourceClass sourceClass, String string) throws EngineException {
        return EngineUtils.implementInterface(javaManager, sourceClass, string, null);
    }

    public static boolean implementInterface(JavaManager javaManager, SourceClass sourceClass, String string, String string2) throws EngineException {
        return EngineUtils.addOrImplementInterface(javaManager, sourceClass, string, string2, true);
    }

    public static boolean addInterface(JavaManager javaManager, SourceClass sourceClass, String string) {
        boolean bl = false;
        try {
            bl = EngineUtils.addOrImplementInterface(javaManager, sourceClass, string, null, false);
        }
        catch (EngineException engineException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean addOrImplementInterface(JavaManager javaManager, SourceClass sourceClass, String string, String string2, boolean bl) throws EngineException {
        JavaClass javaClass = EngineUtils.getJavaClass(javaManager, string, -1);
        if (bl && javaClass == null) {
            throw new EngineException("Interface " + string + " not found!");
        }
        if (bl && !javaClass.isInterface()) {
            throw new EngineException("Class " + string + " is not an interface!");
        }
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        SourceFactory sourceFactory = sourceFile.getFactory();
        EngineUtils.addImport(string, sourceFile);
        EngineUtils.openTransaction(sourceFile);
        sourceClass.getSourceInterfaces().add(EngineUtils.createType(sourceFactory, string));
        if (bl) {
            List list = sourceClass.getSourceMethods();
            for (JavaMethod javaMethod : javaClass.getDeclaredMethods()) {
                MethodInfo methodInfo = new MethodInfo(javaMethod);
                if (ModelUtil.hasLength((String)string2)) {
                    methodInfo.removeException(string2);
                }
                methodInfo.modifiers = 1;
                list.add(methodInfo.createSourceMethod(sourceFile, true));
            }
        }
        return true;
    }

    public static void addAnnotation(SourceElement sourceElement, String string, List list) {
        int n;
        Collection collection = EngineUtils._getSourceAnnotations(sourceElement);
        SourceAnnotation sourceAnnotation = EngineUtils._findSourceAnnotation(string, collection);
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        SourceFactory sourceFactory = sourceFile.getFactory();
        EngineUtils.openTransaction(sourceFile);
        int n2 = n = list == null ? 0 : list.size();
        if (n > 0) {
            if (sourceAnnotation != null) {
                SourceListExpression sourceListExpression = sourceAnnotation.getArgumentList();
                if (sourceListExpression != null) {
                    List list2 = sourceListExpression.getOperands();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string2 = ((String)iterator.next()).trim();
                        int n3 = string2.indexOf(61);
                        String string3 = n3 > 0 ? string2.substring(0, n3).trim() : string2;
                        for (SourceExpression sourceExpression : list2) {
                            String string4 = sourceExpression.getFirstOperand().getText().trim();
                            if (!string3.equals(string4)) continue;
                            sourceExpression.replaceSelf((SourceElement)sourceFactory.createExpressionFromText(string2));
                            return;
                        }
                        list2.add(sourceFactory.createExpressionFromText(string2));
                    }
                } else {
                    SourceExpression[] sourceExpressionArray = new SourceExpression[n];
                    int n4 = 0;
                    while (n4 < n) {
                        String string5 = (String)list.get(n4);
                        sourceExpressionArray[n4] = sourceFactory.createExpression(string5);
                        ++n4;
                    }
                    sourceListExpression = sourceFactory.createArgumentList(sourceExpressionArray);
                    sourceAnnotation.removeSelf();
                    EngineUtils.addImport(string, sourceFile);
                    if (sourceExpressionArray.length > 0) {
                        collection.add(sourceFactory.createAnnotation(EngineUtils.getShortName(string), sourceFactory.createExpressionList(sourceExpressionArray)));
                    } else {
                        collection.add(sourceFactory.createAnnotation(EngineUtils.getShortName(string)));
                    }
                }
            } else {
                SourceExpression[] sourceExpressionArray = new SourceExpression[n];
                int n5 = 0;
                while (n5 < n) {
                    String string6 = (String)list.get(n5);
                    sourceExpressionArray[n5] = sourceFactory.createExpression(string6);
                    ++n5;
                }
                EngineUtils.addImport(string, sourceFile);
                if (sourceExpressionArray.length > 0) {
                    collection.add(sourceFactory.createAnnotation(EngineUtils.getShortName(string), sourceFactory.createArgumentList(sourceExpressionArray)));
                } else {
                    collection.add(sourceFactory.createAnnotation(EngineUtils.getShortName(string)));
                }
            }
        } else if (sourceAnnotation == null) {
            EngineUtils.addImport(string, sourceFile);
            collection.add(sourceFactory.createAnnotation(EngineUtils.getShortName(string)));
        }
    }

    private static SourceAnnotation _findSourceAnnotation(String string, Collection collection) {
        SourceAnnotation sourceAnnotation = null;
        if (collection != null) {
            for (SourceAnnotation sourceAnnotation2 : collection) {
                JavaType javaType;
                JavaAnnotation javaAnnotation = (JavaAnnotation)sourceAnnotation2.getCompiledObject();
                JavaType javaType2 = javaType = javaAnnotation != null ? javaAnnotation.getResolvedType() : null;
                if (javaType == null || !string.equals(javaType.getQualifiedName())) continue;
                sourceAnnotation = sourceAnnotation2;
                break;
            }
        }
        return sourceAnnotation;
    }

    private static Collection _getSourceAnnotations(SourceElement sourceElement) {
        Collection collection = null;
        if (SourceMethod.class.isAssignableFrom(sourceElement.getClass())) {
            collection = ((SourceMethod)sourceElement).getSourceAnnotations();
        } else if (SourceClass.class.isAssignableFrom(sourceElement.getClass())) {
            collection = ((SourceClass)sourceElement).getSourceAnnotations();
        } else if (SourceFieldVariable.class.isAssignableFrom(sourceElement.getClass())) {
            collection = ((SourceFieldVariable)sourceElement).getSourceAnnotations();
        } else if (JavaHasAnnotations.class.isAssignableFrom(sourceElement.getClass())) {
            collection = ((JavaHasAnnotations)sourceElement).getAnnotations();
        }
        return collection;
    }

    public static String getAnnotationAttr(SourceElement sourceElement, String string, String string2, String string3) {
        Collection collection = EngineUtils._getSourceAnnotations(sourceElement);
        SourceAnnotation sourceAnnotation = EngineUtils._findSourceAnnotation(string, collection);
        return EngineUtils.getAnnotationAttr(sourceAnnotation, string2, string3);
    }

    public static String getAnnotationAttr(SourceAnnotation sourceAnnotation, String string, String string2) {
        SourceListExpression sourceListExpression;
        if (sourceAnnotation != null && (sourceListExpression = sourceAnnotation.getArgumentList()) != null) {
            List list = sourceListExpression.getOperands();
            for (SourceExpression sourceExpression : list) {
                if (!string.equals(sourceExpression.getOperandAt(0).getText()) || sourceExpression.getOperandCount() <= 1) continue;
                return sourceExpression.getOperandAt(1).getText();
            }
        }
        return string2;
    }

    public static SourceAnnotation getAnnotation(SourceElement sourceElement, String string) {
        Collection collection = EngineUtils._getSourceAnnotations(sourceElement);
        return EngineUtils._findSourceAnnotation(string, collection);
    }

    public static SourceBlock createTryCatchClause(SourceFile sourceFile, SourceFactory sourceFactory, SourceBlock sourceBlock, String[] stringArray) {
        SourceBlock sourceBlock2 = sourceFactory.createBlock();
        EngineUtils.addImport(stringArray[0], sourceFile);
        SourceBlock sourceBlock3 = sourceFactory.createBlock(new SourceElement[]{sourceFactory.createStatement("e.printStackTrace();")});
        SourceTryStatement sourceTryStatement = sourceFactory.createTryCatchStatement(sourceFactory.createBlockStatement(sourceBlock2), sourceFactory.createLocalVariable(sourceFactory.createType(stringArray[0]), "e"), sourceFactory.createBlockStatement(sourceBlock3));
        int n = 1;
        while (n < stringArray.length) {
            EngineUtils.addImport(stringArray[n], sourceFile);
            sourceBlock3 = sourceFactory.createBlock(new SourceElement[]{sourceFactory.createStatement("e.printStackTrace();")});
            sourceTryStatement.getCatchClauses().add(sourceFactory.createCatchClause(sourceFactory.createLocalVariable(sourceFactory.createType(stringArray[n]), "e"), sourceFactory.createBlockStatement(sourceBlock3)));
            ++n;
        }
        sourceBlock.getCodeElements().add(sourceTryStatement);
        return sourceBlock2;
    }

    public static final String getPackageFromFullClassName(String string) {
        return EngineUtils.getPackage(string);
    }

    public static SourceTransaction openTransaction(SourceFile sourceFile) {
        SourceTransaction sourceTransaction = sourceFile.getTransaction();
        if (sourceTransaction == null) {
            sourceTransaction = sourceFile.beginTransaction();
        }
        return sourceTransaction;
    }

    public static SourceSavepoint createSavepoint(SourceFile sourceFile) {
        return EngineUtils.openTransaction(sourceFile).savepoint();
    }

    public static boolean isPublic(int n) {
        return (n & 1) != 0;
    }

    public static boolean isPrivate(int n) {
        return (n & 2) != 0;
    }

    public static boolean isProtected(int n) {
        return (n & 4) != 0;
    }

    public static boolean isAbstract(int n) {
        return (n & 0x400) != 0;
    }

    public static boolean isNative(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean isFinal(int n) {
        return (n & 0x10) != 0;
    }

    public static String getPrimitiveFromClass(String string) {
        int n = 0;
        while (n < primitiveTypeMap.length) {
            if (string.equals(primitiveTypeMap[n][1])) {
                return primitiveTypeMap[n][0];
            }
            ++n;
        }
        return null;
    }

    public static String getClassFromPrimitive(String string) {
        int n = 0;
        while (n < primitiveTypeMap.length) {
            if (string.equals(primitiveTypeMap[n][0])) {
                return primitiveTypeMap[n][1];
            }
            ++n;
        }
        return null;
    }

    public static boolean fileExists(Project project, String string, String string2) {
        URL uRL = EngineUtils.makeFileURL(project, string, string2 + ".java");
        Node node = NodeFactory.findInFolder((Folder)project, (URL)uRL);
        if (node != null) {
            return true;
        }
        return URLFileSystem.exists((URL)uRL);
    }

    public static String capitalize(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public static String makeReaderName(String string, String string2) {
        String string3 = string2 = string2 != null ? EngineUtils.getShortName(string2) : string2;
        if (string2 == null) {
            return string;
        }
        return (string2.toLowerCase().equals("boolean") ? "is" : "get") + EngineUtils.capitalize(string);
    }

    public static String makeReaderName(String string) {
        return "get" + EngineUtils.capitalize(string);
    }

    public static String makeWriterName(String string) {
        return "set" + EngineUtils.capitalize(string);
    }

    public static Node createNode(Project project, String string, String string2) {
        URL uRL = EngineUtils.makeFileURL(project, string, string2);
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node != null) {
                project.add((Element)node, true);
            }
            Node node2 = node;
            return node2;
        }
        catch (Exception exception) {
            Node node = null;
            return node;
        }
    }

    public static String makeFilePath(Project project, String string, String string2) {
        return URLFileSystem.getPlatformPathName((URL)EngineUtils.makeFileURL(project, string, string2));
    }

    public static URL makeFileURL(Project project, String string, String string2) {
        URL uRL = JProjectUtil.getProjectBasePath(project);
        URL uRL2 = string != null && string.length() > 0 ? URLFactory.newDirURL((URL)uRL, (String)string.replace('.', '/')) : uRL;
        return URLFactory.newURL((URL)uRL2, (String)string2);
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ URL v$classDir;
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ String[] v$libs;
        private final /* synthetic */ URL v$sourceDir;

        public void run() {
            JProjectPaths jProjectPaths;
            URLPath uRLPath;
            if (this.v$classDir != null && !(uRLPath = (jProjectPaths = JProjectPaths.getInstance((PropertyStorage)this.v$project)).getAdditionalClassPath()).contains(this.v$classDir)) {
                uRLPath.add(this.v$classDir);
                jProjectPaths.setAdditionalClassPath(uRLPath);
            }
            if (this.v$libs != null) {
                JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)this.v$project);
                int n = 0;
                while (n < this.v$libs.length) {
                    jProjectLibraries.addLibrary(this.v$libs[n]);
                    ++n;
                }
            }
            if (this.v$sourceDir != null) {
                URLPath uRLPath2 = PathsConfiguration.getInstance(this.v$project).getProjectSourcePath();
                uRLPath2.add(this.v$sourceDir);
                PathsConfiguration.getInstance(this.v$project).setProjectSourcePath(uRLPath2);
            }
        }

        public 1(URL uRL, Project project, String[] stringArray, URL uRL2) {
            this.v$sourceDir = uRL2;
            this.v$libs = stringArray;
            this.v$project = project;
            this.v$classDir = uRL;
        }
    }
}

