/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.engine.ClassEngine;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.FieldInfo;

public class FieldEngine {
    static final int ADD_READER = 1;
    static final int ADD_WRITER = 2;
    static final int REMOVE_READER = 3;
    static final int REMOVE_WRITER = 4;

    public static FieldInfo addField(ClassEngine classEngine, FieldInfo fieldInfo) {
        return FieldEngine.addField(classEngine, fieldInfo, null);
    }

    public static FieldInfo addField(ClassEngine classEngine, FieldInfo fieldInfo, FieldInfo fieldInfo2) {
        SourceClass sourceClass = classEngine.getSourceClass();
        if (!(classEngine.isEditable() && ModelUtil.hasLength((String)fieldInfo.name) && ModelUtil.hasLength((String)fieldInfo.type))) {
            return null;
        }
        if (sourceClass.getField(fieldInfo.name) != null) {
            return fieldInfo;
        }
        EngineUtils.openTransaction(classEngine.getSourceFile());
        List list = sourceClass.getSourceFieldDeclarations();
        list.add(list.size(), fieldInfo.createSourceFieldDecl(classEngine.getSourceFile()));
        return fieldInfo;
    }

    public static boolean removeField(ClassEngine classEngine, String string) {
        if (!classEngine.isEditable()) {
            return false;
        }
        SourceClass sourceClass = classEngine.getSourceClass();
        SourceFieldVariable sourceFieldVariable = sourceClass.getSourceFieldVariable(string);
        if (sourceFieldVariable != null) {
            EngineUtils.openTransaction(classEngine.getSourceFile());
            sourceFieldVariable.removeSelf();
        }
        return true;
    }

    public static FieldInfo updateField(ClassEngine classEngine, FieldInfo fieldInfo, FieldInfo fieldInfo2) {
        SourceFieldDeclaration sourceFieldDeclaration;
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceClass sourceClass = classEngine.getSourceClass();
        SourceFile sourceFile = classEngine.getSourceFile();
        EngineUtils.openTransaction(sourceFile);
        if (!EngineUtils.isAbstract(fieldInfo.modifiers)) {
            SourceFieldVariable sourceFieldVariable;
            SourceFieldVariable sourceFieldVariable2 = sourceFieldVariable = fieldInfo != null ? sourceClass.getSourceFieldVariable(fieldInfo.name) : null;
            if (sourceFieldVariable != null) {
                sourceFieldVariable.removeSelf();
            }
        }
        if (!EngineUtils.isAbstract(fieldInfo2.modifiers) && (sourceFieldDeclaration = fieldInfo2.createSourceFieldDecl(sourceFile)) != null) {
            List list = sourceClass.getSourceFieldDeclarations();
            list.add(list.size(), sourceFieldDeclaration);
        }
        return fieldInfo2;
    }
}

