/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.JavaInfo;
import oracle.jdeveloper.engine.MethodInfo;

public class FieldInfo
implements Comparable,
Copyable,
JavaInfo {
    public String name;
    public String type;
    public String typeSignature;
    public int modifiers;
    public int accessorModifiers;

    void $init$() {
        this.type = "java.lang.String";
        this.modifiers = 0;
        this.accessorModifiers = 0;
    }

    public FieldInfo() {
        this.$init$();
    }

    public FieldInfo(String string, String string2, int n) {
        this.$init$();
        this.name = string2;
        this.type = string;
        this.modifiers = n;
    }

    public FieldInfo(JavaVariable javaVariable) {
        this.$init$();
        if (javaVariable != null) {
            this.name = javaVariable.getName();
            JavaType javaType = javaVariable.getResolvedType();
            if (javaType != null) {
                this.type = javaType.getQualifiedName();
            }
            this.modifiers = javaVariable.getModifiers();
        }
    }

    public FieldInfo(FieldInfo fieldInfo) {
        this.$init$();
        if (fieldInfo != null) {
            this.name = fieldInfo.name;
            this.type = fieldInfo.type;
            this.modifiers = fieldInfo.modifiers;
        }
    }

    public Object copyTo(Object object) {
        FieldInfo fieldInfo = object != null ? (FieldInfo)object : new FieldInfo();
        this.copyToImpl(fieldInfo);
        return fieldInfo;
    }

    protected final void copyToImpl(FieldInfo fieldInfo) {
        fieldInfo.name = this.name;
        fieldInfo.type = this.type;
        fieldInfo.modifiers = this.modifiers;
    }

    public String render() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(" : ");
        stringBuffer.append(EngineUtils.getShortName(this.type));
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        FieldInfo fieldInfo = (FieldInfo)object;
        return (this.name + " " + this.type).compareTo(fieldInfo.name + " " + fieldInfo.type);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((FieldInfo)object);
    }

    protected final boolean equalsImpl(FieldInfo fieldInfo) {
        return ModelUtil.areEqual((Object)this.name, (Object)fieldInfo.name) && ModelUtil.areEqual((Object)this.type, (Object)fieldInfo.type);
    }

    public String toString() {
        return this.name + " : " + this.type;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int validate() {
        if (this.name != null) {
            this.name = this.name.trim();
        }
        if (this.type != null) {
            this.type = this.type.trim();
        }
        if (this.name != null && this.name.length() > 0) {
            if (!IdeUtil.isJavaIdentifier((String)this.name)) {
                return 1;
            }
        } else {
            return 2;
        }
        if (this.type == null) {
            return 4;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public MethodInfo makeGetter() {
        return this.makeGetter(this.name, this.type);
    }

    public MethodInfo makeGetter(String string, String string2) {
        MethodInfo methodInfo = new MethodInfo(string2, EngineUtils.makeReaderName(string, string2), this.accessorModifiers);
        return methodInfo;
    }

    public MethodInfo makeSetter() {
        return this.makeSetter(this.name, this.type);
    }

    public MethodInfo makeSetter(String string, String string2) {
        MethodInfo methodInfo = new MethodInfo("void", EngineUtils.makeWriterName(string), this.accessorModifiers);
        methodInfo.addParameter(string2, string);
        return methodInfo;
    }

    public SourceFieldDeclaration createSourceFieldDecl(SourceFile sourceFile) {
        return this.createSourceFieldDecl(sourceFile, null);
    }

    public SourceFieldDeclaration createSourceFieldDecl(SourceFile sourceFile, String string) {
        if (!EngineUtils.isAbstract(this.modifiers)) {
            SourceFactory sourceFactory = sourceFile.getFactory();
            EngineUtils.addImport(this.type, sourceFile);
            SourceTypeReference sourceTypeReference = EngineUtils.createType(sourceFactory, this.type);
            return ModelUtil.hasLength((String)string) ? sourceFactory.createFieldDeclaration(this.modifiers, sourceTypeReference, this.name, sourceFactory.createExpression(string)) : sourceFactory.createFieldDeclaration(this.modifiers, sourceTypeReference, this.name);
        }
        return null;
    }

    public SourceLocalVariableDeclaration createLocalVariableDeclaration(SourceFile sourceFile) {
        return this.createLocalVariableDeclaration(sourceFile, null);
    }

    public SourceLocalVariableDeclaration createLocalVariableDeclaration(SourceFile sourceFile, String string) {
        if (!EngineUtils.isAbstract(this.modifiers)) {
            SourceFactory sourceFactory = sourceFile.getFactory();
            EngineUtils.addImport(this.type, sourceFile);
            SourceTypeReference sourceTypeReference = EngineUtils.createType(sourceFactory, this.type);
            return ModelUtil.hasLength((String)string) ? sourceFactory.createLocalVariableDeclaration(this.modifiers, sourceTypeReference, this.name, sourceFactory.createExpression(string)) : sourceFactory.createLocalVariableDeclaration(this.modifiers, sourceTypeReference, this.name);
        }
        return null;
    }

    public SourceLocalVariable createLocalVariable(SourceFile sourceFile) {
        return this.createLocalVariable(sourceFile, null);
    }

    public SourceLocalVariable createLocalVariable(SourceFile sourceFile, String string) {
        if (!EngineUtils.isAbstract(this.modifiers)) {
            SourceFactory sourceFactory = sourceFile.getFactory();
            EngineUtils.addImport(this.type, sourceFile);
            SourceTypeReference sourceTypeReference = EngineUtils.createType(sourceFactory, this.type);
            return ModelUtil.hasLength((String)string) ? sourceFactory.createLocalVariable(this.modifiers, sourceTypeReference, this.name, sourceFactory.createExpression(string)) : sourceFactory.createLocalVariable(this.modifiers, sourceTypeReference, this.name);
        }
        return null;
    }
}

