/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.engine.ClassEngine;
import oracle.jdeveloper.engine.EngineConstants;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.FieldInfo;
import oracle.jdeveloper.engine.MethodInfo;
import oracle.jdeveloper.java.JavaManager;

public class MethodEngine
implements EngineConstants {
    public static MethodInfo addMethod(ClassEngine classEngine, MethodInfo methodInfo) {
        return MethodEngine.addMethod(classEngine, methodInfo, null);
    }

    public static MethodInfo addMethod(ClassEngine classEngine, MethodInfo methodInfo, MethodInfo methodInfo2) {
        if (!classEngine.isEditable() || MethodEngine.findSourceMethod(classEngine, methodInfo.name, methodInfo.parameters) != null) {
            return null;
        }
        SourceFile sourceFile = classEngine.getSourceFile();
        SourceMethod sourceMethod = methodInfo.createSourceMethod(sourceFile, true);
        SourceMethod sourceMethod2 = methodInfo2 != null ? MethodEngine.findSourceMethod(classEngine, methodInfo2.name, methodInfo2.parameters) : null;
        EngineUtils.openTransaction(sourceFile);
        if (sourceMethod2 != null) {
            List list = classEngine.getSourceClass().getSourceMethods();
            int n = 0;
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (sourceMethod2.equals(iterator.next())) {
                    list.add(n + 1, sourceMethod);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                list.add(sourceMethod);
            }
        } else {
            classEngine.getSourceClass().getSourceMethods().add(sourceMethod);
        }
        return methodInfo;
    }

    public static void addDefaultImpl(MethodInfo methodInfo, SourceFile sourceFile, SourceMethod sourceMethod) {
        if (!(EngineUtils.isAbstract(methodInfo.modifiers) || EngineUtils.isNative(methodInfo.modifiers) || methodInfo.type == null || methodInfo.type.length() <= 0 || methodInfo.type.equals("void"))) {
            String string = EngineUtils.getClassFromPrimitive(methodInfo.type);
            string = string == null ? (methodInfo.type.equals("java.lang.Boolean") ? "Boolean.FALSE" : "null") : (string.equals("boolean") ? "false" : "0");
            EngineUtils.openTransaction(sourceFile);
            SourceFactory sourceFactory = sourceFile.getFactory();
            sourceMethod.getBlock().getCodeElements().add(sourceFactory.createStatement("return " + string + ';'));
        }
    }

    public static boolean removeMethod(ClassEngine classEngine, String string) {
        SourceClass sourceClass = (SourceClass)classEngine.getJavaClass().getSourceElement();
        if (sourceClass == null || URLFileSystem.isReadOnly((URL)sourceClass.getOwningSourceFile().getURL())) {
            return false;
        }
        Iterator iterator = sourceClass.getSourceMethods(string).iterator();
        if (iterator.hasNext()) {
            iterator.remove();
            return true;
        }
        return false;
    }

    public static boolean removeMethod(ClassEngine classEngine, MethodInfo methodInfo) {
        SourceMethod sourceMethod;
        if (classEngine.isEditable() && (sourceMethod = MethodEngine.findSourceMethod(classEngine, methodInfo.name, methodInfo.parameters)) != null) {
            EngineUtils.openTransaction(classEngine.getSourceFile());
            sourceMethod.removeSelf();
            return true;
        }
        return false;
    }

    public static MethodInfo addReader(ClassEngine classEngine, FieldInfo fieldInfo, String string, int n) {
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceFile sourceFile = classEngine.getSourceFile();
        MethodInfo methodInfo = new MethodInfo(fieldInfo.type, string, n);
        SourceMethod sourceMethod = methodInfo.createSourceMethod(sourceFile, MethodEngine.getReaderStatement(fieldInfo.type, fieldInfo.name, n));
        EngineUtils.openTransaction(sourceFile);
        classEngine.getSourceClass().getSourceMethods().add(sourceMethod);
        EngineUtils.createSavepoint(sourceFile);
        MethodInfo methodInfo2 = new MethodInfo(sourceMethod);
        methodInfo2.type = methodInfo.type;
        return methodInfo2;
    }

    private static String getReaderStatement(String string, String string2, int n) {
        String string3 = null;
        if (!EngineUtils.isAbstract(n)) {
            String string4 = null;
            string4 = ModelUtil.hasLength((String)string2) ? " " + string2 : (EngineUtils.getClassFromPrimitive(string) != null ? (string.equals(" boolean") ? " false" : " 0") : " null");
            string3 = "return" + string4 + ';';
        }
        return string3;
    }

    public static void updateReader(ClassEngine classEngine, MethodInfo methodInfo, String string, MethodInfo methodInfo2, String string2) {
        SourceMethod sourceMethod;
        if (!classEngine.isEditable()) {
            return;
        }
        methodInfo2 = MethodEngine.updateMethod(classEngine, methodInfo, methodInfo2);
        if (!EngineUtils.isAbstract(methodInfo2.modifiers) && (sourceMethod = MethodEngine.findSourceMethod(classEngine, methodInfo2.name, methodInfo2.parameters)) != null) {
            try {
                SourceBlock sourceBlock = sourceMethod.getBlock();
                List list = sourceBlock.getCodeElements();
                SourceElement sourceElement = (SourceElement)list.get(0);
                SourceExpression sourceExpression = ((SourceReturnStatement)sourceElement).getExpression();
                String string3 = ((SourceSimpleNameExpression)sourceExpression).getName();
                if (string3.equals(string)) {
                    ((SourceSimpleNameExpression)sourceExpression).setName(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static MethodInfo removeReader(ClassEngine classEngine, FieldInfo fieldInfo) {
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceClass sourceClass = classEngine.getSourceClass();
        String string = EngineUtils.makeReaderName(fieldInfo.name, fieldInfo.type);
        SourceMethod sourceMethod = sourceClass.getSourceMethod(string, JavaType.EMPTY_ARRAY);
        MethodInfo methodInfo = null;
        if (sourceMethod == null) {
            string = EngineUtils.makeReaderName(fieldInfo.name);
            sourceMethod = sourceClass.getSourceMethod(string, JavaType.EMPTY_ARRAY);
        }
        if (sourceMethod != null) {
            methodInfo = new MethodInfo(sourceMethod);
            EngineUtils.openTransaction(classEngine.getSourceFile());
            sourceMethod.removeSelf();
        }
        return methodInfo;
    }

    public static MethodInfo addWriter(ClassEngine classEngine, FieldInfo fieldInfo, String string, int n) {
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceFile sourceFile = classEngine.getSourceFile();
        MethodInfo methodInfo = new MethodInfo("void", string, n);
        methodInfo.addParameter(fieldInfo.type, fieldInfo.name);
        EngineUtils.openTransaction(sourceFile);
        SourceMethod sourceMethod = methodInfo.createSourceMethod(sourceFile, MethodEngine.getWriterStatement(fieldInfo.name, string, n));
        classEngine.getSourceClass().getSourceMethods().add(sourceMethod);
        return methodInfo;
    }

    private static String getWriterStatement(String string, String string2, int n) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (!EngineUtils.isAbstract(n)) {
            if (!ModelUtil.hasLength((String)string)) {
                stringBuffer.append("super.");
                stringBuffer.append(string2);
                stringBuffer.append('(');
                stringBuffer.append(string);
                stringBuffer.append(')');
            } else {
                stringBuffer.append("this.");
                stringBuffer.append(string);
                stringBuffer.append(" = ");
                stringBuffer.append(string);
            }
            stringBuffer.append(';');
        }
        return ModelUtil.hasLength((String)(string3 = stringBuffer.toString())) ? string3 : null;
    }

    public static void updateWriter(ClassEngine classEngine, MethodInfo methodInfo, String string, MethodInfo methodInfo2, String string2) {
        SourceMethod sourceMethod;
        if (!classEngine.isEditable()) {
            return;
        }
        methodInfo2 = MethodEngine.updateMethod(classEngine, methodInfo, methodInfo2);
        if (!EngineUtils.isAbstract(methodInfo2.modifiers) && (sourceMethod = MethodEngine.findSourceMethod(classEngine, methodInfo2.name, methodInfo2.parameters)) != null) {
            try {
                SourceBlock sourceBlock = sourceMethod.getBlock();
                List list = sourceBlock.getCodeElements();
                SourceElement sourceElement = (SourceElement)list.get(0);
                SourceExpressionStatement sourceExpressionStatement = (SourceExpressionStatement)sourceElement;
                SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceExpressionStatement.getExpression();
                SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceAssignmentExpression.getFirstOperand();
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceDotExpression.getFirstOperand();
                SourceSimpleNameExpression sourceSimpleNameExpression2 = (SourceSimpleNameExpression)sourceAssignmentExpression.getSecondOperand();
                if ("this".equals(sourceSimpleNameExpression.getName()) && string.equals(sourceDotExpression.getName()) && string.equals(sourceSimpleNameExpression2.getName())) {
                    sourceDotExpression.setName(string2);
                    sourceSimpleNameExpression2.setName(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static MethodInfo removeWriter(ClassEngine classEngine, FieldInfo fieldInfo) {
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceClass sourceClass = classEngine.getSourceClass();
        String string = EngineUtils.makeWriterName(fieldInfo.name);
        JavaManager javaManager = classEngine.getJavaManager();
        JavaClass javaClass = javaManager.getClass(fieldInfo.type);
        SourceMethod sourceMethod = sourceClass.getSourceMethod(string, new JavaType[]{javaClass});
        MethodInfo methodInfo = null;
        if (sourceMethod != null) {
            methodInfo = new MethodInfo(sourceMethod);
            EngineUtils.openTransaction(classEngine.getSourceFile());
            sourceMethod.removeSelf();
        }
        return methodInfo;
    }

    public static MethodInfo updateMethod(ClassEngine classEngine, MethodInfo methodInfo, MethodInfo methodInfo2) {
        SourceBlock sourceBlock;
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceFile sourceFile = classEngine.getSourceFile();
        SourceMethod sourceMethod = MethodEngine.findSourceMethod(classEngine, methodInfo.name, methodInfo.parameters);
        if (sourceMethod == null) {
            return MethodEngine.addMethod(classEngine, methodInfo2);
        }
        EngineUtils.openTransaction(sourceFile);
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceBlock sourceBlock2 = null;
        if (!EngineUtils.isAbstract(methodInfo2.modifiers) && (sourceBlock = sourceMethod.getBlock()) != null) {
            sourceBlock2 = sourceFactory.createBlock(sourceBlock.getText());
        }
        SourceMethod sourceMethod2 = methodInfo2.createSourceMethod(sourceFile, sourceBlock2);
        sourceFile.getTransaction().savepoint();
        SourceDocComment sourceDocComment = sourceMethod.getDocComment();
        if (sourceDocComment != null) {
            String string = sourceDocComment.getText();
            sourceMethod2.setDocComment(sourceFactory.createDocComment(string));
        }
        sourceMethod.replaceSelf((SourceElement)sourceMethod2);
        return methodInfo2;
    }

    public static SourceMethod findSourceMethod(ClassEngine classEngine, String string, List list) {
        SourceClass sourceClass = classEngine.getSourceClass();
        if (sourceClass == null) {
            return null;
        }
        int n = list != null ? list.size() : 0;
        JavaType[] javaTypeArray = new JavaType[n];
        JavaManager javaManager = classEngine.getJavaManager();
        if (n > 0) {
            n = 0;
            for (List list2 : list) {
                javaTypeArray[n++] = javaManager.getClass((String)list2.get(0));
            }
        }
        return sourceClass.getSourceMethod(string, javaTypeArray);
    }

    public static boolean updateParamInMethod(ClassEngine classEngine, SourceMethod sourceMethod, String string, String string2, String string3, String string4) {
        for (SourceVariable sourceVariable : sourceMethod.getSourceParameters()) {
            if (!string2.equals(sourceVariable.getName()) || !string.equals(sourceVariable.getResolvedType().getQualifiedName())) continue;
            sourceVariable.setName(string4);
            sourceVariable.setSourceType(EngineUtils.createType(classEngine.getFactory(), string3));
            return true;
        }
        return false;
    }
}

