/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.FieldInfo;
import oracle.jdeveloper.engine.MethodEngine;

public class MethodInfo
extends FieldInfo
implements Comparable {
    public List parameters;
    public Set thrown;

    public MethodInfo() {
    }

    public MethodInfo(String string, String string2, int n) {
        this.type = string;
        this.name = string2;
        this.modifiers = n;
    }

    public MethodInfo(JavaMethod javaMethod) {
        this.name = javaMethod.isConstructor() ? javaMethod.getOwningClass().getName() : javaMethod.getName();
        JavaType javaType = javaMethod.getReturnType();
        this.type = javaType != null ? javaType.getQualifiedName() : "void";
        this.typeSignature = javaType != null ? javaType.getTypeSignature() : "void";
        Collection collection = javaMethod.getParameters();
        if (collection != null && collection.size() > 0) {
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            boolean bl = false;
            if (sourceMethod != null) {
                this.extractParameters(sourceMethod);
            } else {
                int n = 0;
                for (JavaVariable javaVariable : collection) {
                    JavaType javaType2 = javaVariable.getResolvedType();
                    String string = javaType2 == null ? javaVariable.getUnresolvedType().getSimplifiedName() : javaType2.getQualifiedName();
                    String string2 = javaVariable.getName();
                    if (!ModelUtil.hasLength((String)string2)) {
                        string2 = "p" + n++;
                    }
                    this.addParameter(string, string2);
                }
            }
        }
        this.extractExceptions(javaMethod);
        this.modifiers = javaMethod.getModifiers();
    }

    public MethodInfo(SourceMethod sourceMethod) {
        JavaType javaType;
        this.name = sourceMethod.getName();
        SourceTypeReference sourceTypeReference = sourceMethod.getSourceReturnType();
        this.type = sourceTypeReference == null ? "void" : ((javaType = sourceTypeReference.getResolvedType()) == null ? sourceTypeReference.getName() : javaType.getQualifiedName());
        this.extractParameters(sourceMethod);
        this.extractExceptions((JavaMethod)sourceMethod);
        this.modifiers = sourceMethod.getModifiers();
    }

    private void extractExceptions(JavaMethod javaMethod) {
        Collection collection = javaMethod.getExceptions();
        this.thrown = new TreeSet();
        for (JavaType javaType : collection) {
            this.thrown.add(javaType != null ? javaType.getQualifiedName() : "void");
        }
    }

    private void extractParameters(SourceMethod sourceMethod) {
        List list = sourceMethod.getSourceParameters();
        for (SourceVariable sourceVariable : list) {
            String string;
            int n;
            JavaType javaType = sourceVariable.getResolvedType();
            String string2 = javaType != null ? javaType.getQualifiedName() : ((n = (string = sourceVariable.getText()).indexOf(32)) > 0 ? string.substring(0, n) : string);
            this.addParameter(string2, sourceVariable.getName());
        }
    }

    public MethodInfo(MethodInfo methodInfo) {
        super(methodInfo);
        if (methodInfo != null) {
            if (methodInfo.parameters != null) {
                this.parameters = (List)((ArrayList)methodInfo.parameters).clone();
            }
            if (methodInfo.thrown != null) {
                this.thrown = (Set)((TreeSet)methodInfo.thrown).clone();
            }
            this.modifiers = methodInfo.modifiers;
        }
    }

    public Object copyTo(Object object) {
        MethodInfo methodInfo = object != null ? (MethodInfo)object : new MethodInfo();
        this.copyToImpl(methodInfo);
        return methodInfo;
    }

    protected final void copyToImpl(MethodInfo methodInfo) {
        super.copyToImpl(methodInfo);
        if (this.parameters == null || this.parameters.size() == 0) {
            methodInfo.parameters = null;
        } else {
            methodInfo.parameters = new ArrayList();
            ModelUtil.deepCopy((List)this.parameters, (List)methodInfo.parameters);
        }
        if (this.thrown == null || this.thrown.size() == 0) {
            methodInfo.thrown = null;
        } else {
            methodInfo.thrown = new TreeSet();
            MethodInfo.deepCopy(this.thrown, methodInfo.thrown);
        }
    }

    public boolean isGetter() {
        return (this.name.startsWith("get") && this.name.length() > 3 || ("boolean".equals(this.type) || "java.lang.Boolean".equals(this.type)) && this.name.startsWith("is") && this.name.length() > 2) && this.type != null && this.type != "void" && (this.parameters == null || this.parameters.size() == 0);
    }

    public boolean isSetter() {
        return this.name.startsWith("set") && this.name.length() > 3 && (this.type == null || this.type == "void") && this.parameters != null && this.parameters.size() == 1;
    }

    public FieldInfo getField() {
        if (this.isGetter()) {
            int n = this.name.startsWith("is") ? 2 : 3;
            FieldInfo fieldInfo = new FieldInfo(this.type, Introspector.decapitalize(this.name.substring(n)), 0);
            return fieldInfo;
        }
        if (this.isSetter()) {
            FieldInfo fieldInfo = new FieldInfo((String)((List)this.parameters.get(0)).get(0), Introspector.decapitalize(this.name.substring(3)), 0);
            return fieldInfo;
        }
        return null;
    }

    public int validate() {
        int n = super.validate();
        if (n != 0) {
            return n;
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            Iterator iterator = this.parameters.iterator();
            ArrayList<String> arrayList = new ArrayList<String>(this.parameters.size());
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                String string = (String)list.get(0);
                String string2 = (String)list.get(1);
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if (string != null) {
                    string = string.trim();
                }
                if (string2 != null && string2.length() > 0) {
                    if (arrayList.contains(string2)) {
                        return 6;
                    }
                    arrayList.add(string2);
                    if (!IdeUtil.isJavaIdentifier((String)string2)) {
                        return 7;
                    }
                } else {
                    return 8;
                }
                if (string != null) continue;
                return 9;
            }
        }
        if (this.thrown != null && this.thrown.size() > 0) {
            for (String string : this.thrown) {
                if (string != null) {
                    string = string.trim();
                }
                if (string != null && string.length() != 0) continue;
                return 12;
            }
        }
        return 0;
    }

    public void addParameter(String string, String string2) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        this.parameters.add(arrayList);
    }

    public void addException(String string) {
        if (this.thrown == null) {
            this.thrown = new TreeSet();
        }
        this.thrown.add(string);
    }

    public void removeException(String string) {
        if (this.thrown != null) {
            this.thrown.remove(string);
        }
    }

    public String render() {
        return EngineUtils.renderMethod(this.modifiers, this.type, this.name, this.parameters, this.thrown);
    }

    public int compareTo(Object object) {
        if (object instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)object;
            return EngineUtils.renderMethod(-1, null, this.name, this.parameters, null).compareTo(EngineUtils.renderMethod(-1, null, methodInfo.name, methodInfo.parameters, null));
        }
        return super.compareTo(object);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((MethodInfo)object);
    }

    protected final boolean equalsImpl(MethodInfo methodInfo) {
        return super.equalsImpl(methodInfo) && EngineUtils.areEquivalentCollections(this.parameters, methodInfo.parameters) && EngineUtils.areEquivalentCollections(this.thrown, methodInfo.thrown);
    }

    public String toString() {
        return EngineUtils.renderMethod(-1, null, this.name, this.parameters, null);
    }

    public SourceMethod createSourceConstructor(SourceFile sourceFile, boolean bl) {
        return this.createSourceMethod(sourceFile, bl, null, null, null, true);
    }

    public SourceMethod createSourceConstructor(SourceFile sourceFile, String string) {
        return this.createSourceMethod(sourceFile, false, string, null, null, true);
    }

    public SourceMethod createSourceConstructor(SourceFile sourceFile, String[] stringArray) {
        return this.createSourceMethod(sourceFile, false, null, stringArray, null, true);
    }

    public SourceMethod createSourceConstructor(SourceFile sourceFile, SourceBlock sourceBlock) {
        return this.createSourceMethod(sourceFile, false, null, null, sourceBlock, true);
    }

    public SourceMethod createSourceMethod(SourceFile sourceFile, boolean bl) {
        return this.createSourceMethod(sourceFile, bl, null, null, null, false);
    }

    public SourceMethod createSourceMethod(SourceFile sourceFile, String string) {
        return this.createSourceMethod(sourceFile, false, string, null, null, false);
    }

    public SourceMethod createSourceMethod(SourceFile sourceFile, String[] stringArray) {
        return this.createSourceMethod(sourceFile, false, null, stringArray, null, false);
    }

    public SourceMethod createSourceMethod(SourceFile sourceFile, SourceBlock sourceBlock) {
        return this.createSourceMethod(sourceFile, false, null, null, sourceBlock, false);
    }

    private SourceMethod createSourceMethod(SourceFile sourceFile, boolean bl, String string, String[] stringArray, SourceBlock sourceBlock, boolean bl2) {
        SourceMethod sourceMethod;
        boolean bl3;
        EngineUtils.openTransaction(sourceFile);
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceFormalParameterList sourceFormalParameterList = null;
        if (this.parameters != null && this.parameters.size() > 0) {
            sourceFormalParameterList = sourceFactory.createFormalParameterList();
            List list = sourceFormalParameterList.getChildren();
            for (List list2 : this.parameters) {
                String string2 = (String)list2.get(0);
                EngineUtils.addImport(string2, sourceFile);
                SourceTypeReference sourceTypeReference = EngineUtils.createType(sourceFactory, string2);
                SourceLocalVariable sourceLocalVariable = sourceFactory.createLocalVariable(sourceTypeReference, (String)list2.get(1));
                list.add(sourceLocalVariable);
            }
        }
        SourceThrowsClause sourceThrowsClause = null;
        if (this.thrown != null && this.thrown.size() > 0) {
            SourceTypeReference[] sourceTypeReferenceArray = new SourceTypeReference[this.thrown.size()];
            int n = 0;
            for (String string3 : this.thrown) {
                EngineUtils.addImport(string3, sourceFile);
                sourceTypeReferenceArray[n++] = EngineUtils.createType(sourceFactory, string3);
            }
            sourceThrowsClause = sourceFactory.createThrowsClause(sourceTypeReferenceArray);
        }
        EngineUtils.addImport(this.type, sourceFile);
        SourceTypeReference sourceTypeReference = bl2 ? null : EngineUtils.createType(sourceFactory, !ModelUtil.hasLength((String)this.type) ? "void" : this.type);
        SourceClass sourceClass = (SourceClass)sourceFile.getPrimaryClass();
        boolean bl4 = bl3 = sourceClass == null ? false : sourceClass.isInterface();
        if ((this.modifiers & 0x400) != 0 || bl3) {
            sourceBlock = null;
        } else if (sourceBlock == null) {
            if (ModelUtil.hasLength((String)string)) {
                if (!string.endsWith(";")) {
                    string = string + ';';
                }
                sourceBlock = sourceFactory.createBlock(new SourceElement[]{sourceFactory.createStatement(string)});
            } else if (ModelUtil.hasNonNullElement((Object[])stringArray)) {
                SourceElement[] sourceElementArray = new SourceElement[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    if (!stringArray[n].endsWith(";")) {
                        int n2 = n;
                        stringArray[n2] = stringArray[n2] + ';';
                    }
                    sourceElementArray[n] = sourceFactory.createStatement(stringArray[n]);
                    ++n;
                }
                sourceBlock = sourceFactory.createBlock(sourceElementArray);
            } else {
                sourceBlock = sourceFactory.createBlock();
            }
        }
        SourceMethod sourceMethod2 = sourceMethod = bl2 ? sourceFactory.createConstructor(sourceFormalParameterList, sourceThrowsClause, sourceBlock) : sourceFactory.createMethod(sourceTypeReference, this.name, sourceFormalParameterList, sourceThrowsClause, sourceBlock);
        if (!bl3) {
            sourceMethod.setModifiers(this.modifiers);
            if (bl) {
                MethodEngine.addDefaultImpl(this, sourceFile, sourceMethod);
            }
        }
        return sourceMethod;
    }

    private static final void deepCopy(Collection collection, Collection collection2) {
        if (collection == null || collection2 == null) {
            return;
        }
        for (Object e : collection) {
            if (collection2.contains(e)) continue;
            Object object = e instanceof Copyable ? ((Copyable)e).copyTo(null) : e;
            collection2.add(object);
        }
    }
}

