/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.engine.db.DBColumn;
import oracle.jdeveloper.engine.db.DBForeignKey;
import oracle.jdeveloper.engine.db.DBIndex;

public final class DBTable {
    public final DatabaseMetaData metaData;
    public final String schemaDotTable;
    public final String schema;
    public final String table;
    public final Map columnMap;
    public final Map indexMap;
    public final Set primaryKeySet;
    public final List primaryKeyList;
    public final Map exportedKeyMap;
    public final Map importedKeyMap;

    void $init$() {
        this.columnMap = new TreeMap();
        this.indexMap = new HashMap();
        this.primaryKeySet = new HashSet();
        this.primaryKeyList = new ArrayList();
        this.exportedKeyMap = new HashMap();
        this.importedKeyMap = new HashMap();
    }

    public DBTable(DatabaseMetaData databaseMetaData, String string) {
        this.$init$();
        this.metaData = databaseMetaData;
        this.schemaDotTable = string;
        int n = string.indexOf(46);
        this.schema = n >= 0 ? string.substring(0, n) : null;
        this.table = string.substring(n + 1);
        try {
            this.populateColumnMap();
            this.populatePrimaryKeySet();
            this.populateImportedKeyMap();
            this.populateIndexMap();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void populateColumnMap() throws SQLException {
        Connection connection;
        ResultSet resultSet = this.metaData.getColumns(null, this.schema, this.table, null);
        resultSet.setFetchSize(100);
        boolean bl = resultSet.next();
        if (!bl && (connection = this.metaData.getConnection()) instanceof OracleConnection) {
            OracleConnection oracleConnection = (OracleConnection)connection;
            oracleConnection.setIncludeSynonyms(true);
            resultSet = this.metaData.getColumns(null, this.schema, this.table, null);
            oracleConnection.setIncludeSynonyms(false);
            resultSet.setFetchSize(100);
            bl = resultSet.next();
        }
        boolean bl2 = false;
        if (bl) {
            do {
                DBColumn dBColumn = new DBColumn(resultSet, this);
                this.columnMap.put(dBColumn.COLUMN_NAME, dBColumn);
            } while (resultSet.next());
        }
        resultSet.close();
    }

    private void populatePrimaryKeySet() throws SQLException {
        ResultSet resultSet = this.metaData.getPrimaryKeys(null, this.schema, this.table);
        resultSet.setFetchSize(100);
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        while (resultSet.next()) {
            String string = resultSet.getString("COLUMN_NAME");
            short s = resultSet.getShort("KEY_SEQ");
            if (this.primaryKeySet.contains(string)) continue;
            treeMap.put(new Integer(s), string);
            this.primaryKeySet.add(string);
        }
        resultSet.close();
        for (Map.Entry entry : treeMap.entrySet()) {
            this.primaryKeyList.add(entry.getValue());
        }
    }

    public void populateExportedKeyMap(Map map) {
        for (DBTable dBTable : map.values()) {
            if (dBTable.importedKeyMap == null) continue;
            for (DBForeignKey dBForeignKey : dBTable.importedKeyMap.values()) {
                if (!this.schemaDotTable.equals(dBForeignKey.PKSCHEMADOTTABLE)) continue;
                DBForeignKey dBForeignKey2 = new DBForeignKey(dBForeignKey);
                this.exportedKeyMap.put(dBForeignKey2.FK_NAME, dBForeignKey2);
            }
        }
    }

    private void populateImportedKeyMap() throws SQLException {
        ResultSet resultSet = this.metaData.getImportedKeys(null, this.schema, this.table);
        resultSet.setFetchSize(100);
        while (resultSet.next()) {
            DBForeignKey dBForeignKey = new DBForeignKey(resultSet);
            DBForeignKey dBForeignKey2 = (DBForeignKey)this.importedKeyMap.get(dBForeignKey.FK_NAME);
            if (dBForeignKey2 != null) {
                if (dBForeignKey.KEY_SEQ > dBForeignKey2.fkColumnNames.length) {
                    System.arraycopy(dBForeignKey2.fkColumnNames, 0, dBForeignKey.fkColumnNames, 0, dBForeignKey2.fkColumnNames.length);
                    dBForeignKey2.fkColumnNames = dBForeignKey.fkColumnNames;
                    continue;
                }
                dBForeignKey2.fkColumnNames[dBForeignKey.KEY_SEQ] = dBForeignKey.FKCOLUMN_NAME;
                continue;
            }
            this.importedKeyMap.put(dBForeignKey.FK_NAME, dBForeignKey);
        }
        resultSet.close();
    }

    private void populateIndexMap() throws SQLException {
        ResultSet resultSet = this.metaData.getIndexInfo(null, this.schema, this.table, true, false);
        resultSet.setFetchSize(100);
        while (resultSet.next()) {
            short s = resultSet.getShort("TYPE");
            if (s == 0) continue;
            DBIndex dBIndex = new DBIndex(resultSet);
            DBIndex dBIndex2 = (DBIndex)this.indexMap.get(dBIndex.INDEX_NAME);
            if (dBIndex2 != null) {
                if (dBIndex.ORDINAL_POSITION > dBIndex2.columns.length) {
                    System.arraycopy(dBIndex2.columns, 0, dBIndex.columns, 0, dBIndex2.columns.length);
                    dBIndex2.columns = dBIndex.columns;
                    continue;
                }
                dBIndex2.columns[dBIndex.ORDINAL_POSITION] = dBIndex.COLUMN_NAME;
                continue;
            }
            this.indexMap.put(dBIndex.INDEX_NAME, dBIndex);
        }
    }
}

