/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.externaltools;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.ToolRunException;

public abstract class ExternalTool
implements Copyable {
    public static final int INTEG_TOOLS_MENU_ITEM = 1;
    public static final int INTEG_CODE_EDITOR_CONTEXT_MENU_ITEM = 2;
    public static final int INTEG_NAVIGATOR_CONTEXT_MENU_ITEM = 4;
    public static final int INTEG_MAIN_WINDOW_TOOLBAR_BUTTON = 8;
    public static final int INTEG_NAVIGATOR_TOOLBAR_BUTTON = 16;
    public static final int AVAIL_ALWAYS = 0;
    public static final int AVAIL_SELECTION = 1;
    public static final int AVAIL_REGEXP = 2;
    public static final int AVAIL_TYPES = 3;
    private URL m_iconURL;
    private String m_caption;
    private String m_toolTipText;
    private int m_integrationMask;
    private int m_availability;
    private String m_availabilityExpression;
    private List m_availableTypes;
    private boolean m_reloadBuffers;
    private String m_scannerTag;

    void $init$() {
        this.m_reloadBuffers = false;
        this.m_scannerTag = null;
    }

    public ExternalTool() {
        this.$init$();
        this.m_integrationMask = 1;
        this.m_availableTypes = new ArrayList();
    }

    public void setScannerTag(String string) {
        this.m_scannerTag = string;
    }

    public String getScannerTag() {
        return this.m_scannerTag;
    }

    public boolean getReloadBuffers() {
        return this.m_reloadBuffers;
    }

    public void setReloadBuffers(boolean bl) {
        this.m_reloadBuffers = bl;
    }

    public Icon getIconWhenRequired() {
        return IdeIcons.getIcon((int)1);
    }

    public boolean hasIntegration(int n) {
        return (this.getIntegrationMask() & n) != 0;
    }

    public String toString() {
        return this.getCaption();
    }

    public void setAvailableTypes(List list) {
        this.m_availableTypes = list;
    }

    public List getAvailableTypes() {
        return this.m_availableTypes;
    }

    public URL getIconURL() {
        return this.m_iconURL;
    }

    public void setIconURL(URL uRL) {
        this.m_iconURL = uRL;
    }

    public String getCaption() {
        return this.m_caption;
    }

    public void setCaption(String string) {
        this.m_caption = string;
    }

    public String getToolTipText() {
        return this.m_toolTipText;
    }

    public void setToolTipText(String string) {
        this.m_toolTipText = string;
    }

    public int getIntegrationMask() {
        return this.m_integrationMask;
    }

    public void setIntegrationMask(int n) {
        this.m_integrationMask = n;
    }

    public int getAvailability() {
        if (this.m_availability == 2) {
            this.m_availability = 0;
        }
        return this.m_availability;
    }

    public void setAvailability(int n) {
        if (n == 2) {
            n = 0;
        }
        this.m_availability = n;
    }

    public String getAvailabilityExpression() {
        return this.m_availabilityExpression;
    }

    public void setAvailabilityExpression(String string) {
        this.m_availabilityExpression = string;
    }

    protected void copyToImpl(ExternalTool externalTool) {
        externalTool.setAvailability(this.getAvailability());
        externalTool.setAvailabilityExpression(this.getAvailabilityExpression());
        externalTool.setCaption(this.getCaption());
        externalTool.setIconURL(this.getIconURL());
        externalTool.setIntegrationMask(this.getIntegrationMask());
        externalTool.setToolTipText(this.getToolTipText());
        externalTool.setReloadBuffers(this.getReloadBuffers());
        int n = this.getAvailableTypes().size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(null);
            ++n2;
        }
        Collections.copy(arrayList, this.getAvailableTypes());
        externalTool.setAvailableTypes(arrayList);
        externalTool.setScannerTag(this.getScannerTag());
    }

    public abstract void run(ExternalToolManager var1, Context var2) throws ToolRunException;

    public abstract Class getType();
}

