/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.externaltools.macro;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.jdeveloper.externaltools.ExternalToolType;
import oracle.jdeveloper.externaltools.macro.MacroExpander;
import oracle.jdeveloper.externaltools.macro.MacroRegistry;
import oracle.jdeveloper.externaltools.macro.ParameterizedMacro;

class MacroFieldInsightProvider
implements FieldInsightProvider {
    private final MacroRegistry m_registry;
    private final ExternalToolType m_type;
    private final boolean m_onlyDirectories;

    MacroFieldInsightProvider(MacroRegistry macroRegistry, ExternalToolType externalToolType, boolean bl) {
        this.m_registry = macroRegistry;
        this.m_type = externalToolType;
        this.m_onlyDirectories = bl;
    }

    public ListCellRenderer getCellRenderer() {
        return new MacroInsightListCellRenderer();
    }

    public boolean handlesInsight(Document document, int n) {
        String string = this.getIncompleteMacro(document, n);
        return string != null;
    }

    public Object[] getInsightData(Document document, int n) {
        String string = this.getIncompleteMacro(document, n);
        if (string != null) {
            ArrayList<MacroExpander> arrayList = new ArrayList<MacroExpander>();
            Iterator iterator = this.m_registry.iterator();
            while (iterator.hasNext()) {
                MacroExpander macroExpander = (MacroExpander)iterator.next();
                if (!this.isValidMacro(macroExpander) || string != "" && !macroExpander.getMacro().startsWith(string)) continue;
                arrayList.add(macroExpander);
            }
            Object[] objectArray = new MacroExpander[arrayList.size()];
            arrayList.toArray(objectArray);
            return objectArray;
        }
        return null;
    }

    public void completeInsight(Document document, int n, Object object) {
        try {
            MacroExpander macroExpander = (MacroExpander)object;
            int n2 = -1;
            String string = document.getText(n, document.getLength() - n);
            int n3 = n;
            while (n3 < document.getLength()) {
                char c = string.charAt(n3 - n);
                if (c == '}' || Character.isWhitespace(c)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 == -1) {
                n2 = document.getLength() - 1;
            }
            string = document.getText(0, n);
            int n4 = -1;
            int n5 = n - 1;
            while (n5 >= 0) {
                char c = string.charAt(n5);
                if (c == '{') {
                    n4 = n5;
                    break;
                }
                --n5;
            }
            if (n4 == -1) {
                n4 = 0;
            }
            document.remove(n4 + 1, n2 - n4);
            document.insertString(n4 + 1, macroExpander.getMacro() + "}", null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public boolean isAutoPopupChar(char c) {
        return c == '.' || c == '{';
    }

    private boolean isValidMacro(MacroExpander macroExpander) {
        if (macroExpander instanceof ParameterizedMacro) {
            return false;
        }
        if (this.m_type == null || macroExpander.isAvailableForType(this.m_type)) {
            if (this.m_onlyDirectories && macroExpander.isDirectoryMacro()) {
                return true;
            }
            if (!this.m_onlyDirectories) {
                return true;
            }
        }
        return false;
    }

    private String getIncompleteMacro(Document document, int n) {
        try {
            int n2 = -1;
            int n3 = n - 1;
            while (n3 >= 0) {
                char c = document.getText(n3, 1).charAt(0);
                if (Character.isWhitespace(c) || c == '}') break;
                if (c == '{' && n3 > 0 && document.getText(n3 - 1, 1).charAt(0) == '$') {
                    n2 = n3 - 1;
                    break;
                }
                --n3;
            }
            if (n2 > -1) {
                int n4 = n2 + 2;
                if (n4 < n) {
                    String string = document.getText(n4, n - n4);
                    return string;
                }
                String string = "";
                return string;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private class MacroInsightListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private DefaultListCellRenderer m_macroLabel = new DefaultListCellRenderer();
        private DefaultListCellRenderer m_nameLabel = new DefaultListCellRenderer();

        MacroInsightListCellRenderer() {
            this.m_nameLabel.setHorizontalAlignment(4);
            this.m_nameLabel.setForeground(UIManager.getColor("controlShadow"));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_macroLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 15, 0));
            this.add((Component)this.m_nameLabel, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof MacroExpander) {
                MacroExpander macroExpander = (MacroExpander)object;
                this.m_macroLabel.setText("${" + macroExpander.getMacro() + "}");
                this.m_nameLabel.setText(macroExpander.getShortLabel());
                if (bl) {
                    this.m_macroLabel.setBackground(jList.getSelectionBackground());
                    this.m_nameLabel.setBackground(jList.getSelectionBackground());
                    this.m_macroLabel.setForeground(jList.getSelectionForeground());
                    this.m_nameLabel.setForeground(jList.getSelectionForeground());
                } else {
                    this.m_macroLabel.setBackground(jList.getBackground());
                    this.m_macroLabel.setForeground(jList.getForeground());
                    this.m_nameLabel.setBackground(jList.getBackground());
                    this.m_nameLabel.setForeground(jList.getForeground());
                }
            }
            return this;
        }
    }
}

