/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.help;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.javadoc.JProjectJavadoc;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.JavadocUtilArb;

public final class JavadocUtil {
    private static final String HTM_EXTENSION = ".htm";
    private static final String HTML_ADDITION = "l";

    public static URL resolveJavadocURL(Context context, String string) {
        try {
            Project project = context.getProject();
            if (project == null) {
                project = Ide.getDefaultProject();
            }
            URLPath uRLPath = PathsConfiguration.getInstance(project).getDocPath();
            JProjectJavadoc jProjectJavadoc = JProjectJavadoc.getInstance((PropertyStorage)project, project.getURL());
            URL uRL = jProjectJavadoc.getOutputDirectory();
            if (uRL != null && URLFileSystem.exists((URL)uRL)) {
                URL[] uRLArray = uRLPath.getEntries();
                uRLPath.setEntries(null);
                uRLPath.add(uRL);
                uRLPath.add(uRLArray);
            }
            URL[] uRLArray = uRLPath.getEntries();
            JavadocUtil.orderPathsHttpLast(uRLArray);
            uRLPath.setEntries(uRLArray);
            String string2 = uRLPath.toString();
            URL uRL2 = JavadocUtil.resolveJavadocURL(uRLPath, string);
            return uRL2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void orderPathsHttpLast(URL[] uRLArray) {
        Arrays.sort(uRLArray, new PathComparator(null));
    }

    public static URL resolveJavadocURL(URLPath uRLPath, String string) {
        URL[] uRLArray = uRLPath.getEntries();
        int n = uRLArray.length;
        Object[] objectArray = new Object[1];
        IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), JavadocUtilArb.getString(0));
        indeterminateProgressMonitor.setMillisToPopup(100);
        indeterminateProgressMonitor.setCancellable(true);
        indeterminateProgressMonitor.setCloseOnFinish(true);
        indeterminateProgressMonitor.start();
        1 var6_6 = new 1(n, uRLArray, string, indeterminateProgressMonitor, objectArray);
        var6_6.start();
        while (!indeterminateProgressMonitor.isCancelled() && objectArray[0] == null) {
            try {
                Thread.sleep(100);
            }
            catch (Exception exception) {
                indeterminateProgressMonitor.close();
            }
        }
        indeterminateProgressMonitor.close();
        if (indeterminateProgressMonitor.isCancelled()) {
            var6_6.interrupt();
            return null;
        }
        if (objectArray[0] instanceof Boolean) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), JavadocUtilArb.format(1, string));
            return null;
        }
        return (URL)objectArray[0];
    }

    private static URL[] getFullCandidateURLs(URL uRL, String string) {
        URL[] uRLArray = new URL[2];
        URL uRL2 = null;
        URL uRL3 = null;
        String string2 = string.replace('.', '/');
        if (JarUtil.isJarURL((URL)uRL)) {
            URL uRL4 = JarUtil.getJarFileURL((URL)uRL);
            StringBuffer stringBuffer = new StringBuffer(100);
            String string3 = JarUtil.getJarEntry((URL)uRL);
            stringBuffer.append(string3);
            if (!string3.endsWith("/") && string3.length() > 0) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string2);
            stringBuffer.append(HTM_EXTENSION);
            uRL2 = URLFactory.newJarURL((URL)uRL4, (String)stringBuffer.toString());
            stringBuffer.append(HTML_ADDITION);
            uRL3 = URLFactory.newJarURL((URL)uRL4, (String)stringBuffer.toString());
        } else {
            String string4 = string2 + HTM_EXTENSION;
            String string5 = string4 + HTML_ADDITION;
            uRL2 = URLFactory.newURL((URL)uRL, (String)string4);
            uRL3 = URLFactory.newURL((URL)uRL, (String)string5);
        }
        uRLArray[0] = uRL3;
        uRLArray[1] = uRL2;
        return uRLArray;
    }

    public static void main(String[] stringArray) {
        try {
            JavadocUtil.test1();
            JavadocUtil.test2();
            JavadocUtil.test3();
            JavadocUtil.test4();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    private static void test1() throws MalformedURLException {
        URL uRL = new URL("jar:file:/C:/foo.jar!/doc/");
        URL[] uRLArray = JavadocUtil.getFullCandidateURLs(uRL, "java.net.URL");
        System.out.println(uRLArray[0].toString());
        System.out.println(uRLArray[1].toString());
    }

    private static void test2() throws MalformedURLException {
        URL uRL = new URL("jar:file:/C:/foo.jar!/");
        URL[] uRLArray = JavadocUtil.getFullCandidateURLs(uRL, "java.net.URL");
        System.out.println(uRLArray[0].toString());
        System.out.println(uRLArray[1].toString());
    }

    private static void test3() throws MalformedURLException {
        URL uRL = new URL("file:/C:/foo");
        URL[] uRLArray = JavadocUtil.getFullCandidateURLs(uRL, "java.net.URL");
        System.out.println(uRLArray[0].toString());
        System.out.println(uRLArray[1].toString());
    }

    private static void test4() throws MalformedURLException {
        URL uRL = new URL("file:/C:/foo/");
        URL[] uRLArray = JavadocUtil.getFullCandidateURLs(uRL, "java.net.URL");
        System.out.println(uRLArray[0].toString());
        System.out.println(uRLArray[1].toString());
    }

    static URL[] maS$getFullCandidateURLs(URL uRL, String string) {
        return JavadocUtil.getFullCandidateURLs(uRL, string);
    }

    public static final class 1
    extends SwingWorker {
        private final /* synthetic */ int v$numEntries;
        private final /* synthetic */ URL[] v$entries;
        private final /* synthetic */ String v$symbolName;
        private final /* synthetic */ IndeterminateProgressMonitor v$progressMonitor;
        private final /* synthetic */ Object[] v$searchOutput;

        public Object construct() {
            int n = 0;
            while (n < this.v$numEntries) {
                URL[] uRLArray = JavadocUtil.maS$getFullCandidateURLs(this.v$entries[n], this.v$symbolName);
                int n2 = uRLArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    URL uRL = uRLArray[n3];
                    if (this.v$progressMonitor.getPanel() != null) {
                        this.v$progressMonitor.getPanel().setNote(URLFileSystem.getPlatformPathName((URL)uRL));
                    }
                    try {
                        if (URLFileSystem.exists((URL)uRL)) {
                            this.v$searchOutput[0] = uRL;
                            Object var7_7 = null;
                            return var7_7;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n3;
                }
                ++n;
            }
            this.v$searchOutput[0] = false;
            return null;
        }

        public void finished() {
        }

        public 1(int n, URL[] uRLArray, String string, IndeterminateProgressMonitor indeterminateProgressMonitor, Object[] objectArray) {
            this.v$searchOutput = objectArray;
            this.v$progressMonitor = indeterminateProgressMonitor;
            this.v$symbolName = string;
            this.v$entries = uRLArray;
            this.v$numEntries = n;
        }
    }

    private static class PathComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            URL uRL;
            String string;
            URL uRL2 = (URL)object;
            String string2 = uRL2.getProtocol();
            if (string2.equals(string = (uRL = (URL)object2).getProtocol())) {
                return 0;
            }
            if (string2.equals("http")) {
                return 1;
            }
            if (string.equals("http")) {
                return -1;
            }
            return 0;
        }

        private PathComparator() {
        }

        PathComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

