/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.net.URL;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.ide.util.Enum;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.history.DefaultHistoryFilter;
import oracle.jdeveloper.history.DefaultHistoryProperty;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.RevisionIdentifier;

public class CustomFilter
extends DefaultHistoryFilter {
    private static final String REGEXP_PREFIX = "REGEXP:";
    private final String _source;
    private final Expression _expression;
    private String _name;

    private CustomFilter(String string, Expression expression) {
        this._source = string;
        this._expression = expression;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CustomFilter)) {
            return false;
        }
        String string = ((CustomFilter)object)._name;
        if (this._name == null || string == null) {
            return super.equals(object);
        }
        return string.equals(this._name) && ((CustomFilter)object)._source.equals(this._source);
    }

    public int hashCode() {
        return this._name != null ? this._name.intern().hashCode() : super.hashCode();
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public String getSource() {
        return this._source;
    }

    public boolean accept(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry) {
        return this._expression.evaluate(historyModel, uRL, historyEntry);
    }

    public String getShortLabel() {
        return this._name != null ? this._name : this._source;
    }

    public static final CustomFilter parse(String string) throws ParseException {
        return new CustomFilter(string, Expression.parse(string.split("\\s+"), new ParsePosition(0)));
    }

    private static final DateFormat createDateFormat() {
        1 var0 = new 1("yyyy-MM-dd zzz");
        return var0;
    }

    static DateFormat maS$createDateFormat() {
        return CustomFilter.createDateFormat();
    }

    public static final class 1
    extends SimpleDateFormat {
        private final String _timezoneSuffix;

        void $init$() {
            this._timezoneSuffix = " " + new SimpleDateFormat("zzz").format(new Date(0L));
        }

        public Date parse(String string, ParsePosition parsePosition) {
            return super.parse(string + this._timezoneSuffix, parsePosition);
        }

        public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            StringBuffer stringBuffer2 = super.format(date, stringBuffer, fieldPosition);
            stringBuffer2.setLength(10);
            return stringBuffer2;
        }

        public 1(String string) {
            super(string);
            this.$init$();
        }
    }

    private static class Expression {
        private boolean _not;
        private Column _column;
        private ConditionalOperator _conditional;
        private Value _value;
        private BooleanOperator _boolean;
        private Expression _expression;

        static Expression parse(String[] stringArray, ParsePosition parsePosition) throws ParseException {
            Expression expression = new Expression();
            if (parsePosition.getIndex() < stringArray.length && stringArray[parsePosition.getIndex()].equalsIgnoreCase("NOT")) {
                expression._not = true;
                parsePosition.setIndex(parsePosition.getIndex() + 1);
            }
            if (parsePosition.getIndex() >= stringArray.length) {
                throw new ParseException("", 0);
            }
            expression._column = Column.parse(stringArray, parsePosition);
            expression._conditional = ConditionalOperator.parse(stringArray, parsePosition);
            expression._value = Value.parse(stringArray, parsePosition);
            if (parsePosition.getIndex() < stringArray.length) {
                expression._boolean = BooleanOperator.parse(stringArray, parsePosition);
                expression._expression = Expression.parse(stringArray, parsePosition);
            }
            if (parsePosition.getIndex() >= stringArray.length) {
                return expression;
            }
            throw new ParseException("", 0);
        }

        boolean evaluate(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry) {
            boolean bl = this._evaluate(historyModel, uRL, historyEntry);
            if (this._boolean != null) {
                return this._boolean.evaluate(historyModel, uRL, historyEntry, bl, this._expression);
            }
            return bl;
        }

        private boolean _evaluate(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry) {
            return this._not ^ this._conditional.evaluate(historyModel, uRL, historyEntry, this._column, this._value);
        }

        private Expression() {
        }
    }

    private static class Column {
        private String _column;

        static Column parse(String[] stringArray, ParsePosition parsePosition) throws ParseException {
            Column column = new Column();
            if (parsePosition.getIndex() >= stringArray.length) {
                throw new ParseException("", 0);
            }
            String string = stringArray[parsePosition.getIndex()];
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            column._column = string;
            return column;
        }

        Object evaluate(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry) {
            HistoryProperty[] historyPropertyArray = historyModel.getProperties();
            int n = 0;
            while (n < historyPropertyArray.length) {
                String string;
                if (historyPropertyArray[n] instanceof DefaultHistoryProperty && (string = ((DefaultHistoryProperty)historyPropertyArray[n]).getCustomFilterId()) != null && string.equalsIgnoreCase(this._column)) {
                    return historyEntry.getValue(historyPropertyArray[n]);
                }
                ++n;
            }
            return null;
        }

        private Column() {
        }
    }

    private static class Value {
        private static final long MILLIS_PER_DAY = 86400000L;
        private String _atom;
        private ArithmeticOperator _arithmetic;
        private Value _value;

        static Value parse(String[] stringArray, ParsePosition parsePosition) throws ParseException {
            Value value = new Value();
            if (parsePosition.getIndex() >= stringArray.length) {
                throw new ParseException("", 0);
            }
            String string = stringArray[parsePosition.getIndex()];
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            value._atom = string;
            if (value._atom.toUpperCase().startsWith(CustomFilter.REGEXP_PREFIX)) {
                String string2 = value._atom.substring(CustomFilter.REGEXP_PREFIX.length());
                if (string2.equals("")) {
                    throw new ParseException("", 0);
                }
                try {
                    Pattern.compile(string2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseException("", 0);
                }
            }
            if (ArithmeticOperator.look(stringArray, parsePosition) != null) {
                value._arithmetic = ArithmeticOperator.parse(stringArray, parsePosition);
                value._value = Value.parse(stringArray, parsePosition);
            }
            return value;
        }

        Object evaluate(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry) {
            Object object = this._evaluate(historyModel, uRL, historyEntry);
            if (object instanceof Date) {
                object = Value.convertLongToDate(Value.convertDateToLong((Date)object));
            }
            if (this._arithmetic != null) {
                return this._arithmetic.evaluate(historyModel, uRL, historyEntry, object, this._value);
            }
            return object;
        }

        private Object _evaluate(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry) {
            if (this._atom.toUpperCase().startsWith(CustomFilter.REGEXP_PREFIX)) {
                return this._atom;
            }
            if (Pattern.matches("^\\$\\{.+\\}$", this._atom)) {
                return this.evaluateSubstitution(historyModel, uRL);
            }
            try {
                if (Pattern.matches("^-?\\d+$", this._atom)) {
                    Long l = Long.valueOf(this._atom);
                    return l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (Pattern.matches("^\\d{4}-\\d{2}-\\d{2}$", this._atom)) {
                    Date date = CustomFilter.maS$createDateFormat().parse(this._atom);
                    return date;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return this._atom;
        }

        private Object evaluateSubstitution(HistoryModel historyModel, URL uRL) {
            CustomFilterSubstitution[] customFilterSubstitutionArray = HistoryManager.getHistoryManager().getCustomFilterManager().getSubstitutions();
            Object object = null;
            int n = 0;
            while (n < customFilterSubstitutionArray.length) {
                if (this._atom.equals("${" + customFilterSubstitutionArray[n].getName() + "}")) {
                    object = customFilterSubstitutionArray[n].evaluate(historyModel, uRL);
                    break;
                }
                ++n;
            }
            return object != null ? object : "";
        }

        static final long convertDateToLong(Date date) {
            DateFormat dateFormat = CustomFilter.maS$createDateFormat();
            try {
                long l = dateFormat.parse(dateFormat.format(date)).getTime() / 86400000L;
                return l;
            }
            catch (ParseException parseException) {
                long l = date.getTime() / 86400000L;
                return l;
            }
        }

        static final Date convertLongToDate(long l) {
            DateFormat dateFormat = CustomFilter.maS$createDateFormat();
            try {
                Date date = dateFormat.parse(dateFormat.format(new Date(l * 86400000L)));
                return date;
            }
            catch (ParseException parseException) {
                Date date = new Date(l * 86400000L);
                return date;
            }
        }

        private Value() {
        }
    }

    private static class ConditionalOperator
    extends Enum {
        public static final ConditionalOperator EQUALS = new ConditionalOperator("EQUALS");
        public static final ConditionalOperator GREATER_OR_LESS_THAN = new ConditionalOperator("GREATER_OR_LESS_THAN");
        public static final ConditionalOperator NOT_EQUALS = new ConditionalOperator("NOT_EQUALS");
        public static final ConditionalOperator GREATER_THAN = new ConditionalOperator("GREATER_THAN");
        public static final ConditionalOperator LESS_THAN = new ConditionalOperator("LESS_THAN");
        public static final ConditionalOperator GREATER_THAN_OR_EQUALS = new ConditionalOperator("GREATER_THAN_OR_EQUALS");
        public static final ConditionalOperator LESS_THAN_OR_EQUALS = new ConditionalOperator("LESS_THAN_OR_EQUALS");
        public static final ConditionalOperator MATCHES = new ConditionalOperator("MATCHES");
        private static int _nextOrdinal = 0;

        private ConditionalOperator(String string) {
            super(string, _nextOrdinal++);
        }

        static ConditionalOperator parse(String[] stringArray, ParsePosition parsePosition) throws ParseException {
            if (parsePosition.getIndex() >= stringArray.length) {
                throw new ParseException("", 0);
            }
            String string = stringArray[parsePosition.getIndex()];
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            if (string.equals("=")) {
                return EQUALS;
            }
            if (string.equals("<>")) {
                return GREATER_OR_LESS_THAN;
            }
            if (string.equals("!=")) {
                return NOT_EQUALS;
            }
            if (string.equals(">")) {
                return GREATER_THAN;
            }
            if (string.equals("<")) {
                return LESS_THAN;
            }
            if (string.equals(">=")) {
                return GREATER_THAN_OR_EQUALS;
            }
            if (string.equals("<=")) {
                return LESS_THAN_OR_EQUALS;
            }
            if (string.equalsIgnoreCase("MATCHES")) {
                return MATCHES;
            }
            throw new ParseException("", 0);
        }

        boolean evaluate(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry, Column column, Value value) {
            if (column == null) {
                return false;
            }
            Object object = column.evaluate(historyModel, uRL, historyEntry);
            if (object == null) {
                return false;
            }
            Object object2 = value.evaluate(historyModel, uRL, historyEntry);
            if (this == MATCHES) {
                object = this.convertValueToString(object, false);
                if (((String)(object2 = this.convertValueToString(object2, false))).toUpperCase().startsWith(CustomFilter.REGEXP_PREFIX)) {
                    if (!(object instanceof String) || !(object2 instanceof String)) {
                        return false;
                    }
                    try {
                        boolean bl = Pattern.compile(((String)object2).substring(CustomFilter.REGEXP_PREFIX.length())).matcher((String)object).find();
                        return bl;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        boolean bl = false;
                        return bl;
                    }
                }
                return ((String)object).indexOf((String)object2) >= 0;
            }
            if (object instanceof Date) {
                object = Value.convertLongToDate(Value.convertDateToLong((Date)object));
            }
            if (object instanceof Date && object2 instanceof Number) {
                object2 = Value.convertLongToDate(((Number)object2).longValue());
            }
            if (object instanceof RevisionIdentifier) {
                object2 = new RevisionIdentifier(null, this.convertValueToString(object2, true));
            }
            if (!(object instanceof Comparable) || !object.getClass().isInstance(object2)) {
                object = this.convertValueToString(object, true);
                object2 = this.convertValueToString(object2, true);
            }
            Comparable comparable = (Comparable)object;
            Comparable comparable2 = (Comparable)object2;
            if (this == EQUALS) {
                return comparable.equals(comparable2);
            }
            if (this == GREATER_OR_LESS_THAN) {
                return comparable.compareTo(comparable2) != 0;
            }
            if (this == NOT_EQUALS) {
                return comparable.equals(comparable2) ^ true;
            }
            if (this == GREATER_THAN) {
                return comparable.compareTo(comparable2) > 0;
            }
            if (this == LESS_THAN) {
                return comparable.compareTo(comparable2) < 0;
            }
            if (this == GREATER_THAN_OR_EQUALS) {
                return comparable.compareTo(comparable2) >= 0;
            }
            if (this == LESS_THAN_OR_EQUALS) {
                return comparable.compareTo(comparable2) <= 0;
            }
            return false;
        }

        private String convertValueToString(Object object, boolean bl) {
            if (object instanceof String) {
                return object.toString();
            }
            if (object instanceof Number) {
                return NumberFormat.getIntegerInstance().format(object);
            }
            if (object instanceof Date) {
                if (bl) {
                    return CustomFilter.maS$createDateFormat().format(object);
                }
                return DateFormat.getDateTimeInstance().format(object);
            }
            return object.toString();
        }
    }

    private static class ArithmeticOperator
    extends Enum {
        public static final ArithmeticOperator PLUS = new ArithmeticOperator("PLUS");
        public static final ArithmeticOperator MINUS = new ArithmeticOperator("MINUS");
        private static int _nextOrdinal = 0;

        private ArithmeticOperator(String string) {
            super(string, _nextOrdinal++);
        }

        static ArithmeticOperator parse(String[] stringArray, ParsePosition parsePosition) throws ParseException {
            ArithmeticOperator arithmeticOperator = ArithmeticOperator.look(stringArray, parsePosition);
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            if (arithmeticOperator != null) {
                return arithmeticOperator;
            }
            throw new ParseException("", 0);
        }

        static ArithmeticOperator look(String[] stringArray, ParsePosition parsePosition) {
            if (parsePosition.getIndex() >= stringArray.length) {
                return null;
            }
            String string = stringArray[parsePosition.getIndex()];
            if (string.equalsIgnoreCase("+")) {
                return PLUS;
            }
            if (string.equalsIgnoreCase("-")) {
                return MINUS;
            }
            return null;
        }

        Object evaluate(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry, Object object, Value value) {
            Object object2 = object;
            Object object3 = value.evaluate(historyModel, uRL, historyEntry);
            if (object2 instanceof Date) {
                object2 = new Long(Value.convertDateToLong((Date)object2));
            }
            if (object3 instanceof Date) {
                object3 = new Long(Value.convertDateToLong((Date)object3));
            }
            if (!(object2 instanceof Number) || !(object3 instanceof Number)) {
                return object2;
            }
            if (this == PLUS) {
                return new Long(((Number)object2).longValue() + ((Number)object3).longValue());
            }
            if (this == MINUS) {
                return new Long(((Number)object2).longValue() - ((Number)object3).longValue());
            }
            return object2;
        }
    }

    private static class BooleanOperator
    extends Enum {
        public static final BooleanOperator AND = new BooleanOperator("AND");
        public static final BooleanOperator OR = new BooleanOperator("OR");
        private static int _nextOrdinal = 0;

        private BooleanOperator(String string) {
            super(string, _nextOrdinal++);
        }

        static BooleanOperator parse(String[] stringArray, ParsePosition parsePosition) throws ParseException {
            BooleanOperator booleanOperator = BooleanOperator.look(stringArray, parsePosition);
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            if (booleanOperator != null) {
                return booleanOperator;
            }
            throw new ParseException("", 0);
        }

        static BooleanOperator look(String[] stringArray, ParsePosition parsePosition) {
            if (parsePosition.getIndex() >= stringArray.length) {
                return null;
            }
            String string = stringArray[parsePosition.getIndex()];
            if (string.equalsIgnoreCase("AND")) {
                return AND;
            }
            if (string.equalsIgnoreCase("OR")) {
                return OR;
            }
            return null;
        }

        boolean evaluate(HistoryModel historyModel, URL uRL, HistoryEntry historyEntry, boolean bl, Expression expression) {
            if (this == AND) {
                return bl && expression.evaluate(historyModel, uRL, historyEntry);
            }
            if (this == OR) {
                return bl || expression.evaluate(historyModel, uRL, historyEntry);
            }
            return false;
        }
    }
}

