/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import oracle.ide.Ide;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.CustomFilterCopyable;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.resource.HistoryArb;

public class CustomFilterManager {
    private static final String CUSTOM_FILTERS_DATA_KEY = "HistoryManager.CustomFilters";
    private CustomFilter[] _customFilters;
    private final Collection _substitutions;
    private final Observable _customFilterObservable;

    void $init$() {
        this._substitutions = new ArrayList();
        this._customFilterObservable = new 1();
    }

    public CustomFilter[] getFilters() {
        if (this._customFilters != null) {
            return this._customFilters;
        }
        Collection collection = (Collection)Ide.getDTCache().getData(CUSTOM_FILTERS_DATA_KEY);
        if (collection == null) {
            this._customFilters = this.createDefaultFilters();
            this.persistFilters(this._customFilters);
            return this._customFilters;
        }
        ArrayList<CustomFilter> arrayList = new ArrayList<CustomFilter>();
        for (CustomFilterCopyable customFilterCopyable : collection) {
            try {
                CustomFilter customFilter = CustomFilter.parse(customFilterCopyable.getSource());
                customFilter.setName(customFilterCopyable.getName());
                arrayList.add(customFilter);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this._customFilters = arrayList.toArray(new CustomFilter[0]);
        return this._customFilters;
    }

    public void setFilters(CustomFilter[] customFilterArray) {
        this._customFilters = customFilterArray;
        this.persistFilters(this._customFilters);
        this._customFilterObservable.notifyObservers();
    }

    public CustomFilter[] createDefaultFilters() {
        try {
            ArrayList<CustomFilter> arrayList = new ArrayList<CustomFilter>();
            CustomFilter customFilter = CustomFilter.parse("DATE = ${system.date}");
            customFilter.setName(HistoryArb.getString(28));
            arrayList.add(customFilter);
            customFilter = CustomFilter.parse("DATE >= ${system.date} - 7");
            customFilter.setName(HistoryArb.getString(29));
            arrayList.add(customFilter);
            customFilter = CustomFilter.parse("AUTHOR = ${system.user} OR AUTHOR = ${versioning.user} OR REVISION MATCHES REGEXP:(?i)local");
            customFilter.setName(HistoryArb.getString(30));
            arrayList.add(customFilter);
            customFilter = CustomFilter.parse("NOT DESCRIPTION MATCHES REGEXP:^$|^\\[.*\\]$|^\\*\\*\\*.+\\*\\*\\*$");
            customFilter.setName(HistoryArb.getString(31));
            arrayList.add(customFilter);
            customFilter = CustomFilter.parse("TAGS MATCHES REGEXP:.+");
            customFilter.setName(HistoryArb.getString(32));
            arrayList.add(customFilter);
            CustomFilter[] customFilterArray = arrayList.toArray(new CustomFilter[0]);
            return customFilterArray;
        }
        catch (ParseException parseException) {
            CustomFilter[] customFilterArray = null;
            return customFilterArray;
        }
    }

    public Observable getFilterObservable() {
        return this._customFilterObservable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubstitution(CustomFilterSubstitution customFilterSubstitution) {
        if (customFilterSubstitution == null) {
            return;
        }
        Collection collection = this._substitutions;
        synchronized (collection) {
            this._substitutions.add(customFilterSubstitution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSubstitution(CustomFilterSubstitution customFilterSubstitution) {
        Collection collection = this._substitutions;
        synchronized (collection) {
            this._substitutions.remove(customFilterSubstitution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFilterSubstitution[] getSubstitutions() {
        Collection collection = this._substitutions;
        synchronized (collection) {
            CustomFilterSubstitution[] customFilterSubstitutionArray = this._substitutions.toArray(new CustomFilterSubstitution[0]);
            return customFilterSubstitutionArray;
        }
    }

    private void persistFilters(CustomFilter[] customFilterArray) {
        if (customFilterArray == null) {
            return;
        }
        ArrayList<CustomFilterCopyable> arrayList = new ArrayList<CustomFilterCopyable>();
        int n = 0;
        while (n < customFilterArray.length) {
            CustomFilterCopyable customFilterCopyable = new CustomFilterCopyable();
            customFilterCopyable.setName(customFilterArray[n].getName());
            customFilterCopyable.setSource(customFilterArray[n].getSource());
            arrayList.add(customFilterCopyable);
            ++n;
        }
        Ide.getDTCache().putData(CUSTOM_FILTERS_DATA_KEY, arrayList);
    }

    public CustomFilterManager() {
        this.$init$();
    }

    public final class 1
    extends Observable {
        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }
    }
}

