/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.javatools.history.AbstractHistoryModel;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.DefaultHistoryFilter;
import oracle.jdeveloper.history.HistoryFilter;

public class DefaultHistoryModel
extends AbstractHistoryModel {
    private List _entries;
    private Set _properties;
    private HistoryProperty[] _scratchArray;
    private HistoryProperty[] _defaultProperties;

    void $init$() {
        this._entries = new ArrayList();
        this._properties = new LinkedHashSet();
    }

    public DefaultHistoryModel() {
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultHistoryModel(DefaultHistoryModel defaultHistoryModel) {
        this.$init$();
        DefaultHistoryModel defaultHistoryModel2 = defaultHistoryModel;
        synchronized (defaultHistoryModel2) {
            this._entries.addAll(defaultHistoryModel._entries);
            this._properties.addAll(defaultHistoryModel._properties);
            this._scratchArray = defaultHistoryModel._scratchArray != null ? (HistoryProperty[])defaultHistoryModel._scratchArray.clone() : null;
            this._defaultProperties = defaultHistoryModel._defaultProperties != null ? (HistoryProperty[])defaultHistoryModel._defaultProperties.clone() : null;
        }
    }

    public synchronized void applyFilter(URL uRL, HistoryFilter historyFilter) {
        if (historyFilter == null) {
            return;
        }
        Iterator iterator = this._entries.iterator();
        while (iterator.hasNext()) {
            HistoryEntry historyEntry = (HistoryEntry)iterator.next();
            if (historyFilter instanceof DefaultHistoryFilter ? ((DefaultHistoryFilter)historyFilter).accept((HistoryModel)this, uRL, historyEntry) : historyFilter.accept(historyEntry)) continue;
            iterator.remove();
        }
    }

    protected synchronized void addProperties(HistoryProperty[] historyPropertyArray) {
        this._properties.addAll(Arrays.asList(historyPropertyArray));
        this._scratchArray = new HistoryProperty[this._properties.size()];
    }

    protected synchronized void addEntries(HistoryEntry[] historyEntryArray) {
        if (historyEntryArray.length == 0) {
            return;
        }
        int n = this.getSize();
        this._entries.addAll(Arrays.asList(historyEntryArray));
        this.fireEntriesInserted(n, n + historyEntryArray.length - 1);
    }

    public synchronized HistoryProperty[] getProperties() {
        if (this._scratchArray == null) {
            return new HistoryProperty[0];
        }
        this._properties.toArray(this._scratchArray);
        Arrays.sort(this._scratchArray, new 1());
        return this._scratchArray;
    }

    public synchronized HistoryEntry getEntry(int n) {
        return (HistoryEntry)this._entries.get(n);
    }

    public synchronized void setDefaultProperties(HistoryProperty[] historyPropertyArray) {
        this._defaultProperties = historyPropertyArray;
    }

    public synchronized HistoryProperty[] getDefaultProperties() {
        if (this._defaultProperties != null) {
            return this._defaultProperties;
        }
        LinkedHashSet<HistoryProperty> linkedHashSet = new LinkedHashSet<HistoryProperty>();
        for (HistoryProperty historyProperty : this._properties) {
            if (!historyProperty.isDefault()) continue;
            linkedHashSet.add(historyProperty);
        }
        return linkedHashSet.toArray(new HistoryProperty[0]);
    }

    public synchronized int getSize() {
        return this._entries.size();
    }

    public final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            HistoryProperty historyProperty = (HistoryProperty)object;
            HistoryProperty historyProperty2 = (HistoryProperty)object2;
            if (historyProperty.getWeight() > historyProperty2.getWeight()) {
                return 1;
            }
            if (historyProperty.getWeight() < historyProperty2.getWeight()) {
                return -1;
            }
            return 0;
        }
    }
}

