/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;

public class HistoryEntrySelector {
    public static final HistoryEntrySelector CURRENT_REVISION = new 3();
    public static final HistoryEntrySelector PREVIOUS_REVISION = new 2();
    public static final HistoryEntrySelector LATEST_REVISION = new 1();
    private final String _revision;

    public HistoryEntrySelector() {
        this(null);
    }

    public HistoryEntrySelector(String string) {
        this._revision = string;
    }

    public HistoryEntry select(HistoryModel historyModel) {
        if (this._revision == null) {
            return historyModel.getSize() > 0 ? historyModel.getEntry(0) : null;
        }
        return HistoryEntrySelector.findEntryForRevision(historyModel, this._revision);
    }

    private static final RevisionIdentifier[] createSortedRevisionList(HistoryModel historyModel) {
        ArrayList<RevisionIdentifier> arrayList = new ArrayList<RevisionIdentifier>();
        int n = 0;
        while (n < historyModel.getSize()) {
            RevisionIdentifier revisionIdentifier = (RevisionIdentifier)historyModel.getEntry(n).getValue(SharedProperties.getRevisionProperty());
            if (revisionIdentifier != null) {
                arrayList.add(revisionIdentifier);
            }
            ++n;
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new RevisionIdentifier[arrayList.size()]);
    }

    private static final HistoryEntry findEntryForRevision(HistoryModel historyModel, String string) {
        int n = 0;
        while (n < historyModel.getSize()) {
            HistoryEntry historyEntry = historyModel.getEntry(n);
            if (((RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty())).getLabel().equals(string)) {
                return historyEntry;
            }
            ++n;
        }
        return null;
    }

    static RevisionIdentifier[] maS$createSortedRevisionList(HistoryModel historyModel) {
        return HistoryEntrySelector.createSortedRevisionList(historyModel);
    }

    static HistoryEntry maS$findEntryForRevision(HistoryModel historyModel, String string) {
        return HistoryEntrySelector.findEntryForRevision(historyModel, string);
    }

    public static final class 3
    extends HistoryEntrySelector {
        public HistoryEntry select(HistoryModel historyModel) {
            int n = 0;
            while (n < historyModel.getSize()) {
                HistoryEntry historyEntry = historyModel.getEntry(n);
                RevisionIdentifier revisionIdentifier = (RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty());
                if (revisionIdentifier != null && revisionIdentifier.isCurrent()) {
                    return historyEntry;
                }
                ++n;
            }
            return null;
        }
    }

    public static final class 2
    extends HistoryEntrySelector {
        public HistoryEntry select(HistoryModel historyModel) {
            HistoryEntry historyEntry = CURRENT_REVISION.select(historyModel);
            if (historyEntry == null) {
                return null;
            }
            Object[] objectArray = HistoryEntrySelector.maS$createSortedRevisionList(historyModel);
            int n = Arrays.binarySearch(objectArray, historyEntry.getValue(SharedProperties.getRevisionProperty()));
            return n <= 0 ? historyEntry : HistoryEntrySelector.maS$findEntryForRevision(historyModel, ((RevisionIdentifier)objectArray[n - 1]).getLabel());
        }
    }

    public static final class 1
    extends HistoryEntrySelector {
        public HistoryEntry select(HistoryModel historyModel) {
            RevisionIdentifier[] revisionIdentifierArray = HistoryEntrySelector.maS$createSortedRevisionList(historyModel);
            return revisionIdentifierArray.length > 0 ? HistoryEntrySelector.maS$findEntryForRevision(historyModel, revisionIdentifierArray[revisionIdentifierArray.length - 1].getLabel()) : null;
        }
    }
}

