/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.accessibility.Accessible;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.model.Node;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.MnemonicSolver;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.CustomFilterManager;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.resource.HistoryArb;

public abstract class HistoryManager {
    private Collection _providers;
    private static ContextMenu _sharedContextMenu;
    private HistoryFilter _allFilter;
    private CustomFilterManager _customFilterManager;
    protected static final String JNDI_NAME = "jdeveloper/history-manager";

    void $init$() {
        this._allFilter = null;
    }

    public CustomFilterManager getCustomFilterManager() {
        if (this._customFilterManager == null) {
            this._customFilterManager = new CustomFilterManager();
        }
        return this._customFilterManager;
    }

    public HistoryFilter getAllFilter() {
        if (this._allFilter == null) {
            this._allFilter = new 2();
        }
        return this._allFilter;
    }

    public static final HistoryManager getHistoryManager() {
        try {
            HistoryManager historyManager;
            InitialContext initialContext = new InitialContext();
            HistoryManager historyManager2 = historyManager = (HistoryManager)initialContext.lookup(JNDI_NAME);
            return historyManager2;
        }
        catch (NamingException namingException) {
            HistoryManager historyManager = null;
            return historyManager;
        }
    }

    public void registerProvider(HistoryProvider historyProvider) {
        if (this._providers == null) {
            this._providers = new HashSet();
        }
        this._providers.add(historyProvider);
    }

    public void unregisterProvider(HistoryProvider historyProvider) {
        if (this._providers != null) {
            this._providers.remove(historyProvider);
            if (this._providers.isEmpty()) {
                this._providers = null;
            }
        }
    }

    public Collection getProviders() {
        if (this._providers == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._providers);
    }

    public final ContextMenu getContextMenu() {
        if (_sharedContextMenu == null) {
            _sharedContextMenu = new ContextMenu(new MnemonicSolver());
        }
        return _sharedContextMenu;
    }

    public final HistoryComponent createHistoryComponent() {
        HistoryComponent historyComponent = new HistoryComponent();
        AccessibleUtils.updateAccessibleName((Accessible)historyComponent.getTable(), (String)HistoryArb.getString(33), (boolean)false);
        historyComponent.getTable().setDefaultRenderer(RevisionIdentifier.class, (TableCellRenderer)((Object)new 1()));
        return historyComponent;
    }

    public final HistoryComponent createHistoryComponent(HistoryModel historyModel) {
        HistoryComponent historyComponent = this.createHistoryComponent();
        historyComponent.setModel(historyModel);
        return historyComponent;
    }

    public abstract void showHistory(Context var1);

    public abstract void showHistory(Node var1);

    public abstract void updateHistory(URL var1);

    public HistoryModel buildModel(URL uRL, boolean bl, HistoryFilter historyFilter) {
        return this.buildModel(uRL, bl, historyFilter, this.getProviders());
    }

    public HistoryModel buildModel(URL uRL, boolean bl, HistoryFilter historyFilter, Collection collection) {
        DefaultHistoryModel defaultHistoryModel = new DefaultHistoryModel();
        for (HistoryProvider historyProvider : collection) {
            if (!historyProvider.isProviderFor(uRL)) continue;
            defaultHistoryModel.addProperties(historyProvider.getProperties());
            HistoryEntry[] historyEntryArray = historyProvider.getEntries(uRL, historyFilter);
            defaultHistoryModel.addEntries(historyEntryArray);
        }
        if (historyFilter != null) {
            defaultHistoryModel.applyFilter(uRL, historyFilter);
        }
        return defaultHistoryModel;
    }

    public HistoryManager() {
        this.$init$();
    }

    public final class 2
    implements HistoryFilter {
        public String getShortLabel() {
            return HistoryArb.getString(1);
        }

        public boolean accept(HistoryEntry historyEntry) {
            return true;
        }
    }

    public final class 1
    extends NiceTableCellRenderer {
        private final Font _defaultFont;

        void $init$() {
            this._defaultFont = this.getFont();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setFont(this._defaultFont);
            RevisionIdentifier revisionIdentifier = (RevisionIdentifier)object;
            this.setToolTipText(null);
            if (object != null) {
                this.setText(revisionIdentifier.getLabel());
                if (revisionIdentifier.getIcon() != null) {
                    this.setIcon(revisionIdentifier.getIcon());
                } else {
                    this.setIcon(null);
                }
            } else {
                this.setText(null);
                this.setIcon(null);
            }
            if (revisionIdentifier != null && revisionIdentifier.isCurrent()) {
                this.setFont(this._defaultFont.deriveFont(1));
                this.setToolTipText(HistoryArb.getString(27));
            }
            return component;
        }

        public 1() {
            this.$init$();
        }
    }
}

