/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java;

import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLPath;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.java.provider.LocatorWrapper;
import oracle.jdeveloper.java.provider.PathFileProvider;
import oracle.jdeveloper.java.provider.ProjectFileProvider;

public class JavaManager
implements JavaFileProvider {
    protected CachedFileProvider _fileProvider;
    protected Project _project;
    protected JavaClassLocator _classLocator;
    protected CacheSupport _cacheSupport;
    private static final TransactionDescriptor NOT_UNDOABLE = new TransactionDescriptor(null, null);
    private static final int TXN_COMMAND_ID;

    public static JavaManager getJavaManager(Project project) {
        if (project == null) {
            throw new NullPointerException("non-null project required");
        }
        return new JavaManager(project);
    }

    public static JavaManager getJavaManager(URLPath uRLPath, URLPath uRLPath2) {
        PathFileProvider pathFileProvider = new PathFileProvider(uRLPath, uRLPath2);
        return new JavaManager(pathFileProvider);
    }

    protected JavaManager(Project project) {
        this(ProjectFileProvider.getFileProvider(project));
        this._project = project;
    }

    protected JavaManager(CachedFileProvider cachedFileProvider) {
        this._fileProvider = cachedFileProvider;
    }

    protected void finalize() {
        this._fileProvider.beginCacheUse();
        this._fileProvider.endCacheUse();
    }

    public ClassLoader getClassLoader() {
        return this._fileProvider.getClassLoader();
    }

    public SourceTransaction beginTransaction(SourceFile sourceFile) {
        return sourceFile.beginTransaction();
    }

    public boolean commitTransaction(SourceTransaction sourceTransaction) {
        return this.commitTransaction(sourceTransaction, "Code Change");
    }

    public boolean commitTransaction(SourceTransaction sourceTransaction, String string) {
        return this.commitTransaction(sourceTransaction, new TransactionDescriptor(string, null));
    }

    public boolean commitTransactionNoUndo(SourceTransaction sourceTransaction) {
        return this.commitTransaction(sourceTransaction, NOT_UNDOABLE);
    }

    static {
        int n = -1;
        try {
            n = Ide.findOrCreateCmdID((String)TransactionCommand.class.getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TXN_COMMAND_ID = n;
    }

    public boolean commitTransaction(SourceTransaction sourceTransaction, TransactionDescriptor transactionDescriptor) {
        if (sourceTransaction == null) {
            throw new NullPointerException("transaction cannot be null");
        }
        if (transactionDescriptor == null) {
            throw new NullPointerException("txn descriptor cannot be null");
        }
        URL uRL = sourceTransaction.getOwningSourceFile().getURL();
        Node node = NodeFactory.find((URL)uRL);
        Context context = Context.newIdeContext((Node)node);
        if (this._project != null) {
            context.setProject(this._project);
        }
        UndoableEdit undoableEdit = null;
        try {
            undoableEdit = sourceTransaction.commit();
        }
        catch (RuntimeException runtimeException) {
            sourceTransaction.abort();
            boolean bl = false;
            return bl;
        }
        if (undoableEdit == null) {
            return true;
        }
        TransactionCommand transactionCommand = transactionDescriptor == NOT_UNDOABLE ? new TransactionCommand(uRL) : new TransactionCommand(undoableEdit, uRL, transactionDescriptor);
        transactionCommand.setContext(context);
        1 var9_10 = new 1(this, transactionCommand);
        if (SwingUtilities.isEventDispatchThread()) {
            var9_10.run();
        } else {
            SwingUtilities.invokeLater(var9_10);
        }
        return true;
    }

    public JavaClassLocator getJavaClassLocator() {
        if (this._classLocator == null) {
            this._classLocator = new LocatorWrapper(this._fileProvider);
        }
        return this._classLocator;
    }

    public CacheSupport getCacheSupport() {
        if (this._cacheSupport == null) {
            this._cacheSupport = new CacheTracker();
        }
        return this._cacheSupport;
    }

    public JavaFile getFile(URL uRL) {
        return this._fileProvider.getFile(uRL);
    }

    public SourceFile getSourceFile(URL uRL) {
        return this._fileProvider.getSourceFile(uRL);
    }

    public SourceFile createSourceFile(URL uRL) throws IOException, IllegalArgumentException {
        return this._fileProvider.createSourceFile(uRL);
    }

    public SourceFile getSourceFile(TextBuffer textBuffer) {
        return this._fileProvider.getSourceFile(textBuffer);
    }

    public JavaClass getClass(String string) {
        return this._fileProvider.getClass(string);
    }

    public JavaClass getClass(String string, String string2) {
        return this._fileProvider.getClass(string, string2);
    }

    public JavaClass getClassByVMName(String string) {
        return this._fileProvider.getClassByVMName(string);
    }

    public SourceClass getSourceClass(String string) {
        return this._fileProvider.getSourceClass(string);
    }

    public JavaType getArrayType(JavaType javaType, int n) {
        return this._fileProvider.getArrayType(javaType, n);
    }

    public JavaPackage getPackage(String string) {
        return this._fileProvider.getPackage(string);
    }

    public TextBuffer getTextBuffer(URL uRL) {
        return this._fileProvider.getTextBuffer(uRL);
    }

    static int ra$TXN_COMMAND_ID() {
        return TXN_COMMAND_ID;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ TransactionCommand v$command;
        final /* synthetic */ JavaManager this$0;

        public void run() {
            try {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                commandProcessor.invoke((Command)this.v$command);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public 1(JavaManager javaManager, TransactionCommand transactionCommand) {
            this.v$command = transactionCommand;
            this.this$0 = javaManager;
        }
    }

    protected class TransactionCommand
    extends Command {
        private TransactionDescriptor _descriptor;
        private UndoableEdit _undoableEdit;
        private URL _url;
        private boolean _first;

        protected TransactionCommand(URL uRL) {
            super(JavaManager.ra$TXN_COMMAND_ID(), 2);
            this.$init$();
            this._url = uRL;
        }

        protected TransactionCommand(UndoableEdit undoableEdit, URL uRL, TransactionDescriptor transactionDescriptor) {
            super(JavaManager.ra$TXN_COMMAND_ID(), 0, transactionDescriptor.getEditName());
            this.$init$();
            this._undoableEdit = undoableEdit;
            this._url = uRL;
            this._descriptor = transactionDescriptor;
        }

        void $init$() {
            if (JavaManager.ra$TXN_COMMAND_ID() < 0) {
                throw new RuntimeException("Requires an owning Ide instance");
            }
            this._first = true;
        }

        private boolean isReadOnly() {
            try {
                Node node = NodeFactory.findOrCreate((URL)this._url);
                boolean bl = node.isReadOnly();
                return bl;
            }
            catch (Exception exception) {
                boolean bl = true;
                return bl;
            }
        }

        public final int doit() throws Exception {
            Object object;
            if (this.isReadOnly()) {
                return 1;
            }
            Object object2 = object = this._descriptor != null ? this._descriptor.getClientObject() : null;
            if (this._first) {
                this._first = false;
                this._descriptor = null;
            } else if (this._undoableEdit != null) {
                this._undoableEdit.redo();
            }
            Node node = NodeFactory.findOrCreate((URL)this._url);
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, object);
            node.notifyObservers((Object)node, updateMessage);
            return 0;
        }

        public final int undo() throws Exception {
            if (this.isReadOnly()) {
                return 1;
            }
            this._undoableEdit.undo();
            Node node = NodeFactory.findOrCreate((URL)this._url);
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, null);
            node.notifyObservers((Object)node, updateMessage);
            return 0;
        }
    }

    protected class CacheTracker
    implements CacheSupport {
        private int refCount;
        private RuntimeException createdLocation;

        void $init$() {
            this.refCount = 0;
            this.createdLocation = new RuntimeException("Wrapper creation location");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginCacheUse() {
            CacheTracker cacheTracker = this;
            synchronized (cacheTracker) {
                ++this.refCount;
                JavaManager.this._fileProvider.beginCacheUse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            CacheTracker cacheTracker = this;
            synchronized (cacheTracker) {
                block4: {
                    if (this.refCount <= 0) break block4;
                }
                while (this.refCount-- > 0) {
                    JavaManager.this._fileProvider.endCacheUse();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endCacheUse() {
            CacheTracker cacheTracker = this;
            synchronized (cacheTracker) {
                if (this.refCount > 0) {
                    --this.refCount;
                    JavaManager.this._fileProvider.endCacheUse();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCache() {
            CacheTracker cacheTracker = this;
            synchronized (cacheTracker) {
                JavaManager.this._fileProvider.flushCache();
            }
        }

        protected CacheTracker() {
            this.$init$();
        }
    }
}

