/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.filter;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.ide.net.WildcardURLFilter;
import oracle.jdeveloper.java.filter.SimpleNameFilter;

public class PatternMatchNameFilter
extends SimpleNameFilter {
    private Pattern _pattern;

    public PatternMatchNameFilter() {
        this(false);
    }

    public PatternMatchNameFilter(boolean bl) {
        super("", false, bl ? 3 : 2);
    }

    public void setMatchName(String string) {
        super.setMatchName(string);
        this.buildPattern();
    }

    public void setMatchSubstring(boolean bl) {
        this._matchType = bl ? 3 : 2;
    }

    public boolean acceptPackageName(String string) {
        if (this._pattern != null) {
            return this._pattern.matcher(string).matches();
        }
        return super.acceptPackageName(string);
    }

    public boolean acceptClassName(String string, String string2) {
        boolean bl;
        String string3 = string2 + "." + string;
        boolean bl2 = bl = this._matchName.indexOf(46) != -1;
        if (this._pattern != null) {
            String string4 = bl ? string3 : string;
            return this._pattern.matcher(string4).matches();
        }
        if (bl) {
            return super.acceptName(string3);
        }
        return super.acceptClassName(string, string2);
    }

    private void buildPattern() {
        String string;
        Pattern pattern = null;
        boolean bl = false;
        if (this.containsWildcard()) {
            string = this.adjustFilterExpression(this._matchName);
        } else if (this.isCamelCased()) {
            bl = true;
            string = this.camelize();
            if (string != null) {
                string = this.adjustFilterExpression(string);
            }
        } else {
            string = null;
        }
        if (string != null) {
            String string2 = WildcardURLFilter.wildcard2Regexp((String)string);
            try {
                pattern = bl ? Pattern.compile(string2) : Pattern.compile(string2, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                patternSyntaxException.printStackTrace();
            }
        }
        this._pattern = pattern;
    }

    private boolean containsWildcard() {
        return this._matchName.indexOf(42) >= 0 || this._matchName.indexOf(63) >= 0;
    }

    private String adjustFilterExpression(String string) {
        char c;
        String string2 = 3 == this._matchType ? ('*' != (c = string.charAt(0)) ? "*" + string : string) : string;
        char c2 = string2.charAt(string2.length() - 1);
        if ('*' != c2) {
            string2 = string2 + "*";
        }
        return string2;
    }

    private boolean isCamelCased() {
        if (this._matchName.length() % 2 != 0) {
            return false;
        }
        char[] cArray = this._matchName.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isUpperCase(cArray[n++]) || !Character.isLowerCase(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String camelize() {
        char[] cArray = this._matchName.toCharArray();
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            char c2 = cArray[++n2];
            stringBuffer.append(c).append(c2).append('*');
            ++n2;
        }
        return stringBuffer.toString();
    }
}

