/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.filter;

import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;

public class SimpleNameFilter
implements PackageNameFilter,
ClassNameFilter {
    public static final int MATCH_WHOLE = 1;
    public static final int MATCH_PREFIX = 2;
    public static final int MATCH_SUBSTRING = 3;
    public static final int MATCH_SUFFIX = 4;
    protected int _matchType;
    protected boolean _matchCase;
    protected String _matchName;

    public SimpleNameFilter(String string, boolean bl, int n) {
        this._matchName = string;
        this._matchCase = bl;
        this._matchType = n;
    }

    public int getMatchType() {
        return this._matchType;
    }

    public boolean getMatchCase() {
        return this._matchCase;
    }

    public String getMatchName() {
        return this._matchName;
    }

    public void setMatchName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The match name cannot be null.");
        }
        this._matchName = string.trim();
    }

    public boolean acceptClassName(String string, String string2) {
        return this.acceptName(string);
    }

    public boolean acceptPackageName(String string) {
        return this.acceptName(string);
    }

    public boolean acceptName(String string) {
        int n;
        int n2;
        int n3;
        String string2 = this.getMatchName();
        int n4 = string2.length();
        int n5 = string.length();
        if (n5 < n4) {
            return false;
        }
        int n6 = this.getMatchType();
        switch (n6) {
            case 2: {
                n3 = n4;
                n2 = 0;
                n = 1;
                break;
            }
            case 4: {
                n3 = n4;
                n2 = n5 - n3;
                n = 1;
                break;
            }
            case 1: {
                n3 = Math.max(n5, n4);
                n2 = 0;
                n = 1;
                break;
            }
            case 3: {
                n2 = 0;
                n3 = n4;
                n = n5 - n4 + 1;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected match type");
            }
        }
        boolean bl = this.getMatchCase();
        int n7 = 0;
        while (n7 < n) {
            int n8 = n2 + n7;
            if (string.regionMatches(bl ^ true, n8, string2, 0, n3)) {
                return true;
            }
            ++n7;
        }
        return false;
    }
}

