/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.legacy;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ide.util.IdeUtil;

public class JotNames {
    public static final String SIGS = "L[BCDFIJSVZ";
    public static final String[] TYPES = new String[]{"<class>", "<array>", "byte", "char", "double", "float", "int", "long", "short", "void", "boolean"};
    public static final Class[] PRIMITIVE_CLASSES = new Class[]{null, null, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE, Boolean.TYPE};

    public static final String getClassName(String string, String string2) {
        return string != null && string.length() > 0 ? string + "." + string2 : string2;
    }

    public static final String getShortClassName(String string) {
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public static final String getPackageFromFullClassName(String string) {
        int n = string.lastIndexOf(".");
        return n >= 0 ? string.substring(0, n) : "";
    }

    public static boolean isKeyword(String string) {
        return IdeUtil.isJavaKeyword((String)string);
    }

    public static boolean isValidIdentifier(String string) {
        return IdeUtil.isJavaIdentifier((String)string);
    }

    public static boolean isValidClassName(String string) {
        boolean bl = false;
        if (string.length() > 0 && !string.startsWith(".") && !string.endsWith(".") && string.indexOf("..") == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            bl = true;
            while (stringTokenizer.hasMoreTokens()) {
                if (JotNames.isValidIdentifier(stringTokenizer.nextToken())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static final String typeToDotSignature(String string) {
        int n = string.indexOf(91);
        if (n == 0) {
            return string;
        }
        String string2 = "";
        String string3 = string;
        if (n > 0) {
            string2 = string3.substring(n);
            string3 = string3.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string2.length()) {
            if (string2.charAt(n2) == '[') {
                stringBuffer.append('[');
            }
            ++n2;
        }
        int n3 = 2;
        while (n3 < TYPES.length) {
            if (TYPES[n3].equals(string3)) {
                stringBuffer.append(SIGS.charAt(n3));
                return stringBuffer.toString();
            }
            ++n3;
        }
        if (n < 0) {
            return string3;
        }
        stringBuffer.append("L");
        stringBuffer.append(string3);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public static String dotSignatureToType(String string) {
        String string2 = JotNames.signatureToType(string);
        return string2 != null ? string2 : string;
    }

    public static String signatureToType(String string) {
        String string2 = null;
        int n = SIGS.indexOf(string.charAt(0));
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                string2 = string.substring(1, string.indexOf(59)).replace('/', '.');
                break;
            }
            case 1: {
                string2 = JotNames.signatureToType(string.substring(1)) + "[]";
                break;
            }
            default: {
                string2 = TYPES[n];
            }
        }
        return string2;
    }

    public static int getSignatureItemCount(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3++);
            switch (c) {
                case '[': {
                    break;
                }
                case 'L': {
                    int n4 = string.indexOf(59, n3);
                    if (n4 < 0) {
                        n4 = n2;
                    }
                    n3 = n4 + 1;
                    ++n;
                    break;
                }
                default: {
                    ++n;
                }
            }
        }
        return n;
    }

    public static String[] signatureToTypes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        block4: while (n2 < n) {
            String string2;
            char c = string.charAt(n2++);
            switch (c) {
                case '[': {
                    ++n3;
                    continue block4;
                }
                case 'L': {
                    int n4 = string.indexOf(59, n2);
                    if (n4 < 0) {
                        n4 = n;
                    }
                    string2 = string.substring(n2, n4).replace('/', '.');
                    n2 = n4 + 1;
                    break;
                }
                default: {
                    int n5 = SIGS.indexOf(c);
                    if (n5 < 0) continue block4;
                    string2 = TYPES[n5];
                }
            }
            if (n3 > 0) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                int n6 = 0;
                while (n6 < n3) {
                    stringBuffer.append("[]");
                    ++n6;
                }
                n3 = 0;
                string2 = stringBuffer.toString();
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    public static final Class classForName(String string) throws ClassNotFoundException {
        int n;
        String string2 = JotNames.typeToDotSignature(string);
        if (string2.indexOf(46) >= 0 || string2.indexOf(91) >= 0) {
            return Class.forName(string2);
        }
        if (string2.length() > 0 && (n = SIGS.indexOf(string2.charAt(0))) >= 0) {
            return PRIMITIVE_CLASSES[n];
        }
        throw new ClassNotFoundException();
    }

    public static final Class primitiveClassForName(String string) {
        int n;
        if (string.length() == 1 && (n = SIGS.indexOf(string.charAt(0))) >= 0) {
            return PRIMITIVE_CLASSES[n];
        }
        return null;
    }
}

