/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import oracle.ide.util.ArraySortedSet;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.filter.SimpleNameFilter;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;

public abstract class BaseClassLocator
implements JavaResourceLocator,
JavaClassLocator {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Collection EMPTY_COLLECTION = Arrays.asList(EMPTY_STRING_ARRAY);
    private static SimpleCache _splitNameCache = new SimpleCache(25, null);

    public abstract void buildIndex();

    public Collection getPackages(String string) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(20);
        this.getPackages(string, (Collection)arraySortedSet);
        return arraySortedSet;
    }

    protected abstract void getPackages(String var1, Collection var2);

    public Collection getClassesInPackage(String string) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(100);
        this.getClassesInPackage(string, (Collection)arraySortedSet);
        return arraySortedSet;
    }

    protected abstract void getClassesInPackage(String var1, Collection var2);

    public Collection getAllClasses() {
        return this.getAllClasses(null);
    }

    public Collection getAllClasses(ClassNameFilter classNameFilter) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(1000);
        this.getAllClasses((Collection)arraySortedSet, classNameFilter);
        return arraySortedSet;
    }

    protected abstract void getAllClasses(Collection var1, ClassNameFilter var2);

    public Collection getAllPackages() {
        return this.getAllPackages(null);
    }

    public Collection getAllPackages(PackageNameFilter packageNameFilter) {
        ArraySortedSet arraySortedSet = new ArraySortedSet(200);
        this.getAllPackages((Collection)arraySortedSet, packageNameFilter);
        return arraySortedSet;
    }

    protected abstract void getAllPackages(Collection var1, PackageNameFilter var2);

    public Collection getClassesByName(String string, boolean bl) {
        SimpleNameFilter simpleNameFilter = new SimpleNameFilter(string, bl, 1);
        return this.getAllClasses(simpleNameFilter);
    }

    public Collection getClassesByPrefix(String string, boolean bl) {
        SimpleNameFilter simpleNameFilter = new SimpleNameFilter(string, bl, 2);
        return this.getAllClasses(simpleNameFilter);
    }

    protected static BaseClassLocator ensureValid(BaseClassLocator baseClassLocator) {
        if (baseClassLocator != null) {
            return baseClassLocator;
        }
        return ClassLocatorFactory.EMPTY_LOCATOR;
    }

    public static void addToCollection(Object[] objectArray, Collection collection) {
        collection.addAll(Arrays.asList(objectArray));
    }

    public static String[] getStringArray(Collection collection) {
        int n = collection == null ? 0 : collection.size();
        String[] stringArray = n == 0 ? EMPTY_STRING_ARRAY : collection.toArray(new String[n]);
        return stringArray;
    }

    public static String buildFQName(String string, String string2) {
        String string3 = string.length() > 0 ? string + "." + string2 : string2;
        return string3;
    }

    protected static String[] getNameParts(String string) {
        SplitName splitName = BaseClassLocator.getSplitName(string);
        return SplitName.ra$_nameParts(splitName);
    }

    protected static String[] getNameCascades(String string) {
        SplitName splitName = BaseClassLocator.getSplitName(string);
        return SplitName.ra$_nameCascades(splitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SplitName getSplitName(String string) {
        SimpleCache simpleCache = _splitNameCache;
        synchronized (simpleCache) {
            SplitName splitName = (SplitName)SimpleCache.mav$get(_splitNameCache, string);
            if (splitName == null) {
                splitName = new SplitName(string, null);
                SimpleCache.mav$put(_splitNameCache, string, splitName);
            }
            SplitName splitName2 = splitName;
            return splitName2;
        }
    }

    private static class SimpleCache {
        private int _maxSize;
        private ArrayList _entryList;
        private HashMap _entryMap;

        private SimpleCache(int n) {
            this._maxSize = n;
            this._entryList = new ArrayList(n + 1);
            this._entryMap = new HashMap(n + 1);
        }

        private Object get(String string) {
            return this._entryMap.get(string);
        }

        private void put(String string, Object object) {
            this._entryMap.put(string, object);
            this._entryList.add(string);
            if (this._entryList.size() > this._maxSize) {
                String string2 = (String)this._entryList.remove(0);
                this._entryMap.remove(string2);
            }
        }

        static Object mav$get(SimpleCache simpleCache, String string) {
            return simpleCache.get(string);
        }

        static void mav$put(SimpleCache simpleCache, String string, Object object) {
            simpleCache.put(string, object);
        }

        SimpleCache(int n, 1 var2_2) {
            this(n);
        }

        public final class 1 {
        }
    }

    private static class SplitName {
        private String _fqName;
        private String[] _nameParts;
        private String[] _nameCascades;

        private SplitName(String string) {
            int n = 0;
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                if (string.charAt(n3) == '.') {
                    ++n;
                }
                ++n3;
            }
            this._fqName = string;
            this._nameParts = new String[n + 1];
            this._nameCascades = new String[n + 1];
            this._nameCascades[n] = string;
            int n4 = n - 1;
            while (n4 >= 0) {
                String string2 = this._nameCascades[n4 + 1];
                int n5 = string2.lastIndexOf(46);
                this._nameCascades[n4] = string2.substring(0, n5);
                --n4;
            }
            int n6 = 0;
            while (n6 <= n) {
                String string3 = this._nameCascades[n6];
                int n7 = string3.lastIndexOf(46);
                this._nameParts[n6] = n7 == -1 ? string3 : string3.substring(n7 + 1);
                ++n6;
            }
        }

        SplitName(String string, 1 var2_2) {
            this(string);
        }

        static String[] ra$_nameCascades(SplitName splitName) {
            return splitName._nameCascades;
        }

        static String[] ra$_nameParts(SplitName splitName) {
            return splitName._nameParts;
        }

        public final class 1 {
        }
    }
}

