/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class CachedDirURLClassLocator
extends URLClassLocator {
    private Map _packageMap;
    private boolean _built;

    protected CachedDirURLClassLocator(URL uRL, int n) {
        super(uRL, n);
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndex() {
        if (!this._built) {
            CachedDirURLClassLocator cachedDirURLClassLocator = this;
            synchronized (cachedDirURLClassLocator) {
                if (!this._built) {
                    this.buildIndexImpl();
                    this._built = true;
                }
            }
        }
    }

    protected void getPackages(String string, Collection collection) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            collection.addAll(Arrays.asList(PackageEntry.ra$_subPackageNames(packageEntry)));
        }
    }

    protected void getClassesInPackage(String string, Collection collection) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            if (this.isSourceTypeLocator()) {
                collection.addAll(Arrays.asList(PackageEntry.ra$_classNames(packageEntry)));
            } else {
                String[] stringArray = PackageEntry.ra$_classNames(packageEntry);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    if (string2.indexOf(36) == -1) {
                        collection.add(string2);
                    }
                    ++n2;
                }
            }
        }
    }

    protected void getAllClasses(Collection collection, ClassNameFilter classNameFilter) {
        this.getClassesRecursively("", collection, classNameFilter);
    }

    private void getClassesRecursively(String string, Collection collection, ClassNameFilter classNameFilter) {
        PackageEntry packageEntry = this.findExactPackage(string);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$_classNames(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string2.indexOf(36) == -1) {
                    boolean bl = true;
                    if (classNameFilter != null) {
                        bl = classNameFilter.acceptClassName(string2, string);
                    }
                    if (bl) {
                        String string3 = CachedDirURLClassLocator.buildFQName(string, string2);
                        collection.add(string3);
                    }
                }
                ++n2;
            }
            String[] stringArray2 = PackageEntry.ra$_subPackageNames(packageEntry);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String string4 = stringArray2[n4];
                String string5 = CachedDirURLClassLocator.buildFQName(string, string4);
                this.getClassesRecursively(string5, collection, classNameFilter);
                ++n4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAllPackages(Collection collection, PackageNameFilter packageNameFilter) {
        this.buildIndex();
        Map map = this._packageMap;
        synchronized (map) {
            for (String string : this._packageMap.keySet()) {
                if (string == null || string.length() <= 0) continue;
                boolean bl = true;
                if (packageNameFilter != null) {
                    bl = packageNameFilter.acceptPackageName(string);
                }
                if (!bl) continue;
                collection.add(string);
            }
        }
    }

    public URL getURL(String string) {
        int n;
        String[] stringArray = CachedDirURLClassLocator.getNameCascades(string);
        String[] stringArray2 = CachedDirURLClassLocator.getNameParts(string);
        int n2 = n = stringArray.length;
        if (n > 1) {
            String string2 = stringArray[n - 2];
            PackageEntry packageEntry = this.findPackage(string2);
            if (packageEntry == null) {
                return null;
            }
            String string3 = stringArray2[n2 - 1];
            if (!Arrays.asList(PackageEntry.ra$_classNames(packageEntry)).contains(string3)) {
                return null;
            }
        }
        String[] stringArray3 = this.isSourceTypeLocator() ? URLClassLocator.SOURCE_SUFFIXES : URLClassLocator.CLASS_SUFFIXES;
        int n3 = stringArray3.length;
        int n4 = 0;
        while (n4 < n3) {
            String string4 = stringArray3[n4];
            String string5 = string.replace('.', '/') + string4;
            URL uRL = this.getRootURL();
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)string5);
            if (URLFileSystem.exists((URL)uRL2)) {
                return uRL2;
            }
            ++n4;
        }
        return null;
    }

    public URL getResourceURL(String string) {
        URL uRL;
        URL uRL2;
        if (this.isClassTypeLocator() && URLFileSystem.exists((URL)(uRL2 = URLFactory.newURL((URL)(uRL = this.getRootURL()), (String)string)))) {
            return uRL2;
        }
        return null;
    }

    void $init$() {
        this._packageMap = new HashMap(512);
        this._built = false;
    }

    private void buildIndexImpl() {
        this.buildPackage("");
    }

    private void buildPackage(String string) {
        Thread.yield();
        PackageEntry packageEntry = this.findExactPackage(string);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$_subPackageNames(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = string.length() > 0 ? string + "." + stringArray[n2] : stringArray[n2];
                this.buildPackage(string2);
                ++n2;
            }
        }
    }

    private boolean containsSubPackage(PackageEntry packageEntry, String string) {
        if (packageEntry == null) {
            return false;
        }
        if (PackageEntry.ra$_subPackageNames(packageEntry).length == 0) {
            return false;
        }
        List<String> list = Arrays.asList(PackageEntry.ra$_subPackageNames(packageEntry));
        return list.contains(string);
    }

    private PackageEntry findPackage(String string) {
        PackageEntry packageEntry = this.findExactPackage("");
        if (string.length() == 0) {
            return packageEntry;
        }
        String[] stringArray = CachedDirURLClassLocator.getNameCascades(string);
        String[] stringArray2 = CachedDirURLClassLocator.getNameParts(string);
        PackageEntry packageEntry2 = packageEntry;
        int n = stringArray.length;
        PackageEntry packageEntry3 = null;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (!this.containsSubPackage(packageEntry2, string2)) {
                return null;
            }
            packageEntry2 = packageEntry3 = this.findExactPackage(stringArray[n2]);
            ++n2;
        }
        return packageEntry3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageEntry findExactPackage(String string) {
        int n;
        URL uRL;
        PackageEntry packageEntry = null;
        Map map = this._packageMap;
        synchronized (map) {
            packageEntry = (PackageEntry)this._packageMap.get(string);
        }
        URL uRL2 = this.getRootURL();
        if (packageEntry != null) {
            uRL = PackageEntry.ra$_packageURL(packageEntry);
        } else if (string.length() == 0) {
            uRL = uRL2;
        } else {
            String string2 = string.replace('.', '/');
            uRL = URLFactory.newDirURL((URL)uRL2, (String)string2);
        }
        URLFileSystem.FileInfo[] fileInfoArray = URLFileSystem.ls((URL)uRL);
        int n2 = n = fileInfoArray == null ? 0 : fileInfoArray.length;
        if (packageEntry != null && CachedDirURLClassLocator.equals(PackageEntry.ra$_fileInfos(packageEntry), fileInfoArray)) {
            return packageEntry;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        int n3 = 0;
        while (n3 < n) {
            URLFileSystem.FileInfo fileInfo = fileInfoArray[n3];
            URL uRL3 = fileInfo.getURL();
            boolean bl = fileInfo.isDirectory();
            String string3 = URLFileSystem.getFileName((URL)uRL3);
            if (bl) {
                if (string3.indexOf(46) == -1 && string3.indexOf(45) == -1 && !string3.equals("CVS")) {
                    arrayList2.add(new String(string3));
                }
            } else if (this.isMatchingFileType(string3)) {
                int n4 = string3.lastIndexOf(46);
                arrayList.add(new String(string3.substring(0, n4)));
            }
            ++n3;
        }
        String[] stringArray = CachedDirURLClassLocator.getStringArray(arrayList);
        String[] stringArray2 = CachedDirURLClassLocator.getStringArray(arrayList2);
        packageEntry = new PackageEntry(string, uRL, fileInfoArray, stringArray, stringArray2, null);
        Map map2 = this._packageMap;
        synchronized (map2) {
            this._packageMap.put(string, packageEntry);
        }
        return packageEntry;
    }

    protected static boolean supportsCache(URL uRL) {
        URLFileSystem.FileInfo[] fileInfoArray = URLFileSystem.ls((URL)uRL);
        URLFileSystem.FileInfo[] fileInfoArray2 = URLFileSystem.ls((URL)uRL);
        boolean bl = CachedDirURLClassLocator.equals(fileInfoArray, fileInfoArray2);
        return bl;
    }

    private static boolean equals(URLFileSystem.FileInfo[] fileInfoArray, URLFileSystem.FileInfo[] fileInfoArray2) {
        int n;
        int n2 = fileInfoArray == null ? 0 : fileInfoArray.length;
        int n3 = n = fileInfoArray2 == null ? 0 : fileInfoArray2.length;
        if (n2 != n) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (fileInfoArray[n4] != fileInfoArray2[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private static final class PackageEntry {
        private String _packageName;
        private URL _packageURL;
        private URLFileSystem.FileInfo[] _fileInfos;
        private String[] _classNames;
        private String[] _subPackageNames;

        private PackageEntry(String string, URL uRL, URLFileSystem.FileInfo[] fileInfoArray, String[] stringArray, String[] stringArray2) {
            this._packageName = string;
            this._packageURL = uRL;
            this._fileInfos = fileInfoArray;
            this._classNames = stringArray;
            this._subPackageNames = stringArray2;
        }

        static URL ra$_packageURL(PackageEntry packageEntry) {
            return packageEntry._packageURL;
        }

        static URLFileSystem.FileInfo[] ra$_fileInfos(PackageEntry packageEntry) {
            return packageEntry._fileInfos;
        }

        PackageEntry(String string, URL uRL, URLFileSystem.FileInfo[] fileInfoArray, String[] stringArray, String[] stringArray2, 1 var6_6) {
            this(string, uRL, fileInfoArray, stringArray, stringArray2);
        }

        static String[] ra$_subPackageNames(PackageEntry packageEntry) {
            return packageEntry._subPackageNames;
        }

        static String[] ra$_classNames(PackageEntry packageEntry) {
            return packageEntry._classNames;
        }

        public final class 1 {
        }
    }
}

