/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import oracle.ide.model.Project;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.CachedDirURLClassLocator;
import oracle.jdeveloper.java.locator.DirURLClassLocator;
import oracle.jdeveloper.java.locator.JarURLClassLocator;
import oracle.jdeveloper.java.locator.LibraryClassLocator;
import oracle.jdeveloper.java.locator.PathClassLocator;
import oracle.jdeveloper.java.locator.ProjectClassLocator;
import oracle.jdeveloper.library.Library;

public class ClassLocatorFactory {
    private static final WeakCache _sourceLocatorCache = new WeakCache();
    private static final WeakCache _classLocatorCache = new WeakCache();
    public static final BaseClassLocator EMPTY_LOCATOR = new NOPClassLocator(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseClassLocator getSourceLocator(URL uRL) {
        if (uRL != null) {
            WeakCache weakCache = _sourceLocatorCache;
            synchronized (weakCache) {
                BaseClassLocator baseClassLocator = (BaseClassLocator)_sourceLocatorCache.get((Object)uRL);
                if (baseClassLocator == null) {
                    baseClassLocator = ClassLocatorFactory.createURLClassLocator(uRL, 2);
                    _sourceLocatorCache.put((Object)uRL, (Object)baseClassLocator);
                }
                BaseClassLocator baseClassLocator2 = baseClassLocator;
                return baseClassLocator2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseClassLocator getClassLocator(URL uRL) {
        if (uRL != null) {
            WeakCache weakCache = _classLocatorCache;
            synchronized (weakCache) {
                BaseClassLocator baseClassLocator = (BaseClassLocator)_classLocatorCache.get((Object)uRL);
                if (baseClassLocator == null) {
                    baseClassLocator = ClassLocatorFactory.createURLClassLocator(uRL, 1);
                    _classLocatorCache.put((Object)uRL, (Object)baseClassLocator);
                }
                BaseClassLocator baseClassLocator2 = baseClassLocator;
                return baseClassLocator2;
            }
        }
        return null;
    }

    private static BaseClassLocator createURLClassLocator(URL uRL, int n) {
        boolean bl = JarUtil.isJarURL((URL)uRL);
        if (bl) {
            return new JarURLClassLocator(uRL, n);
        }
        boolean bl2 = CachedDirURLClassLocator.supportsCache(uRL);
        return bl2 ? (BaseClassLocator)new CachedDirURLClassLocator(uRL, n) : (BaseClassLocator)new DirURLClassLocator(uRL, n);
    }

    public static BaseClassLocator getSourceLocator(URLPath uRLPath) {
        return ClassLocatorFactory.createArrayClassLocator(uRLPath, 2);
    }

    public static BaseClassLocator getClassLocator(URLPath uRLPath) {
        return ClassLocatorFactory.createArrayClassLocator(uRLPath, 1);
    }

    private static BaseClassLocator createArrayClassLocator(URLPath uRLPath, int n) {
        if (uRLPath != null) {
            int n2;
            URL[] uRLArray = uRLPath.getEntries();
            int n3 = n2 = uRLArray != null ? uRLArray.length : 0;
            if (n2 == 0) {
                return EMPTY_LOCATOR;
            }
            BaseClassLocator[] baseClassLocatorArray = new BaseClassLocator[n2];
            int n4 = 0;
            while (n4 < n2) {
                String string;
                URL uRL = uRLArray[n4];
                if (uRL != null && (string = uRL.getPath()) != null && string.length() > 0 && string.charAt(string.length() - 1) != '/') {
                    uRL = URLFactory.newDirURL((String)string);
                }
                BaseClassLocator baseClassLocator = n == 2 ? ClassLocatorFactory.getSourceLocator(uRL) : ClassLocatorFactory.getClassLocator(uRL);
                baseClassLocatorArray[n4] = BaseClassLocator.ensureValid(baseClassLocator);
                ++n4;
            }
            return new ArrayClassLocator(baseClassLocatorArray);
        }
        return null;
    }

    public static BaseClassLocator getLibraryLocator(Library library) {
        if (library != null) {
            return new LibraryClassLocator(library);
        }
        return null;
    }

    public static BaseClassLocator getLibraryLocator(Library[] libraryArray) {
        if (libraryArray != null) {
            int n = libraryArray.length;
            if (n == 0) {
                return EMPTY_LOCATOR;
            }
            BaseClassLocator[] baseClassLocatorArray = new BaseClassLocator[n];
            int n2 = 0;
            while (n2 < n) {
                BaseClassLocator baseClassLocator = ClassLocatorFactory.getLibraryLocator(libraryArray[n2]);
                baseClassLocatorArray[n2] = baseClassLocator != null ? baseClassLocator : EMPTY_LOCATOR;
                ++n2;
            }
            return new ArrayClassLocator(baseClassLocatorArray);
        }
        return null;
    }

    public static BaseClassLocator getProjectLocator(Project project) {
        if (project != null) {
            return new ProjectClassLocator(project);
        }
        return null;
    }

    public static BaseClassLocator getPathLocator(URLPath uRLPath, URLPath uRLPath2) {
        if (uRLPath != null || uRLPath2 != null) {
            return new PathClassLocator(uRLPath, uRLPath2);
        }
        return null;
    }

    private static class NOPClassLocator
    extends BaseClassLocator {
        public void buildIndex() {
        }

        protected void getPackages(String string, Collection collection) {
        }

        protected void getClassesInPackage(String string, Collection collection) {
        }

        protected void getAllClasses(Collection collection, ClassNameFilter classNameFilter) {
        }

        protected void getAllPackages(Collection collection, PackageNameFilter packageNameFilter) {
        }

        public URL getURL(String string) {
            return null;
        }

        public URL getSourceURL(String string) {
            return null;
        }

        public URL getClassURL(String string) {
            return null;
        }

        public URL getResourceURL(String string) {
            return null;
        }

        private NOPClassLocator() {
        }

        NOPClassLocator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

