/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class DirURLClassLocator
extends URLClassLocator {
    private Map _packageMap;
    private boolean _built;

    protected DirURLClassLocator(URL uRL, int n) {
        super(uRL, n);
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndex() {
        if (!this._built) {
            DirURLClassLocator dirURLClassLocator = this;
            synchronized (dirURLClassLocator) {
                if (!this._built) {
                    this.buildIndexImpl();
                    this._built = true;
                }
            }
        }
    }

    protected void getPackages(String string, Collection collection) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            collection.addAll(Arrays.asList(PackageEntry.ra$_subPackageNames(packageEntry)));
        }
    }

    protected void getClassesInPackage(String string, Collection collection) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            if (this.isSourceTypeLocator()) {
                collection.addAll(Arrays.asList(PackageEntry.ra$_classNames(packageEntry)));
            } else {
                String[] stringArray = PackageEntry.ra$_classNames(packageEntry);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    if (string2.indexOf(36) == -1) {
                        collection.add(string2);
                    }
                    ++n2;
                }
            }
        }
    }

    protected void getAllClasses(Collection collection, ClassNameFilter classNameFilter) {
        this.getClassesRecursively("", collection, classNameFilter);
    }

    private void getClassesRecursively(String string, Collection collection, ClassNameFilter classNameFilter) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$_classNames(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string2.indexOf(36) == -1) {
                    boolean bl = true;
                    if (classNameFilter != null) {
                        bl = classNameFilter.acceptClassName(string2, string);
                    }
                    if (bl) {
                        String string3 = DirURLClassLocator.buildFQName(string, string2);
                        collection.add(string3);
                    }
                }
                ++n2;
            }
            String[] stringArray2 = PackageEntry.ra$_subPackageNames(packageEntry);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String string4 = stringArray2[n4];
                String string5 = DirURLClassLocator.buildFQName(string, string4);
                this.getClassesRecursively(string5, collection, classNameFilter);
                ++n4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAllPackages(Collection collection, PackageNameFilter packageNameFilter) {
        this.buildIndex();
        Map map = this._packageMap;
        synchronized (map) {
            for (String string : this._packageMap.keySet()) {
                if (string == null || string.length() <= 0) continue;
                boolean bl = true;
                if (packageNameFilter != null) {
                    bl = packageNameFilter.acceptPackageName(string);
                }
                if (!bl) continue;
                collection.add(string);
            }
        }
    }

    public URL getURL(String string) {
        String[] stringArray = this.isSourceTypeLocator() ? URLClassLocator.SOURCE_SUFFIXES : URLClassLocator.CLASS_SUFFIXES;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            String string3 = string.replace('.', '/') + string2;
            URL uRL = this.getRootURL();
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)string3);
            if (URLFileSystem.exists((URL)uRL2)) {
                return uRL2;
            }
            ++n2;
        }
        return null;
    }

    public URL getResourceURL(String string) {
        URL uRL;
        URL uRL2;
        if (this.isClassTypeLocator() && URLFileSystem.exists((URL)(uRL2 = URLFactory.newURL((URL)(uRL = this.getRootURL()), (String)string)))) {
            return uRL2;
        }
        return null;
    }

    void $init$() {
        this._packageMap = new HashMap(512);
        this._built = false;
    }

    private void buildIndexImpl() {
        this.buildPackage("");
    }

    private void buildPackage(String string) {
        Thread.yield();
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            String[] stringArray = PackageEntry.ra$_subPackageNames(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = string.length() > 0 ? string + "." + stringArray[n2] : stringArray[n2];
                this.buildPackage(string2);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageEntry findPackage(String string) {
        int n;
        URL uRL;
        PackageEntry packageEntry = null;
        Map map = this._packageMap;
        synchronized (map) {
            packageEntry = (PackageEntry)this._packageMap.get(string);
        }
        URL uRL2 = this.getRootURL();
        if (packageEntry != null) {
            uRL = PackageEntry.ra$_packageURL(packageEntry);
        } else if (string.length() == 0) {
            uRL = uRL2;
        } else {
            String string2 = string.replace('.', '/');
            uRL = URLFactory.newDirURL((URL)uRL2, (String)string2);
        }
        long l = URLFileSystem.lastModified((URL)uRL);
        if (packageEntry != null && l == PackageEntry.ra$_lastModified(packageEntry)) {
            return packageEntry;
        }
        URLFileSystem.FileInfo[] fileInfoArray = URLFileSystem.ls((URL)uRL);
        int n2 = n = fileInfoArray == null ? 0 : fileInfoArray.length;
        if (n == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        int n3 = 0;
        while (n3 < n) {
            URLFileSystem.FileInfo fileInfo = fileInfoArray[n3];
            URL uRL3 = fileInfo.getURL();
            boolean bl = fileInfo.isDirectory();
            String string3 = URLFileSystem.getFileName((URL)uRL3);
            if (bl) {
                if (string3.indexOf(46) == -1 && string3.indexOf(45) == -1 && !string3.equals("CVS")) {
                    arrayList2.add(new String(string3));
                }
            } else if (this.isMatchingFileType(string3)) {
                int n4 = string3.lastIndexOf(46);
                arrayList.add(new String(string3.substring(0, n4)));
            }
            ++n3;
        }
        String[] stringArray = DirURLClassLocator.getStringArray(arrayList);
        String[] stringArray2 = DirURLClassLocator.getStringArray(arrayList2);
        packageEntry = new PackageEntry(string, uRL, stringArray, stringArray2, l, null);
        Map map2 = this._packageMap;
        synchronized (map2) {
            this._packageMap.put(string, packageEntry);
        }
        return packageEntry;
    }

    private static final class PackageEntry {
        private String _packageName;
        private URL _packageURL;
        private String[] _classNames;
        private String[] _subPackageNames;
        private long _lastModified;

        private PackageEntry(String string, URL uRL, String[] stringArray, String[] stringArray2, long l) {
            this._packageName = string;
            this._packageURL = uRL;
            this._classNames = stringArray;
            this._subPackageNames = stringArray2;
            this._lastModified = l;
        }

        static URL ra$_packageURL(PackageEntry packageEntry) {
            return packageEntry._packageURL;
        }

        static long ra$_lastModified(PackageEntry packageEntry) {
            return packageEntry._lastModified;
        }

        PackageEntry(String string, URL uRL, String[] stringArray, String[] stringArray2, long l, 1 var7_6) {
            this(string, uRL, stringArray, stringArray2, l);
        }

        static String[] ra$_subPackageNames(PackageEntry packageEntry) {
            return packageEntry._subPackageNames;
        }

        static String[] ra$_classNames(PackageEntry packageEntry) {
            return packageEntry._classNames;
        }

        public final class 1 {
        }
    }
}

