/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ArraySortedSet;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class JarURLClassLocator
extends URLClassLocator {
    private JarIndex _jarIndex;
    private Map _packageMap;

    protected JarURLClassLocator(URL uRL, int n) {
        super(uRL, n);
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndex() {
        if (this._packageMap == null) {
            JarURLClassLocator jarURLClassLocator = this;
            synchronized (jarURLClassLocator) {
                if (this._packageMap == null) {
                    this.buildIndexImpl();
                }
            }
        }
    }

    protected void getPackages(String string, Collection collection) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            collection.addAll(Arrays.asList(PackageEntry.ra$_subPackageList(packageEntry)));
        }
    }

    protected void getClassesInPackage(String string, Collection collection) {
        PackageEntry packageEntry = this.findPackage(string);
        if (packageEntry != null) {
            if (this.isSourceTypeLocator()) {
                collection.addAll(Arrays.asList(PackageEntry.ra$_classList(packageEntry)));
            } else {
                String[] stringArray = PackageEntry.ra$_classList(packageEntry);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    if (string2.indexOf(36) == -1) {
                        collection.add(string2);
                    }
                    ++n2;
                }
            }
        }
    }

    protected void getAllClasses(Collection collection, ClassNameFilter classNameFilter) {
        this.buildIndex();
        for (PackageEntry packageEntry : this._packageMap.values()) {
            if (packageEntry == null) continue;
            String string = PackageEntry.ra$_packageName(packageEntry);
            String[] stringArray = PackageEntry.ra$_classList(packageEntry);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string2.indexOf(36) == -1) {
                    boolean bl = true;
                    if (classNameFilter != null) {
                        bl = classNameFilter.acceptClassName(string2, string);
                    }
                    if (bl) {
                        String string3 = JarURLClassLocator.buildFQName(string, string2);
                        collection.add(string3);
                    }
                }
                ++n2;
            }
        }
    }

    protected void getAllPackages(Collection collection, PackageNameFilter packageNameFilter) {
        this.buildIndex();
        for (String string : this._packageMap.keySet()) {
            if (string == null || string.length() <= 0) continue;
            boolean bl = true;
            if (packageNameFilter != null) {
                bl = packageNameFilter.acceptPackageName(string);
            }
            if (!bl) continue;
            collection.add(string);
        }
    }

    public URL getURL(String string) {
        int n;
        this.buildIndex();
        if (this._jarIndex == null) {
            return null;
        }
        String[] stringArray = JarURLClassLocator.getNameCascades(string);
        String[] stringArray2 = JarURLClassLocator.getNameParts(string);
        int n2 = n = stringArray.length;
        if (n > 1) {
            String string2 = stringArray[n - 2];
            PackageEntry packageEntry = this.findPackage(string2);
            if (packageEntry == null) {
                return null;
            }
            String string3 = stringArray2[n2 - 1];
            if (!Arrays.asList(PackageEntry.ra$_classList(packageEntry)).contains(string3)) {
                return null;
            }
        }
        String[] stringArray3 = this.isSourceTypeLocator() ? URLClassLocator.SOURCE_SUFFIXES : URLClassLocator.CLASS_SUFFIXES;
        int n3 = stringArray3.length;
        int n4 = 0;
        while (n4 < n3) {
            String string4 = stringArray3[n4];
            String string5 = string.replace('.', '/') + string4;
            URL uRL = this.getRootURL();
            String string6 = JarUtil.getJarEntry((URL)uRL);
            if (string6 == null) {
                string6 = "";
            }
            if (this._jarIndex.entryIndex(string6 + string5) >= 0) {
                return URLFactory.newJarURL((URL)uRL, (String)string5);
            }
            ++n4;
        }
        return null;
    }

    public URL getResourceURL(String string) {
        if (this.isClassTypeLocator()) {
            this.buildIndex();
            if (this._jarIndex == null) {
                return null;
            }
            URL uRL = this.getRootURL();
            String string2 = JarUtil.getJarEntry((URL)uRL);
            if (string2 == null) {
                string2 = "";
            }
            if (this._jarIndex.entryIndex(string2 + string) >= 0) {
                return URLFactory.newJarURL((URL)uRL, (String)string);
            }
        }
        return null;
    }

    void $init$() {
        this._jarIndex = null;
        this._packageMap = null;
    }

    private void buildIndexImpl() {
        try {
            URL uRL = this.getRootURL();
            this._jarIndex = JarUtil.getJarIndex((URL)uRL);
            String[] stringArray = this._jarIndex.getEntries();
            int n = stringArray.length;
            String string = JarUtil.getJarEntry((URL)uRL);
            int n2 = string != null ? string.length() : 0;
            HashMap hashMap = new HashMap(n);
            HashMap hashMap2 = new HashMap(n);
            int n3 = 0;
            while (n3 < n) {
                block9: {
                    String string2;
                    block8: {
                        string2 = stringArray[n3];
                        if (n2 <= 0) break block8;
                        if (!string2.startsWith(string)) break block9;
                        string2 = string2.substring(n2);
                    }
                    if (string2.length() != 0 && this.isMatchingFileType(string2)) {
                        JarURLClassLocator.addClassToMaps(string2, hashMap, hashMap2);
                    }
                }
                ++n3;
            }
            ArraySortedSet arraySortedSet = new ArraySortedSet(100);
            arraySortedSet.addAll(hashMap.keySet());
            arraySortedSet.addAll(hashMap2.keySet());
            HashMap<String, PackageEntry> hashMap3 = new HashMap<String, PackageEntry>(arraySortedSet.size());
            for (Object e : arraySortedSet) {
                String string3 = (String)e;
                Collection collection = (Collection)hashMap.get(e);
                String[] stringArray2 = URLClassLocator.getStringArray(collection);
                Collection collection2 = (Collection)hashMap2.get(e);
                String[] stringArray3 = URLClassLocator.getStringArray(collection2);
                if (stringArray2.length <= 0 && stringArray3.length <= 0) continue;
                PackageEntry packageEntry = new PackageEntry(string3, stringArray2, stringArray3, null);
                hashMap3.put(string3, packageEntry);
            }
            this._packageMap = hashMap3;
        }
        catch (IOException iOException) {
            this._packageMap = new HashMap(1);
            this._jarIndex = null;
        }
    }

    private static void addClassToMaps(String string, Map map, Map map2) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n).replace('/', '.');
        int n2 = string2.lastIndexOf(46);
        String string3 = n2 != -1 ? string2.substring(0, n2) : "";
        String string4 = n2 != -1 ? string2.substring(n2 + 1) : string2;
        boolean bl = true;
        Collection collection = (Collection)map.get(string3);
        if (collection == null) {
            collection = new ArraySortedSet(75);
            map.put(string3, collection);
            bl = false;
        } else {
            string4 = new String(string4);
        }
        collection.add(string4);
        if (bl) {
            return;
        }
        if (string3.length() == 0) {
            return;
        }
        JarURLClassLocator.fillPackagesInMaps(string3, map2);
    }

    private static void fillPackagesInMaps(String string, Map map) {
        String string2 = "";
        int n = 0;
        boolean bl = false;
        while (!bl) {
            int n2 = string.indexOf(46, n);
            if (n2 == -1) {
                bl = true;
                n2 = string.length();
            }
            String string3 = string.substring(n, n2);
            Collection collection = (Collection)map.get(string2);
            if (collection == null) {
                collection = new ArraySortedSet(20);
                map.put(string2, collection);
            }
            collection.add(string3);
            string2 = string.substring(0, n2);
            n = n2 + 1;
        }
    }

    private PackageEntry findPackage(String string) {
        this.buildIndex();
        return (PackageEntry)this._packageMap.get(string);
    }

    private static final class PackageEntry {
        private String _packageName;
        private String[] _classList;
        private String[] _subPackageList;

        private PackageEntry(String string, String[] stringArray, String[] stringArray2) {
            this._packageName = string;
            this._classList = stringArray;
            this._subPackageList = stringArray2;
        }

        PackageEntry(String string, String[] stringArray, String[] stringArray2, 1 var4_4) {
            this(string, stringArray, stringArray2);
        }

        static String[] ra$_classList(PackageEntry packageEntry) {
            return packageEntry._classList;
        }

        static String ra$_packageName(PackageEntry packageEntry) {
            return packageEntry._packageName;
        }

        static String[] ra$_subPackageList(PackageEntry packageEntry) {
            return packageEntry._subPackageList;
        }

        public final class 1 {
        }
    }
}

