/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.library.Library;

public class LibraryClassLocator
extends BaseClassLocator {
    private Library _library;
    private BaseClassLocator _classLocator;
    private boolean _hasNoClassPath;
    private BaseClassLocator _sourceLocator;

    protected LibraryClassLocator(Library library) {
        this._library = library;
        URLPath uRLPath = library.getSourcePath();
        this._sourceLocator = LibraryClassLocator.ensureValid(ClassLocatorFactory.getSourceLocator(uRLPath));
        URLPath uRLPath2 = library.getClassPath();
        this._classLocator = LibraryClassLocator.ensureValid(ClassLocatorFactory.getClassLocator(uRLPath2));
        this._hasNoClassPath = uRLPath2 == null || uRLPath2.size() == 0;
    }

    public void buildIndex() {
        this._classLocator.buildIndex();
        if (this._hasNoClassPath) {
            this._sourceLocator.buildIndex();
        }
    }

    protected void getPackages(String string, Collection collection) {
        this._classLocator.getPackages(string, collection);
        if (this._hasNoClassPath) {
            this._sourceLocator.getPackages(string, collection);
        }
    }

    protected void getClassesInPackage(String string, Collection collection) {
        this._classLocator.getClassesInPackage(string, collection);
        if (this._hasNoClassPath) {
            this._sourceLocator.getClassesInPackage(string, collection);
        }
    }

    protected void getAllClasses(Collection collection, ClassNameFilter classNameFilter) {
        this._classLocator.getAllClasses(collection, classNameFilter);
        if (this._hasNoClassPath) {
            this._sourceLocator.getAllClasses(collection, classNameFilter);
        }
    }

    protected void getAllPackages(Collection collection, PackageNameFilter packageNameFilter) {
        this._classLocator.getAllPackages(collection, packageNameFilter);
        if (this._hasNoClassPath) {
            this._sourceLocator.getAllPackages(collection, packageNameFilter);
        }
    }

    public URL getURL(String string) {
        URL uRL = this.getClassURL(string);
        if (this._hasNoClassPath && uRL == null) {
            uRL = this.getSourceURL(string);
        }
        return uRL;
    }

    public URL getSourceURL(String string) {
        return this._sourceLocator.getSourceURL(string);
    }

    public URL getClassURL(String string) {
        return this._classLocator.getClassURL(string);
    }

    public URL getResourceURL(String string) {
        return this._classLocator.getResourceURL(string);
    }
}

