/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;

public class PathClassLocator
extends BaseClassLocator {
    private BaseClassLocator _sourceLocator;
    private BaseClassLocator _classLocator;

    protected PathClassLocator(URLPath uRLPath, URLPath uRLPath2) {
        this._sourceLocator = PathClassLocator.ensureValid(ClassLocatorFactory.getSourceLocator(uRLPath));
        this._classLocator = PathClassLocator.ensureValid(ClassLocatorFactory.getClassLocator(uRLPath2));
    }

    public void buildIndex() {
        this._sourceLocator.buildIndex();
        this._classLocator.buildIndex();
    }

    protected void getPackages(String string, Collection collection) {
        this._sourceLocator.getPackages(string, collection);
        this._classLocator.getPackages(string, collection);
    }

    protected void getClassesInPackage(String string, Collection collection) {
        this._sourceLocator.getClassesInPackage(string, collection);
        this._classLocator.getClassesInPackage(string, collection);
    }

    protected void getAllClasses(Collection collection, ClassNameFilter classNameFilter) {
        this._sourceLocator.getAllClasses(collection, classNameFilter);
        this._classLocator.getAllClasses(collection, classNameFilter);
    }

    protected void getAllPackages(Collection collection, PackageNameFilter packageNameFilter) {
        this._sourceLocator.getAllPackages(collection, packageNameFilter);
        this._classLocator.getAllPackages(collection, packageNameFilter);
    }

    public URL getURL(String string) {
        URL uRL = this._classLocator.getClassURL(string);
        URL uRL2 = this._sourceLocator.getSourceURL(string);
        if (uRL != null || uRL2 != null) {
            long l;
            if (uRL == null) {
                return uRL2;
            }
            if (uRL2 == null) {
                return uRL;
            }
            long l2 = URLFileSystem.lastModified((URL)uRL);
            Node node = NodeFactory.find((URL)uRL2);
            long l3 = l = node != null && node.isOpen() ? node.getTimestamp() : URLFileSystem.lastModified((URL)uRL2);
            if (l2 >= l) {
                return uRL;
            }
            return uRL2;
        }
        return null;
    }

    public URL getSourceURL(String string) {
        URL uRL = this._sourceLocator.getSourceURL(string);
        return uRL;
    }

    public URL getClassURL(String string) {
        URL uRL = this._classLocator.getClassURL(string);
        return uRL;
    }

    public URL getResourceURL(String string) {
        return this._classLocator.getResourceURL(string);
    }
}

